/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.annotation.UnsupportedAppUsage;
import android.app.AppGlobals;
import android.app.Application;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriPermission;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.media.MediaFile;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Environment;
import android.os.FileUtils;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.os.storage.VolumeInfo;
import android.provider.BaseColumns;
import android.provider.Column;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public final class MediaStore {
    private static final String TAG = "MediaStore";
    public static final String AUTHORITY = "media";
    public static final Uri AUTHORITY_URI = Uri.parse("content://media");
    public static final String VOLUME_INTERNAL = "internal";
    public static final String VOLUME_EXTERNAL = "external";
    public static final String VOLUME_EXTERNAL_PRIMARY = "external_primary";
    public static final String SCAN_FILE_CALL = "scan_file";
    public static final String SCAN_VOLUME_CALL = "scan_volume";
    public static final String EXTRA_ORIGINATED_FROM_SHELL = "android.intent.extra.originated_from_shell";
    @Deprecated
    public static final String UNHIDE_CALL = "unhide";
    public static final String RETRANSLATE_CALL = "update_titles";
    public static final String GET_VERSION_CALL = "get_version";
    public static final String GET_DOCUMENT_URI_CALL = "get_document_uri";
    public static final String GET_MEDIA_URI_CALL = "get_media_uri";
    public static final String GET_CONTRIBUTED_MEDIA_CALL = "get_contributed_media";
    public static final String DELETE_CONTRIBUTED_MEDIA_CALL = "delete_contributed_media";
    public static final String PARAM_DELETE_DATA = "deletedata";
    public static final String PARAM_INCLUDE_PENDING = "includePending";
    public static final String PARAM_INCLUDE_TRASHED = "includeTrashed";
    public static final String PARAM_PROGRESS = "progress";
    public static final String PARAM_REQUIRE_ORIGINAL = "requireOriginal";
    public static final String PARAM_LIMIT = "limit";
    @Deprecated
    public static final String INTENT_ACTION_MUSIC_PLAYER = "android.intent.action.MUSIC_PLAYER";
    public static final String INTENT_ACTION_MEDIA_SEARCH = "android.intent.action.MEDIA_SEARCH";
    public static final String INTENT_ACTION_MEDIA_PLAY_FROM_SEARCH = "android.media.action.MEDIA_PLAY_FROM_SEARCH";
    public static final String INTENT_ACTION_TEXT_OPEN_FROM_SEARCH = "android.media.action.TEXT_OPEN_FROM_SEARCH";
    public static final String INTENT_ACTION_VIDEO_PLAY_FROM_SEARCH = "android.media.action.VIDEO_PLAY_FROM_SEARCH";
    public static final String EXTRA_MEDIA_ARTIST = "android.intent.extra.artist";
    public static final String EXTRA_MEDIA_ALBUM = "android.intent.extra.album";
    public static final String EXTRA_MEDIA_TITLE = "android.intent.extra.title";
    public static final String EXTRA_MEDIA_GENRE = "android.intent.extra.genre";
    public static final String EXTRA_MEDIA_PLAYLIST = "android.intent.extra.playlist";
    public static final String EXTRA_MEDIA_RADIO_CHANNEL = "android.intent.extra.radio_channel";
    public static final String EXTRA_MEDIA_FOCUS = "android.intent.extra.focus";
    public static final String EXTRA_SCREEN_ORIENTATION = "android.intent.extra.screenOrientation";
    public static final String EXTRA_FULL_SCREEN = "android.intent.extra.fullScreen";
    public static final String EXTRA_SHOW_ACTION_ICONS = "android.intent.extra.showActionIcons";
    public static final String EXTRA_FINISH_ON_COMPLETION = "android.intent.extra.finishOnCompletion";
    public static final String INTENT_ACTION_STILL_IMAGE_CAMERA = "android.media.action.STILL_IMAGE_CAMERA";
    public static final String META_DATA_STILL_IMAGE_CAMERA_PREWARM_SERVICE = "android.media.still_image_camera_preview_service";
    public static final String INTENT_ACTION_STILL_IMAGE_CAMERA_SECURE = "android.media.action.STILL_IMAGE_CAMERA_SECURE";
    public static final String INTENT_ACTION_VIDEO_CAMERA = "android.media.action.VIDEO_CAMERA";
    public static final String ACTION_IMAGE_CAPTURE = "android.media.action.IMAGE_CAPTURE";
    public static final String ACTION_IMAGE_CAPTURE_SECURE = "android.media.action.IMAGE_CAPTURE_SECURE";
    public static final String ACTION_VIDEO_CAPTURE = "android.media.action.VIDEO_CAPTURE";
    public static final String ACTION_REVIEW = "android.provider.action.REVIEW";
    public static final String ACTION_REVIEW_SECURE = "android.provider.action.REVIEW_SECURE";
    public static final String EXTRA_BRIGHTNESS = "android.provider.extra.BRIGHTNESS";
    public static final String EXTRA_VIDEO_QUALITY = "android.intent.extra.videoQuality";
    public static final String EXTRA_SIZE_LIMIT = "android.intent.extra.sizeLimit";
    public static final String EXTRA_DURATION_LIMIT = "android.intent.extra.durationLimit";
    public static final String EXTRA_OUTPUT = "output";
    public static final String UNKNOWN_STRING = "<unknown>";
    public static final String MEDIA_SCANNER_VOLUME = "volume";
    public static final String MEDIA_IGNORE_FILENAME = ".nomedia";

    public static Uri setIncludePending(Uri uri) {
        return MediaStore.setIncludePending(uri.buildUpon()).build();
    }

    public static Uri.Builder setIncludePending(Uri.Builder uriBuilder) {
        return uriBuilder.appendQueryParameter(PARAM_INCLUDE_PENDING, "1");
    }

    @Deprecated
    public static Uri setIncludeTrashed(Uri uri) {
        return uri.buildUpon().appendQueryParameter(PARAM_INCLUDE_TRASHED, "1").build();
    }

    public static Uri setRequireOriginal(Uri uri) {
        return uri.buildUpon().appendQueryParameter(PARAM_REQUIRE_ORIGINAL, "1").build();
    }

    @Deprecated
    public static Uri createPending(Context context, PendingParams params) {
        return context.getContentResolver().insert(params.insertUri, params.insertValues);
    }

    @Deprecated
    public static PendingSession openPending(Context context, Uri uri) {
        return new PendingSession(context, uri);
    }

    @Deprecated
    public static void trash(Context context, Uri uri) {
        MediaStore.trash(context, uri, 172800000L);
    }

    @Deprecated
    public static void trash(Context context, Uri uri, long timeoutMillis) {
        if (timeoutMillis < 0L) {
            throw new IllegalArgumentException();
        }
        ContentValues values = new ContentValues();
        values.put("is_trashed", 1);
        values.put("date_expires", (System.currentTimeMillis() + timeoutMillis) / 1000L);
        context.getContentResolver().update(uri, values, null, null);
    }

    @Deprecated
    public static void untrash(Context context, Uri uri) {
        ContentValues values = new ContentValues();
        values.put("is_trashed", 0);
        values.putNull("date_expires");
        context.getContentResolver().update(uri, values, null, null);
    }

    public static String getVolumeName(File path) {
        if (FileUtils.contains(Environment.getStorageDirectory(), path)) {
            StorageManager sm = AppGlobals.getInitialApplication().getSystemService(StorageManager.class);
            StorageVolume sv = sm.getStorageVolume(path);
            if (sv != null) {
                if (sv.isPrimary()) {
                    return VOLUME_EXTERNAL_PRIMARY;
                }
                return MediaStore.checkArgumentVolumeName(sv.getNormalizedUuid());
            }
            throw new IllegalStateException("Unknown volume at " + path);
        }
        return VOLUME_INTERNAL;
    }

    @Deprecated
    public static Set<String> getAllVolumeNames(Context context) {
        return MediaStore.getExternalVolumeNames(context);
    }

    public static Set<String> getExternalVolumeNames(Context context) {
        StorageManager sm = context.getSystemService(StorageManager.class);
        ArraySet<String> volumeNames = new ArraySet<String>();
        for (VolumeInfo vi : sm.getVolumes()) {
            if (!vi.isVisibleForUser(UserHandle.myUserId()) || !vi.isMountedReadable()) continue;
            if (vi.isPrimary()) {
                volumeNames.add(VOLUME_EXTERNAL_PRIMARY);
                continue;
            }
            volumeNames.add(vi.getNormalizedFsUuid());
        }
        return volumeNames;
    }

    public static String getVolumeName(Uri uri) {
        List<String> segments = uri.getPathSegments();
        if (uri.getAuthority().equals(AUTHORITY) && segments != null && segments.size() > 0) {
            return segments.get(0);
        }
        throw new IllegalArgumentException("Missing volume name: " + uri);
    }

    public static String checkArgumentVolumeName(String volumeName) {
        if (TextUtils.isEmpty(volumeName)) {
            throw new IllegalArgumentException();
        }
        if (VOLUME_INTERNAL.equals(volumeName)) {
            return volumeName;
        }
        if (VOLUME_EXTERNAL.equals(volumeName)) {
            return volumeName;
        }
        if (VOLUME_EXTERNAL_PRIMARY.equals(volumeName)) {
            return volumeName;
        }
        for (int i = 0; i < volumeName.length(); ++i) {
            char c = volumeName.charAt(i);
            if ('a' <= c && c <= 'f' || '0' <= c && c <= '9' || c == '-') continue;
            throw new IllegalArgumentException("Invalid volume name: " + volumeName);
        }
        return volumeName;
    }

    public static File getVolumePath(String volumeName) throws FileNotFoundException {
        StorageManager sm = AppGlobals.getInitialApplication().getSystemService(StorageManager.class);
        return MediaStore.getVolumePath(sm.getVolumes(), volumeName);
    }

    public static File getVolumePath(List<VolumeInfo> volumes, String volumeName) throws FileNotFoundException {
        if (TextUtils.isEmpty(volumeName)) {
            throw new IllegalArgumentException();
        }
        switch (volumeName) {
            case "internal": 
            case "external": {
                throw new FileNotFoundException(volumeName + " has no associated path");
            }
        }
        boolean wantPrimary = VOLUME_EXTERNAL_PRIMARY.equals(volumeName);
        for (VolumeInfo volume : volumes) {
            File path;
            boolean matchSecondary;
            boolean matchPrimary = wantPrimary && volume.isPrimary();
            boolean bl = matchSecondary = !wantPrimary && Objects.equals(volume.getNormalizedFsUuid(), volumeName);
            if (!matchPrimary && !matchSecondary || (path = volume.getPathForUser(UserHandle.myUserId())) == null) continue;
            return path;
        }
        throw new FileNotFoundException("Failed to find path for " + volumeName);
    }

    public static Collection<File> getVolumeScanPaths(String volumeName) throws FileNotFoundException {
        if (TextUtils.isEmpty(volumeName)) {
            throw new IllegalArgumentException();
        }
        Application context = AppGlobals.getInitialApplication();
        UserManager um = context.getSystemService(UserManager.class);
        ArrayList<File> res = new ArrayList<File>();
        if (VOLUME_INTERNAL.equals(volumeName)) {
            MediaStore.addCanonicalFile(res, new File(Environment.getRootDirectory(), AUTHORITY));
            MediaStore.addCanonicalFile(res, new File(Environment.getOemDirectory(), AUTHORITY));
            MediaStore.addCanonicalFile(res, new File(Environment.getProductDirectory(), AUTHORITY));
        } else if (VOLUME_EXTERNAL.equals(volumeName)) {
            for (String exactVolume : MediaStore.getExternalVolumeNames(context)) {
                MediaStore.addCanonicalFile(res, MediaStore.getVolumePath(exactVolume));
            }
            if (um.isDemoUser()) {
                MediaStore.addCanonicalFile(res, Environment.getDataPreloadsMediaDirectory());
            }
        } else {
            MediaStore.addCanonicalFile(res, MediaStore.getVolumePath(volumeName));
            if (VOLUME_EXTERNAL_PRIMARY.equals(volumeName) && um.isDemoUser()) {
                MediaStore.addCanonicalFile(res, Environment.getDataPreloadsMediaDirectory());
            }
        }
        return res;
    }

    private static void addCanonicalFile(List<File> list, File file) {
        try {
            list.add(file.getCanonicalFile());
        }
        catch (IOException e) {
            Log.w(TAG, "Failed to resolve " + file + ": " + e);
            list.add(file);
        }
    }

    public static Uri getMediaScannerUri() {
        return AUTHORITY_URI.buildUpon().appendPath("none").appendPath("media_scanner").build();
    }

    public static String getVersion(Context context) {
        return MediaStore.getVersion(context, VOLUME_EXTERNAL_PRIMARY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion(Context context, String volumeName) {
        ContentResolver resolver = context.getContentResolver();
        try (ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);){
            Bundle in = new Bundle();
            in.putString("android.intent.extra.TEXT", volumeName);
            Bundle out = client.call(GET_VERSION_CALL, null, in);
            String string2 = out.getString("android.intent.extra.TEXT");
            return string2;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Uri getDocumentUri(Context context, Uri mediaUri) {
        ContentResolver resolver = context.getContentResolver();
        List<UriPermission> uriPermissions = resolver.getPersistedUriPermissions();
        try (ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);){
            Bundle in = new Bundle();
            in.putParcelable("uri", mediaUri);
            in.putParcelableList("uriPermissions", uriPermissions);
            Bundle out = client.call(GET_DOCUMENT_URI_CALL, null, in);
            Uri uri = (Uri)out.getParcelable("uri");
            return uri;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Uri getMediaUri(Context context, Uri documentUri) {
        ContentResolver resolver = context.getContentResolver();
        List<UriPermission> uriPermissions = resolver.getPersistedUriPermissions();
        try (ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);){
            Bundle in = new Bundle();
            in.putParcelable("uri", documentUri);
            in.putParcelableList("uriPermissions", uriPermissions);
            Bundle out = client.call(GET_MEDIA_URI_CALL, null, in);
            Uri uri = (Uri)out.getParcelable("uri");
            return uri;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public static long getContributedMediaSize(Context context, String packageName, UserHandle user) throws IOException {
        UserManager um = context.getSystemService(UserManager.class);
        if (um.isUserUnlocked(user) && um.isUserRunning(user)) {
            try {
                ContentResolver resolver = context.createPackageContextAsUser(packageName, 0, user).getContentResolver();
                Bundle in = new Bundle();
                in.putString("android.intent.extra.PACKAGE_NAME", packageName);
                Bundle out = resolver.call(AUTHORITY, GET_CONTRIBUTED_MEDIA_CALL, null, in);
                return out.getLong("android.intent.extra.INDEX");
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        throw new IOException("User " + user + " must be unlocked and running");
    }

    public static void deleteContributedMedia(Context context, String packageName, UserHandle user) throws IOException {
        UserManager um = context.getSystemService(UserManager.class);
        if (um.isUserUnlocked(user) && um.isUserRunning(user)) {
            try {
                ContentResolver resolver = context.createPackageContextAsUser(packageName, 0, user).getContentResolver();
                Bundle in = new Bundle();
                in.putString("android.intent.extra.PACKAGE_NAME", packageName);
                resolver.call(AUTHORITY, DELETE_CONTRIBUTED_MEDIA_CALL, null, in);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        } else {
            throw new IOException("User " + user + " must be unlocked and running");
        }
    }

    public static Uri scanFile(Context context, File file) {
        return MediaStore.scan(context, SCAN_FILE_CALL, file, false);
    }

    public static Uri scanFileFromShell(Context context, File file) {
        return MediaStore.scan(context, SCAN_FILE_CALL, file, true);
    }

    public static void scanVolume(Context context, File file) {
        MediaStore.scan(context, SCAN_VOLUME_CALL, file, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Uri scan(Context context, String method, File file, boolean originatedFromShell) {
        ContentResolver resolver = context.getContentResolver();
        try (ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY);){
            Bundle in = new Bundle();
            in.putParcelable("android.intent.extra.STREAM", Uri.fromFile(file));
            in.putBoolean(EXTRA_ORIGINATED_FROM_SHELL, originatedFromShell);
            Bundle out = client.call(method, null, in);
            Uri uri = (Uri)out.getParcelable("android.intent.extra.STREAM");
            return uri;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    public static final class Video {
        public static final String DEFAULT_SORT_ORDER = "_display_name";

        @Deprecated
        public static final Cursor query(ContentResolver cr, Uri uri, String[] projection) {
            return cr.query(uri, projection, null, null, DEFAULT_SORT_ORDER);
        }

        @Deprecated
        public static class Thumbnails
        implements BaseColumns {
            public static final Uri INTERNAL_CONTENT_URI = Thumbnails.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Thumbnails.getContentUri("external");
            public static final String DEFAULT_SORT_ORDER = "video_id ASC";
            @Deprecated
            @Column(value=3)
            public static final String DATA = "_data";
            @Column(value=1)
            public static final String VIDEO_ID = "video_id";
            @Column(value=1)
            public static final String KIND = "kind";
            public static final int MINI_KIND = 1;
            public static final int FULL_SCREEN_KIND = 2;
            public static final int MICRO_KIND = 3;
            @Column(value=1, readOnly=true)
            public static final String WIDTH = "width";
            @Column(value=1, readOnly=true)
            public static final String HEIGHT = "height";

            @Deprecated
            public static void cancelThumbnailRequest(ContentResolver cr, long origId) {
                Uri uri = ContentUris.withAppendedId(Media.EXTERNAL_CONTENT_URI, origId);
                InternalThumbnails.cancelThumbnail(cr, uri);
            }

            @Deprecated
            public static Bitmap getThumbnail(ContentResolver cr, long videoId, int kind, BitmapFactory.Options options) {
                Uri uri = ContentUris.withAppendedId(Media.EXTERNAL_CONTENT_URI, videoId);
                return InternalThumbnails.getThumbnail(cr, uri, kind, options);
            }

            @Deprecated
            public static void cancelThumbnailRequest(ContentResolver cr, long videoId, long groupId) {
                Thumbnails.cancelThumbnailRequest(cr, videoId);
            }

            @Deprecated
            public static Bitmap getThumbnail(ContentResolver cr, long videoId, long groupId, int kind, BitmapFactory.Options options) {
                return Thumbnails.getThumbnail(cr, videoId, kind, options);
            }

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("video").appendPath("thumbnails").build();
            }
        }

        public static final class Media
        implements VideoColumns {
            public static final Uri INTERNAL_CONTENT_URI = Media.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/video";
            public static final String DEFAULT_SORT_ORDER = "title";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("video").appendPath(MediaStore.AUTHORITY).build();
            }

            public static Uri getContentUri(String volumeName, long id2) {
                return ContentUris.withAppendedId(Media.getContentUri(volumeName), id2);
            }
        }

        public static interface VideoColumns
        extends MediaColumns {
            public static final String DURATION = "duration";
            @Column(value=3, readOnly=true)
            public static final String ARTIST = "artist";
            @Column(value=3, readOnly=true)
            public static final String ALBUM = "album";
            @Column(value=3, readOnly=true)
            public static final String RESOLUTION = "resolution";
            @Column(value=3, readOnly=true)
            public static final String DESCRIPTION = "description";
            @Column(value=1)
            public static final String IS_PRIVATE = "isprivate";
            @Column(value=3)
            public static final String TAGS = "tags";
            @Column(value=3)
            public static final String CATEGORY = "category";
            @Column(value=3)
            public static final String LANGUAGE = "language";
            @Deprecated
            @Column(value=2, readOnly=true)
            public static final String LATITUDE = "latitude";
            @Deprecated
            @Column(value=2, readOnly=true)
            public static final String LONGITUDE = "longitude";
            public static final String DATE_TAKEN = "datetaken";
            @Deprecated
            @Column(value=1)
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String BUCKET_ID = "bucket_id";
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
            public static final String GROUP_ID = "group_id";
            @Column(value=1)
            public static final String BOOKMARK = "bookmark";
            @Column(value=1, readOnly=true)
            public static final String COLOR_STANDARD = "color_standard";
            @Column(value=1, readOnly=true)
            public static final String COLOR_TRANSFER = "color_transfer";
            @Column(value=1, readOnly=true)
            public static final String COLOR_RANGE = "color_range";
        }
    }

    public static final class Audio {
        public static String keyFor(String name) {
            if (name != null) {
                boolean sortfirst = false;
                if (name.equals(MediaStore.UNKNOWN_STRING)) {
                    return "\u0001";
                }
                if (name.startsWith("\u0001")) {
                    sortfirst = true;
                }
                if ((name = name.trim().toLowerCase()).startsWith("the ")) {
                    name = name.substring(4);
                }
                if (name.startsWith("an ")) {
                    name = name.substring(3);
                }
                if (name.startsWith("a ")) {
                    name = name.substring(2);
                }
                if (name.endsWith(", the") || name.endsWith(",the") || name.endsWith(", an") || name.endsWith(",an") || name.endsWith(", a") || name.endsWith(",a")) {
                    name = name.substring(0, name.lastIndexOf(44));
                }
                if ((name = name.replaceAll("[\\[\\]\\(\\)\"'.,?!]", "").trim()).length() > 0) {
                    StringBuilder b = new StringBuilder();
                    b.append('.');
                    int nl = name.length();
                    for (int i = 0; i < nl; ++i) {
                        b.append(name.charAt(i));
                        b.append('.');
                    }
                    name = b.toString();
                    String key = DatabaseUtils.getCollationKey(name);
                    if (sortfirst) {
                        key = "\u0001" + key;
                    }
                    return key;
                }
                return "";
            }
            return null;
        }

        @Deprecated
        public static class Thumbnails
        implements BaseColumns {
            @Deprecated
            @Column(value=3)
            public static final String DATA = "_data";
            @Column(value=1)
            public static final String ALBUM_ID = "album_id";
        }

        public static final class Radio {
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/radio";

            private Radio() {
            }
        }

        public static final class Albums
        implements BaseColumns,
        AlbumColumns {
            public static final Uri INTERNAL_CONTENT_URI = Albums.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Albums.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/albums";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/album";
            public static final String DEFAULT_SORT_ORDER = "album_key";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath("albums").build();
            }
        }

        public static interface AlbumColumns {
            @Column(value=1, readOnly=true)
            public static final String ALBUM_ID = "album_id";
            @Column(value=3, readOnly=true)
            public static final String ALBUM = "album";
            @Column(value=1, readOnly=true)
            public static final String ARTIST_ID = "artist_id";
            @Column(value=3, readOnly=true)
            public static final String ARTIST = "artist";
            @Column(value=1, readOnly=true)
            public static final String NUMBER_OF_SONGS = "numsongs";
            @Column(value=1, readOnly=true)
            public static final String NUMBER_OF_SONGS_FOR_ARTIST = "numsongs_by_artist";
            @Column(value=1, readOnly=true)
            public static final String FIRST_YEAR = "minyear";
            @Column(value=1, readOnly=true)
            public static final String LAST_YEAR = "maxyear";
            @Column(value=3, readOnly=true)
            public static final String ALBUM_KEY = "album_key";
            @Deprecated
            @Column(value=3)
            public static final String ALBUM_ART = "album_art";
        }

        public static final class Artists
        implements BaseColumns,
        ArtistColumns {
            public static final Uri INTERNAL_CONTENT_URI = Artists.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Artists.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/artists";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/artist";
            public static final String DEFAULT_SORT_ORDER = "artist_key";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath("artists").build();
            }

            public static final class Albums
            implements AlbumColumns {
                public static final Uri getContentUri(String volumeName, long artistId) {
                    return ContentUris.withAppendedId(Artists.getContentUri(volumeName), artistId).buildUpon().appendPath("albums").build();
                }
            }
        }

        public static interface ArtistColumns {
            @Column(value=3, readOnly=true)
            public static final String ARTIST = "artist";
            @Column(value=3, readOnly=true)
            public static final String ARTIST_KEY = "artist_key";
            @Column(value=1, readOnly=true)
            public static final String NUMBER_OF_ALBUMS = "number_of_albums";
            @Column(value=1, readOnly=true)
            public static final String NUMBER_OF_TRACKS = "number_of_tracks";
        }

        public static final class Playlists
        implements BaseColumns,
        PlaylistsColumns {
            public static final Uri INTERNAL_CONTENT_URI = Playlists.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Playlists.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/playlist";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/playlist";
            public static final String DEFAULT_SORT_ORDER = "name";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath("playlists").build();
            }

            public static final class Members
            implements AudioColumns {
                @Column(value=1)
                public static final String _ID = "_id";
                public static final String CONTENT_DIRECTORY = "members";
                @Column(value=1)
                public static final String AUDIO_ID = "audio_id";
                @Column(value=1)
                public static final String PLAYLIST_ID = "playlist_id";
                @Column(value=1)
                public static final String PLAY_ORDER = "play_order";
                public static final String DEFAULT_SORT_ORDER = "play_order";

                public static final Uri getContentUri(String volumeName, long playlistId) {
                    return ContentUris.withAppendedId(Playlists.getContentUri(volumeName), playlistId).buildUpon().appendPath(CONTENT_DIRECTORY).build();
                }

                public static final boolean moveItem(ContentResolver res, long playlistId, int from, int to) {
                    Uri uri = Members.getContentUri(MediaStore.VOLUME_EXTERNAL, playlistId).buildUpon().appendEncodedPath(String.valueOf(from)).appendQueryParameter("move", "true").build();
                    ContentValues values = new ContentValues();
                    values.put("play_order", to);
                    return res.update(uri, values, null, null) != 0;
                }
            }
        }

        public static interface PlaylistsColumns {
            @Column(value=3)
            public static final String NAME = "name";
            @Deprecated
            @Column(value=3)
            public static final String DATA = "_data";
            @Column(value=1, readOnly=true)
            public static final String DATE_ADDED = "date_added";
            @Column(value=1, readOnly=true)
            public static final String DATE_MODIFIED = "date_modified";
        }

        public static final class Genres
        implements BaseColumns,
        GenresColumns {
            public static final Uri INTERNAL_CONTENT_URI = Genres.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Genres.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/genre";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/genre";
            public static final String DEFAULT_SORT_ORDER = "name";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath("genres").build();
            }

            public static Uri getContentUriForAudioId(String volumeName, int audioId) {
                return ContentUris.withAppendedId(Media.getContentUri(volumeName), audioId).buildUpon().appendPath("genres").build();
            }

            public static final class Members
            implements AudioColumns {
                public static final String CONTENT_DIRECTORY = "members";
                public static final String DEFAULT_SORT_ORDER = "title_key";
                @Column(value=1)
                public static final String AUDIO_ID = "audio_id";
                @Column(value=1)
                public static final String GENRE_ID = "genre_id";

                public static final Uri getContentUri(String volumeName, long genreId) {
                    return ContentUris.withAppendedId(Genres.getContentUri(volumeName), genreId).buildUpon().appendPath(CONTENT_DIRECTORY).build();
                }
            }
        }

        public static interface GenresColumns {
            @Column(value=3)
            public static final String NAME = "name";
        }

        public static final class Media
        implements AudioColumns {
            public static final Uri INTERNAL_CONTENT_URI = Media.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/audio";
            public static final String ENTRY_CONTENT_TYPE = "vnd.android.cursor.item/audio";
            public static final String DEFAULT_SORT_ORDER = "title_key";
            public static final String RECORD_SOUND_ACTION = "android.provider.MediaStore.RECORD_SOUND";
            public static final String EXTRA_MAX_BYTES = "android.provider.MediaStore.extra.MAX_BYTES";

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("audio").appendPath(MediaStore.AUTHORITY).build();
            }

            public static Uri getContentUri(String volumeName, long id2) {
                return ContentUris.withAppendedId(Media.getContentUri(volumeName), id2);
            }

            @Deprecated
            public static Uri getContentUriForPath(String path) {
                return Media.getContentUri(MediaStore.getVolumeName(new File(path)));
            }
        }

        public static interface AudioColumns
        extends MediaColumns {
            @Column(value=3, readOnly=true)
            public static final String TITLE_KEY = "title_key";
            public static final String DURATION = "duration";
            @Column(value=1)
            public static final String BOOKMARK = "bookmark";
            @Column(value=1, readOnly=true)
            public static final String ARTIST_ID = "artist_id";
            @Column(value=3, readOnly=true)
            public static final String ARTIST = "artist";
            @Column(value=3, readOnly=true)
            public static final String ALBUM_ARTIST = "album_artist";
            @Deprecated
            public static final String COMPILATION = "compilation";
            @Column(value=3, readOnly=true)
            public static final String ARTIST_KEY = "artist_key";
            @Column(value=3, readOnly=true)
            public static final String COMPOSER = "composer";
            @Column(value=1, readOnly=true)
            public static final String ALBUM_ID = "album_id";
            @Column(value=3, readOnly=true)
            public static final String ALBUM = "album";
            @Column(value=3, readOnly=true)
            public static final String ALBUM_KEY = "album_key";
            @Column(value=1, readOnly=true)
            public static final String TRACK = "track";
            @Column(value=1, readOnly=true)
            public static final String YEAR = "year";
            @Column(value=1, readOnly=true)
            public static final String IS_MUSIC = "is_music";
            @Column(value=1, readOnly=true)
            public static final String IS_PODCAST = "is_podcast";
            @Column(value=1, readOnly=true)
            public static final String IS_RINGTONE = "is_ringtone";
            @Column(value=1, readOnly=true)
            public static final String IS_ALARM = "is_alarm";
            @Column(value=1, readOnly=true)
            public static final String IS_NOTIFICATION = "is_notification";
            @Column(value=1, readOnly=true)
            public static final String IS_AUDIOBOOK = "is_audiobook";
            @Deprecated
            public static final String GENRE = "genre";
            @Column(value=3, readOnly=true)
            public static final String TITLE_RESOURCE_URI = "title_resource_uri";
        }
    }

    public static final class Images {

        @Deprecated
        public static class Thumbnails
        implements BaseColumns {
            public static final Uri INTERNAL_CONTENT_URI = Thumbnails.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Thumbnails.getContentUri("external");
            public static final String DEFAULT_SORT_ORDER = "image_id ASC";
            @Deprecated
            @Column(value=3)
            public static final String DATA = "_data";
            @Column(value=1)
            public static final String IMAGE_ID = "image_id";
            @Column(value=1)
            public static final String KIND = "kind";
            public static final int MINI_KIND = 1;
            public static final int FULL_SCREEN_KIND = 2;
            public static final int MICRO_KIND = 3;
            @Deprecated
            @Column(value=4)
            public static final String THUMB_DATA = "thumb_data";
            @Column(value=1, readOnly=true)
            public static final String WIDTH = "width";
            @Column(value=1, readOnly=true)
            public static final String HEIGHT = "height";

            @Deprecated
            public static final Cursor query(ContentResolver cr, Uri uri, String[] projection) {
                return cr.query(uri, projection, null, null, DEFAULT_SORT_ORDER);
            }

            @Deprecated
            public static final Cursor queryMiniThumbnails(ContentResolver cr, Uri uri, int kind, String[] projection) {
                return cr.query(uri, projection, "kind = " + kind, null, DEFAULT_SORT_ORDER);
            }

            @Deprecated
            public static final Cursor queryMiniThumbnail(ContentResolver cr, long origId, int kind, String[] projection) {
                return cr.query(EXTERNAL_CONTENT_URI, projection, "image_id = " + origId + " AND " + KIND + " = " + kind, null, null);
            }

            @Deprecated
            public static void cancelThumbnailRequest(ContentResolver cr, long origId) {
                Uri uri = ContentUris.withAppendedId(Media.EXTERNAL_CONTENT_URI, origId);
                InternalThumbnails.cancelThumbnail(cr, uri);
            }

            @Deprecated
            public static Bitmap getThumbnail(ContentResolver cr, long imageId, int kind, BitmapFactory.Options options) {
                Uri uri = ContentUris.withAppendedId(Media.EXTERNAL_CONTENT_URI, imageId);
                return InternalThumbnails.getThumbnail(cr, uri, kind, options);
            }

            @Deprecated
            public static void cancelThumbnailRequest(ContentResolver cr, long origId, long groupId) {
                Thumbnails.cancelThumbnailRequest(cr, origId);
            }

            @Deprecated
            public static Bitmap getThumbnail(ContentResolver cr, long imageId, long groupId, int kind, BitmapFactory.Options options) {
                return Thumbnails.getThumbnail(cr, imageId, kind, options);
            }

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("images").appendPath("thumbnails").build();
            }
        }

        public static final class Media
        implements ImageColumns {
            public static final Uri INTERNAL_CONTENT_URI = Media.getContentUri("internal");
            public static final Uri EXTERNAL_CONTENT_URI = Media.getContentUri("external");
            public static final String CONTENT_TYPE = "vnd.android.cursor.dir/image";
            public static final String DEFAULT_SORT_ORDER = "bucket_display_name";

            @Deprecated
            public static final Cursor query(ContentResolver cr, Uri uri, String[] projection) {
                return cr.query(uri, projection, null, null, DEFAULT_SORT_ORDER);
            }

            @Deprecated
            public static final Cursor query(ContentResolver cr, Uri uri, String[] projection, String where, String orderBy) {
                return cr.query(uri, projection, where, null, orderBy == null ? DEFAULT_SORT_ORDER : orderBy);
            }

            @Deprecated
            public static final Cursor query(ContentResolver cr, Uri uri, String[] projection, String selection, String[] selectionArgs, String orderBy) {
                return cr.query(uri, projection, selection, selectionArgs, orderBy == null ? DEFAULT_SORT_ORDER : orderBy);
            }

            @Deprecated
            public static final Bitmap getBitmap(ContentResolver cr, Uri url) throws FileNotFoundException, IOException {
                InputStream input = cr.openInputStream(url);
                Bitmap bitmap = BitmapFactory.decodeStream(input);
                input.close();
                return bitmap;
            }

            @Deprecated
            public static final String insertImage(ContentResolver cr, String imagePath, String name, String description) throws FileNotFoundException {
                String string2;
                block21: {
                    File file = new File(imagePath);
                    String mimeType = MediaFile.getMimeTypeForFile(imagePath);
                    if (TextUtils.isEmpty(name)) {
                        name = "Image";
                    }
                    PendingParams params = new PendingParams(EXTERNAL_CONTENT_URI, name, mimeType);
                    Application context = AppGlobals.getInitialApplication();
                    Uri pendingUri = MediaStore.createPending(context, params);
                    PendingSession session = MediaStore.openPending(context, pendingUri);
                    Throwable throwable = null;
                    try {
                        try (FileInputStream in = new FileInputStream(file);
                             OutputStream out = session.openOutputStream();){
                            FileUtils.copy(in, out);
                        }
                        string2 = session.publish().toString();
                        if (session == null) break block21;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (session != null) {
                                    Media.$closeResource(throwable, session);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Exception e) {
                            Log.w(MediaStore.TAG, "Failed to insert image", e);
                            ((Context)context).getContentResolver().delete(pendingUri, null, null);
                            return null;
                        }
                    }
                    Media.$closeResource(throwable, session);
                }
                return string2;
            }

            @Deprecated
            public static final String insertImage(ContentResolver cr, Bitmap source, String title, String description) {
                String string2;
                block16: {
                    if (TextUtils.isEmpty(title)) {
                        title = "Image";
                    }
                    PendingParams params = new PendingParams(EXTERNAL_CONTENT_URI, title, "image/jpeg");
                    Application context = AppGlobals.getInitialApplication();
                    Uri pendingUri = MediaStore.createPending(context, params);
                    PendingSession session = MediaStore.openPending(context, pendingUri);
                    Throwable throwable = null;
                    try {
                        try (OutputStream out = session.openOutputStream();){
                            source.compress(Bitmap.CompressFormat.JPEG, 90, out);
                        }
                        string2 = session.publish().toString();
                        if (session == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        try {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (session != null) {
                                    Media.$closeResource(throwable, session);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Exception e) {
                            Log.w(MediaStore.TAG, "Failed to insert image", e);
                            ((Context)context).getContentResolver().delete(pendingUri, null, null);
                            return null;
                        }
                    }
                    Media.$closeResource(throwable, session);
                }
                return string2;
            }

            public static Uri getContentUri(String volumeName) {
                return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("images").appendPath(MediaStore.AUTHORITY).build();
            }

            public static Uri getContentUri(String volumeName, long id2) {
                return ContentUris.withAppendedId(Media.getContentUri(volumeName), id2);
            }
        }

        public static interface ImageColumns
        extends MediaColumns {
            @Column(value=3, readOnly=true)
            public static final String DESCRIPTION = "description";
            @Deprecated
            @Column(value=3)
            public static final String PICASA_ID = "picasa_id";
            @Column(value=1)
            public static final String IS_PRIVATE = "isprivate";
            @Deprecated
            @Column(value=2, readOnly=true)
            public static final String LATITUDE = "latitude";
            @Deprecated
            @Column(value=2, readOnly=true)
            public static final String LONGITUDE = "longitude";
            public static final String DATE_TAKEN = "datetaken";
            public static final String ORIENTATION = "orientation";
            @Deprecated
            @Column(value=1)
            public static final String MINI_THUMB_MAGIC = "mini_thumb_magic";
            public static final String BUCKET_ID = "bucket_id";
            public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
            public static final String GROUP_ID = "group_id";
        }
    }

    @Deprecated
    private static class InternalThumbnails
    implements BaseColumns {
        @GuardedBy(value={"sPending"})
        private static ArrayMap<Uri, CancellationSignal> sPending = new ArrayMap();

        private InternalThumbnails() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        static Bitmap getThumbnail(ContentResolver cr, Uri uri, int kind, BitmapFactory.Options opts) {
            Point size;
            if (kind == 3) {
                size = ThumbnailConstants.MICRO_SIZE;
            } else if (kind == 2) {
                size = ThumbnailConstants.FULL_SCREEN_SIZE;
            } else if (kind == 1) {
                size = ThumbnailConstants.MINI_SIZE;
            } else {
                throw new IllegalArgumentException("Unsupported kind: " + kind);
            }
            CancellationSignal signal = null;
            Object object = sPending;
            synchronized (object) {
                signal = sPending.get(uri);
                if (signal == null) {
                    signal = new CancellationSignal();
                    sPending.put(uri, signal);
                }
            }
            try {
                object = cr.loadThumbnail(uri, Point.convert(size), signal);
                return object;
            }
            catch (IOException e) {
                Log.w(MediaStore.TAG, "Failed to obtain thumbnail for " + uri, e);
                Bitmap bitmap = null;
                return bitmap;
            }
            finally {
                ArrayMap<Uri, CancellationSignal> arrayMap = sPending;
                synchronized (arrayMap) {
                    sPending.remove(uri);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        static void cancelThumbnail(ContentResolver cr, Uri uri) {
            ArrayMap<Uri, CancellationSignal> arrayMap = sPending;
            synchronized (arrayMap) {
                CancellationSignal signal = sPending.get(uri);
                if (signal != null) {
                    signal.cancel();
                }
            }
        }
    }

    public static final class Downloads
    implements DownloadColumns {
        public static final Uri INTERNAL_CONTENT_URI = Downloads.getContentUri("internal");
        public static final Uri EXTERNAL_CONTENT_URI = Downloads.getContentUri("external");
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/download";
        public static final Pattern PATTERN_DOWNLOADS_FILE = Pattern.compile("(?i)^/storage/[^/]+/(?:[0-9]+/)?(?:Android/sandbox/[^/]+/)?Download/.+");
        private static final Pattern PATTERN_DOWNLOADS_DIRECTORY = Pattern.compile("(?i)^/storage/[^/]+/(?:[0-9]+/)?(?:Android/sandbox/[^/]+/)?Download/?");

        private Downloads() {
        }

        public static Uri getContentUri(String volumeName) {
            return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("downloads").build();
        }

        public static Uri getContentUri(String volumeName, long id2) {
            return ContentUris.withAppendedId(Downloads.getContentUri(volumeName), id2);
        }

        public static Uri getContentUriForPath(String path) {
            return Downloads.getContentUri(MediaStore.getVolumeName(new File(path)));
        }

        public static boolean isDownload(String path) {
            return PATTERN_DOWNLOADS_FILE.matcher(path).matches();
        }

        public static boolean isDownloadDir(String path) {
            return PATTERN_DOWNLOADS_DIRECTORY.matcher(path).matches();
        }
    }

    public static interface DownloadColumns
    extends MediaColumns {
        @Column(value=3)
        public static final String DOWNLOAD_URI = "download_uri";
        @Column(value=3)
        public static final String REFERER_URI = "referer_uri";
        @Deprecated
        @Column(value=3)
        public static final String DESCRIPTION = "description";
    }

    public static class ThumbnailConstants {
        public static final int MINI_KIND = 1;
        public static final int FULL_SCREEN_KIND = 2;
        public static final int MICRO_KIND = 3;
        public static final Point MINI_SIZE = new Point(512, 384);
        public static final Point FULL_SCREEN_SIZE = new Point(1024, 786);
        public static final Point MICRO_SIZE = new Point(96, 96);
    }

    public static final class Files {
        public static final String TABLE = "files";
        public static final Uri EXTERNAL_CONTENT_URI = Files.getContentUri("external");

        public static Uri getContentUri(String volumeName) {
            return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("file").build();
        }

        public static final Uri getContentUri(String volumeName, long rowId) {
            return ContentUris.withAppendedId(Files.getContentUri(volumeName), rowId);
        }

        @UnsupportedAppUsage
        public static Uri getMtpObjectsUri(String volumeName) {
            return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("object").build();
        }

        @UnsupportedAppUsage
        public static final Uri getMtpObjectsUri(String volumeName, long fileId) {
            return ContentUris.withAppendedId(Files.getMtpObjectsUri(volumeName), fileId);
        }

        @UnsupportedAppUsage
        public static final Uri getMtpReferencesUri(String volumeName, long fileId) {
            return Files.getMtpObjectsUri(volumeName, fileId).buildUpon().appendPath("references").build();
        }

        public static final Uri getDirectoryUri(String volumeName) {
            return AUTHORITY_URI.buildUpon().appendPath(volumeName).appendPath("dir").build();
        }

        public static final Uri getContentUriForPath(String path) {
            return Files.getContentUri(MediaStore.getVolumeName(new File(path)));
        }

        public static interface FileColumns
        extends MediaColumns {
            @Deprecated
            @UnsupportedAppUsage
            public static final String STORAGE_ID = "storage_id";
            @Column(value=1, readOnly=true)
            @UnsupportedAppUsage
            public static final String FORMAT = "format";
            @Column(value=1, readOnly=true)
            public static final String PARENT = "parent";
            @Column(value=3)
            public static final String MIME_TYPE = "mime_type";
            @Column(value=3, readOnly=true)
            public static final String TITLE = "title";
            @Column(value=1)
            public static final String MEDIA_TYPE = "media_type";
            public static final int MEDIA_TYPE_NONE = 0;
            public static final int MEDIA_TYPE_IMAGE = 1;
            public static final int MEDIA_TYPE_AUDIO = 2;
            public static final int MEDIA_TYPE_VIDEO = 3;
            public static final int MEDIA_TYPE_PLAYLIST = 4;
            @Column(value=1, readOnly=true)
            public static final String IS_DOWNLOAD = "is_download";
        }
    }

    public static interface MediaColumns
    extends BaseColumns {
        @Deprecated
        @Column(value=3)
        public static final String DATA = "_data";
        @Deprecated
        @Column(value=4, readOnly=true)
        public static final String HASH = "_hash";
        @Column(value=1, readOnly=true)
        public static final String SIZE = "_size";
        @Column(value=3)
        public static final String DISPLAY_NAME = "_display_name";
        @Column(value=3, readOnly=true)
        public static final String TITLE = "title";
        @Column(value=1, readOnly=true)
        public static final String DATE_ADDED = "date_added";
        @Column(value=1, readOnly=true)
        public static final String DATE_MODIFIED = "date_modified";
        @Column(value=1, readOnly=true)
        public static final String DATE_TAKEN = "datetaken";
        @Column(value=3)
        public static final String MIME_TYPE = "mime_type";
        @Deprecated
        public static final String MEDIA_SCANNER_NEW_OBJECT_ID = "media_scanner_new_object_id";
        @Deprecated
        @Column(value=1)
        @UnsupportedAppUsage
        public static final String IS_DRM = "is_drm";
        @Column(value=1)
        public static final String IS_PENDING = "is_pending";
        @Deprecated
        @Column(value=1)
        public static final String IS_TRASHED = "is_trashed";
        @Column(value=1)
        public static final String DATE_EXPIRES = "date_expires";
        @Column(value=1, readOnly=true)
        public static final String WIDTH = "width";
        @Column(value=1, readOnly=true)
        public static final String HEIGHT = "height";
        @Column(value=3, readOnly=true)
        public static final String OWNER_PACKAGE_NAME = "owner_package_name";
        @Column(value=3, readOnly=true)
        public static final String VOLUME_NAME = "volume_name";
        @Column(value=3)
        public static final String RELATIVE_PATH = "relative_path";
        @Column(value=3)
        @Deprecated
        public static final String PRIMARY_DIRECTORY = "primary_directory";
        @Column(value=3)
        @Deprecated
        public static final String SECONDARY_DIRECTORY = "secondary_directory";
        @Column(value=1, readOnly=true)
        public static final String BUCKET_ID = "bucket_id";
        @Column(value=3, readOnly=true)
        public static final String BUCKET_DISPLAY_NAME = "bucket_display_name";
        @Column(value=1, readOnly=true)
        @Deprecated
        public static final String GROUP_ID = "group_id";
        @Column(value=3, readOnly=true)
        public static final String DOCUMENT_ID = "document_id";
        @Column(value=3, readOnly=true)
        public static final String INSTANCE_ID = "instance_id";
        @Column(value=3, readOnly=true)
        public static final String ORIGINAL_DOCUMENT_ID = "original_document_id";
        @Column(value=1, readOnly=true)
        public static final String DURATION = "duration";
        @Column(value=1, readOnly=true)
        public static final String ORIENTATION = "orientation";
    }

    @Deprecated
    public static class PendingSession
    implements AutoCloseable {
        private final Context mContext;
        private final Uri mUri;

        public PendingSession(Context context, Uri uri) {
            this.mContext = Objects.requireNonNull(context);
            this.mUri = Objects.requireNonNull(uri);
        }

        public ParcelFileDescriptor open() throws FileNotFoundException {
            return this.mContext.getContentResolver().openFileDescriptor(this.mUri, "rw");
        }

        public OutputStream openOutputStream() throws FileNotFoundException {
            return this.mContext.getContentResolver().openOutputStream(this.mUri);
        }

        public void notifyProgress(int progress) {
            Uri withProgress = this.mUri.buildUpon().appendQueryParameter(MediaStore.PARAM_PROGRESS, Integer.toString(progress)).build();
            this.mContext.getContentResolver().notifyChange(withProgress, null, 0);
        }

        public Uri publish() {
            ContentValues values = new ContentValues();
            values.put("is_pending", 0);
            values.putNull("date_expires");
            this.mContext.getContentResolver().update(this.mUri, values, null, null);
            return this.mUri;
        }

        public void abandon() {
            this.mContext.getContentResolver().delete(this.mUri, null, null);
        }

        @Override
        public void close() {
            this.notifyProgress(-1);
        }
    }

    @Deprecated
    public static class PendingParams {
        public final Uri insertUri;
        public final ContentValues insertValues;

        public PendingParams(Uri insertUri, String displayName, String mimeType) {
            this.insertUri = Objects.requireNonNull(insertUri);
            long now = System.currentTimeMillis() / 1000L;
            this.insertValues = new ContentValues();
            this.insertValues.put("_display_name", Objects.requireNonNull(displayName));
            this.insertValues.put("mime_type", Objects.requireNonNull(mimeType));
            this.insertValues.put("date_added", now);
            this.insertValues.put("date_modified", now);
            this.insertValues.put("is_pending", 1);
            this.insertValues.put("date_expires", (System.currentTimeMillis() + 86400000L) / 1000L);
        }

        public void setPrimaryDirectory(String primaryDirectory) {
            if (primaryDirectory == null) {
                this.insertValues.remove("primary_directory");
            } else {
                this.insertValues.put("primary_directory", primaryDirectory);
            }
        }

        public void setSecondaryDirectory(String secondaryDirectory) {
            if (secondaryDirectory == null) {
                this.insertValues.remove("secondary_directory");
            } else {
                this.insertValues.put("secondary_directory", secondaryDirectory);
            }
        }

        public void setDownloadUri(Uri downloadUri) {
            if (downloadUri == null) {
                this.insertValues.remove("download_uri");
            } else {
                this.insertValues.put("download_uri", downloadUri.toString());
            }
        }

        public void setRefererUri(Uri refererUri) {
            if (refererUri == null) {
                this.insertValues.remove("referer_uri");
            } else {
                this.insertValues.put("referer_uri", refererUri.toString());
            }
        }
    }
}

