/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.annotation.UnsupportedAppUsage;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.renderscript.BaseObj;
import android.renderscript.Mesh;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import java.io.File;
import java.io.InputStream;

public class FileA3D
extends BaseObj {
    IndexEntry[] mFileEntries;
    InputStream mInputStream;

    FileA3D(long id2, RenderScript rs, InputStream stream) {
        super(id2, rs);
        this.mInputStream = stream;
        this.guard.open("destroy");
    }

    private void initEntries() {
        int numFileEntries = this.mRS.nFileA3DGetNumIndexEntries(this.getID(this.mRS));
        if (numFileEntries <= 0) {
            return;
        }
        this.mFileEntries = new IndexEntry[numFileEntries];
        int[] ids = new int[numFileEntries];
        String[] names = new String[numFileEntries];
        this.mRS.nFileA3DGetIndexEntries(this.getID(this.mRS), numFileEntries, ids, names);
        for (int i = 0; i < numFileEntries; ++i) {
            this.mFileEntries[i] = new IndexEntry(this.mRS, i, this.getID(this.mRS), names[i], EntryType.toEntryType(ids[i]));
        }
    }

    public int getIndexEntryCount() {
        if (this.mFileEntries == null) {
            return 0;
        }
        return this.mFileEntries.length;
    }

    @UnsupportedAppUsage
    public IndexEntry getIndexEntry(int index) {
        if (this.getIndexEntryCount() == 0 || index < 0 || index >= this.mFileEntries.length) {
            return null;
        }
        return this.mFileEntries[index];
    }

    public static FileA3D createFromAsset(RenderScript rs, AssetManager mgr, String path) {
        rs.validate();
        long fileId = rs.nFileA3DCreateFromAsset(mgr, path);
        if (fileId == 0L) {
            throw new RSRuntimeException("Unable to create a3d file from asset " + path);
        }
        FileA3D fa3d = new FileA3D(fileId, rs, null);
        fa3d.initEntries();
        return fa3d;
    }

    public static FileA3D createFromFile(RenderScript rs, String path) {
        long fileId = rs.nFileA3DCreateFromFile(path);
        if (fileId == 0L) {
            throw new RSRuntimeException("Unable to create a3d file from " + path);
        }
        FileA3D fa3d = new FileA3D(fileId, rs, null);
        fa3d.initEntries();
        return fa3d;
    }

    public static FileA3D createFromFile(RenderScript rs, File path) {
        return FileA3D.createFromFile(rs, path.getAbsolutePath());
    }

    @UnsupportedAppUsage
    public static FileA3D createFromResource(RenderScript rs, Resources res, int id2) {
        rs.validate();
        InputStream is = null;
        try {
            is = res.openRawResource(id2);
        }
        catch (Exception e) {
            throw new RSRuntimeException("Unable to open resource " + id2);
        }
        long fileId = 0L;
        if (!(is instanceof AssetManager.AssetInputStream)) {
            throw new RSRuntimeException("Unsupported asset stream");
        }
        long asset = ((AssetManager.AssetInputStream)is).getNativeAsset();
        fileId = rs.nFileA3DCreateFromAssetStream(asset);
        if (fileId == 0L) {
            throw new RSRuntimeException("Unable to create a3d file from resource " + id2);
        }
        FileA3D fa3d = new FileA3D(fileId, rs, is);
        fa3d.initEntries();
        return fa3d;
    }

    public static class IndexEntry {
        RenderScript mRS;
        int mIndex;
        long mID;
        String mName;
        EntryType mEntryType;
        BaseObj mLoadedObj;

        public String getName() {
            return this.mName;
        }

        @UnsupportedAppUsage
        public EntryType getEntryType() {
            return this.mEntryType;
        }

        @UnsupportedAppUsage
        public BaseObj getObject() {
            this.mRS.validate();
            BaseObj obj = IndexEntry.internalCreate(this.mRS, this);
            return obj;
        }

        public Mesh getMesh() {
            return (Mesh)this.getObject();
        }

        static synchronized BaseObj internalCreate(RenderScript rs, IndexEntry entry) {
            if (entry.mLoadedObj != null) {
                return entry.mLoadedObj;
            }
            if (entry.mEntryType == EntryType.UNKNOWN) {
                return null;
            }
            long objectID = rs.nFileA3DGetEntryByIndex(entry.mID, entry.mIndex);
            if (objectID == 0L) {
                return null;
            }
            switch (entry.mEntryType) {
                case MESH: {
                    entry.mLoadedObj = new Mesh(objectID, rs);
                    break;
                }
                default: {
                    throw new RSRuntimeException("Unrecognized object type in file.");
                }
            }
            entry.mLoadedObj.updateFromNative();
            return entry.mLoadedObj;
        }

        IndexEntry(RenderScript rs, int index, long id2, String name, EntryType type) {
            this.mRS = rs;
            this.mIndex = index;
            this.mID = id2;
            this.mName = name;
            this.mEntryType = type;
            this.mLoadedObj = null;
        }
    }

    public static enum EntryType {
        UNKNOWN(0),
        MESH(1);

        int mID;

        private EntryType(int id2) {
            this.mID = id2;
        }

        static EntryType toEntryType(int intID) {
            return EntryType.values()[intID];
        }
    }
}

