/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.annotation.UnsupportedAppUsage;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Environment;
import android.renderscript.BaseObj;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class Font
extends BaseObj {
    private static final String[] sSansNames = new String[]{"sans-serif", "arial", "helvetica", "tahoma", "verdana"};
    private static final String[] sSerifNames = new String[]{"serif", "times", "times new roman", "palatino", "georgia", "baskerville", "goudy", "fantasy", "cursive", "ITC Stone Serif"};
    private static final String[] sMonoNames = new String[]{"monospace", "courier", "courier new", "monaco"};
    private static Map<String, FontFamily> sFontFamilyMap;

    private static void addFamilyToMap(FontFamily family) {
        for (int i = 0; i < family.mNames.length; ++i) {
            sFontFamilyMap.put(family.mNames[i], family);
        }
    }

    private static void initFontFamilyMap() {
        sFontFamilyMap = new HashMap<String, FontFamily>();
        FontFamily sansFamily = new FontFamily();
        sansFamily.mNames = sSansNames;
        sansFamily.mNormalFileName = "Roboto-Regular.ttf";
        sansFamily.mBoldFileName = "Roboto-Bold.ttf";
        sansFamily.mItalicFileName = "Roboto-Italic.ttf";
        sansFamily.mBoldItalicFileName = "Roboto-BoldItalic.ttf";
        Font.addFamilyToMap(sansFamily);
        FontFamily serifFamily = new FontFamily();
        serifFamily.mNames = sSerifNames;
        serifFamily.mNormalFileName = "NotoSerif-Regular.ttf";
        serifFamily.mBoldFileName = "NotoSerif-Bold.ttf";
        serifFamily.mItalicFileName = "NotoSerif-Italic.ttf";
        serifFamily.mBoldItalicFileName = "NotoSerif-BoldItalic.ttf";
        Font.addFamilyToMap(serifFamily);
        FontFamily monoFamily = new FontFamily();
        monoFamily.mNames = sMonoNames;
        monoFamily.mNormalFileName = "DroidSansMono.ttf";
        monoFamily.mBoldFileName = "DroidSansMono.ttf";
        monoFamily.mItalicFileName = "DroidSansMono.ttf";
        monoFamily.mBoldItalicFileName = "DroidSansMono.ttf";
        Font.addFamilyToMap(monoFamily);
    }

    static String getFontFileName(String familyName, Style style2) {
        FontFamily family = sFontFamilyMap.get(familyName);
        if (family != null) {
            switch (style2) {
                case NORMAL: {
                    return family.mNormalFileName;
                }
                case BOLD: {
                    return family.mBoldFileName;
                }
                case ITALIC: {
                    return family.mItalicFileName;
                }
                case BOLD_ITALIC: {
                    return family.mBoldItalicFileName;
                }
            }
        }
        return "DroidSans.ttf";
    }

    Font(long id2, RenderScript rs) {
        super(id2, rs);
        this.guard.open("destroy");
    }

    public static Font createFromFile(RenderScript rs, Resources res, String path, float pointSize) {
        rs.validate();
        int dpi = res.getDisplayMetrics().densityDpi;
        long fontId = rs.nFontCreateFromFile(path, pointSize, dpi);
        if (fontId == 0L) {
            throw new RSRuntimeException("Unable to create font from file " + path);
        }
        Font rsFont = new Font(fontId, rs);
        return rsFont;
    }

    public static Font createFromFile(RenderScript rs, Resources res, File path, float pointSize) {
        return Font.createFromFile(rs, res, path.getAbsolutePath(), pointSize);
    }

    public static Font createFromAsset(RenderScript rs, Resources res, String path, float pointSize) {
        rs.validate();
        AssetManager mgr = res.getAssets();
        int dpi = res.getDisplayMetrics().densityDpi;
        long fontId = rs.nFontCreateFromAsset(mgr, path, pointSize, dpi);
        if (fontId == 0L) {
            throw new RSRuntimeException("Unable to create font from asset " + path);
        }
        Font rsFont = new Font(fontId, rs);
        return rsFont;
    }

    public static Font createFromResource(RenderScript rs, Resources res, int id2, float pointSize) {
        String name = "R." + Integer.toString(id2);
        rs.validate();
        InputStream is = null;
        try {
            is = res.openRawResource(id2);
        }
        catch (Exception e) {
            throw new RSRuntimeException("Unable to open resource " + id2);
        }
        int dpi = res.getDisplayMetrics().densityDpi;
        long fontId = 0L;
        if (!(is instanceof AssetManager.AssetInputStream)) {
            throw new RSRuntimeException("Unsupported asset stream created");
        }
        long asset = ((AssetManager.AssetInputStream)is).getNativeAsset();
        fontId = rs.nFontCreateFromAssetStream(name, pointSize, dpi, asset);
        if (fontId == 0L) {
            throw new RSRuntimeException("Unable to create font from resource " + id2);
        }
        Font rsFont = new Font(fontId, rs);
        return rsFont;
    }

    @UnsupportedAppUsage
    public static Font create(RenderScript rs, Resources res, String familyName, Style fontStyle, float pointSize) {
        String fileName = Font.getFontFileName(familyName, fontStyle);
        String fontPath = Environment.getRootDirectory().getAbsolutePath();
        fontPath = fontPath + "/fonts/" + fileName;
        return Font.createFromFile(rs, res, fontPath, pointSize);
    }

    static {
        Font.initFontFamilyMap();
    }

    public static enum Style {
        NORMAL,
        BOLD,
        ITALIC,
        BOLD_ITALIC;

    }

    private static class FontFamily {
        String[] mNames;
        String mNormalFileName;
        String mBoldFileName;
        String mItalicFileName;
        String mBoldItalicFileName;

        private FontFamily() {
        }
    }
}

