/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.annotation.UnsupportedAppUsage;
import android.renderscript.Element;
import android.renderscript.Program;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;

public class ProgramVertex
extends Program {
    ProgramVertex(long id2, RenderScript rs) {
        super(id2, rs);
    }

    public int getInputCount() {
        return this.mInputs != null ? this.mInputs.length : 0;
    }

    public Element getInput(int slot) {
        if (slot < 0 || slot >= this.mInputs.length) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        return this.mInputs[slot];
    }

    public static class Builder
    extends Program.BaseProgramBuilder {
        @UnsupportedAppUsage
        public Builder(RenderScript rs) {
            super(rs);
        }

        @UnsupportedAppUsage
        public Builder addInput(Element e) throws IllegalStateException {
            if (this.mInputCount >= 8) {
                throw new RSIllegalArgumentException("Max input count exceeded.");
            }
            if (e.isComplex()) {
                throw new RSIllegalArgumentException("Complex elements not allowed.");
            }
            this.mInputs[this.mInputCount++] = e;
            return this;
        }

        @UnsupportedAppUsage
        public ProgramVertex create() {
            int i;
            this.mRS.validate();
            long[] tmp = new long[(this.mInputCount + this.mOutputCount + this.mConstantCount + this.mTextureCount) * 2];
            String[] texNames = new String[this.mTextureCount];
            int idx = 0;
            for (i = 0; i < this.mInputCount; ++i) {
                tmp[idx++] = Program.ProgramParam.INPUT.mID;
                tmp[idx++] = this.mInputs[i].getID(this.mRS);
            }
            for (i = 0; i < this.mOutputCount; ++i) {
                tmp[idx++] = Program.ProgramParam.OUTPUT.mID;
                tmp[idx++] = this.mOutputs[i].getID(this.mRS);
            }
            for (i = 0; i < this.mConstantCount; ++i) {
                tmp[idx++] = Program.ProgramParam.CONSTANT.mID;
                tmp[idx++] = this.mConstants[i].getID(this.mRS);
            }
            for (i = 0; i < this.mTextureCount; ++i) {
                tmp[idx++] = Program.ProgramParam.TEXTURE_TYPE.mID;
                tmp[idx++] = this.mTextureTypes[i].mID;
                texNames[i] = this.mTextureNames[i];
            }
            long id2 = this.mRS.nProgramVertexCreate(this.mShader, texNames, tmp);
            ProgramVertex pv = new ProgramVertex(id2, this.mRS);
            this.initProgram(pv);
            return pv;
        }
    }
}

