/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.annotation.UnsupportedAppUsage;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.FieldPacker;
import android.renderscript.Matrix4f;
import android.renderscript.Program;
import android.renderscript.ProgramVertex;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Type;

public class ProgramVertexFixedFunction
extends ProgramVertex {
    ProgramVertexFixedFunction(long id2, RenderScript rs) {
        super(id2, rs);
    }

    @UnsupportedAppUsage
    public void bindConstants(Constants va) {
        this.mRS.validate();
        this.bindConstants(va.getAllocation(), 0);
    }

    public static class Constants {
        static final int MODELVIEW_OFFSET = 0;
        static final int PROJECTION_OFFSET = 16;
        static final int TEXTURE_OFFSET = 32;
        Matrix4f mModel;
        Matrix4f mProjection;
        Matrix4f mTexture;
        Allocation mAlloc;
        private FieldPacker mIOBuffer;

        Allocation getAllocation() {
            return this.mAlloc;
        }

        @UnsupportedAppUsage
        public Constants(RenderScript rs) {
            Type constInputType = Builder.getConstantInputType(rs);
            this.mAlloc = Allocation.createTyped(rs, constInputType);
            int bufferSize = constInputType.getElement().getBytesSize() * constInputType.getCount();
            this.mIOBuffer = new FieldPacker(bufferSize);
            this.mModel = new Matrix4f();
            this.mProjection = new Matrix4f();
            this.mTexture = new Matrix4f();
            this.setModelview(new Matrix4f());
            this.setProjection(new Matrix4f());
            this.setTexture(new Matrix4f());
        }

        public void destroy() {
            this.mAlloc.destroy();
            this.mAlloc = null;
        }

        private void addToBuffer(int offset, Matrix4f m) {
            this.mIOBuffer.reset(offset);
            for (int i = 0; i < 16; ++i) {
                this.mIOBuffer.addF32(m.mMat[i]);
            }
            this.mIOBuffer.reset(this.mIOBuffer.getData().length);
            this.mAlloc.setFromFieldPacker(0, this.mIOBuffer);
        }

        public void setModelview(Matrix4f m) {
            this.mModel.load(m);
            this.addToBuffer(0, m);
        }

        @UnsupportedAppUsage
        public void setProjection(Matrix4f m) {
            this.mProjection.load(m);
            this.addToBuffer(64, m);
        }

        public void setTexture(Matrix4f m) {
            this.mTexture.load(m);
            this.addToBuffer(128, m);
        }
    }

    public static class Builder {
        boolean mTextureMatrixEnable;
        String mShader;
        RenderScript mRS;

        @UnsupportedAppUsage
        public Builder(RenderScript rs) {
            this.mRS = rs;
        }

        public Builder setTextureMatrixEnable(boolean enable) {
            this.mTextureMatrixEnable = enable;
            return this;
        }

        static Type getConstantInputType(RenderScript rs) {
            Element.Builder b = new Element.Builder(rs);
            b.add(Element.MATRIX4X4(rs), "MV");
            b.add(Element.MATRIX4X4(rs), "P");
            b.add(Element.MATRIX4X4(rs), "TexMatrix");
            b.add(Element.MATRIX4X4(rs), "MVP");
            Type.Builder typeBuilder = new Type.Builder(rs, b.create());
            typeBuilder.setX(1);
            return typeBuilder.create();
        }

        private void buildShaderString() {
            this.mShader = "//rs_shader_internal\n";
            this.mShader = this.mShader + "varying vec4 varColor;\n";
            this.mShader = this.mShader + "varying vec2 varTex0;\n";
            this.mShader = this.mShader + "void main() {\n";
            this.mShader = this.mShader + "  gl_Position = UNI_MVP * ATTRIB_position;\n";
            this.mShader = this.mShader + "  gl_PointSize = 1.0;\n";
            this.mShader = this.mShader + "  varColor = ATTRIB_color;\n";
            this.mShader = this.mTextureMatrixEnable ? this.mShader + "  varTex0 = (UNI_TexMatrix * vec4(ATTRIB_texture0, 0.0, 1.0)).xy;\n" : this.mShader + "  varTex0 = ATTRIB_texture0;\n";
            this.mShader = this.mShader + "}\n";
        }

        @UnsupportedAppUsage
        public ProgramVertexFixedFunction create() {
            this.buildShaderString();
            InternalBuilder sb = new InternalBuilder(this.mRS);
            sb.setShader(this.mShader);
            sb.addConstant(Builder.getConstantInputType(this.mRS));
            Element.Builder b = new Element.Builder(this.mRS);
            b.add(Element.F32_4(this.mRS), "position");
            b.add(Element.F32_4(this.mRS), "color");
            b.add(Element.F32_3(this.mRS), "normal");
            b.add(Element.F32_2(this.mRS), "texture0");
            sb.addInput(b.create());
            return sb.create();
        }
    }

    static class InternalBuilder
    extends Program.BaseProgramBuilder {
        public InternalBuilder(RenderScript rs) {
            super(rs);
        }

        public InternalBuilder addInput(Element e) throws IllegalStateException {
            if (this.mInputCount >= 8) {
                throw new RSIllegalArgumentException("Max input count exceeded.");
            }
            if (e.isComplex()) {
                throw new RSIllegalArgumentException("Complex elements not allowed.");
            }
            this.mInputs[this.mInputCount++] = e;
            return this;
        }

        public ProgramVertexFixedFunction create() {
            int i;
            this.mRS.validate();
            long[] tmp = new long[(this.mInputCount + this.mOutputCount + this.mConstantCount + this.mTextureCount) * 2];
            String[] texNames = new String[this.mTextureCount];
            int idx = 0;
            for (i = 0; i < this.mInputCount; ++i) {
                tmp[idx++] = Program.ProgramParam.INPUT.mID;
                tmp[idx++] = this.mInputs[i].getID(this.mRS);
            }
            for (i = 0; i < this.mOutputCount; ++i) {
                tmp[idx++] = Program.ProgramParam.OUTPUT.mID;
                tmp[idx++] = this.mOutputs[i].getID(this.mRS);
            }
            for (i = 0; i < this.mConstantCount; ++i) {
                tmp[idx++] = Program.ProgramParam.CONSTANT.mID;
                tmp[idx++] = this.mConstants[i].getID(this.mRS);
            }
            for (i = 0; i < this.mTextureCount; ++i) {
                tmp[idx++] = Program.ProgramParam.TEXTURE_TYPE.mID;
                tmp[idx++] = this.mTextureTypes[i].mID;
                texNames[i] = this.mTextureNames[i];
            }
            long id2 = this.mRS.nProgramVertexCreate(this.mShader, texNames, tmp);
            ProgramVertexFixedFunction pv = new ProgramVertexFixedFunction(id2, this.mRS);
            this.initProgram(pv);
            return pv;
        }
    }
}

