/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.os.SystemProperties;
import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.RSDriverException;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScriptCacheDir;
import android.renderscript.Sampler;
import android.util.Log;
import android.view.Surface;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RenderScript {
    static final long TRACE_TAG = 32768L;
    static final String LOG_TAG = "RenderScript_jni";
    static final boolean DEBUG = false;
    static final boolean LOG_ENABLED = false;
    private static ArrayList<RenderScript> mProcessContextList = new ArrayList();
    private boolean mIsProcessContext = false;
    private int mContextFlags = 0;
    private int mContextSdkVersion = 0;
    private Context mApplicationContext;
    static boolean sInitialized = false;
    static Object sRuntime;
    static Method registerNativeAllocation;
    static Method registerNativeFree;
    public static final int CREATE_FLAG_NONE = 0;
    public static final int CREATE_FLAG_LOW_LATENCY = 2;
    public static final int CREATE_FLAG_LOW_POWER = 4;
    public static final int CREATE_FLAG_WAIT_FOR_ATTACH = 8;
    @UnsupportedAppUsage
    static int sPointerSize;
    static final long sMinorVersion = 1L;
    ContextType mContextType = ContextType.NORMAL;
    ReentrantReadWriteLock mRWLock;
    long mContext;
    private boolean mDestroyed = false;
    MessageThread mMessageThread;
    volatile Element mElement_U8;
    volatile Element mElement_I8;
    volatile Element mElement_U16;
    volatile Element mElement_I16;
    volatile Element mElement_U32;
    volatile Element mElement_I32;
    volatile Element mElement_U64;
    volatile Element mElement_I64;
    volatile Element mElement_F16;
    volatile Element mElement_F32;
    volatile Element mElement_F64;
    volatile Element mElement_BOOLEAN;
    volatile Element mElement_ELEMENT;
    volatile Element mElement_TYPE;
    volatile Element mElement_ALLOCATION;
    volatile Element mElement_SAMPLER;
    volatile Element mElement_SCRIPT;
    volatile Element mElement_MESH;
    volatile Element mElement_PROGRAM_FRAGMENT;
    volatile Element mElement_PROGRAM_VERTEX;
    volatile Element mElement_PROGRAM_RASTER;
    volatile Element mElement_PROGRAM_STORE;
    volatile Element mElement_FONT;
    volatile Element mElement_A_8;
    volatile Element mElement_RGB_565;
    volatile Element mElement_RGB_888;
    volatile Element mElement_RGBA_5551;
    volatile Element mElement_RGBA_4444;
    volatile Element mElement_RGBA_8888;
    volatile Element mElement_HALF_2;
    volatile Element mElement_HALF_3;
    volatile Element mElement_HALF_4;
    volatile Element mElement_FLOAT_2;
    volatile Element mElement_FLOAT_3;
    volatile Element mElement_FLOAT_4;
    volatile Element mElement_DOUBLE_2;
    volatile Element mElement_DOUBLE_3;
    volatile Element mElement_DOUBLE_4;
    volatile Element mElement_UCHAR_2;
    volatile Element mElement_UCHAR_3;
    volatile Element mElement_UCHAR_4;
    volatile Element mElement_CHAR_2;
    volatile Element mElement_CHAR_3;
    volatile Element mElement_CHAR_4;
    volatile Element mElement_USHORT_2;
    volatile Element mElement_USHORT_3;
    volatile Element mElement_USHORT_4;
    volatile Element mElement_SHORT_2;
    volatile Element mElement_SHORT_3;
    volatile Element mElement_SHORT_4;
    volatile Element mElement_UINT_2;
    volatile Element mElement_UINT_3;
    volatile Element mElement_UINT_4;
    volatile Element mElement_INT_2;
    volatile Element mElement_INT_3;
    volatile Element mElement_INT_4;
    volatile Element mElement_ULONG_2;
    volatile Element mElement_ULONG_3;
    volatile Element mElement_ULONG_4;
    volatile Element mElement_LONG_2;
    volatile Element mElement_LONG_3;
    volatile Element mElement_LONG_4;
    volatile Element mElement_YUV;
    volatile Element mElement_MATRIX_4X4;
    volatile Element mElement_MATRIX_3X3;
    volatile Element mElement_MATRIX_2X2;
    volatile Sampler mSampler_CLAMP_NEAREST;
    volatile Sampler mSampler_CLAMP_LINEAR;
    volatile Sampler mSampler_CLAMP_LINEAR_MIP_LINEAR;
    volatile Sampler mSampler_WRAP_NEAREST;
    volatile Sampler mSampler_WRAP_LINEAR;
    volatile Sampler mSampler_WRAP_LINEAR_MIP_LINEAR;
    volatile Sampler mSampler_MIRRORED_REPEAT_NEAREST;
    volatile Sampler mSampler_MIRRORED_REPEAT_LINEAR;
    volatile Sampler mSampler_MIRRORED_REPEAT_LINEAR_MIP_LINEAR;
    ProgramStore mProgramStore_BLEND_NONE_DEPTH_TEST;
    ProgramStore mProgramStore_BLEND_NONE_DEPTH_NO_DEPTH;
    ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_TEST;
    ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_NO_DEPTH;
    ProgramRaster mProgramRaster_CULL_BACK;
    ProgramRaster mProgramRaster_CULL_FRONT;
    ProgramRaster mProgramRaster_CULL_NONE;
    @UnsupportedAppUsage
    RSMessageHandler mMessageCallback = null;
    RSErrorHandler mErrorCallback = null;
    private static String mCachePath;

    static native void _nInit();

    static native int rsnSystemGetPointerSize();

    native long nDeviceCreate();

    native void nDeviceDestroy(long var1);

    native void nDeviceSetConfig(long var1, int var3, int var4);

    native int nContextGetUserMessage(long var1, int[] var3);

    native String nContextGetErrorMessage(long var1);

    native int nContextPeekMessage(long var1, int[] var3);

    native void nContextInitToClient(long var1);

    native void nContextDeinitToClient(long var1);

    @UnsupportedAppUsage
    public static long getMinorID() {
        return 1L;
    }

    public static long getMinorVersion() {
        return 1L;
    }

    native long rsnContextCreateGL(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, float var15, int var16);

    synchronized long nContextCreateGL(long dev, int ver, int sdkVer, int colorMin, int colorPref, int alphaMin, int alphaPref, int depthMin, int depthPref, int stencilMin, int stencilPref, int samplesMin, int samplesPref, float samplesQ, int dpi) {
        return this.rsnContextCreateGL(dev, ver, sdkVer, colorMin, colorPref, alphaMin, alphaPref, depthMin, depthPref, stencilMin, stencilPref, samplesMin, samplesPref, samplesQ, dpi);
    }

    native long rsnContextCreate(long var1, int var3, int var4, int var5);

    synchronized long nContextCreate(long dev, int ver, int sdkVer, int contextType) {
        return this.rsnContextCreate(dev, ver, sdkVer, contextType);
    }

    native void rsnContextDestroy(long var1);

    synchronized void nContextDestroy() {
        this.validate();
        ReentrantReadWriteLock.WriteLock wlock = this.mRWLock.writeLock();
        wlock.lock();
        long curCon = this.mContext;
        this.mContext = 0L;
        wlock.unlock();
        this.rsnContextDestroy(curCon);
    }

    native void rsnContextSetSurface(long var1, int var3, int var4, Surface var5);

    synchronized void nContextSetSurface(int w, int h, Surface sur) {
        this.validate();
        this.rsnContextSetSurface(this.mContext, w, h, sur);
    }

    native void rsnContextSetSurfaceTexture(long var1, int var3, int var4, SurfaceTexture var5);

    synchronized void nContextSetSurfaceTexture(int w, int h, SurfaceTexture sur) {
        this.validate();
        this.rsnContextSetSurfaceTexture(this.mContext, w, h, sur);
    }

    native void rsnContextSetPriority(long var1, int var3);

    synchronized void nContextSetPriority(int p) {
        this.validate();
        this.rsnContextSetPriority(this.mContext, p);
    }

    native void rsnContextSetCacheDir(long var1, String var3);

    synchronized void nContextSetCacheDir(String cacheDir) {
        this.validate();
        this.rsnContextSetCacheDir(this.mContext, cacheDir);
    }

    native void rsnContextDump(long var1, int var3);

    synchronized void nContextDump(int bits) {
        this.validate();
        this.rsnContextDump(this.mContext, bits);
    }

    native void rsnContextFinish(long var1);

    synchronized void nContextFinish() {
        this.validate();
        this.rsnContextFinish(this.mContext);
    }

    native void rsnContextSendMessage(long var1, int var3, int[] var4);

    synchronized void nContextSendMessage(int id2, int[] data) {
        this.validate();
        this.rsnContextSendMessage(this.mContext, id2, data);
    }

    native void rsnContextBindRootScript(long var1, long var3);

    synchronized void nContextBindRootScript(long script) {
        this.validate();
        this.rsnContextBindRootScript(this.mContext, script);
    }

    native void rsnContextBindSampler(long var1, int var3, int var4);

    synchronized void nContextBindSampler(int sampler, int slot) {
        this.validate();
        this.rsnContextBindSampler(this.mContext, sampler, slot);
    }

    native void rsnContextBindProgramStore(long var1, long var3);

    synchronized void nContextBindProgramStore(long pfs) {
        this.validate();
        this.rsnContextBindProgramStore(this.mContext, pfs);
    }

    native void rsnContextBindProgramFragment(long var1, long var3);

    synchronized void nContextBindProgramFragment(long pf) {
        this.validate();
        this.rsnContextBindProgramFragment(this.mContext, pf);
    }

    native void rsnContextBindProgramVertex(long var1, long var3);

    synchronized void nContextBindProgramVertex(long pv) {
        this.validate();
        this.rsnContextBindProgramVertex(this.mContext, pv);
    }

    native void rsnContextBindProgramRaster(long var1, long var3);

    synchronized void nContextBindProgramRaster(long pr) {
        this.validate();
        this.rsnContextBindProgramRaster(this.mContext, pr);
    }

    native void rsnContextPause(long var1);

    synchronized void nContextPause() {
        this.validate();
        this.rsnContextPause(this.mContext);
    }

    native void rsnContextResume(long var1);

    synchronized void nContextResume() {
        this.validate();
        this.rsnContextResume(this.mContext);
    }

    native long rsnClosureCreate(long var1, long var3, long var5, long[] var7, long[] var8, int[] var9, long[] var10, long[] var11);

    synchronized long nClosureCreate(long kernelID, long returnValue, long[] fieldIDs, long[] values, int[] sizes, long[] depClosures, long[] depFieldIDs) {
        this.validate();
        long c = this.rsnClosureCreate(this.mContext, kernelID, returnValue, fieldIDs, values, sizes, depClosures, depFieldIDs);
        if (c == 0L) {
            throw new RSRuntimeException("Failed creating closure.");
        }
        return c;
    }

    native long rsnInvokeClosureCreate(long var1, long var3, byte[] var5, long[] var6, long[] var7, int[] var8);

    synchronized long nInvokeClosureCreate(long invokeID, byte[] params, long[] fieldIDs, long[] values, int[] sizes) {
        this.validate();
        long c = this.rsnInvokeClosureCreate(this.mContext, invokeID, params, fieldIDs, values, sizes);
        if (c == 0L) {
            throw new RSRuntimeException("Failed creating closure.");
        }
        return c;
    }

    native void rsnClosureSetArg(long var1, long var3, int var5, long var6, int var8);

    synchronized void nClosureSetArg(long closureID, int index, long value, int size) {
        this.validate();
        this.rsnClosureSetArg(this.mContext, closureID, index, value, size);
    }

    native void rsnClosureSetGlobal(long var1, long var3, long var5, long var7, int var9);

    synchronized void nClosureSetGlobal(long closureID, long fieldID, long value, int size) {
        this.validate();
        this.rsnClosureSetGlobal(this.mContext, closureID, fieldID, value, size);
    }

    native long rsnScriptGroup2Create(long var1, String var3, String var4, long[] var5);

    synchronized long nScriptGroup2Create(String name, String cachePath, long[] closures) {
        this.validate();
        long g = this.rsnScriptGroup2Create(this.mContext, name, cachePath, closures);
        if (g == 0L) {
            throw new RSRuntimeException("Failed creating script group.");
        }
        return g;
    }

    native void rsnScriptGroup2Execute(long var1, long var3);

    synchronized void nScriptGroup2Execute(long groupID) {
        this.validate();
        this.rsnScriptGroup2Execute(this.mContext, groupID);
    }

    native void rsnAssignName(long var1, long var3, byte[] var5);

    synchronized void nAssignName(long obj, byte[] name) {
        this.validate();
        this.rsnAssignName(this.mContext, obj, name);
    }

    native String rsnGetName(long var1, long var3);

    synchronized String nGetName(long obj) {
        this.validate();
        return this.rsnGetName(this.mContext, obj);
    }

    native void rsnObjDestroy(long var1, long var3);

    void nObjDestroy(long id2) {
        if (this.mContext != 0L) {
            this.rsnObjDestroy(this.mContext, id2);
        }
    }

    native long rsnElementCreate(long var1, long var3, int var5, boolean var6, int var7);

    synchronized long nElementCreate(long type, int kind, boolean norm, int vecSize) {
        this.validate();
        return this.rsnElementCreate(this.mContext, type, kind, norm, vecSize);
    }

    native long rsnElementCreate2(long var1, long[] var3, String[] var4, int[] var5);

    synchronized long nElementCreate2(long[] elements, String[] names, int[] arraySizes) {
        this.validate();
        return this.rsnElementCreate2(this.mContext, elements, names, arraySizes);
    }

    native void rsnElementGetNativeData(long var1, long var3, int[] var5);

    synchronized void nElementGetNativeData(long id2, int[] elementData) {
        this.validate();
        this.rsnElementGetNativeData(this.mContext, id2, elementData);
    }

    native void rsnElementGetSubElements(long var1, long var3, long[] var5, String[] var6, int[] var7);

    synchronized void nElementGetSubElements(long id2, long[] IDs, String[] names, int[] arraySizes) {
        this.validate();
        this.rsnElementGetSubElements(this.mContext, id2, IDs, names, arraySizes);
    }

    native long rsnTypeCreate(long var1, long var3, int var5, int var6, int var7, boolean var8, boolean var9, int var10);

    synchronized long nTypeCreate(long eid, int x, int y, int z, boolean mips, boolean faces, int yuv) {
        this.validate();
        return this.rsnTypeCreate(this.mContext, eid, x, y, z, mips, faces, yuv);
    }

    native void rsnTypeGetNativeData(long var1, long var3, long[] var5);

    synchronized void nTypeGetNativeData(long id2, long[] typeData) {
        this.validate();
        this.rsnTypeGetNativeData(this.mContext, id2, typeData);
    }

    native long rsnAllocationCreateTyped(long var1, long var3, int var5, int var6, long var7);

    synchronized long nAllocationCreateTyped(long type, int mip, int usage, long pointer) {
        this.validate();
        return this.rsnAllocationCreateTyped(this.mContext, type, mip, usage, pointer);
    }

    native long rsnAllocationCreateFromBitmap(long var1, long var3, int var5, long var6, int var8);

    synchronized long nAllocationCreateFromBitmap(long type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromBitmap(this.mContext, type, mip, bmp.getNativeInstance(), usage);
    }

    native long rsnAllocationCreateBitmapBackedAllocation(long var1, long var3, int var5, long var6, int var8);

    synchronized long nAllocationCreateBitmapBackedAllocation(long type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateBitmapBackedAllocation(this.mContext, type, mip, bmp.getNativeInstance(), usage);
    }

    native long rsnAllocationCubeCreateFromBitmap(long var1, long var3, int var5, long var6, int var8);

    synchronized long nAllocationCubeCreateFromBitmap(long type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCubeCreateFromBitmap(this.mContext, type, mip, bmp.getNativeInstance(), usage);
    }

    native long rsnAllocationCreateBitmapRef(long var1, long var3, long var5);

    synchronized long nAllocationCreateBitmapRef(long type, Bitmap bmp) {
        this.validate();
        return this.rsnAllocationCreateBitmapRef(this.mContext, type, bmp.getNativeInstance());
    }

    native long rsnAllocationCreateFromAssetStream(long var1, int var3, int var4, int var5);

    synchronized long nAllocationCreateFromAssetStream(int mips, int assetStream, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromAssetStream(this.mContext, mips, assetStream, usage);
    }

    native void rsnAllocationCopyToBitmap(long var1, long var3, long var5);

    synchronized void nAllocationCopyToBitmap(long alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyToBitmap(this.mContext, alloc, bmp.getNativeInstance());
    }

    native void rsnAllocationSyncAll(long var1, long var3, int var5);

    synchronized void nAllocationSyncAll(long alloc, int src) {
        this.validate();
        this.rsnAllocationSyncAll(this.mContext, alloc, src);
    }

    native ByteBuffer rsnAllocationGetByteBuffer(long var1, long var3, long[] var5, int var6, int var7, int var8);

    synchronized ByteBuffer nAllocationGetByteBuffer(long alloc, long[] stride, int xBytesSize, int dimY, int dimZ) {
        this.validate();
        return this.rsnAllocationGetByteBuffer(this.mContext, alloc, stride, xBytesSize, dimY, dimZ);
    }

    native void rsnAllocationSetupBufferQueue(long var1, long var3, int var5);

    synchronized void nAllocationSetupBufferQueue(long alloc, int numAlloc) {
        this.validate();
        this.rsnAllocationSetupBufferQueue(this.mContext, alloc, numAlloc);
    }

    native void rsnAllocationShareBufferQueue(long var1, long var3, long var5);

    synchronized void nAllocationShareBufferQueue(long alloc1, long alloc2) {
        this.validate();
        this.rsnAllocationShareBufferQueue(this.mContext, alloc1, alloc2);
    }

    native Surface rsnAllocationGetSurface(long var1, long var3);

    synchronized Surface nAllocationGetSurface(long alloc) {
        this.validate();
        return this.rsnAllocationGetSurface(this.mContext, alloc);
    }

    native void rsnAllocationSetSurface(long var1, long var3, Surface var5);

    synchronized void nAllocationSetSurface(long alloc, Surface sur) {
        this.validate();
        this.rsnAllocationSetSurface(this.mContext, alloc, sur);
    }

    native void rsnAllocationIoSend(long var1, long var3);

    synchronized void nAllocationIoSend(long alloc) {
        this.validate();
        this.rsnAllocationIoSend(this.mContext, alloc);
    }

    native long rsnAllocationIoReceive(long var1, long var3);

    synchronized long nAllocationIoReceive(long alloc) {
        this.validate();
        return this.rsnAllocationIoReceive(this.mContext, alloc);
    }

    native void rsnAllocationGenerateMipmaps(long var1, long var3);

    synchronized void nAllocationGenerateMipmaps(long alloc) {
        this.validate();
        this.rsnAllocationGenerateMipmaps(this.mContext, alloc);
    }

    native void rsnAllocationCopyFromBitmap(long var1, long var3, long var5);

    synchronized void nAllocationCopyFromBitmap(long alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyFromBitmap(this.mContext, alloc, bmp.getNativeInstance());
    }

    native void rsnAllocationData1D(long var1, long var3, int var5, int var6, int var7, Object var8, int var9, int var10, int var11, boolean var12);

    synchronized void nAllocationData1D(long id2, int off, int mip, int count, Object d, int sizeBytes, Element.DataType dt, int mSize, boolean usePadding) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes, dt.mID, mSize, usePadding);
    }

    native void rsnAllocationElementData(long var1, long var3, int var5, int var6, int var7, int var8, int var9, byte[] var10, int var11);

    synchronized void nAllocationElementData(long id2, int xoff, int yoff, int zoff, int mip, int compIdx, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationElementData(this.mContext, id2, xoff, yoff, zoff, mip, compIdx, d, sizeBytes);
    }

    native void rsnAllocationData2D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, long var11, int var13, int var14, int var15, int var16);

    synchronized void nAllocationData2D(long dstAlloc, int dstXoff, int dstYoff, int dstMip, int dstFace, int width, int height, long srcAlloc, int srcXoff, int srcYoff, int srcMip, int srcFace) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, dstAlloc, dstXoff, dstYoff, dstMip, dstFace, width, height, srcAlloc, srcXoff, srcYoff, srcMip, srcFace);
    }

    native void rsnAllocationData2D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, Object var11, int var12, int var13, int var14, boolean var15);

    synchronized void nAllocationData2D(long id2, int xoff, int yoff, int mip, int face, int w, int h, Object d, int sizeBytes, Element.DataType dt, int mSize, boolean usePadding) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes, dt.mID, mSize, usePadding);
    }

    native void rsnAllocationData2D(long var1, long var3, int var5, int var6, int var7, int var8, Bitmap var9);

    synchronized void nAllocationData2D(long id2, int xoff, int yoff, int mip, int face, Bitmap b) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, b);
    }

    native void rsnAllocationData3D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, long var12, int var14, int var15, int var16, int var17);

    synchronized void nAllocationData3D(long dstAlloc, int dstXoff, int dstYoff, int dstZoff, int dstMip, int width, int height, int depth, long srcAlloc, int srcXoff, int srcYoff, int srcZoff, int srcMip) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, dstAlloc, dstXoff, dstYoff, dstZoff, dstMip, width, height, depth, srcAlloc, srcXoff, srcYoff, srcZoff, srcMip);
    }

    native void rsnAllocationData3D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, Object var12, int var13, int var14, int var15, boolean var16);

    synchronized void nAllocationData3D(long id2, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, Object d, int sizeBytes, Element.DataType dt, int mSize, boolean usePadding) {
        this.validate();
        this.rsnAllocationData3D(this.mContext, id2, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes, dt.mID, mSize, usePadding);
    }

    native void rsnAllocationRead(long var1, long var3, Object var5, int var6, int var7, boolean var8);

    synchronized void nAllocationRead(long id2, Object d, Element.DataType dt, int mSize, boolean usePadding) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d, dt.mID, mSize, usePadding);
    }

    native void rsnAllocationRead1D(long var1, long var3, int var5, int var6, int var7, Object var8, int var9, int var10, int var11, boolean var12);

    synchronized void nAllocationRead1D(long id2, int off, int mip, int count, Object d, int sizeBytes, Element.DataType dt, int mSize, boolean usePadding) {
        this.validate();
        this.rsnAllocationRead1D(this.mContext, id2, off, mip, count, d, sizeBytes, dt.mID, mSize, usePadding);
    }

    native void rsnAllocationElementRead(long var1, long var3, int var5, int var6, int var7, int var8, int var9, byte[] var10, int var11);

    synchronized void nAllocationElementRead(long id2, int xoff, int yoff, int zoff, int mip, int compIdx, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationElementRead(this.mContext, id2, xoff, yoff, zoff, mip, compIdx, d, sizeBytes);
    }

    native void rsnAllocationRead2D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, Object var11, int var12, int var13, int var14, boolean var15);

    synchronized void nAllocationRead2D(long id2, int xoff, int yoff, int mip, int face, int w, int h, Object d, int sizeBytes, Element.DataType dt, int mSize, boolean usePadding) {
        this.validate();
        this.rsnAllocationRead2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes, dt.mID, mSize, usePadding);
    }

    native void rsnAllocationRead3D(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, Object var12, int var13, int var14, int var15, boolean var16);

    synchronized void nAllocationRead3D(long id2, int xoff, int yoff, int zoff, int mip, int w, int h, int depth, Object d, int sizeBytes, Element.DataType dt, int mSize, boolean usePadding) {
        this.validate();
        this.rsnAllocationRead3D(this.mContext, id2, xoff, yoff, zoff, mip, w, h, depth, d, sizeBytes, dt.mID, mSize, usePadding);
    }

    native long rsnAllocationGetType(long var1, long var3);

    synchronized long nAllocationGetType(long id2) {
        this.validate();
        return this.rsnAllocationGetType(this.mContext, id2);
    }

    native void rsnAllocationResize1D(long var1, long var3, int var5);

    synchronized void nAllocationResize1D(long id2, int dimX) {
        this.validate();
        this.rsnAllocationResize1D(this.mContext, id2, dimX);
    }

    native long rsnAllocationAdapterCreate(long var1, long var3, long var5);

    synchronized long nAllocationAdapterCreate(long allocId, long typeId) {
        this.validate();
        return this.rsnAllocationAdapterCreate(this.mContext, allocId, typeId);
    }

    native void rsnAllocationAdapterOffset(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);

    synchronized void nAllocationAdapterOffset(long id2, int x, int y, int z, int mip, int face, int a1, int a2, int a3, int a4) {
        this.validate();
        this.rsnAllocationAdapterOffset(this.mContext, id2, x, y, z, mip, face, a1, a2, a3, a4);
    }

    native long rsnFileA3DCreateFromAssetStream(long var1, long var3);

    synchronized long nFileA3DCreateFromAssetStream(long assetStream) {
        this.validate();
        return this.rsnFileA3DCreateFromAssetStream(this.mContext, assetStream);
    }

    native long rsnFileA3DCreateFromFile(long var1, String var3);

    synchronized long nFileA3DCreateFromFile(String path) {
        this.validate();
        return this.rsnFileA3DCreateFromFile(this.mContext, path);
    }

    native long rsnFileA3DCreateFromAsset(long var1, AssetManager var3, String var4);

    synchronized long nFileA3DCreateFromAsset(AssetManager mgr, String path) {
        this.validate();
        return this.rsnFileA3DCreateFromAsset(this.mContext, mgr, path);
    }

    native int rsnFileA3DGetNumIndexEntries(long var1, long var3);

    synchronized int nFileA3DGetNumIndexEntries(long fileA3D) {
        this.validate();
        return this.rsnFileA3DGetNumIndexEntries(this.mContext, fileA3D);
    }

    native void rsnFileA3DGetIndexEntries(long var1, long var3, int var5, int[] var6, String[] var7);

    synchronized void nFileA3DGetIndexEntries(long fileA3D, int numEntries, int[] IDs, String[] names) {
        this.validate();
        this.rsnFileA3DGetIndexEntries(this.mContext, fileA3D, numEntries, IDs, names);
    }

    native long rsnFileA3DGetEntryByIndex(long var1, long var3, int var5);

    synchronized long nFileA3DGetEntryByIndex(long fileA3D, int index) {
        this.validate();
        return this.rsnFileA3DGetEntryByIndex(this.mContext, fileA3D, index);
    }

    native long rsnFontCreateFromFile(long var1, String var3, float var4, int var5);

    synchronized long nFontCreateFromFile(String fileName, float size, int dpi) {
        this.validate();
        return this.rsnFontCreateFromFile(this.mContext, fileName, size, dpi);
    }

    native long rsnFontCreateFromAssetStream(long var1, String var3, float var4, int var5, long var6);

    synchronized long nFontCreateFromAssetStream(String name, float size, int dpi, long assetStream) {
        this.validate();
        return this.rsnFontCreateFromAssetStream(this.mContext, name, size, dpi, assetStream);
    }

    native long rsnFontCreateFromAsset(long var1, AssetManager var3, String var4, float var5, int var6);

    synchronized long nFontCreateFromAsset(AssetManager mgr, String path, float size, int dpi) {
        this.validate();
        return this.rsnFontCreateFromAsset(this.mContext, mgr, path, size, dpi);
    }

    native void rsnScriptBindAllocation(long var1, long var3, long var5, int var7);

    synchronized void nScriptBindAllocation(long script, long alloc, int slot) {
        this.validate();
        this.rsnScriptBindAllocation(this.mContext, script, alloc, slot);
    }

    native void rsnScriptSetTimeZone(long var1, long var3, byte[] var5);

    synchronized void nScriptSetTimeZone(long script, byte[] timeZone) {
        this.validate();
        this.rsnScriptSetTimeZone(this.mContext, script, timeZone);
    }

    native void rsnScriptInvoke(long var1, long var3, int var5);

    synchronized void nScriptInvoke(long id2, int slot) {
        this.validate();
        this.rsnScriptInvoke(this.mContext, id2, slot);
    }

    native void rsnScriptForEach(long var1, long var3, int var5, long[] var6, long var7, byte[] var9, int[] var10);

    synchronized void nScriptForEach(long id2, int slot, long[] ains, long aout, byte[] params, int[] limits) {
        this.validate();
        this.rsnScriptForEach(this.mContext, id2, slot, ains, aout, params, limits);
    }

    native void rsnScriptReduce(long var1, long var3, int var5, long[] var6, long var7, int[] var9);

    synchronized void nScriptReduce(long id2, int slot, long[] ains, long aout, int[] limits) {
        this.validate();
        this.rsnScriptReduce(this.mContext, id2, slot, ains, aout, limits);
    }

    native void rsnScriptInvokeV(long var1, long var3, int var5, byte[] var6);

    synchronized void nScriptInvokeV(long id2, int slot, byte[] params) {
        this.validate();
        this.rsnScriptInvokeV(this.mContext, id2, slot, params);
    }

    native void rsnScriptSetVarI(long var1, long var3, int var5, int var6);

    synchronized void nScriptSetVarI(long id2, int slot, int val) {
        this.validate();
        this.rsnScriptSetVarI(this.mContext, id2, slot, val);
    }

    native int rsnScriptGetVarI(long var1, long var3, int var5);

    synchronized int nScriptGetVarI(long id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarI(this.mContext, id2, slot);
    }

    native void rsnScriptSetVarJ(long var1, long var3, int var5, long var6);

    synchronized void nScriptSetVarJ(long id2, int slot, long val) {
        this.validate();
        this.rsnScriptSetVarJ(this.mContext, id2, slot, val);
    }

    native long rsnScriptGetVarJ(long var1, long var3, int var5);

    synchronized long nScriptGetVarJ(long id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarJ(this.mContext, id2, slot);
    }

    native void rsnScriptSetVarF(long var1, long var3, int var5, float var6);

    synchronized void nScriptSetVarF(long id2, int slot, float val) {
        this.validate();
        this.rsnScriptSetVarF(this.mContext, id2, slot, val);
    }

    native float rsnScriptGetVarF(long var1, long var3, int var5);

    synchronized float nScriptGetVarF(long id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarF(this.mContext, id2, slot);
    }

    native void rsnScriptSetVarD(long var1, long var3, int var5, double var6);

    synchronized void nScriptSetVarD(long id2, int slot, double val) {
        this.validate();
        this.rsnScriptSetVarD(this.mContext, id2, slot, val);
    }

    native double rsnScriptGetVarD(long var1, long var3, int var5);

    synchronized double nScriptGetVarD(long id2, int slot) {
        this.validate();
        return this.rsnScriptGetVarD(this.mContext, id2, slot);
    }

    native void rsnScriptSetVarV(long var1, long var3, int var5, byte[] var6);

    synchronized void nScriptSetVarV(long id2, int slot, byte[] val) {
        this.validate();
        this.rsnScriptSetVarV(this.mContext, id2, slot, val);
    }

    native void rsnScriptGetVarV(long var1, long var3, int var5, byte[] var6);

    synchronized void nScriptGetVarV(long id2, int slot, byte[] val) {
        this.validate();
        this.rsnScriptGetVarV(this.mContext, id2, slot, val);
    }

    native void rsnScriptSetVarVE(long var1, long var3, int var5, byte[] var6, long var7, int[] var9);

    synchronized void nScriptSetVarVE(long id2, int slot, byte[] val, long e, int[] dims) {
        this.validate();
        this.rsnScriptSetVarVE(this.mContext, id2, slot, val, e, dims);
    }

    native void rsnScriptSetVarObj(long var1, long var3, int var5, long var6);

    synchronized void nScriptSetVarObj(long id2, int slot, long val) {
        this.validate();
        this.rsnScriptSetVarObj(this.mContext, id2, slot, val);
    }

    native long rsnScriptCCreate(long var1, String var3, String var4, byte[] var5, int var6);

    @UnsupportedAppUsage
    synchronized long nScriptCCreate(String resName, String cacheDir, byte[] script, int length) {
        this.validate();
        return this.rsnScriptCCreate(this.mContext, resName, cacheDir, script, length);
    }

    native long rsnScriptIntrinsicCreate(long var1, int var3, long var4);

    synchronized long nScriptIntrinsicCreate(int id2, long eid) {
        this.validate();
        return this.rsnScriptIntrinsicCreate(this.mContext, id2, eid);
    }

    native long rsnScriptKernelIDCreate(long var1, long var3, int var5, int var6);

    synchronized long nScriptKernelIDCreate(long sid, int slot, int sig) {
        this.validate();
        return this.rsnScriptKernelIDCreate(this.mContext, sid, slot, sig);
    }

    native long rsnScriptInvokeIDCreate(long var1, long var3, int var5);

    synchronized long nScriptInvokeIDCreate(long sid, int slot) {
        this.validate();
        return this.rsnScriptInvokeIDCreate(this.mContext, sid, slot);
    }

    native long rsnScriptFieldIDCreate(long var1, long var3, int var5);

    synchronized long nScriptFieldIDCreate(long sid, int slot) {
        this.validate();
        return this.rsnScriptFieldIDCreate(this.mContext, sid, slot);
    }

    native long rsnScriptGroupCreate(long var1, long[] var3, long[] var4, long[] var5, long[] var6, long[] var7);

    synchronized long nScriptGroupCreate(long[] kernels, long[] src, long[] dstk, long[] dstf, long[] types) {
        this.validate();
        return this.rsnScriptGroupCreate(this.mContext, kernels, src, dstk, dstf, types);
    }

    native void rsnScriptGroupSetInput(long var1, long var3, long var5, long var7);

    synchronized void nScriptGroupSetInput(long group, long kernel, long alloc) {
        this.validate();
        this.rsnScriptGroupSetInput(this.mContext, group, kernel, alloc);
    }

    native void rsnScriptGroupSetOutput(long var1, long var3, long var5, long var7);

    synchronized void nScriptGroupSetOutput(long group, long kernel, long alloc) {
        this.validate();
        this.rsnScriptGroupSetOutput(this.mContext, group, kernel, alloc);
    }

    native void rsnScriptGroupExecute(long var1, long var3);

    synchronized void nScriptGroupExecute(long group) {
        this.validate();
        this.rsnScriptGroupExecute(this.mContext, group);
    }

    native long rsnSamplerCreate(long var1, int var3, int var4, int var5, int var6, int var7, float var8);

    synchronized long nSamplerCreate(int magFilter, int minFilter, int wrapS, int wrapT, int wrapR, float aniso) {
        this.validate();
        return this.rsnSamplerCreate(this.mContext, magFilter, minFilter, wrapS, wrapT, wrapR, aniso);
    }

    native long rsnProgramStoreCreate(long var1, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, int var9, int var10, int var11);

    synchronized long nProgramStoreCreate(boolean r, boolean g, boolean b, boolean a, boolean depthMask, boolean dither, int srcMode, int dstMode, int depthFunc) {
        this.validate();
        return this.rsnProgramStoreCreate(this.mContext, r, g, b, a, depthMask, dither, srcMode, dstMode, depthFunc);
    }

    native long rsnProgramRasterCreate(long var1, boolean var3, int var4);

    synchronized long nProgramRasterCreate(boolean pointSprite, int cullMode) {
        this.validate();
        return this.rsnProgramRasterCreate(this.mContext, pointSprite, cullMode);
    }

    native void rsnProgramBindConstants(long var1, long var3, int var5, long var6);

    synchronized void nProgramBindConstants(long pv, int slot, long mID) {
        this.validate();
        this.rsnProgramBindConstants(this.mContext, pv, slot, mID);
    }

    native void rsnProgramBindTexture(long var1, long var3, int var5, long var6);

    synchronized void nProgramBindTexture(long vpf, int slot, long a) {
        this.validate();
        this.rsnProgramBindTexture(this.mContext, vpf, slot, a);
    }

    native void rsnProgramBindSampler(long var1, long var3, int var5, long var6);

    synchronized void nProgramBindSampler(long vpf, int slot, long s) {
        this.validate();
        this.rsnProgramBindSampler(this.mContext, vpf, slot, s);
    }

    native long rsnProgramFragmentCreate(long var1, String var3, String[] var4, long[] var5);

    synchronized long nProgramFragmentCreate(String shader, String[] texNames, long[] params) {
        this.validate();
        return this.rsnProgramFragmentCreate(this.mContext, shader, texNames, params);
    }

    native long rsnProgramVertexCreate(long var1, String var3, String[] var4, long[] var5);

    synchronized long nProgramVertexCreate(String shader, String[] texNames, long[] params) {
        this.validate();
        return this.rsnProgramVertexCreate(this.mContext, shader, texNames, params);
    }

    native long rsnMeshCreate(long var1, long[] var3, long[] var4, int[] var5);

    synchronized long nMeshCreate(long[] vtx, long[] idx, int[] prim) {
        this.validate();
        return this.rsnMeshCreate(this.mContext, vtx, idx, prim);
    }

    native int rsnMeshGetVertexBufferCount(long var1, long var3);

    synchronized int nMeshGetVertexBufferCount(long id2) {
        this.validate();
        return this.rsnMeshGetVertexBufferCount(this.mContext, id2);
    }

    native int rsnMeshGetIndexCount(long var1, long var3);

    synchronized int nMeshGetIndexCount(long id2) {
        this.validate();
        return this.rsnMeshGetIndexCount(this.mContext, id2);
    }

    native void rsnMeshGetVertices(long var1, long var3, long[] var5, int var6);

    synchronized void nMeshGetVertices(long id2, long[] vtxIds, int vtxIdCount) {
        this.validate();
        this.rsnMeshGetVertices(this.mContext, id2, vtxIds, vtxIdCount);
    }

    native void rsnMeshGetIndices(long var1, long var3, long[] var5, int[] var6, int var7);

    synchronized void nMeshGetIndices(long id2, long[] idxIds, int[] primitives, int vtxIdCount) {
        this.validate();
        this.rsnMeshGetIndices(this.mContext, id2, idxIds, primitives, vtxIdCount);
    }

    native void rsnScriptIntrinsicBLAS_Single(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, float var14, long var15, long var17, float var19, long var20, int var22, int var23, int var24, int var25);

    synchronized void nScriptIntrinsicBLAS_Single(long id2, int func, int TransA, int TransB, int Side2, int Uplo2, int Diag2, int M, int N, int K, float alpha, long A, long B, float beta, long C, int incX, int incY, int KL, int KU) {
        this.validate();
        this.rsnScriptIntrinsicBLAS_Single(this.mContext, id2, func, TransA, TransB, Side2, Uplo2, Diag2, M, N, K, alpha, A, B, beta, C, incX, incY, KL, KU);
    }

    native void rsnScriptIntrinsicBLAS_Double(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, double var14, long var16, long var18, double var20, long var22, int var24, int var25, int var26, int var27);

    synchronized void nScriptIntrinsicBLAS_Double(long id2, int func, int TransA, int TransB, int Side2, int Uplo2, int Diag2, int M, int N, int K, double alpha, long A, long B, double beta, long C, int incX, int incY, int KL, int KU) {
        this.validate();
        this.rsnScriptIntrinsicBLAS_Double(this.mContext, id2, func, TransA, TransB, Side2, Uplo2, Diag2, M, N, K, alpha, A, B, beta, C, incX, incY, KL, KU);
    }

    native void rsnScriptIntrinsicBLAS_Complex(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, float var14, float var15, long var16, long var18, float var20, float var21, long var22, int var24, int var25, int var26, int var27);

    synchronized void nScriptIntrinsicBLAS_Complex(long id2, int func, int TransA, int TransB, int Side2, int Uplo2, int Diag2, int M, int N, int K, float alphaX, float alphaY, long A, long B, float betaX, float betaY, long C, int incX, int incY, int KL, int KU) {
        this.validate();
        this.rsnScriptIntrinsicBLAS_Complex(this.mContext, id2, func, TransA, TransB, Side2, Uplo2, Diag2, M, N, K, alphaX, alphaY, A, B, betaX, betaY, C, incX, incY, KL, KU);
    }

    native void rsnScriptIntrinsicBLAS_Z(long var1, long var3, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, double var14, double var16, long var18, long var20, double var22, double var24, long var26, int var28, int var29, int var30, int var31);

    synchronized void nScriptIntrinsicBLAS_Z(long id2, int func, int TransA, int TransB, int Side2, int Uplo2, int Diag2, int M, int N, int K, double alphaX, double alphaY, long A, long B, double betaX, double betaY, long C, int incX, int incY, int KL, int KU) {
        this.validate();
        this.rsnScriptIntrinsicBLAS_Z(this.mContext, id2, func, TransA, TransB, Side2, Uplo2, Diag2, M, N, K, alphaX, alphaY, A, B, betaX, betaY, C, incX, incY, KL, KU);
    }

    native void rsnScriptIntrinsicBLAS_BNNM(long var1, long var3, int var5, int var6, int var7, long var8, int var10, long var11, int var13, long var14, int var16, int var17);

    synchronized void nScriptIntrinsicBLAS_BNNM(long id2, int M, int N, int K, long A, int a_offset, long B, int b_offset, long C, int c_offset, int c_mult_int) {
        this.validate();
        this.rsnScriptIntrinsicBLAS_BNNM(this.mContext, id2, M, N, K, A, a_offset, B, b_offset, C, c_offset, c_mult_int);
    }

    public void setMessageHandler(RSMessageHandler msg) {
        this.mMessageCallback = msg;
    }

    public RSMessageHandler getMessageHandler() {
        return this.mMessageCallback;
    }

    public void sendMessage(int id2, int[] data) {
        this.nContextSendMessage(id2, data);
    }

    public void setErrorHandler(RSErrorHandler msg) {
        this.mErrorCallback = msg;
    }

    public RSErrorHandler getErrorHandler() {
        return this.mErrorCallback;
    }

    void validateObject(BaseObj o) {
        if (o != null && o.mRS != this) {
            throw new RSIllegalArgumentException("Attempting to use an object across contexts.");
        }
    }

    @UnsupportedAppUsage
    void validate() {
        if (this.mContext == 0L) {
            throw new RSInvalidStateException("Calling RS with no Context active.");
        }
    }

    public void setPriority(Priority p) {
        this.validate();
        this.nContextSetPriority(p.mID);
    }

    RenderScript(Context ctx) {
        if (ctx != null) {
            this.mApplicationContext = ctx.getApplicationContext();
        }
        this.mRWLock = new ReentrantReadWriteLock();
        try {
            registerNativeAllocation.invoke(sRuntime, 0x400000);
        }
        catch (Exception e) {
            Log.e(LOG_TAG, "Couldn't invoke registerNativeAllocation:" + e);
            throw new RSRuntimeException("Couldn't invoke registerNativeAllocation:" + e);
        }
    }

    public final Context getApplicationContext() {
        return this.mApplicationContext;
    }

    static synchronized String getCachePath() {
        if (mCachePath == null) {
            String CACHE_PATH = "com.android.renderscript.cache";
            if (RenderScriptCacheDir.mCacheDir == null) {
                throw new RSRuntimeException("RenderScript code cache directory uninitialized.");
            }
            File f = new File(RenderScriptCacheDir.mCacheDir, "com.android.renderscript.cache");
            mCachePath = f.getAbsolutePath();
            f.mkdirs();
        }
        return mCachePath;
    }

    private static RenderScript internalCreate(Context ctx, int sdkVersion, ContextType ct, int flags) {
        if (!sInitialized) {
            Log.e(LOG_TAG, "RenderScript.create() called when disabled; someone is likely to crash");
            return null;
        }
        if ((flags & 0xFFFFFFF1) != 0) {
            throw new RSIllegalArgumentException("Invalid flags passed.");
        }
        RenderScript rs = new RenderScript(ctx);
        long device = rs.nDeviceCreate();
        rs.mContext = rs.nContextCreate(device, flags, sdkVersion, ct.mID);
        rs.mContextType = ct;
        rs.mContextFlags = flags;
        rs.mContextSdkVersion = sdkVersion;
        if (rs.mContext == 0L) {
            throw new RSDriverException("Failed to create RS context.");
        }
        rs.nContextSetCacheDir(RenderScript.getCachePath());
        rs.mMessageThread = new MessageThread(rs);
        rs.mMessageThread.start();
        return rs;
    }

    public static RenderScript create(Context ctx) {
        return RenderScript.create(ctx, ContextType.NORMAL);
    }

    public static RenderScript create(Context ctx, ContextType ct) {
        return RenderScript.create(ctx, ct, 0);
    }

    public static RenderScript create(Context ctx, ContextType ct, int flags) {
        int v = ctx.getApplicationInfo().targetSdkVersion;
        return RenderScript.create(ctx, v, ct, flags);
    }

    @UnsupportedAppUsage
    public static RenderScript create(Context ctx, int sdkVersion) {
        return RenderScript.create(ctx, sdkVersion, ContextType.NORMAL, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    private static RenderScript create(Context ctx, int sdkVersion, ContextType ct, int flags) {
        if (sdkVersion < 23) {
            return RenderScript.internalCreate(ctx, sdkVersion, ct, flags);
        }
        ArrayList<RenderScript> arrayList = mProcessContextList;
        synchronized (arrayList) {
            for (RenderScript prs : mProcessContextList) {
                if (prs.mContextType != ct || prs.mContextFlags != flags || prs.mContextSdkVersion != sdkVersion) continue;
                return prs;
            }
            RenderScript prs = RenderScript.internalCreate(ctx, sdkVersion, ct, flags);
            prs.mIsProcessContext = true;
            mProcessContextList.add(prs);
            return prs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAllContexts() {
        ArrayList<RenderScript> oldList;
        ArrayList<RenderScript> arrayList = mProcessContextList;
        synchronized (arrayList) {
            oldList = mProcessContextList;
            mProcessContextList = new ArrayList();
        }
        for (RenderScript prs : oldList) {
            prs.mIsProcessContext = false;
            prs.destroy();
        }
        oldList.clear();
    }

    public static RenderScript createMultiContext(Context ctx, ContextType ct, int flags, int API_number) {
        return RenderScript.internalCreate(ctx, API_number, ct, flags);
    }

    public void contextDump() {
        this.validate();
        this.nContextDump(0);
    }

    public void finish() {
        this.nContextFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void helpDestroy() {
        boolean shouldDestroy = false;
        RenderScript renderScript = this;
        synchronized (renderScript) {
            if (!this.mDestroyed) {
                shouldDestroy = true;
                this.mDestroyed = true;
            }
        }
        if (shouldDestroy) {
            this.nContextFinish();
            this.nContextDeinitToClient(this.mContext);
            this.mMessageThread.mRun = false;
            this.mMessageThread.interrupt();
            boolean hasJoined = false;
            boolean interrupted = false;
            while (!hasJoined) {
                try {
                    this.mMessageThread.join();
                    hasJoined = true;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Log.v(LOG_TAG, "Interrupted during wait for MessageThread to join");
                Thread.currentThread().interrupt();
            }
            this.nContextDestroy();
        }
    }

    protected void finalize() throws Throwable {
        this.helpDestroy();
        super.finalize();
    }

    public void destroy() {
        if (this.mIsProcessContext) {
            return;
        }
        this.validate();
        this.helpDestroy();
    }

    boolean isAlive() {
        return this.mContext != 0L;
    }

    long safeID(BaseObj o) {
        if (o != null) {
            return o.getID(this);
        }
        return 0L;
    }

    static {
        if (!SystemProperties.getBoolean("config.disable_renderscript", false)) {
            try {
                Class<?> vm_runtime = Class.forName("dalvik.system.VMRuntime");
                Method get_runtime = vm_runtime.getDeclaredMethod("getRuntime", new Class[0]);
                sRuntime = get_runtime.invoke(null, new Object[0]);
                registerNativeAllocation = vm_runtime.getDeclaredMethod("registerNativeAllocation", Long.TYPE);
                registerNativeFree = vm_runtime.getDeclaredMethod("registerNativeFree", Long.TYPE);
            }
            catch (Exception e) {
                Log.e(LOG_TAG, "Error loading GC methods: " + e);
                throw new RSRuntimeException("Error loading GC methods: " + e);
            }
            try {
                System.loadLibrary("rs_jni");
                RenderScript._nInit();
                sInitialized = true;
                sPointerSize = RenderScript.rsnSystemGetPointerSize();
            }
            catch (UnsatisfiedLinkError e) {
                Log.e(LOG_TAG, "Error loading RS jni library: " + e);
                throw new RSRuntimeException("Error loading RS jni library: " + e);
            }
        }
    }

    static class MessageThread
    extends Thread {
        RenderScript mRS;
        boolean mRun = true;
        int[] mAuxData = new int[2];
        static final int RS_MESSAGE_TO_CLIENT_NONE = 0;
        static final int RS_MESSAGE_TO_CLIENT_EXCEPTION = 1;
        static final int RS_MESSAGE_TO_CLIENT_RESIZE = 2;
        static final int RS_MESSAGE_TO_CLIENT_ERROR = 3;
        static final int RS_MESSAGE_TO_CLIENT_USER = 4;
        static final int RS_MESSAGE_TO_CLIENT_NEW_BUFFER = 5;
        static final int RS_ERROR_FATAL_DEBUG = 2048;
        static final int RS_ERROR_FATAL_UNKNOWN = 4096;

        MessageThread(RenderScript rs) {
            super("RSMessageThread");
            this.mRS = rs;
        }

        @Override
        public void run() {
            int[] rbuf = new int[16];
            this.mRS.nContextInitToClient(this.mRS.mContext);
            while (this.mRun) {
                rbuf[0] = 0;
                int msg = this.mRS.nContextPeekMessage(this.mRS.mContext, this.mAuxData);
                int size = this.mAuxData[1];
                int subID = this.mAuxData[0];
                if (msg == 4) {
                    if (size >> 2 >= rbuf.length) {
                        rbuf = new int[size + 3 >> 2];
                    }
                    if (this.mRS.nContextGetUserMessage(this.mRS.mContext, rbuf) != 4) {
                        throw new RSDriverException("Error processing message from RenderScript.");
                    }
                    if (this.mRS.mMessageCallback != null) {
                        this.mRS.mMessageCallback.mData = rbuf;
                        this.mRS.mMessageCallback.mID = subID;
                        this.mRS.mMessageCallback.mLength = size;
                        this.mRS.mMessageCallback.run();
                        continue;
                    }
                    throw new RSInvalidStateException("Received a message from the script with no message handler installed.");
                }
                if (msg == 3) {
                    String e = this.mRS.nContextGetErrorMessage(this.mRS.mContext);
                    if (subID >= 4096 || subID >= 2048 && (this.mRS.mContextType != ContextType.DEBUG || this.mRS.mErrorCallback == null)) {
                        throw new RSRuntimeException("Fatal error " + subID + ", details: " + e);
                    }
                    if (this.mRS.mErrorCallback != null) {
                        this.mRS.mErrorCallback.mErrorMessage = e;
                        this.mRS.mErrorCallback.mErrorNum = subID;
                        this.mRS.mErrorCallback.run();
                        continue;
                    }
                    Log.e(RenderScript.LOG_TAG, "non fatal RS error, " + e);
                    continue;
                }
                if (msg == 5) {
                    if (this.mRS.nContextGetUserMessage(this.mRS.mContext, rbuf) != 5) {
                        throw new RSDriverException("Error processing message from RenderScript.");
                    }
                    long bufferID = ((long)rbuf[1] << 32) + ((long)rbuf[0] & 0xFFFFFFFFL);
                    Allocation.sendBufferNotification(bufferID);
                    continue;
                }
                try {
                    MessageThread.sleep(1L, 0);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public static enum Priority {
        LOW(15),
        NORMAL(-8);

        int mID;

        private Priority(int id2) {
            this.mID = id2;
        }
    }

    public static class RSErrorHandler
    implements Runnable {
        protected String mErrorMessage;
        protected int mErrorNum;

        @Override
        public void run() {
        }
    }

    public static class RSMessageHandler
    implements Runnable {
        protected int[] mData;
        protected int mID;
        protected int mLength;

        @Override
        public void run() {
        }
    }

    public static enum ContextType {
        NORMAL(0),
        DEBUG(1),
        PROFILE(2);

        int mID;

        private ContextType(int id2) {
            this.mID = id2;
        }
    }
}

