/*
 * Decompiled with CFR 0.152.
 */
package android.se.omapi;

import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.se.omapi.Channel;
import android.se.omapi.ISecureElementChannel;
import android.se.omapi.ISecureElementSession;
import android.se.omapi.Reader;
import android.se.omapi.SEService;
import android.util.Log;
import java.io.IOException;
import java.util.NoSuchElementException;

public final class Session {
    private final Object mLock = new Object();
    private final SEService mService;
    private final Reader mReader;
    private final ISecureElementSession mSession;
    private static final String TAG = "OMAPI.Session";

    Session(SEService service, ISecureElementSession session, Reader reader) {
        if (service == null || reader == null || session == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        this.mService = service;
        this.mReader = reader;
        this.mSession = session;
    }

    public Reader getReader() {
        return this.mReader;
    }

    public byte[] getATR() {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        try {
            return this.mSession.getAtr();
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.mService.isConnected()) {
            Log.e(TAG, "service not connected to system");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mSession.close();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error closing session", e);
            }
        }
    }

    public boolean isClosed() {
        try {
            return this.mSession.isClosed();
        }
        catch (RemoteException e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannels() {
        if (!this.mService.isConnected()) {
            Log.e(TAG, "service not connected to system");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.mSession.closeChannels();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error closing channels", e);
            }
        }
    }

    public Channel openBasicChannel(byte[] aid, byte p2) throws IOException {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                ISecureElementChannel channel = this.mSession.openBasicChannel(aid, p2, this.mReader.getSEService().getListener());
                if (channel == null) {
                    return null;
                }
                return new Channel(this.mService, this, channel);
            }
            catch (ServiceSpecificException e) {
                if (e.errorCode == 1) {
                    throw new IOException(e.getMessage());
                }
                if (e.errorCode == 2) {
                    throw new NoSuchElementException(e.getMessage());
                }
                throw new IllegalStateException(e.getMessage());
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
    }

    public Channel openBasicChannel(byte[] aid) throws IOException {
        return this.openBasicChannel(aid, (byte)0);
    }

    public Channel openLogicalChannel(byte[] aid, byte p2) throws IOException {
        if (!this.mService.isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                ISecureElementChannel channel = this.mSession.openLogicalChannel(aid, p2, this.mReader.getSEService().getListener());
                if (channel == null) {
                    return null;
                }
                return new Channel(this.mService, this, channel);
            }
            catch (ServiceSpecificException e) {
                if (e.errorCode == 1) {
                    throw new IOException(e.getMessage());
                }
                if (e.errorCode == 2) {
                    throw new NoSuchElementException(e.getMessage());
                }
                throw new IllegalStateException(e.getMessage());
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
    }

    public Channel openLogicalChannel(byte[] aid) throws IOException {
        return this.openLogicalChannel(aid, (byte)0);
    }
}

