/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.content.ContentResolver;
import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import android.provider.Settings;
import android.security.ConfirmationAlreadyPresentingException;
import android.security.ConfirmationCallback;
import android.security.ConfirmationNotAvailableException;
import android.security.IConfirmationPromptCallback;
import android.security.KeyStore;
import android.text.TextUtils;
import android.util.Log;
import java.util.Locale;
import java.util.concurrent.Executor;

public class ConfirmationPrompt {
    private static final String TAG = "ConfirmationPrompt";
    private CharSequence mPromptText;
    private byte[] mExtraData;
    private ConfirmationCallback mCallback;
    private Executor mExecutor;
    private Context mContext;
    private final KeyStore mKeyStore = KeyStore.getInstance();
    private final IBinder mCallbackBinder = new IConfirmationPromptCallback.Stub(){

        @Override
        public void onConfirmationPromptCompleted(final int responseCode, final byte[] dataThatWasConfirmed) throws RemoteException {
            if (ConfirmationPrompt.this.mCallback != null) {
                final ConfirmationCallback callback = ConfirmationPrompt.this.mCallback;
                Executor executor = ConfirmationPrompt.this.mExecutor;
                ConfirmationPrompt.this.mCallback = null;
                ConfirmationPrompt.this.mExecutor = null;
                if (executor == null) {
                    ConfirmationPrompt.this.doCallback(responseCode, dataThatWasConfirmed, callback);
                } else {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ConfirmationPrompt.this.doCallback(responseCode, dataThatWasConfirmed, callback);
                        }
                    });
                }
            }
        }
    };
    private static final int UI_OPTION_ACCESSIBILITY_INVERTED_FLAG = 1;
    private static final int UI_OPTION_ACCESSIBILITY_MAGNIFIED_FLAG = 2;

    private void doCallback(int responseCode, byte[] dataThatWasConfirmed, ConfirmationCallback callback) {
        switch (responseCode) {
            case 0: {
                callback.onConfirmed(dataThatWasConfirmed);
                break;
            }
            case 1: {
                callback.onDismissed();
                break;
            }
            case 2: {
                callback.onCanceled();
                break;
            }
            case 5: {
                callback.onError(new Exception("System error returned by ConfirmationUI."));
                break;
            }
            default: {
                callback.onError(new Exception("Unexpected responseCode=" + responseCode + " from onConfirmtionPromptCompleted() callback."));
            }
        }
    }

    private ConfirmationPrompt(Context context, CharSequence promptText, byte[] extraData) {
        this.mContext = context;
        this.mPromptText = promptText;
        this.mExtraData = extraData;
    }

    private int getUiOptionsAsFlags() {
        int uiOptionsAsFlags = 0;
        try {
            float fontScale;
            ContentResolver contentResolver = this.mContext.getContentResolver();
            int inversionEnabled = Settings.Secure.getInt(contentResolver, "accessibility_display_inversion_enabled");
            if (inversionEnabled == 1) {
                uiOptionsAsFlags |= 1;
            }
            if ((double)(fontScale = Settings.System.getFloat(contentResolver, "font_scale")) > 1.0) {
                uiOptionsAsFlags |= 2;
            }
        }
        catch (Settings.SettingNotFoundException e) {
            Log.w(TAG, "Unexpected SettingNotFoundException");
        }
        return uiOptionsAsFlags;
    }

    private static boolean isAccessibilityServiceRunning(Context context) {
        boolean serviceRunning = false;
        try {
            ContentResolver contentResolver = context.getContentResolver();
            int a11yEnabled = Settings.Secure.getInt(contentResolver, "accessibility_enabled");
            if (a11yEnabled == 1) {
                serviceRunning = true;
            }
        }
        catch (Settings.SettingNotFoundException e) {
            Log.w(TAG, "Unexpected SettingNotFoundException");
            e.printStackTrace();
        }
        return serviceRunning;
    }

    public void presentPrompt(Executor executor, ConfirmationCallback callback) throws ConfirmationAlreadyPresentingException, ConfirmationNotAvailableException {
        if (this.mCallback != null) {
            throw new ConfirmationAlreadyPresentingException();
        }
        if (ConfirmationPrompt.isAccessibilityServiceRunning(this.mContext)) {
            throw new ConfirmationNotAvailableException();
        }
        this.mCallback = callback;
        this.mExecutor = executor;
        int uiOptionsAsFlags = this.getUiOptionsAsFlags();
        String locale = Locale.getDefault().toLanguageTag();
        int responseCode = this.mKeyStore.presentConfirmationPrompt(this.mCallbackBinder, this.mPromptText.toString(), this.mExtraData, locale, uiOptionsAsFlags);
        switch (responseCode) {
            case 0: {
                return;
            }
            case 3: {
                throw new ConfirmationAlreadyPresentingException();
            }
            case 6: {
                throw new ConfirmationNotAvailableException();
            }
            case 65536: {
                throw new IllegalArgumentException();
            }
        }
        Log.w(TAG, "Unexpected responseCode=" + responseCode + " from presentConfirmationPrompt() call.");
        throw new IllegalArgumentException();
    }

    public void cancelPrompt() {
        int responseCode = this.mKeyStore.cancelConfirmationPrompt(this.mCallbackBinder);
        if (responseCode == 0) {
            return;
        }
        if (responseCode == 3) {
            throw new IllegalStateException();
        }
        Log.w(TAG, "Unexpected responseCode=" + responseCode + " from cancelConfirmationPrompt() call.");
        throw new IllegalStateException();
    }

    public static boolean isSupported(Context context) {
        if (ConfirmationPrompt.isAccessibilityServiceRunning(context)) {
            return false;
        }
        return KeyStore.getInstance().isConfirmationPromptSupported();
    }

    public static final class Builder {
        private Context mContext;
        private CharSequence mPromptText;
        private byte[] mExtraData;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setPromptText(CharSequence promptText) {
            this.mPromptText = promptText;
            return this;
        }

        public Builder setExtraData(byte[] extraData) {
            this.mExtraData = extraData;
            return this;
        }

        public ConfirmationPrompt build() {
            if (TextUtils.isEmpty(this.mPromptText)) {
                throw new IllegalArgumentException("prompt text must be set and non-empty");
            }
            if (this.mExtraData == null) {
                throw new IllegalArgumentException("extraData must be set");
            }
            return new ConfirmationPrompt(this.mContext, this.mPromptText, this.mExtraData);
        }
    }
}

