/*
 * Decompiled with CFR 0.152.
 */
package android.security.keymaster;

import android.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.security.keymaster.KeymasterArgument;
import android.security.keymaster.KeymasterBlobArgument;
import android.security.keymaster.KeymasterBooleanArgument;
import android.security.keymaster.KeymasterDateArgument;
import android.security.keymaster.KeymasterDefs;
import android.security.keymaster.KeymasterIntArgument;
import android.security.keymaster.KeymasterLongArgument;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class KeymasterArguments
implements Parcelable {
    private static final long UINT32_RANGE = 0x100000000L;
    public static final long UINT32_MAX_VALUE = 0xFFFFFFFFL;
    private static final BigInteger UINT64_RANGE = BigInteger.ONE.shiftLeft(64);
    public static final BigInteger UINT64_MAX_VALUE = UINT64_RANGE.subtract(BigInteger.ONE);
    private List<KeymasterArgument> mArguments;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<KeymasterArguments> CREATOR = new Parcelable.Creator<KeymasterArguments>(){

        @Override
        public KeymasterArguments createFromParcel(Parcel in) {
            return new KeymasterArguments(in);
        }

        public KeymasterArguments[] newArray(int size) {
            return new KeymasterArguments[size];
        }
    };

    @UnsupportedAppUsage
    public KeymasterArguments() {
        this.mArguments = new ArrayList<KeymasterArgument>();
    }

    private KeymasterArguments(Parcel in) {
        this.mArguments = in.createTypedArrayList(KeymasterArgument.CREATOR);
    }

    @UnsupportedAppUsage
    public void addEnum(int tag, int value) {
        int tagType = KeymasterDefs.getTagType(tag);
        if (tagType != 0x10000000 && tagType != 0x20000000) {
            throw new IllegalArgumentException("Not an enum or repeating enum tag: " + tag);
        }
        this.addEnumTag(tag, value);
    }

    public void addEnums(int tag, int ... values) {
        if (KeymasterDefs.getTagType(tag) != 0x20000000) {
            throw new IllegalArgumentException("Not a repeating enum tag: " + tag);
        }
        for (int value : values) {
            this.addEnumTag(tag, value);
        }
    }

    public int getEnum(int tag, int defaultValue) {
        if (KeymasterDefs.getTagType(tag) != 0x10000000) {
            throw new IllegalArgumentException("Not an enum tag: " + tag);
        }
        KeymasterArgument arg = this.getArgumentByTag(tag);
        if (arg == null) {
            return defaultValue;
        }
        return this.getEnumTagValue(arg);
    }

    public List<Integer> getEnums(int tag) {
        if (KeymasterDefs.getTagType(tag) != 0x20000000) {
            throw new IllegalArgumentException("Not a repeating enum tag: " + tag);
        }
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (KeymasterArgument arg : this.mArguments) {
            if (arg.tag != tag) continue;
            values.add(this.getEnumTagValue(arg));
        }
        return values;
    }

    private void addEnumTag(int tag, int value) {
        this.mArguments.add(new KeymasterIntArgument(tag, value));
    }

    private int getEnumTagValue(KeymasterArgument arg) {
        return ((KeymasterIntArgument)arg).value;
    }

    @UnsupportedAppUsage
    public void addUnsignedInt(int tag, long value) {
        int tagType = KeymasterDefs.getTagType(tag);
        if (tagType != 0x30000000 && tagType != 0x40000000) {
            throw new IllegalArgumentException("Not an int or repeating int tag: " + tag);
        }
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Int tag value out of range: " + value);
        }
        this.mArguments.add(new KeymasterIntArgument(tag, (int)value));
    }

    public long getUnsignedInt(int tag, long defaultValue) {
        if (KeymasterDefs.getTagType(tag) != 0x30000000) {
            throw new IllegalArgumentException("Not an int tag: " + tag);
        }
        KeymasterArgument arg = this.getArgumentByTag(tag);
        if (arg == null) {
            return defaultValue;
        }
        return (long)((KeymasterIntArgument)arg).value & 0xFFFFFFFFL;
    }

    @UnsupportedAppUsage
    public void addUnsignedLong(int tag, BigInteger value) {
        int tagType = KeymasterDefs.getTagType(tag);
        if (tagType != 0x50000000 && tagType != -1610612736) {
            throw new IllegalArgumentException("Not a long or repeating long tag: " + tag);
        }
        this.addLongTag(tag, value);
    }

    public List<BigInteger> getUnsignedLongs(int tag) {
        if (KeymasterDefs.getTagType(tag) != -1610612736) {
            throw new IllegalArgumentException("Tag is not a repeating long: " + tag);
        }
        ArrayList<BigInteger> values = new ArrayList<BigInteger>();
        for (KeymasterArgument arg : this.mArguments) {
            if (arg.tag != tag) continue;
            values.add(this.getLongTagValue(arg));
        }
        return values;
    }

    private void addLongTag(int tag, BigInteger value) {
        if (value.signum() == -1 || value.compareTo(UINT64_MAX_VALUE) > 0) {
            throw new IllegalArgumentException("Long tag value out of range: " + value);
        }
        this.mArguments.add(new KeymasterLongArgument(tag, value.longValue()));
    }

    private BigInteger getLongTagValue(KeymasterArgument arg) {
        return KeymasterArguments.toUint64(((KeymasterLongArgument)arg).value);
    }

    public void addBoolean(int tag) {
        if (KeymasterDefs.getTagType(tag) != 0x70000000) {
            throw new IllegalArgumentException("Not a boolean tag: " + tag);
        }
        this.mArguments.add(new KeymasterBooleanArgument(tag));
    }

    public boolean getBoolean(int tag) {
        if (KeymasterDefs.getTagType(tag) != 0x70000000) {
            throw new IllegalArgumentException("Not a boolean tag: " + tag);
        }
        KeymasterArgument arg = this.getArgumentByTag(tag);
        return arg != null;
    }

    public void addBytes(int tag, byte[] value) {
        if (KeymasterDefs.getTagType(tag) != -1879048192) {
            throw new IllegalArgumentException("Not a bytes tag: " + tag);
        }
        if (value == null) {
            throw new NullPointerException("value == nulll");
        }
        this.mArguments.add(new KeymasterBlobArgument(tag, value));
    }

    public byte[] getBytes(int tag, byte[] defaultValue) {
        if (KeymasterDefs.getTagType(tag) != -1879048192) {
            throw new IllegalArgumentException("Not a bytes tag: " + tag);
        }
        KeymasterArgument arg = this.getArgumentByTag(tag);
        if (arg == null) {
            return defaultValue;
        }
        return ((KeymasterBlobArgument)arg).blob;
    }

    public void addDate(int tag, Date value) {
        if (KeymasterDefs.getTagType(tag) != 0x60000000) {
            throw new IllegalArgumentException("Not a date tag: " + tag);
        }
        if (value == null) {
            throw new NullPointerException("value == nulll");
        }
        if (value.getTime() < 0L) {
            throw new IllegalArgumentException("Date tag value out of range: " + value);
        }
        this.mArguments.add(new KeymasterDateArgument(tag, value));
    }

    public void addDateIfNotNull(int tag, Date value) {
        if (KeymasterDefs.getTagType(tag) != 0x60000000) {
            throw new IllegalArgumentException("Not a date tag: " + tag);
        }
        if (value != null) {
            this.addDate(tag, value);
        }
    }

    public Date getDate(int tag, Date defaultValue) {
        if (KeymasterDefs.getTagType(tag) != 0x60000000) {
            throw new IllegalArgumentException("Tag is not a date type: " + tag);
        }
        KeymasterArgument arg = this.getArgumentByTag(tag);
        if (arg == null) {
            return defaultValue;
        }
        Date result = ((KeymasterDateArgument)arg).date;
        if (result.getTime() < 0L) {
            throw new IllegalArgumentException("Tag value too large. Tag: " + tag);
        }
        return result;
    }

    private KeymasterArgument getArgumentByTag(int tag) {
        for (KeymasterArgument arg : this.mArguments) {
            if (arg.tag != tag) continue;
            return arg;
        }
        return null;
    }

    public boolean containsTag(int tag) {
        return this.getArgumentByTag(tag) != null;
    }

    public int size() {
        return this.mArguments.size();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeTypedList(this.mArguments);
    }

    @UnsupportedAppUsage
    public void readFromParcel(Parcel in) {
        in.readTypedList(this.mArguments, KeymasterArgument.CREATOR);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static BigInteger toUint64(long value) {
        if (value >= 0L) {
            return BigInteger.valueOf(value);
        }
        return BigInteger.valueOf(value).add(UINT64_RANGE);
    }
}

