/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.SystemApi;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import android.security.keystore.recovery.DecryptionFailedException;
import android.security.keystore.recovery.InternalRecoveryServiceException;
import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.RecoveryCertPath;
import android.security.keystore.recovery.RecoveryController;
import android.security.keystore.recovery.SessionExpiredException;
import android.security.keystore.recovery.WrappedApplicationKey;
import android.util.ArrayMap;
import android.util.Log;
import java.security.Key;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SystemApi
public class RecoverySession
implements AutoCloseable {
    private static final String TAG = "RecoverySession";
    private static final int SESSION_ID_LENGTH_BYTES = 16;
    private final String mSessionId;
    private final RecoveryController mRecoveryController;

    private RecoverySession(RecoveryController recoveryController, String sessionId) {
        this.mRecoveryController = recoveryController;
        this.mSessionId = sessionId;
    }

    static RecoverySession newInstance(RecoveryController recoveryController) {
        return new RecoverySession(recoveryController, RecoverySession.newSessionId());
    }

    private static String newSessionId() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] sessionId = new byte[16];
        secureRandom.nextBytes(sessionId);
        StringBuilder sb = new StringBuilder();
        for (byte b : sessionId) {
            sb.append(Byte.toHexString((byte)b, (boolean)false));
        }
        return sb.toString();
    }

    public byte[] start(String rootCertificateAlias, CertPath verifierCertPath, byte[] vaultParams, byte[] vaultChallenge, List<KeyChainProtectionParams> secrets) throws CertificateException, InternalRecoveryServiceException {
        RecoveryCertPath recoveryCertPath = RecoveryCertPath.createRecoveryCertPath(verifierCertPath);
        try {
            byte[] recoveryClaim = this.mRecoveryController.getBinder().startRecoverySessionWithCertPath(this.mSessionId, rootCertificateAlias, recoveryCertPath, vaultParams, vaultChallenge, secrets);
            return recoveryClaim;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 25 || e.errorCode == 28) {
                throw new CertificateException("Invalid certificate for recovery session", e);
            }
            throw this.mRecoveryController.wrapUnexpectedServiceSpecificException(e);
        }
    }

    public Map<String, Key> recoverKeyChainSnapshot(byte[] recoveryKeyBlob, List<WrappedApplicationKey> applicationKeys) throws SessionExpiredException, DecryptionFailedException, InternalRecoveryServiceException {
        try {
            Map grantAliases = this.mRecoveryController.getBinder().recoverKeyChainSnapshot(this.mSessionId, recoveryKeyBlob, applicationKeys);
            return this.getKeysFromGrants(grantAliases);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (ServiceSpecificException e) {
            if (e.errorCode == 26) {
                throw new DecryptionFailedException(e.getMessage());
            }
            if (e.errorCode == 24) {
                throw new SessionExpiredException(e.getMessage());
            }
            throw this.mRecoveryController.wrapUnexpectedServiceSpecificException(e);
        }
    }

    private Map<String, Key> getKeysFromGrants(Map<String, String> grantAliases) throws InternalRecoveryServiceException {
        ArrayMap<String, Key> keysByAlias = new ArrayMap<String, Key>(grantAliases.size());
        for (String alias : grantAliases.keySet()) {
            Key key;
            String grantAlias = grantAliases.get(alias);
            try {
                key = this.mRecoveryController.getKeyFromGrant(grantAlias);
            }
            catch (KeyPermanentlyInvalidatedException | UnrecoverableKeyException e) {
                throw new InternalRecoveryServiceException(String.format(Locale.US, "Failed to get key '%s' from grant '%s'", alias, grantAlias), e);
            }
            keysByAlias.put(alias, key);
        }
        return keysByAlias;
    }

    String getSessionId() {
        return this.mSessionId;
    }

    @Override
    public void close() {
        try {
            this.mRecoveryController.getBinder().closeSession(this.mSessionId);
        }
        catch (RemoteException | ServiceSpecificException e) {
            Log.e(TAG, "Unexpected error trying to close session", e);
        }
    }
}

