/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;

public class X509CertificateParsingUtils {
    private static final String CERT_FORMAT = "X.509";

    public static X509Certificate decodeBase64Cert(String string2) throws CertificateException {
        try {
            return X509CertificateParsingUtils.decodeCert(X509CertificateParsingUtils.decodeBase64(string2));
        }
        catch (IllegalArgumentException e) {
            throw new CertificateException(e);
        }
    }

    private static byte[] decodeBase64(String string2) {
        return Base64.getDecoder().decode(string2);
    }

    private static X509Certificate decodeCert(byte[] certBytes) throws CertificateException {
        return X509CertificateParsingUtils.decodeCert(new ByteArrayInputStream(certBytes));
    }

    private static X509Certificate decodeCert(InputStream inStream) throws CertificateException {
        CertificateFactory certFactory;
        try {
            certFactory = CertificateFactory.getInstance(CERT_FORMAT);
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        return (X509Certificate)certFactory.generateCertificate(inStream);
    }
}

