/*
 * Decompiled with CFR 0.152.
 */
package android.service.appprediction;

import android.annotation.SystemApi;
import android.app.Service;
import android.app.prediction.AppPredictionContext;
import android.app.prediction.AppPredictionSessionId;
import android.app.prediction.AppTarget;
import android.app.prediction.AppTargetEvent;
import android.app.prediction.AppTargetId;
import android.app.prediction.IPredictionCallback;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.service.appprediction.IPredictionService;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import com.android.internal.util.function.pooled.PooledLambda;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

@SystemApi
public abstract class AppPredictionService
extends Service {
    private static final String TAG = "AppPredictionService";
    public static final String SERVICE_INTERFACE = "android.service.appprediction.AppPredictionService";
    private final ArrayMap<AppPredictionSessionId, ArrayList<CallbackWrapper>> mSessionCallbacks = new ArrayMap();
    private Handler mHandler;
    private final IPredictionService mInterface = new IPredictionService.Stub(){

        @Override
        public void onCreatePredictionSession(AppPredictionContext context, AppPredictionSessionId sessionId) {
            AppPredictionService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1) -> ((AppPredictionService)rec$).doCreatePredictionSession(x$0, x$1), AppPredictionService.this, context, sessionId));
        }

        @Override
        public void notifyAppTargetEvent(AppPredictionSessionId sessionId, AppTargetEvent event) {
            AppPredictionService.this.mHandler.sendMessage(PooledLambda.obtainMessage(AppPredictionService::onAppTargetEvent, AppPredictionService.this, sessionId, event));
        }

        @Override
        public void notifyLaunchLocationShown(AppPredictionSessionId sessionId, String launchLocation, ParceledListSlice targetIds) {
            AppPredictionService.this.mHandler.sendMessage(PooledLambda.obtainMessage(AppPredictionService::onLaunchLocationShown, AppPredictionService.this, sessionId, launchLocation, targetIds.getList()));
        }

        @Override
        public void sortAppTargets(AppPredictionSessionId sessionId, ParceledListSlice targets, IPredictionCallback callback) {
            AppPredictionService.this.mHandler.sendMessage(PooledLambda.obtainMessage(AppPredictionService::onSortAppTargets, AppPredictionService.this, sessionId, targets.getList(), null, new CallbackWrapper(callback, null)));
        }

        @Override
        public void registerPredictionUpdates(AppPredictionSessionId sessionId, IPredictionCallback callback) {
            AppPredictionService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1) -> ((AppPredictionService)rec$).doRegisterPredictionUpdates(x$0, x$1), AppPredictionService.this, sessionId, callback));
        }

        @Override
        public void unregisterPredictionUpdates(AppPredictionSessionId sessionId, IPredictionCallback callback) {
            AppPredictionService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1) -> ((AppPredictionService)rec$).doUnregisterPredictionUpdates(x$0, x$1), AppPredictionService.this, sessionId, callback));
        }

        @Override
        public void requestPredictionUpdate(AppPredictionSessionId sessionId) {
            AppPredictionService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0) -> ((AppPredictionService)rec$).doRequestPredictionUpdate(x$0), AppPredictionService.this, sessionId));
        }

        @Override
        public void onDestroyPredictionSession(AppPredictionSessionId sessionId) {
            AppPredictionService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0) -> ((AppPredictionService)rec$).doDestroyPredictionSession(x$0), AppPredictionService.this, sessionId));
        }
    };

    @Override
    public void onCreate() {
        super.onCreate();
        this.mHandler = new Handler(Looper.getMainLooper(), null, true);
    }

    @Override
    public final IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mInterface.asBinder();
        }
        Log.w(TAG, "Tried to bind to wrong intent (should be android.service.appprediction.AppPredictionService: " + intent);
        return null;
    }

    public abstract void onAppTargetEvent(AppPredictionSessionId var1, AppTargetEvent var2);

    public abstract void onLaunchLocationShown(AppPredictionSessionId var1, String var2, List<AppTargetId> var3);

    private void doCreatePredictionSession(AppPredictionContext context, AppPredictionSessionId sessionId) {
        this.mSessionCallbacks.put(sessionId, new ArrayList());
        this.onCreatePredictionSession(context, sessionId);
    }

    public void onCreatePredictionSession(AppPredictionContext context, AppPredictionSessionId sessionId) {
    }

    public abstract void onSortAppTargets(AppPredictionSessionId var1, List<AppTarget> var2, CancellationSignal var3, Consumer<List<AppTarget>> var4);

    private void doRegisterPredictionUpdates(AppPredictionSessionId sessionId, IPredictionCallback callback) {
        ArrayList<CallbackWrapper> callbacks = this.mSessionCallbacks.get(sessionId);
        if (callbacks == null) {
            Slog.e(TAG, "Failed to register for updates for unknown session: " + sessionId);
            return;
        }
        CallbackWrapper wrapper = this.findCallbackWrapper(callbacks, callback);
        if (wrapper == null) {
            callbacks.add(new CallbackWrapper(callback, callbackWrapper -> this.mHandler.post(() -> this.removeCallbackWrapper(callbacks, (CallbackWrapper)callbackWrapper))));
            if (callbacks.size() == 1) {
                this.onStartPredictionUpdates();
            }
        }
    }

    public void onStartPredictionUpdates() {
    }

    private void doUnregisterPredictionUpdates(AppPredictionSessionId sessionId, IPredictionCallback callback) {
        ArrayList<CallbackWrapper> callbacks = this.mSessionCallbacks.get(sessionId);
        if (callbacks == null) {
            Slog.e(TAG, "Failed to unregister for updates for unknown session: " + sessionId);
            return;
        }
        CallbackWrapper wrapper = this.findCallbackWrapper(callbacks, callback);
        if (wrapper != null) {
            this.removeCallbackWrapper(callbacks, wrapper);
        }
    }

    private void removeCallbackWrapper(ArrayList<CallbackWrapper> callbacks, CallbackWrapper wrapper) {
        if (callbacks == null) {
            return;
        }
        callbacks.remove(wrapper);
        if (callbacks.isEmpty()) {
            this.onStopPredictionUpdates();
        }
    }

    public void onStopPredictionUpdates() {
    }

    private void doRequestPredictionUpdate(AppPredictionSessionId sessionId) {
        ArrayList<CallbackWrapper> callbacks = this.mSessionCallbacks.get(sessionId);
        if (callbacks != null && !callbacks.isEmpty()) {
            this.onRequestPredictionUpdate(sessionId);
        }
    }

    public abstract void onRequestPredictionUpdate(AppPredictionSessionId var1);

    private void doDestroyPredictionSession(AppPredictionSessionId sessionId) {
        this.mSessionCallbacks.remove(sessionId);
        this.onDestroyPredictionSession(sessionId);
    }

    public void onDestroyPredictionSession(AppPredictionSessionId sessionId) {
    }

    public final void updatePredictions(AppPredictionSessionId sessionId, List<AppTarget> targets) {
        List callbacks = this.mSessionCallbacks.get(sessionId);
        if (callbacks != null) {
            for (CallbackWrapper callback : callbacks) {
                callback.accept(targets);
            }
        }
    }

    private CallbackWrapper findCallbackWrapper(ArrayList<CallbackWrapper> callbacks, IPredictionCallback callback) {
        for (int i = callbacks.size() - 1; i >= 0; --i) {
            if (!callbacks.get(i).isCallback(callback)) continue;
            return callbacks.get(i);
        }
        return null;
    }

    private static final class CallbackWrapper
    implements Consumer<List<AppTarget>>,
    IBinder.DeathRecipient {
        private IPredictionCallback mCallback;
        private final Consumer<CallbackWrapper> mOnBinderDied;

        CallbackWrapper(IPredictionCallback callback, Consumer<CallbackWrapper> onBinderDied) {
            this.mCallback = callback;
            this.mOnBinderDied = onBinderDied;
            try {
                this.mCallback.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Slog.e(AppPredictionService.TAG, "Failed to link to death: " + e);
            }
        }

        public boolean isCallback(IPredictionCallback callback) {
            if (this.mCallback == null) {
                Slog.e(AppPredictionService.TAG, "Callback is null, likely the binder has died.");
                return false;
            }
            return this.mCallback.equals(callback);
        }

        @Override
        public void accept(List<AppTarget> ts) {
            try {
                if (this.mCallback != null) {
                    this.mCallback.onResult(new ParceledListSlice<AppTarget>(ts));
                }
            }
            catch (RemoteException e) {
                Slog.e(AppPredictionService.TAG, "Error sending result:" + e);
            }
        }

        @Override
        public void binderDied() {
            this.mCallback = null;
            if (this.mOnBinderDied != null) {
                this.mOnBinderDied.accept(this);
            }
        }
    }
}

