/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.service.autofill.IAutofillFieldClassificationService;
import android.util.Log;
import android.view.autofill.AutofillValue;
import com.android.internal.util.function.pooled.PooledLambda;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@SystemApi
public abstract class AutofillFieldClassificationService
extends Service {
    private static final String TAG = "AutofillFieldClassificationService";
    public static final String SERVICE_INTERFACE = "android.service.autofill.AutofillFieldClassificationService";
    public static final String SERVICE_META_DATA_KEY_DEFAULT_ALGORITHM = "android.autofill.field_classification.default_algorithm";
    public static final String SERVICE_META_DATA_KEY_AVAILABLE_ALGORITHMS = "android.autofill.field_classification.available_algorithms";
    public static final String REQUIRED_ALGORITHM_EDIT_DISTANCE = "EDIT_DISTANCE";
    public static final String REQUIRED_ALGORITHM_EXACT_MATCH = "EXACT_MATCH";
    public static final String EXTRA_SCORES = "scores";
    private AutofillFieldClassificationServiceWrapper mWrapper;
    private final Handler mHandler = new Handler(Looper.getMainLooper(), null, true);

    private void calculateScores(RemoteCallback callback, List<AutofillValue> actualValues, String[] userDataValues, String[] categoryIds, String defaultAlgorithm, Bundle defaultArgs, Map algorithms, Map args) {
        Bundle data = new Bundle();
        float[][] scores = this.onCalculateScores(actualValues, Arrays.asList(userDataValues), Arrays.asList(categoryIds), defaultAlgorithm, defaultArgs, algorithms, args);
        if (scores != null) {
            data.putParcelable(EXTRA_SCORES, new Scores(scores));
        }
        callback.sendResult(data);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        this.mWrapper = new AutofillFieldClassificationServiceWrapper();
    }

    @Override
    public IBinder onBind(Intent intent) {
        return this.mWrapper;
    }

    @SystemApi
    @Deprecated
    public float[][] onGetScores(String algorithm, Bundle algorithmOptions, List<AutofillValue> actualValues, List<String> userDataValues) {
        Log.e(TAG, "service implementation (" + this.getClass() + " does not implement onGetScores()");
        return null;
    }

    @SystemApi
    public float[][] onCalculateScores(List<AutofillValue> actualValues, List<String> userDataValues, List<String> categoryIds, String defaultAlgorithm, Bundle defaultArgs, Map algorithms, Map args) {
        Log.e(TAG, "service implementation (" + this.getClass() + " does not implement onCalculateScore()");
        return null;
    }

    public static final class Scores
    implements Parcelable {
        public final float[][] scores;
        public static final Parcelable.Creator<Scores> CREATOR = new Parcelable.Creator<Scores>(){

            @Override
            public Scores createFromParcel(Parcel parcel) {
                return new Scores(parcel);
            }

            public Scores[] newArray(int size) {
                return new Scores[size];
            }
        };

        private Scores(Parcel parcel) {
            int size1 = parcel.readInt();
            int size2 = parcel.readInt();
            this.scores = new float[size1][size2];
            for (int i = 0; i < size1; ++i) {
                for (int j = 0; j < size2; ++j) {
                    this.scores[i][j] = parcel.readFloat();
                }
            }
        }

        private Scores(float[][] scores) {
            this.scores = scores;
        }

        public String toString() {
            int size1 = this.scores.length;
            int size2 = size1 > 0 ? this.scores[0].length : 0;
            StringBuilder builder = new StringBuilder("Scores [").append(size1).append("x").append(size2).append("] ");
            for (int i = 0; i < size1; ++i) {
                builder.append(i).append(": ").append(Arrays.toString(this.scores[i])).append(' ');
            }
            return builder.toString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            int size1 = this.scores.length;
            int size2 = this.scores[0].length;
            parcel.writeInt(size1);
            parcel.writeInt(size2);
            for (int i = 0; i < size1; ++i) {
                for (int j = 0; j < size2; ++j) {
                    parcel.writeFloat(this.scores[i][j]);
                }
            }
        }
    }

    private final class AutofillFieldClassificationServiceWrapper
    extends IAutofillFieldClassificationService.Stub {
        private AutofillFieldClassificationServiceWrapper() {
        }

        @Override
        public void calculateScores(RemoteCallback callback, List<AutofillValue> actualValues, String[] userDataValues, String[] categoryIds, String defaultAlgorithm, Bundle defaultArgs, Map algorithms, Map args) throws RemoteException {
            AutofillFieldClassificationService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7) -> ((AutofillFieldClassificationService)rec$).calculateScores(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7), AutofillFieldClassificationService.this, callback, actualValues, userDataValues, categoryIds, defaultAlgorithm, defaultArgs, algorithms, args));
        }
    }
}

