/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.metrics.LogMaker;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.PrintWriter;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class AutofillServiceInfo {
    private static final String TAG = "AutofillServiceInfo";
    private static final String TAG_AUTOFILL_SERVICE = "autofill-service";
    private static final String TAG_COMPATIBILITY_PACKAGE = "compatibility-package";
    private final ServiceInfo mServiceInfo;
    private final String mSettingsActivity;
    private final ArrayMap<String, Long> mCompatibilityPackages;

    private static ServiceInfo getServiceInfoOrThrow(ComponentName comp, int userHandle) throws PackageManager.NameNotFoundException {
        try {
            ServiceInfo si = AppGlobals.getPackageManager().getServiceInfo(comp, 128, userHandle);
            if (si != null) {
                return si;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        throw new PackageManager.NameNotFoundException(comp.toString());
    }

    public AutofillServiceInfo(Context context, ComponentName comp, int userHandle) throws PackageManager.NameNotFoundException {
        this(context, AutofillServiceInfo.getServiceInfoOrThrow(comp, userHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutofillServiceInfo(Context context, ServiceInfo si) {
        ArrayMap<String, Long> compatibilityPackages;
        String settingsActivity;
        block13: {
            if (!"android.permission.BIND_AUTOFILL_SERVICE".equals(si.permission)) {
                if ("android.permission.BIND_AUTOFILL".equals(si.permission)) {
                    Log.w(TAG, "AutofillService from '" + si.packageName + "' uses unsupported permission " + "android.permission.BIND_AUTOFILL" + ". It works for now, but might not be supported on future releases");
                    new MetricsLogger().write(new LogMaker(1289).setPackageName(si.packageName));
                } else {
                    Log.w(TAG, "AutofillService from '" + si.packageName + "' does not require permission " + "android.permission.BIND_AUTOFILL_SERVICE");
                    throw new SecurityException("Service does not require permission android.permission.BIND_AUTOFILL_SERVICE");
                }
            }
            this.mServiceInfo = si;
            XmlResourceParser parser = si.loadXmlMetaData(context.getPackageManager(), "android.autofill");
            if (parser == null) {
                this.mSettingsActivity = null;
                this.mCompatibilityPackages = null;
                return;
            }
            settingsActivity = null;
            compatibilityPackages = null;
            try {
                Resources resources = context.getPackageManager().getResourcesForApplication(si.applicationInfo);
                int type = 0;
                while (type != 1 && type != 2) {
                    type = parser.next();
                }
                if (TAG_AUTOFILL_SERVICE.equals(parser.getName())) {
                    AttributeSet allAttributes = Xml.asAttributeSet(parser);
                    TypedArray afsAttributes = null;
                    try {
                        afsAttributes = resources.obtainAttributes(allAttributes, R.styleable.AutofillService);
                        settingsActivity = afsAttributes.getString(0);
                    }
                    finally {
                        if (afsAttributes != null) {
                            afsAttributes.recycle();
                        }
                    }
                    compatibilityPackages = this.parseCompatibilityPackages(parser, resources);
                    break block13;
                }
                Log.e(TAG, "Meta-data does not start with autofill-service tag");
            }
            catch (PackageManager.NameNotFoundException | IOException | XmlPullParserException e) {
                Log.e(TAG, "Error parsing auto fill service meta-data", e);
            }
        }
        this.mSettingsActivity = settingsActivity;
        this.mCompatibilityPackages = compatibilityPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayMap<String, Long> parseCompatibilityPackages(XmlPullParser parser, Resources resources) throws IOException, XmlPullParserException {
        int type;
        ArrayMap<String, Long> compatibilityPackages = null;
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type == 3 || type == 4 || !TAG_COMPATIBILITY_PACKAGE.equals(parser.getName())) continue;
            TypedArray cpAttributes = null;
            try {
                Long maxVersionCode;
                AttributeSet allAttributes = Xml.asAttributeSet(parser);
                cpAttributes = resources.obtainAttributes(allAttributes, R.styleable.AutofillService_CompatibilityPackage);
                String name = cpAttributes.getString(0);
                if (TextUtils.isEmpty(name)) {
                    Log.e(TAG, "Invalid compatibility package:" + name);
                    break;
                }
                String maxVersionCodeStr = cpAttributes.getString(1);
                if (maxVersionCodeStr != null) {
                    try {
                        maxVersionCode = Long.parseLong(maxVersionCodeStr);
                    }
                    catch (NumberFormatException e) {
                        Log.e(TAG, "Invalid compatibility max version code:" + maxVersionCodeStr);
                        XmlUtils.skipCurrentTag(parser);
                        if (cpAttributes == null) break;
                        cpAttributes.recycle();
                        break;
                    }
                    if (maxVersionCode < 0L) {
                        Log.e(TAG, "Invalid compatibility max version code:" + maxVersionCode);
                        break;
                    }
                } else {
                    maxVersionCode = Long.MAX_VALUE;
                }
                if (compatibilityPackages == null) {
                    compatibilityPackages = new ArrayMap<String, Long>();
                }
                compatibilityPackages.put(name, maxVersionCode);
            }
            finally {
                XmlUtils.skipCurrentTag(parser);
                if (cpAttributes == null) continue;
                cpAttributes.recycle();
            }
        }
        return compatibilityPackages;
    }

    public ServiceInfo getServiceInfo() {
        return this.mServiceInfo;
    }

    public String getSettingsActivity() {
        return this.mSettingsActivity;
    }

    public ArrayMap<String, Long> getCompatibilityPackages() {
        return this.mCompatibilityPackages;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("[").append(this.mServiceInfo);
        builder.append(", settings:").append(this.mSettingsActivity);
        builder.append(", hasCompatPckgs:").append(this.mCompatibilityPackages != null && !this.mCompatibilityPackages.isEmpty()).append("]");
        return builder.toString();
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("Component: ");
        pw.println(this.getServiceInfo().getComponentName());
        pw.print(prefix);
        pw.print("Settings: ");
        pw.println(this.mSettingsActivity);
        pw.print(prefix);
        pw.print("Compat packages: ");
        pw.println(this.mCompatibilityPackages);
    }
}

