/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalTransformation;
import android.service.autofill.Transformation;
import android.util.Pair;
import android.view.autofill.Helper;
import android.widget.RemoteViews;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;

public final class BatchUpdates
implements Parcelable {
    private final ArrayList<Pair<Integer, InternalTransformation>> mTransformations;
    private final RemoteViews mUpdates;
    public static final Parcelable.Creator<BatchUpdates> CREATOR = new Parcelable.Creator<BatchUpdates>(){

        @Override
        public BatchUpdates createFromParcel(Parcel parcel) {
            RemoteViews updates;
            Builder builder = new Builder();
            int[] ids = parcel.createIntArray();
            if (ids != null) {
                InternalTransformation[] values = (InternalTransformation[])parcel.readParcelableArray(null, InternalTransformation.class);
                int size = ids.length;
                for (int i = 0; i < size; ++i) {
                    builder.transformChild(ids[i], values[i]);
                }
            }
            if ((updates = (RemoteViews)parcel.readParcelable(null)) != null) {
                builder.updateTemplate(updates);
            }
            return builder.build();
        }

        public BatchUpdates[] newArray(int size) {
            return new BatchUpdates[size];
        }
    };

    private BatchUpdates(Builder builder) {
        this.mTransformations = builder.mTransformations;
        this.mUpdates = builder.mUpdates;
    }

    public ArrayList<Pair<Integer, InternalTransformation>> getTransformations() {
        return this.mTransformations;
    }

    public RemoteViews getUpdates() {
        return this.mUpdates;
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "BatchUpdates: [" + ", transformations=" + (this.mTransformations == null ? "N/A" : Integer.valueOf(this.mTransformations.size())) + ", updates=" + this.mUpdates + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.mTransformations == null) {
            dest.writeIntArray(null);
        } else {
            int size = this.mTransformations.size();
            int[] ids = new int[size];
            Parcelable[] values = new InternalTransformation[size];
            for (int i = 0; i < size; ++i) {
                Pair<Integer, InternalTransformation> pair = this.mTransformations.get(i);
                ids[i] = (Integer)pair.first;
                values[i] = (InternalTransformation)pair.second;
            }
            dest.writeIntArray(ids);
            dest.writeParcelableArray(values, flags);
        }
        dest.writeParcelable(this.mUpdates, flags);
    }

    public static class Builder {
        private RemoteViews mUpdates;
        private boolean mDestroyed;
        private ArrayList<Pair<Integer, InternalTransformation>> mTransformations;

        public Builder updateTemplate(RemoteViews updates) {
            this.throwIfDestroyed();
            this.mUpdates = Preconditions.checkNotNull(updates);
            return this;
        }

        public Builder transformChild(int id2, Transformation transformation) {
            this.throwIfDestroyed();
            Preconditions.checkArgument(transformation instanceof InternalTransformation, "not provided by Android System: " + transformation);
            if (this.mTransformations == null) {
                this.mTransformations = new ArrayList();
            }
            this.mTransformations.add(new Pair<Integer, InternalTransformation>(id2, (InternalTransformation)transformation));
            return this;
        }

        public BatchUpdates build() {
            this.throwIfDestroyed();
            Preconditions.checkState(this.mUpdates != null || this.mTransformations != null, "must call either updateTemplate() or transformChild() at least once");
            this.mDestroyed = true;
            return new BatchUpdates(this);
        }

        private void throwIfDestroyed() {
            if (this.mDestroyed) {
                throw new IllegalStateException("Already called #build()");
            }
        }
    }
}

