/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.FieldClassificationUserData;
import android.service.autofill.UserData;
import android.util.ArrayMap;
import android.view.autofill.Helper;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;

public final class CompositeUserData
implements FieldClassificationUserData,
Parcelable {
    private final UserData mGenericUserData;
    private final UserData mPackageUserData;
    private final String[] mCategories;
    private final String[] mValues;
    public static final Parcelable.Creator<CompositeUserData> CREATOR = new Parcelable.Creator<CompositeUserData>(){

        @Override
        public CompositeUserData createFromParcel(Parcel parcel) {
            UserData genericUserData = (UserData)parcel.readParcelable(null);
            UserData packageUserData = (UserData)parcel.readParcelable(null);
            return new CompositeUserData(genericUserData, packageUserData);
        }

        public CompositeUserData[] newArray(int size) {
            return new CompositeUserData[size];
        }
    };

    public CompositeUserData(UserData genericUserData, UserData packageUserData) {
        this.mGenericUserData = genericUserData;
        this.mPackageUserData = packageUserData;
        String[] packageCategoryIds = this.mPackageUserData.getCategoryIds();
        String[] packageValues = this.mPackageUserData.getValues();
        ArrayList<String> categoryIds = new ArrayList<String>(packageCategoryIds.length);
        ArrayList<String> values = new ArrayList<String>(packageValues.length);
        Collections.addAll(categoryIds, packageCategoryIds);
        Collections.addAll(values, packageValues);
        if (this.mGenericUserData != null) {
            String[] genericCategoryIds = this.mGenericUserData.getCategoryIds();
            String[] genericValues = this.mGenericUserData.getValues();
            int size = this.mGenericUserData.getCategoryIds().length;
            for (int i = 0; i < size; ++i) {
                if (categoryIds.contains(genericCategoryIds[i])) continue;
                categoryIds.add(genericCategoryIds[i]);
                values.add(genericValues[i]);
            }
        }
        this.mCategories = new String[categoryIds.size()];
        categoryIds.toArray(this.mCategories);
        this.mValues = new String[values.size()];
        values.toArray(this.mValues);
    }

    @Override
    public String getFieldClassificationAlgorithm() {
        String packageDefaultAlgo = this.mPackageUserData.getFieldClassificationAlgorithm();
        if (packageDefaultAlgo != null) {
            return packageDefaultAlgo;
        }
        return this.mGenericUserData == null ? null : this.mGenericUserData.getFieldClassificationAlgorithm();
    }

    @Override
    public Bundle getDefaultFieldClassificationArgs() {
        Bundle packageDefaultArgs = this.mPackageUserData.getDefaultFieldClassificationArgs();
        if (packageDefaultArgs != null) {
            return packageDefaultArgs;
        }
        return this.mGenericUserData == null ? null : this.mGenericUserData.getDefaultFieldClassificationArgs();
    }

    @Override
    public String getFieldClassificationAlgorithmForCategory(String categoryId) {
        Preconditions.checkNotNull(categoryId);
        ArrayMap<String, String> categoryAlgorithms = this.getFieldClassificationAlgorithms();
        if (categoryAlgorithms == null || !categoryAlgorithms.containsKey(categoryId)) {
            return null;
        }
        return categoryAlgorithms.get(categoryId);
    }

    @Override
    public ArrayMap<String, String> getFieldClassificationAlgorithms() {
        ArrayMap<String, String> packageAlgos = this.mPackageUserData.getFieldClassificationAlgorithms();
        ArrayMap<String, String> genericAlgos = this.mGenericUserData == null ? null : this.mGenericUserData.getFieldClassificationAlgorithms();
        ArrayMap<String, String> categoryAlgorithms = null;
        if (packageAlgos != null || genericAlgos != null) {
            categoryAlgorithms = new ArrayMap<String, String>();
            if (genericAlgos != null) {
                categoryAlgorithms.putAll(genericAlgos);
            }
            if (packageAlgos != null) {
                categoryAlgorithms.putAll(packageAlgos);
            }
        }
        return categoryAlgorithms;
    }

    @Override
    public ArrayMap<String, Bundle> getFieldClassificationArgs() {
        ArrayMap<String, Bundle> packageArgs = this.mPackageUserData.getFieldClassificationArgs();
        ArrayMap<String, Bundle> genericArgs = this.mGenericUserData == null ? null : this.mGenericUserData.getFieldClassificationArgs();
        ArrayMap<String, Bundle> categoryArgs = null;
        if (packageArgs != null || genericArgs != null) {
            categoryArgs = new ArrayMap<String, Bundle>();
            if (genericArgs != null) {
                categoryArgs.putAll(genericArgs);
            }
            if (packageArgs != null) {
                categoryArgs.putAll(packageArgs);
            }
        }
        return categoryArgs;
    }

    @Override
    public String[] getCategoryIds() {
        return this.mCategories;
    }

    @Override
    public String[] getValues() {
        return this.mValues;
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        StringBuilder builder = new StringBuilder("genericUserData=").append(this.mGenericUserData).append(", packageUserData=").append(this.mPackageUserData);
        return builder.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mGenericUserData, 0);
        parcel.writeParcelable(this.mPackageUserData, 0);
    }
}

