/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.BatchUpdates;
import android.service.autofill.InternalOnClickAction;
import android.service.autofill.InternalTransformation;
import android.service.autofill.InternalValidator;
import android.service.autofill.OnClickAction;
import android.service.autofill.Transformation;
import android.service.autofill.Validator;
import android.util.Pair;
import android.util.SparseArray;
import android.view.autofill.Helper;
import android.widget.RemoteViews;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;

public final class CustomDescription
implements Parcelable {
    private final RemoteViews mPresentation;
    private final ArrayList<Pair<Integer, InternalTransformation>> mTransformations;
    private final ArrayList<Pair<InternalValidator, BatchUpdates>> mUpdates;
    private final SparseArray<InternalOnClickAction> mActions;
    public static final Parcelable.Creator<CustomDescription> CREATOR = new Parcelable.Creator<CustomDescription>(){

        @Override
        public CustomDescription createFromParcel(Parcel parcel) {
            int[] actionIds;
            InternalValidator[] conditions;
            RemoteViews parentPresentation = (RemoteViews)parcel.readParcelable(null);
            if (parentPresentation == null) {
                return null;
            }
            Builder builder = new Builder(parentPresentation);
            int[] transformationIds = parcel.createIntArray();
            if (transformationIds != null) {
                InternalTransformation[] values = (InternalTransformation[])parcel.readParcelableArray(null, InternalTransformation.class);
                int size = transformationIds.length;
                for (int i = 0; i < size; ++i) {
                    builder.addChild(transformationIds[i], values[i]);
                }
            }
            if ((conditions = (InternalValidator[])parcel.readParcelableArray(null, InternalValidator.class)) != null) {
                BatchUpdates[] updates = (BatchUpdates[])parcel.readParcelableArray(null, BatchUpdates.class);
                int size = conditions.length;
                for (int i = 0; i < size; ++i) {
                    builder.batchUpdate(conditions[i], updates[i]);
                }
            }
            if ((actionIds = parcel.createIntArray()) != null) {
                InternalOnClickAction[] values = (InternalOnClickAction[])parcel.readParcelableArray(null, InternalOnClickAction.class);
                int size = actionIds.length;
                for (int i = 0; i < size; ++i) {
                    builder.addOnClickAction(actionIds[i], values[i]);
                }
            }
            return builder.build();
        }

        public CustomDescription[] newArray(int size) {
            return new CustomDescription[size];
        }
    };

    private CustomDescription(Builder builder) {
        this.mPresentation = builder.mPresentation;
        this.mTransformations = builder.mTransformations;
        this.mUpdates = builder.mUpdates;
        this.mActions = builder.mActions;
    }

    public RemoteViews getPresentation() {
        return this.mPresentation;
    }

    public ArrayList<Pair<Integer, InternalTransformation>> getTransformations() {
        return this.mTransformations;
    }

    public ArrayList<Pair<InternalValidator, BatchUpdates>> getUpdates() {
        return this.mUpdates;
    }

    public SparseArray<InternalOnClickAction> getActions() {
        return this.mActions;
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "CustomDescription: [presentation=" + this.mPresentation + ", transformations=" + (this.mTransformations == null ? "N/A" : Integer.valueOf(this.mTransformations.size())) + ", updates=" + (this.mUpdates == null ? "N/A" : Integer.valueOf(this.mUpdates.size())) + ", actions=" + (this.mActions == null ? "N/A" : Integer.valueOf(this.mActions.size())) + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Pair<Object, Parcelable> pair;
        int i;
        Parcelable[] values;
        int[] ids;
        int size;
        dest.writeParcelable(this.mPresentation, flags);
        if (this.mPresentation == null) {
            return;
        }
        if (this.mTransformations == null) {
            dest.writeIntArray(null);
        } else {
            size = this.mTransformations.size();
            ids = new int[size];
            values = new InternalTransformation[size];
            for (i = 0; i < size; ++i) {
                pair = this.mTransformations.get(i);
                ids[i] = (Integer)pair.first;
                values[i] = (InternalTransformation)pair.second;
            }
            dest.writeIntArray(ids);
            dest.writeParcelableArray(values, flags);
        }
        if (this.mUpdates == null) {
            dest.writeParcelableArray(null, flags);
        } else {
            size = this.mUpdates.size();
            Parcelable[] conditions = new InternalValidator[size];
            Parcelable[] updates = new BatchUpdates[size];
            for (i = 0; i < size; ++i) {
                pair = this.mUpdates.get(i);
                conditions[i] = (InternalValidator)pair.first;
                updates[i] = (BatchUpdates)pair.second;
            }
            dest.writeParcelableArray(conditions, flags);
            dest.writeParcelableArray(updates, flags);
        }
        if (this.mActions == null) {
            dest.writeIntArray(null);
        } else {
            size = this.mActions.size();
            ids = new int[size];
            values = new InternalOnClickAction[size];
            for (i = 0; i < size; ++i) {
                ids[i] = this.mActions.keyAt(i);
                values[i] = this.mActions.valueAt(i);
            }
            dest.writeIntArray(ids);
            dest.writeParcelableArray(values, flags);
        }
    }

    public static class Builder {
        private final RemoteViews mPresentation;
        private boolean mDestroyed;
        private ArrayList<Pair<Integer, InternalTransformation>> mTransformations;
        private ArrayList<Pair<InternalValidator, BatchUpdates>> mUpdates;
        private SparseArray<InternalOnClickAction> mActions;

        public Builder(RemoteViews parentPresentation) {
            this.mPresentation = Preconditions.checkNotNull(parentPresentation);
        }

        public Builder addChild(int id2, Transformation transformation) {
            this.throwIfDestroyed();
            Preconditions.checkArgument(transformation instanceof InternalTransformation, "not provided by Android System: " + transformation);
            if (this.mTransformations == null) {
                this.mTransformations = new ArrayList();
            }
            this.mTransformations.add(new Pair<Integer, InternalTransformation>(id2, (InternalTransformation)transformation));
            return this;
        }

        public Builder batchUpdate(Validator condition, BatchUpdates updates) {
            this.throwIfDestroyed();
            Preconditions.checkArgument(condition instanceof InternalValidator, "not provided by Android System: " + condition);
            Preconditions.checkNotNull(updates);
            if (this.mUpdates == null) {
                this.mUpdates = new ArrayList();
            }
            this.mUpdates.add(new Pair<InternalValidator, BatchUpdates>((InternalValidator)condition, updates));
            return this;
        }

        public Builder addOnClickAction(int id2, OnClickAction action) {
            this.throwIfDestroyed();
            Preconditions.checkArgument(action instanceof InternalOnClickAction, "not provided by Android System: " + action);
            if (this.mActions == null) {
                this.mActions = new SparseArray();
            }
            this.mActions.put(id2, (InternalOnClickAction)action);
            return this;
        }

        public CustomDescription build() {
            this.throwIfDestroyed();
            this.mDestroyed = true;
            return new CustomDescription(this);
        }

        private void throwIfDestroyed() {
            if (this.mDestroyed) {
                throw new IllegalStateException("Already called #build()");
            }
        }
    }
}

