/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.Helper;
import android.widget.RemoteViews;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.regex.Pattern;

public final class Dataset
implements Parcelable {
    private final ArrayList<AutofillId> mFieldIds;
    private final ArrayList<AutofillValue> mFieldValues;
    private final ArrayList<RemoteViews> mFieldPresentations;
    private final ArrayList<DatasetFieldFilter> mFieldFilters;
    private final RemoteViews mPresentation;
    private final IntentSender mAuthentication;
    String mId;
    public static final Parcelable.Creator<Dataset> CREATOR = new Parcelable.Creator<Dataset>(){

        @Override
        public Dataset createFromParcel(Parcel parcel) {
            RemoteViews presentation = (RemoteViews)parcel.readParcelable(null);
            Builder builder = presentation == null ? new Builder() : new Builder(presentation);
            ArrayList<AutofillId> ids = parcel.createTypedArrayList(AutofillId.CREATOR);
            ArrayList<AutofillValue> values = parcel.createTypedArrayList(AutofillValue.CREATOR);
            ArrayList<RemoteViews> presentations = parcel.createTypedArrayList(RemoteViews.CREATOR);
            ArrayList<DatasetFieldFilter> filters = parcel.createTypedArrayList(DatasetFieldFilter.CREATOR);
            for (int i = 0; i < ids.size(); ++i) {
                AutofillId id2 = ids.get(i);
                AutofillValue value = values.get(i);
                RemoteViews fieldPresentation = presentations.get(i);
                DatasetFieldFilter filter = filters.get(i);
                builder.setLifeTheUniverseAndEverything(id2, value, fieldPresentation, filter);
            }
            builder.setAuthentication((IntentSender)parcel.readParcelable(null));
            builder.setId(parcel.readString());
            return builder.build();
        }

        public Dataset[] newArray(int size) {
            return new Dataset[size];
        }
    };

    private Dataset(Builder builder) {
        this.mFieldIds = builder.mFieldIds;
        this.mFieldValues = builder.mFieldValues;
        this.mFieldPresentations = builder.mFieldPresentations;
        this.mFieldFilters = builder.mFieldFilters;
        this.mPresentation = builder.mPresentation;
        this.mAuthentication = builder.mAuthentication;
        this.mId = builder.mId;
    }

    public ArrayList<AutofillId> getFieldIds() {
        return this.mFieldIds;
    }

    public ArrayList<AutofillValue> getFieldValues() {
        return this.mFieldValues;
    }

    public RemoteViews getFieldPresentation(int index) {
        RemoteViews customPresentation = this.mFieldPresentations.get(index);
        return customPresentation != null ? customPresentation : this.mPresentation;
    }

    public DatasetFieldFilter getFilter(int index) {
        return this.mFieldFilters.get(index);
    }

    public IntentSender getAuthentication() {
        return this.mAuthentication;
    }

    public boolean isEmpty() {
        return this.mFieldIds == null || this.mFieldIds.isEmpty();
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        StringBuilder builder = new StringBuilder("Dataset[");
        if (this.mId == null) {
            builder.append("noId");
        } else {
            builder.append("id=").append(this.mId.length()).append("_chars");
        }
        if (this.mFieldIds != null) {
            builder.append(", fieldIds=").append(this.mFieldIds);
        }
        if (this.mFieldValues != null) {
            builder.append(", fieldValues=").append(this.mFieldValues);
        }
        if (this.mFieldPresentations != null) {
            builder.append(", fieldPresentations=").append(this.mFieldPresentations.size());
        }
        if (this.mFieldFilters != null) {
            builder.append(", fieldFilters=").append(this.mFieldFilters.size());
        }
        if (this.mPresentation != null) {
            builder.append(", hasPresentation");
        }
        if (this.mAuthentication != null) {
            builder.append(", hasAuthentication");
        }
        return builder.append(']').toString();
    }

    public String getId() {
        return this.mId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mPresentation, flags);
        parcel.writeTypedList(this.mFieldIds, flags);
        parcel.writeTypedList(this.mFieldValues, flags);
        parcel.writeTypedList(this.mFieldPresentations, flags);
        parcel.writeTypedList(this.mFieldFilters, flags);
        parcel.writeParcelable(this.mAuthentication, flags);
        parcel.writeString(this.mId);
    }

    public static final class DatasetFieldFilter
    implements Parcelable {
        public final Pattern pattern;
        public static final Parcelable.Creator<DatasetFieldFilter> CREATOR = new Parcelable.Creator<DatasetFieldFilter>(){

            @Override
            public DatasetFieldFilter createFromParcel(Parcel parcel) {
                return new DatasetFieldFilter((Pattern)parcel.readSerializable());
            }

            public DatasetFieldFilter[] newArray(int size) {
                return new DatasetFieldFilter[size];
            }
        };

        private DatasetFieldFilter(Pattern pattern) {
            this.pattern = pattern;
        }

        public String toString() {
            if (!Helper.sDebug) {
                return super.toString();
            }
            return this.pattern == null ? "null" : this.pattern.pattern().length() + "_chars";
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeSerializable(this.pattern);
        }
    }

    public static final class Builder {
        private ArrayList<AutofillId> mFieldIds;
        private ArrayList<AutofillValue> mFieldValues;
        private ArrayList<RemoteViews> mFieldPresentations;
        private ArrayList<DatasetFieldFilter> mFieldFilters;
        private RemoteViews mPresentation;
        private IntentSender mAuthentication;
        private boolean mDestroyed;
        private String mId;

        public Builder(RemoteViews presentation) {
            Preconditions.checkNotNull(presentation, "presentation must be non-null");
            this.mPresentation = presentation;
        }

        public Builder() {
        }

        public Builder setAuthentication(IntentSender authentication) {
            this.throwIfDestroyed();
            this.mAuthentication = authentication;
            return this;
        }

        public Builder setId(String id2) {
            this.throwIfDestroyed();
            this.mId = id2;
            return this;
        }

        public Builder setValue(AutofillId id2, AutofillValue value) {
            this.throwIfDestroyed();
            this.setLifeTheUniverseAndEverything(id2, value, null, null);
            return this;
        }

        public Builder setValue(AutofillId id2, AutofillValue value, RemoteViews presentation) {
            this.throwIfDestroyed();
            Preconditions.checkNotNull(presentation, "presentation cannot be null");
            this.setLifeTheUniverseAndEverything(id2, value, presentation, null);
            return this;
        }

        public Builder setValue(AutofillId id2, AutofillValue value, Pattern filter) {
            this.throwIfDestroyed();
            Preconditions.checkState(this.mPresentation != null, "Dataset presentation not set on constructor");
            this.setLifeTheUniverseAndEverything(id2, value, null, new DatasetFieldFilter(filter));
            return this;
        }

        public Builder setValue(AutofillId id2, AutofillValue value, Pattern filter, RemoteViews presentation) {
            this.throwIfDestroyed();
            Preconditions.checkNotNull(presentation, "presentation cannot be null");
            this.setLifeTheUniverseAndEverything(id2, value, presentation, new DatasetFieldFilter(filter));
            return this;
        }

        private void setLifeTheUniverseAndEverything(AutofillId id2, AutofillValue value, RemoteViews presentation, DatasetFieldFilter filter) {
            Preconditions.checkNotNull(id2, "id cannot be null");
            if (this.mFieldIds != null) {
                int existingIdx = this.mFieldIds.indexOf(id2);
                if (existingIdx >= 0) {
                    this.mFieldValues.set(existingIdx, value);
                    this.mFieldPresentations.set(existingIdx, presentation);
                    this.mFieldFilters.set(existingIdx, filter);
                    return;
                }
            } else {
                this.mFieldIds = new ArrayList();
                this.mFieldValues = new ArrayList();
                this.mFieldPresentations = new ArrayList();
                this.mFieldFilters = new ArrayList();
            }
            this.mFieldIds.add(id2);
            this.mFieldValues.add(value);
            this.mFieldPresentations.add(presentation);
            this.mFieldFilters.add(filter);
        }

        public Dataset build() {
            this.throwIfDestroyed();
            this.mDestroyed = true;
            if (this.mFieldIds == null) {
                throw new IllegalStateException("at least one value must be set");
            }
            return new Dataset(this);
        }

        private void throwIfDestroyed() {
            if (this.mDestroyed) {
                throw new IllegalStateException("Already called #build()");
            }
        }
    }
}

