/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.RemoteException;
import android.service.autofill.FillResponse;
import android.service.autofill.IFillCallback;
import android.util.Log;

public final class FillCallback {
    private static final String TAG = "FillCallback";
    private final IFillCallback mCallback;
    private final int mRequestId;
    private boolean mCalled;

    public FillCallback(IFillCallback callback, int requestId) {
        this.mCallback = callback;
        this.mRequestId = requestId;
    }

    public void onSuccess(FillResponse response) {
        this.assertNotCalled();
        this.mCalled = true;
        if (response != null) {
            response.setRequestId(this.mRequestId);
        }
        try {
            this.mCallback.onSuccess(response);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    public void onFailure(CharSequence message) {
        Log.w(TAG, "onFailure(): " + message);
        this.assertNotCalled();
        this.mCalled = true;
        try {
            this.mCallback.onFailure(this.mRequestId, message);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    private void assertNotCalled() {
        if (this.mCalled) {
            throw new IllegalStateException("Already called");
        }
    }
}

