/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.content.IntentSender;
import android.content.pm.ParceledListSlice;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.AutofillServiceHelper;
import android.service.autofill.Dataset;
import android.service.autofill.SaveInfo;
import android.service.autofill.UserData;
import android.view.autofill.AutofillId;
import android.view.autofill.Helper;
import android.widget.RemoteViews;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class FillResponse
implements Parcelable {
    public static final int FLAG_TRACK_CONTEXT_COMMITED = 1;
    public static final int FLAG_DISABLE_ACTIVITY_ONLY = 2;
    private final ParceledListSlice<Dataset> mDatasets;
    private final SaveInfo mSaveInfo;
    private final Bundle mClientState;
    private final RemoteViews mPresentation;
    private final RemoteViews mHeader;
    private final RemoteViews mFooter;
    private final IntentSender mAuthentication;
    private final AutofillId[] mAuthenticationIds;
    private final AutofillId[] mIgnoredIds;
    private final long mDisableDuration;
    private final AutofillId[] mFieldClassificationIds;
    private final int mFlags;
    private int mRequestId;
    private final UserData mUserData;
    public static final Parcelable.Creator<FillResponse> CREATOR = new Parcelable.Creator<FillResponse>(){

        @Override
        public FillResponse createFromParcel(Parcel parcel) {
            AutofillId[] fieldClassifactionIds;
            UserData userData;
            RemoteViews footer;
            RemoteViews header;
            Builder builder = new Builder();
            ParceledListSlice datasetSlice = (ParceledListSlice)parcel.readParcelable(null);
            List datasets = datasetSlice != null ? datasetSlice.getList() : null;
            int datasetCount = datasets != null ? datasets.size() : 0;
            for (int i = 0; i < datasetCount; ++i) {
                builder.addDataset((Dataset)datasets.get(i));
            }
            builder.setSaveInfo((SaveInfo)parcel.readParcelable(null));
            builder.setClientState((Bundle)parcel.readParcelable(null));
            AutofillId[] authenticationIds = (AutofillId[])parcel.readParcelableArray(null, AutofillId.class);
            IntentSender authentication = (IntentSender)parcel.readParcelable(null);
            RemoteViews presentation = (RemoteViews)parcel.readParcelable(null);
            if (authenticationIds != null) {
                builder.setAuthentication(authenticationIds, authentication, presentation);
            }
            if ((header = (RemoteViews)parcel.readParcelable(null)) != null) {
                builder.setHeader(header);
            }
            if ((footer = (RemoteViews)parcel.readParcelable(null)) != null) {
                builder.setFooter(footer);
            }
            if ((userData = (UserData)parcel.readParcelable(null)) != null) {
                builder.setUserData(userData);
            }
            builder.setIgnoredIds((AutofillId[])parcel.readParcelableArray(null, AutofillId.class));
            long disableDuration = parcel.readLong();
            if (disableDuration > 0L) {
                builder.disableAutofill(disableDuration);
            }
            if ((fieldClassifactionIds = (AutofillId[])parcel.readParcelableArray(null, AutofillId.class)) != null) {
                builder.setFieldClassificationIds(fieldClassifactionIds);
            }
            builder.setFlags(parcel.readInt());
            FillResponse response = builder.build();
            response.setRequestId(parcel.readInt());
            return response;
        }

        public FillResponse[] newArray(int size) {
            return new FillResponse[size];
        }
    };

    private FillResponse(Builder builder) {
        this.mDatasets = builder.mDatasets != null ? new ParceledListSlice(builder.mDatasets) : null;
        this.mSaveInfo = builder.mSaveInfo;
        this.mClientState = builder.mClientState;
        this.mPresentation = builder.mPresentation;
        this.mHeader = builder.mHeader;
        this.mFooter = builder.mFooter;
        this.mAuthentication = builder.mAuthentication;
        this.mAuthenticationIds = builder.mAuthenticationIds;
        this.mIgnoredIds = builder.mIgnoredIds;
        this.mDisableDuration = builder.mDisableDuration;
        this.mFieldClassificationIds = builder.mFieldClassificationIds;
        this.mFlags = builder.mFlags;
        this.mRequestId = Integer.MIN_VALUE;
        this.mUserData = builder.mUserData;
    }

    public Bundle getClientState() {
        return this.mClientState;
    }

    public List<Dataset> getDatasets() {
        return this.mDatasets != null ? this.mDatasets.getList() : null;
    }

    public SaveInfo getSaveInfo() {
        return this.mSaveInfo;
    }

    public RemoteViews getPresentation() {
        return this.mPresentation;
    }

    public RemoteViews getHeader() {
        return this.mHeader;
    }

    public RemoteViews getFooter() {
        return this.mFooter;
    }

    public IntentSender getAuthentication() {
        return this.mAuthentication;
    }

    public AutofillId[] getAuthenticationIds() {
        return this.mAuthenticationIds;
    }

    public AutofillId[] getIgnoredIds() {
        return this.mIgnoredIds;
    }

    public long getDisableDuration() {
        return this.mDisableDuration;
    }

    public AutofillId[] getFieldClassificationIds() {
        return this.mFieldClassificationIds;
    }

    public UserData getUserData() {
        return this.mUserData;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public void setRequestId(int requestId) {
        this.mRequestId = requestId;
    }

    public int getRequestId() {
        return this.mRequestId;
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        StringBuilder builder = new StringBuilder("FillResponse : [mRequestId=" + this.mRequestId);
        if (this.mDatasets != null) {
            builder.append(", datasets=").append(this.mDatasets.getList());
        }
        if (this.mSaveInfo != null) {
            builder.append(", saveInfo=").append(this.mSaveInfo);
        }
        if (this.mClientState != null) {
            builder.append(", hasClientState");
        }
        if (this.mPresentation != null) {
            builder.append(", hasPresentation");
        }
        if (this.mHeader != null) {
            builder.append(", hasHeader");
        }
        if (this.mFooter != null) {
            builder.append(", hasFooter");
        }
        if (this.mAuthentication != null) {
            builder.append(", hasAuthentication");
        }
        if (this.mAuthenticationIds != null) {
            builder.append(", authenticationIds=").append(Arrays.toString(this.mAuthenticationIds));
        }
        builder.append(", disableDuration=").append(this.mDisableDuration);
        if (this.mFlags != 0) {
            builder.append(", flags=").append(this.mFlags);
        }
        if (this.mFieldClassificationIds != null) {
            builder.append(Arrays.toString(this.mFieldClassificationIds));
        }
        if (this.mUserData != null) {
            builder.append(", userData=").append(this.mUserData);
        }
        return builder.append("]").toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mDatasets, flags);
        parcel.writeParcelable(this.mSaveInfo, flags);
        parcel.writeParcelable(this.mClientState, flags);
        parcel.writeParcelableArray(this.mAuthenticationIds, flags);
        parcel.writeParcelable(this.mAuthentication, flags);
        parcel.writeParcelable(this.mPresentation, flags);
        parcel.writeParcelable(this.mHeader, flags);
        parcel.writeParcelable(this.mFooter, flags);
        parcel.writeParcelable(this.mUserData, flags);
        parcel.writeParcelableArray(this.mIgnoredIds, flags);
        parcel.writeLong(this.mDisableDuration);
        parcel.writeParcelableArray(this.mFieldClassificationIds, flags);
        parcel.writeInt(this.mFlags);
        parcel.writeInt(this.mRequestId);
    }

    public static final class Builder {
        private ArrayList<Dataset> mDatasets;
        private SaveInfo mSaveInfo;
        private Bundle mClientState;
        private RemoteViews mPresentation;
        private RemoteViews mHeader;
        private RemoteViews mFooter;
        private IntentSender mAuthentication;
        private AutofillId[] mAuthenticationIds;
        private AutofillId[] mIgnoredIds;
        private long mDisableDuration;
        private AutofillId[] mFieldClassificationIds;
        private int mFlags;
        private boolean mDestroyed;
        private UserData mUserData;

        public Builder setAuthentication(AutofillId[] ids, IntentSender authentication, RemoteViews presentation) {
            this.throwIfDestroyed();
            this.throwIfDisableAutofillCalled();
            if (this.mHeader != null || this.mFooter != null) {
                throw new IllegalStateException("Already called #setHeader() or #setFooter()");
            }
            if (authentication == null ^ presentation == null) {
                throw new IllegalArgumentException("authentication and presentation must be both non-null or null");
            }
            this.mAuthentication = authentication;
            this.mPresentation = presentation;
            this.mAuthenticationIds = AutofillServiceHelper.assertValid(ids);
            return this;
        }

        public Builder setIgnoredIds(AutofillId ... ids) {
            this.throwIfDestroyed();
            this.mIgnoredIds = ids;
            return this;
        }

        public Builder addDataset(Dataset dataset) {
            this.throwIfDestroyed();
            this.throwIfDisableAutofillCalled();
            if (dataset == null) {
                return this;
            }
            if (this.mDatasets == null) {
                this.mDatasets = new ArrayList();
            }
            if (!this.mDatasets.add(dataset)) {
                return this;
            }
            return this;
        }

        public Builder setSaveInfo(SaveInfo saveInfo) {
            this.throwIfDestroyed();
            this.throwIfDisableAutofillCalled();
            this.mSaveInfo = saveInfo;
            return this;
        }

        public Builder setClientState(Bundle clientState) {
            this.throwIfDestroyed();
            this.throwIfDisableAutofillCalled();
            this.mClientState = clientState;
            return this;
        }

        public Builder setFieldClassificationIds(AutofillId ... ids) {
            this.throwIfDestroyed();
            this.throwIfDisableAutofillCalled();
            Preconditions.checkArrayElementsNotNull(ids, "ids");
            Preconditions.checkArgumentInRange(ids.length, 1, UserData.getMaxFieldClassificationIdsSize(), "ids length");
            this.mFieldClassificationIds = ids;
            this.mFlags |= 1;
            return this;
        }

        public Builder setFlags(int flags) {
            this.throwIfDestroyed();
            this.mFlags = Preconditions.checkFlagsArgument(flags, 3);
            return this;
        }

        public Builder disableAutofill(long duration) {
            this.throwIfDestroyed();
            if (duration <= 0L) {
                throw new IllegalArgumentException("duration must be greater than 0");
            }
            if (this.mAuthentication != null || this.mDatasets != null || this.mSaveInfo != null || this.mFieldClassificationIds != null || this.mClientState != null) {
                throw new IllegalStateException("disableAutofill() must be the only method called");
            }
            this.mDisableDuration = duration;
            return this;
        }

        public Builder setHeader(RemoteViews header) {
            this.throwIfDestroyed();
            this.throwIfAuthenticationCalled();
            this.mHeader = Preconditions.checkNotNull(header);
            return this;
        }

        public Builder setFooter(RemoteViews footer) {
            this.throwIfDestroyed();
            this.throwIfAuthenticationCalled();
            this.mFooter = Preconditions.checkNotNull(footer);
            return this;
        }

        public Builder setUserData(UserData userData) {
            this.throwIfDestroyed();
            this.throwIfAuthenticationCalled();
            this.mUserData = Preconditions.checkNotNull(userData);
            return this;
        }

        public FillResponse build() {
            this.throwIfDestroyed();
            if (this.mAuthentication == null && this.mDatasets == null && this.mSaveInfo == null && this.mDisableDuration == 0L && this.mFieldClassificationIds == null && this.mClientState == null) {
                throw new IllegalStateException("need to provide: at least one DataSet, or a SaveInfo, or an authentication with a presentation, or a FieldsDetection, or a client state, or disable autofill");
            }
            if (this.mDatasets == null && (this.mHeader != null || this.mFooter != null)) {
                throw new IllegalStateException("must add at least 1 dataset when using header or footer");
            }
            this.mDestroyed = true;
            return new FillResponse(this);
        }

        private void throwIfDestroyed() {
            if (this.mDestroyed) {
                throw new IllegalStateException("Already called #build()");
            }
        }

        private void throwIfDisableAutofillCalled() {
            if (this.mDisableDuration > 0L) {
                throw new IllegalStateException("Already called #disableAutofill()");
            }
        }

        private void throwIfAuthenticationCalled() {
            if (this.mAuthentication != null) {
                throw new IllegalStateException("Already called #setAuthentication()");
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface FillResponseFlags {
    }
}

