/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalTransformation;
import android.service.autofill.Transformation;
import android.service.autofill.ValueFinder;
import android.text.TextUtils;
import android.util.Log;
import android.view.autofill.AutofillId;
import android.view.autofill.Helper;
import android.widget.RemoteViews;
import com.android.internal.util.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Pattern;

public final class ImageTransformation
extends InternalTransformation
implements Transformation,
Parcelable {
    private static final String TAG = "ImageTransformation";
    private final AutofillId mId;
    private final ArrayList<Option> mOptions;
    public static final Parcelable.Creator<ImageTransformation> CREATOR = new Parcelable.Creator<ImageTransformation>(){

        @Override
        public ImageTransformation createFromParcel(Parcel parcel) {
            AutofillId id2 = (AutofillId)parcel.readParcelable(null);
            Pattern[] regexs = (Pattern[])parcel.readSerializable();
            int[] resIds = parcel.createIntArray();
            CharSequence[] contentDescriptions = parcel.readCharSequenceArray();
            CharSequence contentDescription = contentDescriptions[0];
            Builder builder = contentDescription != null ? new Builder(id2, regexs[0], resIds[0], contentDescription) : new Builder(id2, regexs[0], resIds[0]);
            int size = regexs.length;
            for (int i = 1; i < size; ++i) {
                if (contentDescriptions[i] != null) {
                    builder.addOption(regexs[i], resIds[i], contentDescriptions[i]);
                    continue;
                }
                builder.addOption(regexs[i], resIds[i]);
            }
            return builder.build();
        }

        public ImageTransformation[] newArray(int size) {
            return new ImageTransformation[size];
        }
    };

    private ImageTransformation(Builder builder) {
        this.mId = builder.mId;
        this.mOptions = builder.mOptions;
    }

    @Override
    public void apply(ValueFinder finder, RemoteViews parentTemplate, int childViewId) throws Exception {
        String value = finder.findByAutofillId(this.mId);
        if (value == null) {
            Log.w(TAG, "No view for id " + this.mId);
            return;
        }
        int size = this.mOptions.size();
        if (Helper.sDebug) {
            Log.d(TAG, size + " multiple options on id " + childViewId + " to compare against");
        }
        for (int i = 0; i < size; ++i) {
            Option option = this.mOptions.get(i);
            try {
                if (!option.pattern.matcher(value).matches()) continue;
                Log.d(TAG, "Found match at " + i + ": " + option);
                parentTemplate.setImageViewResource(childViewId, option.resId);
                if (option.contentDescription != null) {
                    parentTemplate.setContentDescription(childViewId, option.contentDescription);
                }
                return;
            }
            catch (Exception e) {
                Log.w(TAG, "Error matching regex #" + i + "(" + option.pattern + ") on id " + option.resId + ": " + e.getClass());
                throw e;
            }
        }
        if (Helper.sDebug) {
            Log.d(TAG, "No match for " + value);
        }
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "ImageTransformation: [id=" + this.mId + ", options=" + this.mOptions + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mId, flags);
        int size = this.mOptions.size();
        Pattern[] patterns = new Pattern[size];
        int[] resIds = new int[size];
        CharSequence[] contentDescriptions = new String[size];
        for (int i = 0; i < size; ++i) {
            Option option = this.mOptions.get(i);
            patterns[i] = option.pattern;
            resIds[i] = option.resId;
            contentDescriptions[i] = option.contentDescription;
        }
        parcel.writeSerializable((Serializable)patterns);
        parcel.writeIntArray(resIds);
        parcel.writeCharSequenceArray(contentDescriptions);
    }

    private static final class Option {
        public final Pattern pattern;
        public final int resId;
        public final CharSequence contentDescription;

        Option(Pattern pattern, int resId, CharSequence contentDescription) {
            this.pattern = pattern;
            this.resId = resId;
            this.contentDescription = TextUtils.trimNoCopySpans(contentDescription);
        }
    }

    public static class Builder {
        private final AutofillId mId;
        private final ArrayList<Option> mOptions = new ArrayList();
        private boolean mDestroyed;

        @Deprecated
        public Builder(AutofillId id2, Pattern regex, int resId) {
            this.mId = Preconditions.checkNotNull(id2);
            this.addOption(regex, resId);
        }

        public Builder(AutofillId id2, Pattern regex, int resId, CharSequence contentDescription) {
            this.mId = Preconditions.checkNotNull(id2);
            this.addOption(regex, resId, contentDescription);
        }

        @Deprecated
        public Builder addOption(Pattern regex, int resId) {
            this.addOptionInternal(regex, resId, null);
            return this;
        }

        public Builder addOption(Pattern regex, int resId, CharSequence contentDescription) {
            this.addOptionInternal(regex, resId, Preconditions.checkNotNull(contentDescription));
            return this;
        }

        private void addOptionInternal(Pattern regex, int resId, CharSequence contentDescription) {
            this.throwIfDestroyed();
            Preconditions.checkNotNull(regex);
            Preconditions.checkArgument(resId != 0);
            this.mOptions.add(new Option(regex, resId, contentDescription));
        }

        public ImageTransformation build() {
            this.throwIfDestroyed();
            this.mDestroyed = true;
            return new ImageTransformation(this);
        }

        private void throwIfDestroyed() {
            Preconditions.checkState(!this.mDestroyed, "Already called build()");
        }
    }
}

