/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalValidator;
import android.service.autofill.Validator;
import android.service.autofill.ValueFinder;
import android.util.Log;
import android.view.autofill.AutofillId;
import android.view.autofill.Helper;
import com.android.internal.util.Preconditions;
import java.util.Arrays;

public final class LuhnChecksumValidator
extends InternalValidator
implements Validator,
Parcelable {
    private static final String TAG = "LuhnChecksumValidator";
    private final AutofillId[] mIds;
    public static final Parcelable.Creator<LuhnChecksumValidator> CREATOR = new Parcelable.Creator<LuhnChecksumValidator>(){

        @Override
        public LuhnChecksumValidator createFromParcel(Parcel parcel) {
            return new LuhnChecksumValidator((AutofillId[])parcel.readParcelableArray(null, AutofillId.class));
        }

        public LuhnChecksumValidator[] newArray(int size) {
            return new LuhnChecksumValidator[size];
        }
    };

    public LuhnChecksumValidator(AutofillId ... ids) {
        this.mIds = Preconditions.checkArrayElementsNotNull(ids, "ids");
    }

    private static boolean isLuhnChecksumValid(String number) {
        int sum = 0;
        boolean isDoubled = false;
        for (int i = number.length() - 1; i >= 0; --i) {
            int addend;
            int digit = number.charAt(i) - 48;
            if (digit < 0 || digit > 9) continue;
            if (isDoubled) {
                addend = digit * 2;
                if (addend > 9) {
                    addend -= 9;
                }
            } else {
                addend = digit;
            }
            sum += addend;
            isDoubled = !isDoubled;
        }
        return sum % 10 == 0;
    }

    @Override
    public boolean isValid(ValueFinder finder) {
        if (this.mIds == null || this.mIds.length == 0) {
            return false;
        }
        StringBuilder builder = new StringBuilder();
        for (AutofillId id2 : this.mIds) {
            String partialNumber = finder.findByAutofillId(id2);
            if (partialNumber == null) {
                if (Helper.sDebug) {
                    Log.d(TAG, "No partial number for id " + id2);
                }
                return false;
            }
            builder.append(partialNumber);
        }
        String number = builder.toString();
        boolean valid = LuhnChecksumValidator.isLuhnChecksumValid(number);
        if (Helper.sDebug) {
            Log.d(TAG, "isValid(" + number.length() + " chars): " + valid);
        }
        return valid;
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "LuhnChecksumValidator: [ids=" + Arrays.toString(this.mIds) + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelableArray(this.mIds, flags);
    }
}

