/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.content.IntentSender;
import android.os.RemoteException;
import android.service.autofill.ISaveCallback;
import android.util.Log;
import com.android.internal.util.Preconditions;

public final class SaveCallback {
    private static final String TAG = "SaveCallback";
    private final ISaveCallback mCallback;
    private boolean mCalled;

    SaveCallback(ISaveCallback callback) {
        this.mCallback = callback;
    }

    public void onSuccess() {
        this.onSuccessInternal(null);
    }

    public void onSuccess(IntentSender intentSender) {
        this.onSuccessInternal(Preconditions.checkNotNull(intentSender));
    }

    private void onSuccessInternal(IntentSender intentSender) {
        this.assertNotCalled();
        this.mCalled = true;
        try {
            this.mCallback.onSuccess(intentSender);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    public void onFailure(CharSequence message) {
        Log.w(TAG, "onFailure(): " + message);
        this.assertNotCalled();
        this.mCalled = true;
        try {
            this.mCallback.onFailure(message);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
    }

    private void assertNotCalled() {
        if (this.mCalled) {
            throw new IllegalStateException("Already called");
        }
    }
}

