/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.service.autofill.InternalOnClickAction;
import android.service.autofill.OnClickAction;
import android.util.Slog;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.autofill.Helper;
import com.android.internal.util.Preconditions;

public final class VisibilitySetterAction
extends InternalOnClickAction
implements OnClickAction,
Parcelable {
    private static final String TAG = "VisibilitySetterAction";
    private final SparseIntArray mVisibilities;
    public static final Parcelable.Creator<VisibilitySetterAction> CREATOR = new Parcelable.Creator<VisibilitySetterAction>(){

        @Override
        public VisibilitySetterAction createFromParcel(Parcel parcel) {
            SparseIntArray visibilities = parcel.readSparseIntArray();
            Builder builder = null;
            for (int i = 0; i < visibilities.size(); ++i) {
                int id2 = visibilities.keyAt(i);
                int visibility = visibilities.valueAt(i);
                if (builder == null) {
                    builder = new Builder(id2, visibility);
                    continue;
                }
                builder.setVisibility(id2, visibility);
            }
            return builder == null ? null : builder.build();
        }

        public VisibilitySetterAction[] newArray(int size) {
            return new VisibilitySetterAction[size];
        }
    };

    private VisibilitySetterAction(Builder builder) {
        this.mVisibilities = builder.mVisibilities;
    }

    @Override
    public void onClick(ViewGroup rootView) {
        for (int i = 0; i < this.mVisibilities.size(); ++i) {
            int id2 = this.mVisibilities.keyAt(i);
            Object child = rootView.findViewById(id2);
            if (child == null) {
                Slog.w(TAG, "Skipping view id " + id2 + " because it's not found on " + rootView);
                continue;
            }
            int visibility = this.mVisibilities.valueAt(i);
            if (Helper.sVerbose) {
                Slog.v(TAG, "Changing visibility of view " + child + " from " + ((View)child).getVisibility() + " to  " + visibility);
            }
            ((View)child).setVisibility(visibility);
        }
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        return "VisibilitySetterAction: [" + this.mVisibilities + "]";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeSparseIntArray(this.mVisibilities);
    }

    public static final class Builder {
        private final SparseIntArray mVisibilities = new SparseIntArray();
        private boolean mDestroyed;

        public Builder(int id2, int visibility) {
            this.setVisibility(id2, visibility);
        }

        public Builder setVisibility(int id2, int visibility) {
            this.throwIfDestroyed();
            switch (visibility) {
                case 0: 
                case 4: 
                case 8: {
                    this.mVisibilities.put(id2, visibility);
                    return this;
                }
            }
            throw new IllegalArgumentException("Invalid visibility: " + visibility);
        }

        public VisibilitySetterAction build() {
            this.throwIfDestroyed();
            this.mDestroyed = true;
            return new VisibilitySetterAction(this);
        }

        private void throwIfDestroyed() {
            Preconditions.checkState(!this.mDestroyed, "Already called build()");
        }
    }
}

