/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill.augmented;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.ComponentName;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Build;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.Looper;
import android.os.RemoteException;
import android.os.SystemClock;
import android.service.autofill.augmented.FillCallback;
import android.service.autofill.augmented.FillController;
import android.service.autofill.augmented.FillRequest;
import android.service.autofill.augmented.FillWindow;
import android.service.autofill.augmented.Helper;
import android.service.autofill.augmented.IAugmentedAutofillService;
import android.service.autofill.augmented.IFillCallback;
import android.service.autofill.augmented.PresentationParams;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import android.util.TimeUtils;
import android.view.autofill.AutofillId;
import android.view.autofill.AutofillValue;
import android.view.autofill.IAugmentedAutofillManagerClient;
import android.view.autofill.IAutofillWindowPresenter;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.function.pooled.PooledLambda;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

@SystemApi
public abstract class AugmentedAutofillService
extends Service {
    private static final String TAG = AugmentedAutofillService.class.getSimpleName();
    static boolean sDebug = !Build.IS_USER;
    static boolean sVerbose = false;
    public static final String SERVICE_INTERFACE = "android.service.autofill.augmented.AugmentedAutofillService";
    private Handler mHandler;
    private SparseArray<AutofillProxy> mAutofillProxies;
    private ComponentName mServiceComponentName;
    private final IAugmentedAutofillService mInterface = new IAugmentedAutofillService.Stub(){

        @Override
        public void onConnected(boolean debug, boolean verbose) {
            AugmentedAutofillService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1) -> ((AugmentedAutofillService)rec$).handleOnConnected(x$0, x$1), AugmentedAutofillService.this, debug, verbose));
        }

        @Override
        public void onDisconnected() {
            AugmentedAutofillService.this.mHandler.sendMessage(PooledLambda.obtainMessage(rec$ -> ((AugmentedAutofillService)rec$).handleOnDisconnected(), AugmentedAutofillService.this));
        }

        @Override
        public void onFillRequest(int sessionId, IBinder client, int taskId, ComponentName componentName, AutofillId focusedId, AutofillValue focusedValue, long requestTime, IFillCallback callback) {
            AugmentedAutofillService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7) -> ((AugmentedAutofillService)rec$).handleOnFillRequest(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7), AugmentedAutofillService.this, sessionId, client, taskId, componentName, focusedId, focusedValue, requestTime, callback));
        }

        @Override
        public void onDestroyAllFillWindowsRequest() {
            AugmentedAutofillService.this.mHandler.sendMessage(PooledLambda.obtainMessage(rec$ -> ((AugmentedAutofillService)rec$).handleOnDestroyAllFillWindowsRequest(), AugmentedAutofillService.this));
        }
    };

    @Override
    public void onCreate() {
        super.onCreate();
        this.mHandler = new Handler(Looper.getMainLooper(), null, true);
    }

    @Override
    public final IBinder onBind(Intent intent) {
        this.mServiceComponentName = intent.getComponent();
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mInterface.asBinder();
        }
        Log.w(TAG, "Tried to bind to wrong intent (should be android.service.autofill.augmented.AugmentedAutofillService: " + intent);
        return null;
    }

    @Override
    public boolean onUnbind(Intent intent) {
        this.mHandler.sendMessage(PooledLambda.obtainMessage(AugmentedAutofillService::handleOnUnbind, this));
        return false;
    }

    public void onConnected() {
    }

    public void onFillRequest(FillRequest request, CancellationSignal cancellationSignal, FillController controller, FillCallback callback) {
    }

    public void onDisconnected() {
    }

    private void handleOnConnected(boolean debug, boolean verbose) {
        if (sDebug || debug) {
            Log.d(TAG, "handleOnConnected(): debug=" + debug + ", verbose=" + verbose);
        }
        sDebug = debug;
        sVerbose = verbose;
        this.onConnected();
    }

    private void handleOnDisconnected() {
        this.onDisconnected();
    }

    private void handleOnFillRequest(int sessionId, IBinder client, int taskId, ComponentName componentName, AutofillId focusedId, AutofillValue focusedValue, long requestTime, IFillCallback callback) {
        if (this.mAutofillProxies == null) {
            this.mAutofillProxies = new SparseArray();
        }
        ICancellationSignal transport = CancellationSignal.createTransport();
        CancellationSignal cancellationSignal = CancellationSignal.fromTransport(transport);
        AutofillProxy proxy = this.mAutofillProxies.get(sessionId);
        if (proxy == null) {
            proxy = new AutofillProxy(sessionId, client, taskId, this.mServiceComponentName, componentName, focusedId, focusedValue, requestTime, callback, cancellationSignal);
            this.mAutofillProxies.put(sessionId, proxy);
        } else {
            if (sDebug) {
                Log.d(TAG, "Reusing proxy for session " + sessionId);
            }
            proxy.update(focusedId, focusedValue, callback, cancellationSignal);
        }
        try {
            callback.onCancellable(transport);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
        this.onFillRequest(new FillRequest(proxy), cancellationSignal, new FillController(proxy), new FillCallback(proxy));
    }

    private void handleOnDestroyAllFillWindowsRequest() {
        if (this.mAutofillProxies != null) {
            int size = this.mAutofillProxies.size();
            for (int i = 0; i < size; ++i) {
                int sessionId = this.mAutofillProxies.keyAt(i);
                AutofillProxy proxy = this.mAutofillProxies.valueAt(i);
                if (proxy == null) {
                    Log.w(TAG, "No proxy for session " + sessionId);
                    return;
                }
                if (proxy.mCallback != null) {
                    try {
                        if (!proxy.mCallback.isCompleted()) {
                            proxy.mCallback.cancel();
                        }
                    }
                    catch (Exception e) {
                        Log.e(TAG, "failed to check current pending request status", e);
                    }
                }
                proxy.destroy();
            }
            this.mAutofillProxies.clear();
        }
    }

    private void handleOnUnbind() {
        if (this.mAutofillProxies == null) {
            if (sDebug) {
                Log.d(TAG, "onUnbind(): no proxy to destroy");
            }
            return;
        }
        int size = this.mAutofillProxies.size();
        if (sDebug) {
            Log.d(TAG, "onUnbind(): destroying " + size + " proxies");
        }
        for (int i = 0; i < size; ++i) {
            AutofillProxy proxy = this.mAutofillProxies.valueAt(i);
            try {
                proxy.destroy();
                continue;
            }
            catch (Exception e) {
                Log.w(TAG, "error destroying " + proxy);
            }
        }
        this.mAutofillProxies = null;
    }

    @Override
    protected final void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.print("Service component: ");
        pw.println(ComponentName.flattenToShortString(this.mServiceComponentName));
        if (this.mAutofillProxies != null) {
            int size = this.mAutofillProxies.size();
            pw.print("Number proxies: ");
            pw.println(size);
            for (int i = 0; i < size; ++i) {
                int sessionId = this.mAutofillProxies.keyAt(i);
                AutofillProxy proxy = this.mAutofillProxies.valueAt(i);
                pw.print(i);
                pw.print(") SessionId=");
                pw.print(sessionId);
                pw.println(":");
                proxy.dump("  ", pw);
            }
        }
        this.dump(pw, args);
    }

    protected void dump(PrintWriter pw, String[] args) {
        pw.print(this.getClass().getName());
        pw.println(": nothing to dump");
    }

    static final class AutofillProxy {
        static final int REPORT_EVENT_NO_RESPONSE = 1;
        static final int REPORT_EVENT_UI_SHOWN = 2;
        static final int REPORT_EVENT_UI_DESTROYED = 3;
        private final Object mLock = new Object();
        private final IAugmentedAutofillManagerClient mClient;
        private final int mSessionId;
        public final int taskId;
        public final ComponentName componentName;
        private String mServicePackageName;
        @GuardedBy(value={"mLock"})
        private AutofillId mFocusedId;
        @GuardedBy(value={"mLock"})
        private AutofillValue mFocusedValue;
        @GuardedBy(value={"mLock"})
        private IFillCallback mCallback;
        @GuardedBy(value={"mLock"})
        private AutofillId mLastShownId;
        private final long mFirstRequestTime;
        private long mFirstOnSuccessTime;
        private long mUiFirstShownTime;
        private long mUiFirstDestroyedTime;
        @GuardedBy(value={"mLock"})
        private PresentationParams.SystemPopupPresentationParams mSmartSuggestion;
        @GuardedBy(value={"mLock"})
        private FillWindow mFillWindow;
        private CancellationSignal mCancellationSignal;

        private AutofillProxy(int sessionId, IBinder client, int taskId, ComponentName serviceComponentName, ComponentName componentName, AutofillId focusedId, AutofillValue focusedValue, long requestTime, IFillCallback callback, CancellationSignal cancellationSignal) {
            this.mSessionId = sessionId;
            this.mClient = IAugmentedAutofillManagerClient.Stub.asInterface(client);
            this.mCallback = callback;
            this.taskId = taskId;
            this.componentName = componentName;
            this.mServicePackageName = serviceComponentName.getPackageName();
            this.mFocusedId = focusedId;
            this.mFocusedValue = focusedValue;
            this.mFirstRequestTime = requestTime;
            this.mCancellationSignal = cancellationSignal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PresentationParams.SystemPopupPresentationParams getSmartSuggestionParams() {
            Object object = this.mLock;
            synchronized (object) {
                Rect rect;
                if (this.mSmartSuggestion != null && this.mFocusedId.equals(this.mLastShownId)) {
                    return this.mSmartSuggestion;
                }
                try {
                    rect = this.mClient.getViewCoordinates(this.mFocusedId);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Could not get coordinates for " + this.mFocusedId);
                    return null;
                }
                if (rect == null) {
                    if (sDebug) {
                        Log.d(TAG, "getViewCoordinates(" + this.mFocusedId + ") returned null");
                    }
                    return null;
                }
                this.mSmartSuggestion = new PresentationParams.SystemPopupPresentationParams(this, rect);
                this.mLastShownId = this.mFocusedId;
                return this.mSmartSuggestion;
            }
        }

        public void autofill(List<Pair<AutofillId, AutofillValue>> pairs) throws RemoteException {
            int size = pairs.size();
            ArrayList<AutofillId> ids = new ArrayList<AutofillId>(size);
            ArrayList<AutofillValue> values = new ArrayList<AutofillValue>(size);
            for (int i = 0; i < size; ++i) {
                Pair<AutofillId, AutofillValue> pair = pairs.get(i);
                ids.add((AutofillId)pair.first);
                values.add((AutofillValue)pair.second);
            }
            this.mClient.autofill(this.mSessionId, ids, values);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFillWindow(FillWindow fillWindow) {
            Object object = this.mLock;
            synchronized (object) {
                this.mFillWindow = fillWindow;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FillWindow getFillWindow() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mFillWindow;
            }
        }

        public void requestShowFillUi(int width, int height, Rect anchorBounds, IAutofillWindowPresenter presenter) throws RemoteException {
            if (this.mCancellationSignal.isCanceled()) {
                if (sVerbose) {
                    Log.v(TAG, "requestShowFillUi() not showing because request is cancelled");
                }
                return;
            }
            this.mClient.requestShowFillUi(this.mSessionId, this.mFocusedId, width, height, anchorBounds, presenter);
        }

        public void requestHideFillUi() throws RemoteException {
            this.mClient.requestHideFillUi(this.mSessionId, this.mFocusedId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(AutofillId focusedId, AutofillValue focusedValue, IFillCallback callback, CancellationSignal cancellationSignal) {
            Object object = this.mLock;
            synchronized (object) {
                this.mFocusedId = focusedId;
                this.mFocusedValue = focusedValue;
                if (this.mCallback != null) {
                    try {
                        if (!this.mCallback.isCompleted()) {
                            this.mCallback.cancel();
                        }
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "failed to check current pending request status", e);
                    }
                    Log.d(TAG, "mCallback is updated.");
                }
                this.mCallback = callback;
                this.mCancellationSignal = cancellationSignal;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AutofillId getFocusedId() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mFocusedId;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AutofillValue getFocusedValue() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mFocusedValue;
            }
        }

        public void report(int event) {
            if (sVerbose) {
                Log.v(TAG, "report(): " + event);
            }
            long duration = -1L;
            int type = 0;
            switch (event) {
                case 1: {
                    type = 10;
                    if (this.mFirstOnSuccessTime == 0L) {
                        this.mFirstOnSuccessTime = SystemClock.elapsedRealtime();
                        duration = this.mFirstOnSuccessTime - this.mFirstRequestTime;
                        if (sDebug) {
                            Log.d(TAG, "Service responded nothing in " + TimeUtils.formatDuration(duration));
                        }
                    }
                    try {
                        this.mCallback.onSuccess();
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Error reporting success: " + e);
                    }
                    break;
                }
                case 2: {
                    type = 1;
                    if (this.mUiFirstShownTime != 0L) break;
                    this.mUiFirstShownTime = SystemClock.elapsedRealtime();
                    duration = this.mUiFirstShownTime - this.mFirstRequestTime;
                    if (!sDebug) break;
                    Log.d(TAG, "UI shown in " + TimeUtils.formatDuration(duration));
                    break;
                }
                case 3: {
                    type = 2;
                    if (this.mUiFirstDestroyedTime != 0L) break;
                    this.mUiFirstDestroyedTime = SystemClock.elapsedRealtime();
                    duration = this.mUiFirstDestroyedTime - this.mFirstRequestTime;
                    if (!sDebug) break;
                    Log.d(TAG, "UI destroyed in " + TimeUtils.formatDuration(duration));
                    break;
                }
                default: {
                    Log.w(TAG, "invalid event reported: " + event);
                }
            }
            Helper.logResponse(type, this.mServicePackageName, this.componentName, this.mSessionId, duration);
        }

        public void dump(String prefix, PrintWriter pw) {
            pw.print(prefix);
            pw.print("sessionId: ");
            pw.println(this.mSessionId);
            pw.print(prefix);
            pw.print("taskId: ");
            pw.println(this.taskId);
            pw.print(prefix);
            pw.print("component: ");
            pw.println(this.componentName.flattenToShortString());
            pw.print(prefix);
            pw.print("focusedId: ");
            pw.println(this.mFocusedId);
            if (this.mFocusedValue != null) {
                pw.print(prefix);
                pw.print("focusedValue: ");
                pw.println(this.mFocusedValue);
            }
            if (this.mLastShownId != null) {
                pw.print(prefix);
                pw.print("lastShownId: ");
                pw.println(this.mLastShownId);
            }
            pw.print(prefix);
            pw.print("client: ");
            pw.println(this.mClient);
            String prefix2 = prefix + "  ";
            if (this.mFillWindow != null) {
                pw.print(prefix);
                pw.println("window:");
                this.mFillWindow.dump(prefix2, pw);
            }
            if (this.mSmartSuggestion != null) {
                pw.print(prefix);
                pw.println("smartSuggestion:");
                this.mSmartSuggestion.dump(prefix2, pw);
            }
            if (this.mFirstOnSuccessTime > 0L) {
                long responseTime = this.mFirstOnSuccessTime - this.mFirstRequestTime;
                pw.print(prefix);
                pw.print("response time: ");
                TimeUtils.formatDuration(responseTime, pw);
                pw.println();
            }
            if (this.mUiFirstShownTime > 0L) {
                long uiRenderingTime = this.mUiFirstShownTime - this.mFirstRequestTime;
                pw.print(prefix);
                pw.print("UI rendering time: ");
                TimeUtils.formatDuration(uiRenderingTime, pw);
                pw.println();
            }
            if (this.mUiFirstDestroyedTime > 0L) {
                long uiTotalTime = this.mUiFirstDestroyedTime - this.mFirstRequestTime;
                pw.print(prefix);
                pw.print("UI life time: ");
                TimeUtils.formatDuration(uiTotalTime, pw);
                pw.println();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void destroy() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mFillWindow != null) {
                    if (sDebug) {
                        Log.d(TAG, "destroying window");
                    }
                    this.mFillWindow.destroy();
                    this.mFillWindow = null;
                }
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface ReportEvent {
        }
    }
}

