/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill.augmented;

import android.annotation.SystemApi;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.service.autofill.augmented.AugmentedAutofillService;
import android.service.autofill.augmented.PresentationParams;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.view.autofill.IAutofillWindowPresenter;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.internal.util.function.pooled.PooledLambda;
import dalvik.system.CloseGuard;
import java.io.PrintWriter;

@SystemApi
public final class FillWindow
implements AutoCloseable {
    private static final String TAG = FillWindow.class.getSimpleName();
    private final Object mLock = new Object();
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final Handler mUiThreadHandler = new Handler(Looper.getMainLooper());
    private final FillWindowPresenter mFillWindowPresenter = new FillWindowPresenter();
    @GuardedBy(value={"mLock"})
    private WindowManager mWm;
    @GuardedBy(value={"mLock"})
    private View mFillView;
    @GuardedBy(value={"mLock"})
    private boolean mShowing;
    @GuardedBy(value={"mLock"})
    private Rect mBounds;
    @GuardedBy(value={"mLock"})
    private boolean mUpdateCalled;
    @GuardedBy(value={"mLock"})
    private boolean mDestroyed;
    private AugmentedAutofillService.AutofillProxy mProxy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(PresentationParams.Area area, View rootView, long flags) {
        if (AugmentedAutofillService.sDebug) {
            Log.d(TAG, "Updating " + area + " + with " + rootView);
        }
        Preconditions.checkNotNull(area);
        Preconditions.checkNotNull(area.proxy);
        Preconditions.checkNotNull(rootView);
        PresentationParams.SystemPopupPresentationParams smartSuggestion = area.proxy.getSmartSuggestionParams();
        if (smartSuggestion == null) {
            Log.w(TAG, "No SmartSuggestionParams");
            return false;
        }
        Rect rect = area.getBounds();
        if (rect == null) {
            Log.wtf(TAG, "No Rect on SmartSuggestionParams");
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotDestroyedLocked();
            this.mProxy = area.proxy;
            this.mWm = rootView.getContext().getSystemService(WindowManager.class);
            this.mFillView = rootView;
            this.mFillView.setOnTouchListener((view, motionEvent) -> {
                if (motionEvent.getAction() == 4) {
                    if (AugmentedAutofillService.sVerbose) {
                        Log.v(TAG, "Outside touch detected, hiding the window");
                    }
                    this.hide();
                }
                return false;
            });
            this.mShowing = false;
            this.mBounds = new Rect(area.getBounds());
            if (AugmentedAutofillService.sDebug) {
                Log.d(TAG, "Created FillWindow: params= " + smartSuggestion + " view=" + rootView);
            }
            this.mUpdateCalled = true;
            this.mDestroyed = false;
            this.mProxy.setFillWindow(this);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void show() {
        if (AugmentedAutofillService.sDebug) {
            Log.d(TAG, "show()");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotDestroyedLocked();
            if (this.mWm == null || this.mFillView == null) {
                throw new IllegalStateException("update() not called yet, or already destroyed()");
            }
            if (this.mProxy != null) {
                try {
                    this.mProxy.requestShowFillUi(this.mBounds.right - this.mBounds.left, this.mBounds.bottom - this.mBounds.top, null, this.mFillWindowPresenter);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Error requesting to show fill window", e);
                }
                this.mProxy.report(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hide() {
        if (AugmentedAutofillService.sDebug) {
            Log.d(TAG, "hide()");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotDestroyedLocked();
            if (this.mWm == null || this.mFillView == null) {
                throw new IllegalStateException("update() not called yet, or already destroyed()");
            }
            if (this.mProxy != null && this.mShowing) {
                try {
                    this.mProxy.requestHideFillUi();
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Error requesting to hide fill window", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleShow(WindowManager.LayoutParams p) {
        if (AugmentedAutofillService.sDebug) {
            Log.d(TAG, "handleShow()");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWm != null && this.mFillView != null) {
                p.flags |= 0x40000;
                if (!this.mShowing) {
                    this.mWm.addView(this.mFillView, p);
                    this.mShowing = true;
                } else {
                    this.mWm.updateViewLayout(this.mFillView, p);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHide() {
        if (AugmentedAutofillService.sDebug) {
            Log.d(TAG, "handleHide()");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWm != null && this.mFillView != null && this.mShowing) {
                this.mWm.removeView(this.mFillView);
                this.mShowing = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (AugmentedAutofillService.sDebug) {
            Log.d(TAG, "destroy(): mDestroyed=" + this.mDestroyed + " mShowing=" + this.mShowing + " mFillView=" + this.mFillView);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                return;
            }
            if (this.mUpdateCalled) {
                this.hide();
                this.mProxy.report(3);
            }
            this.mDestroyed = true;
            this.mCloseGuard.close();
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    private void checkNotDestroyedLocked() {
        if (this.mDestroyed) {
            throw new IllegalStateException("already destroyed()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(String prefix, PrintWriter pw) {
        FillWindow fillWindow = this;
        synchronized (fillWindow) {
            pw.print(prefix);
            pw.print("destroyed: ");
            pw.println(this.mDestroyed);
            pw.print(prefix);
            pw.print("updateCalled: ");
            pw.println(this.mUpdateCalled);
            if (this.mFillView != null) {
                pw.print(prefix);
                pw.print("fill window: ");
                pw.println(this.mShowing ? "shown" : "hidden");
                pw.print(prefix);
                pw.print("fill view: ");
                pw.println(this.mFillView);
                pw.print(prefix);
                pw.print("mBounds: ");
                pw.println(this.mBounds);
                pw.print(prefix);
                pw.print("mWm: ");
                pw.println(this.mWm);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.destroy();
    }

    private final class FillWindowPresenter
    extends IAutofillWindowPresenter.Stub {
        private FillWindowPresenter() {
        }

        @Override
        public void show(WindowManager.LayoutParams p, Rect transitionEpicenter, boolean fitsSystemWindows, int layoutDirection) {
            if (AugmentedAutofillService.sDebug) {
                Log.d(TAG, "FillWindowPresenter.show()");
            }
            FillWindow.this.mUiThreadHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0) -> ((FillWindow)rec$).handleShow(x$0), FillWindow.this, p));
        }

        @Override
        public void hide(Rect transitionEpicenter) {
            if (AugmentedAutofillService.sDebug) {
                Log.d(TAG, "FillWindowPresenter.hide()");
            }
            FillWindow.this.mUiThreadHandler.sendMessage(PooledLambda.obtainMessage(rec$ -> ((FillWindow)rec$).handleHide(), FillWindow.this));
        }
    }
}

