/*
 * Decompiled with CFR 0.152.
 */
package android.service.contentcapture;

import android.annotation.SystemApi;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public final class ActivityEvent
implements Parcelable {
    public static final int TYPE_ACTIVITY_RESUMED = 1;
    public static final int TYPE_ACTIVITY_PAUSED = 2;
    public static final int TYPE_ACTIVITY_STOPPED = 23;
    public static final int TYPE_ACTIVITY_DESTROYED = 24;
    private final ComponentName mComponentName;
    private final int mType;
    public static final Parcelable.Creator<ActivityEvent> CREATOR = new Parcelable.Creator<ActivityEvent>(){

        @Override
        public ActivityEvent createFromParcel(Parcel parcel) {
            ComponentName componentName = (ComponentName)parcel.readParcelable(null);
            int eventType = parcel.readInt();
            return new ActivityEvent(componentName, eventType);
        }

        public ActivityEvent[] newArray(int size) {
            return new ActivityEvent[size];
        }
    };

    public ActivityEvent(ComponentName componentName, int type) {
        this.mComponentName = componentName;
        this.mType = type;
    }

    public ComponentName getComponentName() {
        return this.mComponentName;
    }

    public int getEventType() {
        return this.mType;
    }

    public static String getTypeAsString(int type) {
        switch (type) {
            case 1: {
                return "ACTIVITY_RESUMED";
            }
            case 2: {
                return "ACTIVITY_PAUSED";
            }
            case 23: {
                return "ACTIVITY_STOPPED";
            }
            case 24: {
                return "ACTIVITY_DESTROYED";
            }
        }
        return "UKNOWN_TYPE: " + type;
    }

    public String toString() {
        return "ActivityEvent[" + this.mComponentName.toShortString() + "]:" + ActivityEvent.getTypeAsString(this.mType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mComponentName, flags);
        parcel.writeInt(this.mType);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActivityEventType {
    }
}

