/*
 * Decompiled with CFR 0.152.
 */
package android.service.contentcapture;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.ComponentName;
import android.content.ContentCaptureOptions;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.service.contentcapture.ActivityEvent;
import android.service.contentcapture.FlushMetrics;
import android.service.contentcapture.IContentCaptureService;
import android.service.contentcapture.IContentCaptureServiceCallback;
import android.service.contentcapture.SnapshotData;
import android.util.Log;
import android.util.Slog;
import android.util.SparseIntArray;
import android.util.StatsLog;
import android.view.contentcapture.ContentCaptureCondition;
import android.view.contentcapture.ContentCaptureContext;
import android.view.contentcapture.ContentCaptureEvent;
import android.view.contentcapture.ContentCaptureHelper;
import android.view.contentcapture.ContentCaptureSessionId;
import android.view.contentcapture.DataRemovalRequest;
import android.view.contentcapture.IContentCaptureDirectManager;
import com.android.internal.os.IResultReceiver;
import com.android.internal.util.function.pooled.PooledLambda;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.List;
import java.util.Set;

@SystemApi
public abstract class ContentCaptureService
extends Service {
    private static final String TAG = ContentCaptureService.class.getSimpleName();
    public static final String SERVICE_INTERFACE = "android.service.contentcapture.ContentCaptureService";
    public static final String SERVICE_META_DATA = "android.content_capture";
    private Handler mHandler;
    private IContentCaptureServiceCallback mCallback;
    private long mCallerMismatchTimeout = 1000L;
    private long mLastCallerMismatchLog;
    private final IContentCaptureService mServerInterface = new IContentCaptureService.Stub(){

        @Override
        public void onConnected(IBinder callback, boolean verbose, boolean debug) {
            ContentCaptureHelper.sVerbose = verbose;
            ContentCaptureHelper.sDebug = debug;
            ContentCaptureService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0) -> ((ContentCaptureService)rec$).handleOnConnected(x$0), ContentCaptureService.this, callback));
        }

        @Override
        public void onDisconnected() {
            ContentCaptureService.this.mHandler.sendMessage(PooledLambda.obtainMessage(rec$ -> ((ContentCaptureService)rec$).handleOnDisconnected(), ContentCaptureService.this));
        }

        @Override
        public void onSessionStarted(ContentCaptureContext context, int sessionId, int uid, IResultReceiver clientReceiver, int initialState) {
            ContentCaptureService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1, x$2, x$3, x$4) -> ((ContentCaptureService)rec$).handleOnCreateSession(x$0, x$1, x$2, x$3, x$4), ContentCaptureService.this, context, sessionId, uid, clientReceiver, initialState));
        }

        @Override
        public void onActivitySnapshot(int sessionId, SnapshotData snapshotData) {
            ContentCaptureService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1) -> ((ContentCaptureService)rec$).handleOnActivitySnapshot(x$0, x$1), ContentCaptureService.this, sessionId, snapshotData));
        }

        @Override
        public void onSessionFinished(int sessionId) {
            ContentCaptureService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0) -> ((ContentCaptureService)rec$).handleFinishSession(x$0), ContentCaptureService.this, sessionId));
        }

        @Override
        public void onDataRemovalRequest(DataRemovalRequest request) {
            ContentCaptureService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0) -> ((ContentCaptureService)rec$).handleOnDataRemovalRequest(x$0), ContentCaptureService.this, request));
        }

        @Override
        public void onActivityEvent(ActivityEvent event) {
            ContentCaptureService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0) -> ((ContentCaptureService)rec$).handleOnActivityEvent(x$0), ContentCaptureService.this, event));
        }
    };
    private final IContentCaptureDirectManager mClientInterface = new IContentCaptureDirectManager.Stub(){

        @Override
        public void sendEvents(ParceledListSlice events, int reason, ContentCaptureOptions options) {
            ContentCaptureService.this.mHandler.sendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1, x$2, x$3) -> ((ContentCaptureService)rec$).handleSendEvents(x$0, x$1, x$2, x$3), ContentCaptureService.this, Binder.getCallingUid(), events, reason, options));
        }
    };
    private final SparseIntArray mSessionUids = new SparseIntArray();

    @Override
    public void onCreate() {
        super.onCreate();
        this.mHandler = new Handler(Looper.getMainLooper(), null, true);
    }

    @Override
    public final IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mServerInterface.asBinder();
        }
        Log.w(TAG, "Tried to bind to wrong intent (should be android.service.contentcapture.ContentCaptureService: " + intent);
        return null;
    }

    public final void setContentCaptureWhitelist(Set<String> packages, Set<ComponentName> activities) {
        IContentCaptureServiceCallback callback = this.mCallback;
        if (callback == null) {
            Log.w(TAG, "setContentCaptureWhitelist(): no server callback");
            return;
        }
        try {
            callback.setContentCaptureWhitelist(ContentCaptureHelper.toList(packages), ContentCaptureHelper.toList(activities));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public final void setContentCaptureConditions(String packageName, Set<ContentCaptureCondition> conditions) {
        IContentCaptureServiceCallback callback = this.mCallback;
        if (callback == null) {
            Log.w(TAG, "setContentCaptureConditions(): no server callback");
            return;
        }
        try {
            callback.setContentCaptureConditions(packageName, ContentCaptureHelper.toList(conditions));
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void onConnected() {
        Slog.i(TAG, "bound to " + this.getClass().getName());
    }

    public void onCreateContentCaptureSession(ContentCaptureContext context, ContentCaptureSessionId sessionId) {
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "onCreateContentCaptureSession(id=" + sessionId + ", ctx=" + context + ")");
        }
    }

    public void onContentCaptureEvent(ContentCaptureSessionId sessionId, ContentCaptureEvent event) {
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "onContentCaptureEventsRequest(id=" + sessionId + ")");
        }
    }

    public void onDataRemovalRequest(DataRemovalRequest request) {
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "onDataRemovalRequest()");
        }
    }

    public void onActivitySnapshot(ContentCaptureSessionId sessionId, SnapshotData snapshotData) {
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "onActivitySnapshot(id=" + sessionId + ")");
        }
    }

    public void onActivityEvent(ActivityEvent event) {
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "onActivityEvent(): " + event);
        }
    }

    public void onDestroyContentCaptureSession(ContentCaptureSessionId sessionId) {
        if (ContentCaptureHelper.sVerbose) {
            Log.v(TAG, "onDestroyContentCaptureSession(id=" + sessionId + ")");
        }
    }

    public final void disableSelf() {
        IContentCaptureServiceCallback callback;
        if (ContentCaptureHelper.sDebug) {
            Log.d(TAG, "disableSelf()");
        }
        if ((callback = this.mCallback) == null) {
            Log.w(TAG, "disableSelf(): no server callback");
            return;
        }
        try {
            callback.disableSelf();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void onDisconnected() {
        Slog.i(TAG, "unbinding from " + this.getClass().getName());
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.print("Debug: ");
        pw.print(ContentCaptureHelper.sDebug);
        pw.print(" Verbose: ");
        pw.println(ContentCaptureHelper.sVerbose);
        int size = this.mSessionUids.size();
        pw.print("Number sessions: ");
        pw.println(size);
        if (size > 0) {
            String prefix = "  ";
            for (int i = 0; i < size; ++i) {
                pw.print("  ");
                pw.print(this.mSessionUids.keyAt(i));
                pw.print(": uid=");
                pw.println(this.mSessionUids.valueAt(i));
            }
        }
    }

    private void handleOnConnected(IBinder callback) {
        this.mCallback = IContentCaptureServiceCallback.Stub.asInterface(callback);
        this.onConnected();
    }

    private void handleOnDisconnected() {
        this.onDisconnected();
        this.mCallback = null;
    }

    private void handleOnCreateSession(ContentCaptureContext context, int sessionId, int uid, IResultReceiver clientReceiver, int initialState) {
        this.mSessionUids.put(sessionId, uid);
        this.onCreateContentCaptureSession(context, new ContentCaptureSessionId(sessionId));
        int clientFlags = context.getFlags();
        int stateFlags = 0;
        if ((clientFlags & 2) != 0) {
            stateFlags |= 0x20;
        }
        if ((clientFlags & 1) != 0) {
            stateFlags |= 0x40;
        }
        stateFlags = stateFlags == 0 ? initialState : (stateFlags |= 4);
        ContentCaptureService.setClientState(clientReceiver, stateFlags, this.mClientInterface.asBinder());
    }

    private void handleSendEvents(int uid, ParceledListSlice<ContentCaptureEvent> parceledEvents, int reason, ContentCaptureOptions options) {
        List events = parceledEvents.getList();
        if (events.isEmpty()) {
            Log.w(TAG, "handleSendEvents() received empty list of events");
            return;
        }
        FlushMetrics metrics = new FlushMetrics();
        ComponentName activityComponent = null;
        int lastSessionId = 0;
        ContentCaptureSessionId sessionId = null;
        block7: for (int i = 0; i < events.size(); ++i) {
            ContentCaptureEvent event = (ContentCaptureEvent)events.get(i);
            if (!this.handleIsRightCallerFor(event, uid)) continue;
            int sessionIdInt = event.getSessionId();
            if (sessionIdInt != lastSessionId) {
                sessionId = new ContentCaptureSessionId(sessionIdInt);
                lastSessionId = sessionIdInt;
                if (i != 0) {
                    this.writeFlushMetrics(lastSessionId, activityComponent, metrics, options, reason);
                    metrics.reset();
                }
            }
            ContentCaptureContext clientContext = event.getContentCaptureContext();
            if (activityComponent == null && clientContext != null) {
                activityComponent = clientContext.getActivityComponent();
            }
            switch (event.getType()) {
                case -1: {
                    clientContext.setParentSessionId(event.getParentSessionId());
                    this.mSessionUids.put(sessionIdInt, uid);
                    this.onCreateContentCaptureSession(clientContext, sessionId);
                    ++metrics.sessionStarted;
                    continue block7;
                }
                case -2: {
                    this.mSessionUids.delete(sessionIdInt);
                    this.onDestroyContentCaptureSession(sessionId);
                    ++metrics.sessionFinished;
                    continue block7;
                }
                case 1: {
                    this.onContentCaptureEvent(sessionId, event);
                    ++metrics.viewAppearedCount;
                    continue block7;
                }
                case 2: {
                    this.onContentCaptureEvent(sessionId, event);
                    ++metrics.viewDisappearedCount;
                    continue block7;
                }
                case 3: {
                    this.onContentCaptureEvent(sessionId, event);
                    ++metrics.viewTextChangedCount;
                    continue block7;
                }
                default: {
                    this.onContentCaptureEvent(sessionId, event);
                }
            }
        }
        this.writeFlushMetrics(lastSessionId, activityComponent, metrics, options, reason);
    }

    private void handleOnActivitySnapshot(int sessionId, SnapshotData snapshotData) {
        this.onActivitySnapshot(new ContentCaptureSessionId(sessionId), snapshotData);
    }

    private void handleFinishSession(int sessionId) {
        this.mSessionUids.delete(sessionId);
        this.onDestroyContentCaptureSession(new ContentCaptureSessionId(sessionId));
    }

    private void handleOnDataRemovalRequest(DataRemovalRequest request) {
        this.onDataRemovalRequest(request);
    }

    private void handleOnActivityEvent(ActivityEvent event) {
        this.onActivityEvent(event);
    }

    private boolean handleIsRightCallerFor(ContentCaptureEvent event, int uid) {
        int sessionId;
        switch (event.getType()) {
            case -2: 
            case -1: {
                sessionId = event.getParentSessionId();
                break;
            }
            default: {
                sessionId = event.getSessionId();
            }
        }
        if (this.mSessionUids.indexOfKey(sessionId) < 0) {
            if (ContentCaptureHelper.sVerbose) {
                Log.v(TAG, "handleIsRightCallerFor(" + event + "): no session for " + sessionId + ": " + this.mSessionUids);
            }
            return false;
        }
        int rightUid = this.mSessionUids.get(sessionId);
        if (rightUid != uid) {
            Log.e(TAG, "invalid call from UID " + uid + ": session " + sessionId + " belongs to " + rightUid);
            long now = System.currentTimeMillis();
            if (now - this.mLastCallerMismatchLog > this.mCallerMismatchTimeout) {
                StatsLog.write(206, this.getPackageManager().getNameForUid(rightUid), this.getPackageManager().getNameForUid(uid));
                this.mLastCallerMismatchLog = now;
            }
            return false;
        }
        return true;
    }

    public static void setClientState(IResultReceiver clientReceiver, int sessionState, IBinder binder) {
        try {
            Bundle extras;
            if (binder != null) {
                extras = new Bundle();
                extras.putBinder("binder", binder);
            } else {
                extras = null;
            }
            clientReceiver.send(sessionState, extras);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Error async reporting result to client: " + e);
        }
    }

    private void writeFlushMetrics(int sessionId, ComponentName app, FlushMetrics flushMetrics, ContentCaptureOptions options, int flushReason) {
        if (this.mCallback == null) {
            Log.w(TAG, "writeSessionFlush(): no server callback");
            return;
        }
        try {
            this.mCallback.writeSessionFlush(sessionId, app, flushMetrics, options, flushReason);
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to write flush metrics: " + e);
        }
    }
}

