/*
 * Decompiled with CFR 0.152.
 */
package android.service.contentcapture;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.service.contentcapture.ActivityEvent;
import android.service.contentcapture.SnapshotData;
import android.view.contentcapture.ContentCaptureContext;
import android.view.contentcapture.DataRemovalRequest;
import com.android.internal.os.IResultReceiver;

public interface IContentCaptureService
extends IInterface {
    public void onConnected(IBinder var1, boolean var2, boolean var3) throws RemoteException;

    public void onDisconnected() throws RemoteException;

    public void onSessionStarted(ContentCaptureContext var1, int var2, int var3, IResultReceiver var4, int var5) throws RemoteException;

    public void onSessionFinished(int var1) throws RemoteException;

    public void onActivitySnapshot(int var1, SnapshotData var2) throws RemoteException;

    public void onDataRemovalRequest(DataRemovalRequest var1) throws RemoteException;

    public void onActivityEvent(ActivityEvent var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContentCaptureService {
        private static final String DESCRIPTOR = "android.service.contentcapture.IContentCaptureService";
        static final int TRANSACTION_onConnected = 1;
        static final int TRANSACTION_onDisconnected = 2;
        static final int TRANSACTION_onSessionStarted = 3;
        static final int TRANSACTION_onSessionFinished = 4;
        static final int TRANSACTION_onActivitySnapshot = 5;
        static final int TRANSACTION_onDataRemovalRequest = 6;
        static final int TRANSACTION_onActivityEvent = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IContentCaptureService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IContentCaptureService) {
                return (IContentCaptureService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onConnected";
                }
                case 2: {
                    return "onDisconnected";
                }
                case 3: {
                    return "onSessionStarted";
                }
                case 4: {
                    return "onSessionFinished";
                }
                case 5: {
                    return "onActivitySnapshot";
                }
                case 6: {
                    return "onDataRemovalRequest";
                }
                case 7: {
                    return "onActivityEvent";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    this.onConnected(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.onDisconnected();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    ContentCaptureContext _arg0 = 0 != data.readInt() ? ContentCaptureContext.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    IResultReceiver _arg3 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    int _arg4 = data.readInt();
                    this.onSessionStarted(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onSessionFinished(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    SnapshotData _arg1 = 0 != data.readInt() ? SnapshotData.CREATOR.createFromParcel(data) : null;
                    this.onActivitySnapshot(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    DataRemovalRequest _arg0 = 0 != data.readInt() ? DataRemovalRequest.CREATOR.createFromParcel(data) : null;
                    this.onDataRemovalRequest(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    ActivityEvent _arg0 = 0 != data.readInt() ? ActivityEvent.CREATOR.createFromParcel(data) : null;
                    this.onActivityEvent(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IContentCaptureService impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IContentCaptureService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IContentCaptureService {
            private IBinder mRemote;
            public static IContentCaptureService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConnected(IBinder callback, boolean verbose, boolean debug) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback);
                    _data.writeInt(verbose ? 1 : 0);
                    _data.writeInt(debug ? 1 : 0);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onConnected(callback, verbose, debug);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onDisconnected() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDisconnected();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionStarted(ContentCaptureContext context, int sessionId, int uid, IResultReceiver clientReceiver, int initialState) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (context != null) {
                        _data.writeInt(1);
                        context.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(sessionId);
                    _data.writeInt(uid);
                    _data.writeStrongBinder(clientReceiver != null ? clientReceiver.asBinder() : null);
                    _data.writeInt(initialState);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSessionStarted(context, sessionId, uid, clientReceiver, initialState);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionFinished(int sessionId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSessionFinished(sessionId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivitySnapshot(int sessionId, SnapshotData snapshotData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sessionId);
                    if (snapshotData != null) {
                        _data.writeInt(1);
                        snapshotData.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onActivitySnapshot(sessionId, snapshotData);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDataRemovalRequest(DataRemovalRequest request) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (request != null) {
                        _data.writeInt(1);
                        request.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDataRemovalRequest(request);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onActivityEvent(ActivityEvent event) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (event != null) {
                        _data.writeInt(1);
                        event.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onActivityEvent(event);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IContentCaptureService {
        @Override
        public void onConnected(IBinder callback, boolean verbose, boolean debug) throws RemoteException {
        }

        @Override
        public void onDisconnected() throws RemoteException {
        }

        @Override
        public void onSessionStarted(ContentCaptureContext context, int sessionId, int uid, IResultReceiver clientReceiver, int initialState) throws RemoteException {
        }

        @Override
        public void onSessionFinished(int sessionId) throws RemoteException {
        }

        @Override
        public void onActivitySnapshot(int sessionId, SnapshotData snapshotData) throws RemoteException {
        }

        @Override
        public void onDataRemovalRequest(DataRemovalRequest request) throws RemoteException {
        }

        @Override
        public void onActivityEvent(ActivityEvent event) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

