/*
 * Decompiled with CFR 0.152.
 */
package android.service.contentsuggestions;

import android.annotation.SystemApi;
import android.app.Service;
import android.app.contentsuggestions.ClassificationsRequest;
import android.app.contentsuggestions.ContentSuggestionsManager;
import android.app.contentsuggestions.IClassificationsCallback;
import android.app.contentsuggestions.ISelectionsCallback;
import android.app.contentsuggestions.SelectionsRequest;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.GraphicBuffer;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.service.contentsuggestions.IContentSuggestionsService;
import android.util.Log;
import android.util.Slog;
import com.android.internal.util.function.pooled.PooledLambda;

@SystemApi
public abstract class ContentSuggestionsService
extends Service {
    private static final String TAG = ContentSuggestionsService.class.getSimpleName();
    private Handler mHandler;
    public static final String SERVICE_INTERFACE = "android.service.contentsuggestions.ContentSuggestionsService";
    private final IContentSuggestionsService mInterface = new IContentSuggestionsService.Stub(){

        @Override
        public void provideContextImage(int taskId, GraphicBuffer contextImage, int colorSpaceId, Bundle imageContextRequestExtras) {
            Bitmap wrappedBuffer = null;
            if (contextImage != null) {
                ColorSpace colorSpace = null;
                if (colorSpaceId >= 0 && colorSpaceId < ColorSpace.Named.values().length) {
                    colorSpace = ColorSpace.get(ColorSpace.Named.values()[colorSpaceId]);
                }
                wrappedBuffer = Bitmap.wrapHardwareBuffer(contextImage, colorSpace);
            }
            ContentSuggestionsService.this.mHandler.sendMessage(PooledLambda.obtainMessage(ContentSuggestionsService::onProcessContextImage, ContentSuggestionsService.this, taskId, wrappedBuffer, imageContextRequestExtras));
        }

        @Override
        public void suggestContentSelections(SelectionsRequest request, ISelectionsCallback callback) {
            ContentSuggestionsService.this.mHandler.sendMessage(PooledLambda.obtainMessage(ContentSuggestionsService::onSuggestContentSelections, ContentSuggestionsService.this, request, ContentSuggestionsService.this.wrapSelectionsCallback(callback)));
        }

        @Override
        public void classifyContentSelections(ClassificationsRequest request, IClassificationsCallback callback) {
            ContentSuggestionsService.this.mHandler.sendMessage(PooledLambda.obtainMessage(ContentSuggestionsService::onClassifyContentSelections, ContentSuggestionsService.this, request, ContentSuggestionsService.this.wrapClassificationCallback(callback)));
        }

        @Override
        public void notifyInteraction(String requestId, Bundle interaction) {
            ContentSuggestionsService.this.mHandler.sendMessage(PooledLambda.obtainMessage(ContentSuggestionsService::onNotifyInteraction, ContentSuggestionsService.this, requestId, interaction));
        }
    };

    @Override
    public void onCreate() {
        super.onCreate();
        this.mHandler = new Handler(Looper.getMainLooper(), null, true);
    }

    @Override
    public final IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mInterface.asBinder();
        }
        Log.w(TAG, "Tried to bind to wrong intent (should be android.service.contentsuggestions.ContentSuggestionsService: " + intent);
        return null;
    }

    public abstract void onProcessContextImage(int var1, Bitmap var2, Bundle var3);

    public abstract void onSuggestContentSelections(SelectionsRequest var1, ContentSuggestionsManager.SelectionsCallback var2);

    public abstract void onClassifyContentSelections(ClassificationsRequest var1, ContentSuggestionsManager.ClassificationsCallback var2);

    public abstract void onNotifyInteraction(String var1, Bundle var2);

    private ContentSuggestionsManager.SelectionsCallback wrapSelectionsCallback(ISelectionsCallback callback) {
        return (statusCode, selections) -> {
            try {
                callback.onContentSelectionsAvailable(statusCode, selections);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error sending result: " + e);
            }
        };
    }

    private ContentSuggestionsManager.ClassificationsCallback wrapClassificationCallback(IClassificationsCallback callback) {
        return (statusCode, classifications) -> {
            try {
                callback.onContentClassificationsAvailable(statusCode, classifications);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Error sending result: " + e);
            }
        };
    }
}

