/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.annotation.SystemApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.service.notification.Adjustment;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationListenerService;
import android.service.notification.NotificationStats;
import android.service.notification.StatusBarNotification;
import android.util.Log;
import com.android.internal.os.SomeArgs;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

@SystemApi
public abstract class NotificationAssistantService
extends NotificationListenerService {
    private static final String TAG = "NotificationAssistants";
    public static final int SOURCE_FROM_APP = 0;
    public static final int SOURCE_FROM_ASSISTANT = 1;
    public static final String SERVICE_INTERFACE = "android.service.notification.NotificationAssistantService";
    protected Handler mHandler;

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new MyHandler(this.getContext().getMainLooper());
    }

    @Override
    public final IBinder onBind(Intent intent) {
        if (this.mWrapper == null) {
            this.mWrapper = new NotificationAssistantServiceWrapper();
        }
        return this.mWrapper;
    }

    public abstract void onNotificationSnoozedUntilContext(StatusBarNotification var1, String var2);

    public abstract Adjustment onNotificationEnqueued(StatusBarNotification var1);

    public Adjustment onNotificationEnqueued(StatusBarNotification sbn, NotificationChannel channel) {
        return this.onNotificationEnqueued(sbn);
    }

    @Override
    public void onNotificationRemoved(StatusBarNotification sbn, NotificationListenerService.RankingMap rankingMap, NotificationStats stats, int reason) {
        this.onNotificationRemoved(sbn, rankingMap, reason);
    }

    public void onNotificationsSeen(List<String> keys) {
    }

    public void onNotificationExpansionChanged(String key, boolean isUserAction, boolean isExpanded) {
    }

    public void onNotificationDirectReplied(String key) {
    }

    public void onSuggestedReplySent(String key, CharSequence reply, int source) {
    }

    public void onActionInvoked(String key, Notification.Action action, int source) {
    }

    public void onAllowedAdjustmentsChanged() {
    }

    public final void adjustNotification(Adjustment adjustment) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.setAdjustmentIssuer(adjustment);
            this.getNotificationInterface().applyEnqueuedAdjustmentFromAssistant(this.mWrapper, adjustment);
        }
        catch (RemoteException ex) {
            Log.v(TAG, "Unable to contact notification manager", ex);
            throw ex.rethrowFromSystemServer();
        }
    }

    public final void adjustNotifications(List<Adjustment> adjustments) {
        if (!this.isBound()) {
            return;
        }
        try {
            for (Adjustment adjustment : adjustments) {
                this.setAdjustmentIssuer(adjustment);
            }
            this.getNotificationInterface().applyAdjustmentsFromAssistant(this.mWrapper, adjustments);
        }
        catch (RemoteException ex) {
            Log.v(TAG, "Unable to contact notification manager", ex);
            throw ex.rethrowFromSystemServer();
        }
    }

    public final void unsnoozeNotification(String key) {
        if (!this.isBound()) {
            return;
        }
        try {
            this.getNotificationInterface().unsnoozeNotificationFromAssistant(this.mWrapper, key);
        }
        catch (RemoteException ex) {
            Log.v(TAG, "Unable to contact notification manager", ex);
        }
    }

    private void setAdjustmentIssuer(Adjustment adjustment) {
        if (adjustment != null) {
            adjustment.setIssuer(this.getOpPackageName() + "/" + this.getClass().getName());
        }
    }

    private final class MyHandler
    extends Handler {
        public static final int MSG_ON_NOTIFICATION_ENQUEUED = 1;
        public static final int MSG_ON_NOTIFICATION_SNOOZED = 2;
        public static final int MSG_ON_NOTIFICATIONS_SEEN = 3;
        public static final int MSG_ON_NOTIFICATION_EXPANSION_CHANGED = 4;
        public static final int MSG_ON_NOTIFICATION_DIRECT_REPLY_SENT = 5;
        public static final int MSG_ON_SUGGESTED_REPLY_SENT = 6;
        public static final int MSG_ON_ACTION_INVOKED = 7;
        public static final int MSG_ON_ALLOWED_ADJUSTMENTS_CHANGED = 8;

        public MyHandler(Looper looper) {
            super(looper, null, false);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    NotificationChannel channel = (NotificationChannel)args.arg2;
                    args.recycle();
                    Adjustment adjustment = NotificationAssistantService.this.onNotificationEnqueued(sbn, channel);
                    NotificationAssistantService.this.setAdjustmentIssuer(adjustment);
                    if (adjustment == null) break;
                    if (!NotificationAssistantService.this.isBound()) {
                        Log.w(NotificationAssistantService.TAG, "MSG_ON_NOTIFICATION_ENQUEUED: service not bound, skip.");
                        return;
                    }
                    try {
                        NotificationAssistantService.this.getNotificationInterface().applyEnqueuedAdjustmentFromAssistant(NotificationAssistantService.this.mWrapper, adjustment);
                        break;
                    }
                    catch (RemoteException ex) {
                        Log.v(NotificationAssistantService.TAG, "Unable to contact notification manager", ex);
                        throw ex.rethrowFromSystemServer();
                    }
                    catch (SecurityException e) {
                        Log.w(NotificationAssistantService.TAG, "Enqueue adjustment failed; no longer connected", e);
                        break;
                    }
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    StatusBarNotification sbn = (StatusBarNotification)args.arg1;
                    String snoozeCriterionId = (String)args.arg2;
                    args.recycle();
                    NotificationAssistantService.this.onNotificationSnoozedUntilContext(sbn, snoozeCriterionId);
                    break;
                }
                case 3: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    List keys = (List)args.arg1;
                    args.recycle();
                    NotificationAssistantService.this.onNotificationsSeen(keys);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String key = (String)args.arg1;
                    boolean isUserAction = args.argi1 == 1;
                    boolean isExpanded = args.argi2 == 1;
                    args.recycle();
                    NotificationAssistantService.this.onNotificationExpansionChanged(key, isUserAction, isExpanded);
                    break;
                }
                case 5: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String key = (String)args.arg1;
                    args.recycle();
                    NotificationAssistantService.this.onNotificationDirectReplied(key);
                    break;
                }
                case 6: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String key = (String)args.arg1;
                    CharSequence reply = (CharSequence)args.arg2;
                    int source = args.argi2;
                    args.recycle();
                    NotificationAssistantService.this.onSuggestedReplySent(key, reply, source);
                    break;
                }
                case 7: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    String key = (String)args.arg1;
                    Notification.Action action = (Notification.Action)args.arg2;
                    int source = args.argi2;
                    args.recycle();
                    NotificationAssistantService.this.onActionInvoked(key, action, source);
                    break;
                }
                case 8: {
                    NotificationAssistantService.this.onAllowedAdjustmentsChanged();
                }
            }
        }
    }

    private class NotificationAssistantServiceWrapper
    extends NotificationListenerService.NotificationListenerWrapper {
        private NotificationAssistantServiceWrapper() {
            super(NotificationAssistantService.this);
        }

        @Override
        public void onNotificationEnqueuedWithChannel(IStatusBarNotificationHolder sbnHolder, NotificationChannel channel) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(NotificationAssistantService.TAG, "onNotificationEnqueued: Error receiving StatusBarNotification", e);
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = sbn;
            args.arg2 = channel;
            NotificationAssistantService.this.mHandler.obtainMessage(1, args).sendToTarget();
        }

        @Override
        public void onNotificationSnoozedUntilContext(IStatusBarNotificationHolder sbnHolder, String snoozeCriterionId) {
            StatusBarNotification sbn;
            try {
                sbn = sbnHolder.get();
            }
            catch (RemoteException e) {
                Log.w(NotificationAssistantService.TAG, "onNotificationSnoozed: Error receiving StatusBarNotification", e);
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = sbn;
            args.arg2 = snoozeCriterionId;
            NotificationAssistantService.this.mHandler.obtainMessage(2, args).sendToTarget();
        }

        @Override
        public void onNotificationsSeen(List<String> keys) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = keys;
            NotificationAssistantService.this.mHandler.obtainMessage(3, args).sendToTarget();
        }

        @Override
        public void onNotificationExpansionChanged(String key, boolean isUserAction, boolean isExpanded) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = key;
            args.argi1 = isUserAction ? 1 : 0;
            args.argi2 = isExpanded ? 1 : 0;
            NotificationAssistantService.this.mHandler.obtainMessage(4, args).sendToTarget();
        }

        @Override
        public void onNotificationDirectReply(String key) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = key;
            NotificationAssistantService.this.mHandler.obtainMessage(5, args).sendToTarget();
        }

        @Override
        public void onSuggestedReplySent(String key, CharSequence reply, int source) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = key;
            args.arg2 = reply;
            args.argi2 = source;
            NotificationAssistantService.this.mHandler.obtainMessage(6, args).sendToTarget();
        }

        @Override
        public void onActionClicked(String key, Notification.Action action, int source) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = key;
            args.arg2 = action;
            args.argi2 = source;
            NotificationAssistantService.this.mHandler.obtainMessage(7, args).sendToTarget();
        }

        @Override
        public void onAllowedAdjustmentsChanged() {
            NotificationAssistantService.this.mHandler.obtainMessage(8).sendToTarget();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Source {
    }
}

