/*
 * Decompiled with CFR 0.152.
 */
package android.service.settings.suggestions;

import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.graphics.drawable.Icon;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public final class Suggestion
implements Parcelable {
    public static final int FLAG_HAS_BUTTON = 1;
    public static final int FLAG_ICON_TINTABLE = 2;
    private final String mId;
    private final CharSequence mTitle;
    private final CharSequence mSummary;
    private final Icon mIcon;
    private final int mFlags;
    private final PendingIntent mPendingIntent;
    public static final Parcelable.Creator<Suggestion> CREATOR = new Parcelable.Creator<Suggestion>(){

        @Override
        public Suggestion createFromParcel(Parcel in) {
            return new Suggestion(in);
        }

        public Suggestion[] newArray(int size) {
            return new Suggestion[size];
        }
    };

    public String getId() {
        return this.mId;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public CharSequence getSummary() {
        return this.mSummary;
    }

    public Icon getIcon() {
        return this.mIcon;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    private Suggestion(Builder builder) {
        this.mId = builder.mId;
        this.mTitle = builder.mTitle;
        this.mSummary = builder.mSummary;
        this.mIcon = builder.mIcon;
        this.mFlags = builder.mFlags;
        this.mPendingIntent = builder.mPendingIntent;
    }

    private Suggestion(Parcel in) {
        this.mId = in.readString();
        this.mTitle = in.readCharSequence();
        this.mSummary = in.readCharSequence();
        this.mIcon = (Icon)in.readParcelable(Icon.class.getClassLoader());
        this.mFlags = in.readInt();
        this.mPendingIntent = (PendingIntent)in.readParcelable(PendingIntent.class.getClassLoader());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mId);
        dest.writeCharSequence(this.mTitle);
        dest.writeCharSequence(this.mSummary);
        dest.writeParcelable(this.mIcon, flags);
        dest.writeInt(this.mFlags);
        dest.writeParcelable(this.mPendingIntent, flags);
    }

    public static class Builder {
        private final String mId;
        private CharSequence mTitle;
        private CharSequence mSummary;
        private Icon mIcon;
        private int mFlags;
        private PendingIntent mPendingIntent;

        public Builder(String id2) {
            if (TextUtils.isEmpty(id2)) {
                throw new IllegalArgumentException("Suggestion id cannot be empty");
            }
            this.mId = id2;
        }

        public Builder setTitle(CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setSummary(CharSequence summary) {
            this.mSummary = summary;
            return this;
        }

        public Builder setIcon(Icon icon) {
            this.mIcon = icon;
            return this;
        }

        public Builder setFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        public Builder setPendingIntent(PendingIntent pendingIntent) {
            this.mPendingIntent = pendingIntent;
            return this;
        }

        public Suggestion build() {
            return new Suggestion(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

