/*
 * Decompiled with CFR 0.152.
 */
package android.service.trust;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;

public interface ITrustAgentServiceCallback
extends IInterface {
    public void grantTrust(CharSequence var1, long var2, int var4) throws RemoteException;

    public void revokeTrust() throws RemoteException;

    public void setManagingTrust(boolean var1) throws RemoteException;

    public void onConfigureCompleted(boolean var1, IBinder var2) throws RemoteException;

    public void addEscrowToken(byte[] var1, int var2) throws RemoteException;

    public void isEscrowTokenActive(long var1, int var3) throws RemoteException;

    public void removeEscrowToken(long var1, int var3) throws RemoteException;

    public void unlockUserWithToken(long var1, byte[] var3, int var4) throws RemoteException;

    public void showKeyguardErrorMessage(CharSequence var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITrustAgentServiceCallback {
        private static final String DESCRIPTOR = "android.service.trust.ITrustAgentServiceCallback";
        static final int TRANSACTION_grantTrust = 1;
        static final int TRANSACTION_revokeTrust = 2;
        static final int TRANSACTION_setManagingTrust = 3;
        static final int TRANSACTION_onConfigureCompleted = 4;
        static final int TRANSACTION_addEscrowToken = 5;
        static final int TRANSACTION_isEscrowTokenActive = 6;
        static final int TRANSACTION_removeEscrowToken = 7;
        static final int TRANSACTION_unlockUserWithToken = 8;
        static final int TRANSACTION_showKeyguardErrorMessage = 9;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ITrustAgentServiceCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ITrustAgentServiceCallback) {
                return (ITrustAgentServiceCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "grantTrust";
                }
                case 2: {
                    return "revokeTrust";
                }
                case 3: {
                    return "setManagingTrust";
                }
                case 4: {
                    return "onConfigureCompleted";
                }
                case 5: {
                    return "addEscrowToken";
                }
                case 6: {
                    return "isEscrowTokenActive";
                }
                case 7: {
                    return "removeEscrowToken";
                }
                case 8: {
                    return "unlockUserWithToken";
                }
                case 9: {
                    return "showKeyguardErrorMessage";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    CharSequence _arg0 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    long _arg1 = data.readLong();
                    int _arg2 = data.readInt();
                    this.grantTrust(_arg0, _arg1, _arg2);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.revokeTrust();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setManagingTrust(_arg0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    this.onConfigureCompleted(_arg0, _arg1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    int _arg1 = data.readInt();
                    this.addEscrowToken(_arg0, _arg1);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    this.isEscrowTokenActive(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    this.removeEscrowToken(_arg0, _arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    byte[] _arg1 = data.createByteArray();
                    int _arg2 = data.readInt();
                    this.unlockUserWithToken(_arg0, _arg1, _arg2);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    CharSequence _arg0 = 0 != data.readInt() ? TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data) : null;
                    this.showKeyguardErrorMessage(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITrustAgentServiceCallback impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITrustAgentServiceCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITrustAgentServiceCallback {
            private IBinder mRemote;
            public static ITrustAgentServiceCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantTrust(CharSequence message, long durationMs, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (message != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(message, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeLong(durationMs);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().grantTrust(message, durationMs, flags);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void revokeTrust() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().revokeTrust();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setManagingTrust(boolean managingTrust) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(managingTrust ? 1 : 0);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setManagingTrust(managingTrust);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigureCompleted(boolean result, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(result ? 1 : 0);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onConfigureCompleted(result, token);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addEscrowToken(byte[] token, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(token);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addEscrowToken(token, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isEscrowTokenActive(long handle, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(handle);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().isEscrowTokenActive(handle, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeEscrowToken(long handle, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(handle);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeEscrowToken(handle, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlockUserWithToken(long handle, byte[] token, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(handle);
                    _data.writeByteArray(token);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unlockUserWithToken(handle, token, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showKeyguardErrorMessage(CharSequence message) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (message != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(message, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().showKeyguardErrorMessage(message);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITrustAgentServiceCallback {
        @Override
        public void grantTrust(CharSequence message, long durationMs, int flags) throws RemoteException {
        }

        @Override
        public void revokeTrust() throws RemoteException {
        }

        @Override
        public void setManagingTrust(boolean managingTrust) throws RemoteException {
        }

        @Override
        public void onConfigureCompleted(boolean result, IBinder token) throws RemoteException {
        }

        @Override
        public void addEscrowToken(byte[] token, int userId) throws RemoteException {
        }

        @Override
        public void isEscrowTokenActive(long handle, int userId) throws RemoteException {
        }

        @Override
        public void removeEscrowToken(long handle, int userId) throws RemoteException {
        }

        @Override
        public void unlockUserWithToken(long handle, byte[] token, int userId) throws RemoteException {
        }

        @Override
        public void showKeyguardErrorMessage(CharSequence message) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

