/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.annotation.UnsupportedAppUsage;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.hardware.soundtrigger.KeyphraseEnrollmentInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.service.voice.AlwaysOnHotwordDetector;
import android.service.voice.IVoiceInteractionService;
import android.util.ArraySet;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.IVoiceActionCheckCallback;
import com.android.internal.app.IVoiceInteractionManagerService;
import com.android.internal.util.function.pooled.PooledLambda;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class VoiceInteractionService
extends Service {
    public static final String SERVICE_INTERFACE = "android.service.voice.VoiceInteractionService";
    public static final String SERVICE_META_DATA = "android.voice_interaction";
    IVoiceInteractionService mInterface = new IVoiceInteractionService.Stub(){

        @Override
        public void ready() {
            Handler.getMain().executeOrSendMessage(PooledLambda.obtainMessage(VoiceInteractionService::onReady, VoiceInteractionService.this));
        }

        @Override
        public void shutdown() {
            Handler.getMain().executeOrSendMessage(PooledLambda.obtainMessage(rec$ -> ((VoiceInteractionService)rec$).onShutdownInternal(), VoiceInteractionService.this));
        }

        @Override
        public void soundModelsChanged() {
            Handler.getMain().executeOrSendMessage(PooledLambda.obtainMessage(rec$ -> ((VoiceInteractionService)rec$).onSoundModelsChangedInternal(), VoiceInteractionService.this));
        }

        @Override
        public void launchVoiceAssistFromKeyguard() {
            Handler.getMain().executeOrSendMessage(PooledLambda.obtainMessage(VoiceInteractionService::onLaunchVoiceAssistFromKeyguard, VoiceInteractionService.this));
        }

        @Override
        public void getActiveServiceSupportedActions(List<String> voiceActions, IVoiceActionCheckCallback callback) {
            Handler.getMain().executeOrSendMessage(PooledLambda.obtainMessage((rec$, x$0, x$1) -> ((VoiceInteractionService)rec$).onHandleVoiceActionCheck(x$0, x$1), VoiceInteractionService.this, voiceActions, callback));
        }
    };
    IVoiceInteractionManagerService mSystemService;
    private final Object mLock = new Object();
    private KeyphraseEnrollmentInfo mKeyphraseEnrollmentInfo;
    private AlwaysOnHotwordDetector mHotwordDetector;

    public void onLaunchVoiceAssistFromKeyguard() {
    }

    public static boolean isActiveService(Context context, ComponentName service) {
        String cur = Settings.Secure.getString(context.getContentResolver(), "voice_interaction_service");
        if (cur == null || cur.isEmpty()) {
            return false;
        }
        ComponentName curComp = ComponentName.unflattenFromString(cur);
        if (curComp == null) {
            return false;
        }
        return curComp.equals(service);
    }

    public void setDisabledShowContext(int flags) {
        try {
            this.mSystemService.setDisabledShowContext(flags);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getDisabledShowContext() {
        try {
            return this.mSystemService.getDisabledShowContext();
        }
        catch (RemoteException e) {
            return 0;
        }
    }

    public void showSession(Bundle args, int flags) {
        if (this.mSystemService == null) {
            throw new IllegalStateException("Not available until onReady() is called");
        }
        try {
            this.mSystemService.showSession(this.mInterface, args, flags);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public Set<String> onGetSupportedVoiceActions(Set<String> voiceActions) {
        return Collections.emptySet();
    }

    @Override
    public IBinder onBind(Intent intent) {
        if (SERVICE_INTERFACE.equals(intent.getAction())) {
            return this.mInterface.asBinder();
        }
        return null;
    }

    public void onReady() {
        this.mSystemService = IVoiceInteractionManagerService.Stub.asInterface(ServiceManager.getService("voiceinteraction"));
        this.mKeyphraseEnrollmentInfo = new KeyphraseEnrollmentInfo(this.getPackageManager());
    }

    private void onShutdownInternal() {
        this.onShutdown();
        this.safelyShutdownHotwordDetector();
    }

    public void onShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSoundModelsChangedInternal() {
        VoiceInteractionService voiceInteractionService = this;
        synchronized (voiceInteractionService) {
            if (this.mHotwordDetector != null) {
                this.mHotwordDetector.onSoundModelsChanged();
            }
        }
    }

    private void onHandleVoiceActionCheck(List<String> voiceActions, IVoiceActionCheckCallback callback) {
        if (callback != null) {
            try {
                ArraySet<String> voiceActionsSet = new ArraySet<String>(voiceActions);
                Set<String> resultSet = this.onGetSupportedVoiceActions(voiceActionsSet);
                callback.onComplete(new ArrayList<String>(resultSet));
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AlwaysOnHotwordDetector createAlwaysOnHotwordDetector(String keyphrase, Locale locale, AlwaysOnHotwordDetector.Callback callback) {
        if (this.mSystemService == null) {
            throw new IllegalStateException("Not available until onReady() is called");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.safelyShutdownHotwordDetector();
            this.mHotwordDetector = new AlwaysOnHotwordDetector(keyphrase, locale, callback, this.mKeyphraseEnrollmentInfo, this.mInterface, this.mSystemService);
        }
        return this.mHotwordDetector;
    }

    @VisibleForTesting
    protected final KeyphraseEnrollmentInfo getKeyphraseEnrollmentInfo() {
        return this.mKeyphraseEnrollmentInfo;
    }

    @UnsupportedAppUsage
    public final boolean isKeyphraseAndLocaleSupportedForHotword(String keyphrase, Locale locale) {
        if (this.mKeyphraseEnrollmentInfo == null) {
            return false;
        }
        return this.mKeyphraseEnrollmentInfo.getKeyphraseMetadata(keyphrase, locale) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safelyShutdownHotwordDetector() {
        try {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mHotwordDetector != null) {
                    this.mHotwordDetector.stopRecognition();
                    this.mHotwordDetector.invalidate();
                    this.mHotwordDetector = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void setUiHints(Bundle hints) {
        if (hints == null) {
            throw new IllegalArgumentException("Hints must be non-null");
        }
        try {
            this.mSystemService.setUiHints(this.mInterface, hints);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("VOICE INTERACTION");
        Object object = this.mLock;
        synchronized (object) {
            pw.println("  AlwaysOnHotwordDetector");
            if (this.mHotwordDetector == null) {
                pw.println("    NULL");
            } else {
                this.mHotwordDetector.dump("    ", pw);
            }
        }
    }
}

