/*
 * Decompiled with CFR 0.152.
 */
package android.service.watchdog;

import android.annotation.SystemApi;
import android.app.Service;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.service.watchdog.IExplicitHealthCheckService;
import android.util.Log;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@SystemApi
public abstract class ExplicitHealthCheckService
extends Service {
    private static final String TAG = "ExplicitHealthCheckService";
    public static final String EXTRA_SUPPORTED_PACKAGES = "android.service.watchdog.extra.supported_packages";
    public static final String EXTRA_REQUESTED_PACKAGES = "android.service.watchdog.extra.requested_packages";
    public static final String EXTRA_HEALTH_CHECK_PASSED_PACKAGE = "android.service.watchdog.extra.health_check_passed_package";
    public static final String SERVICE_INTERFACE = "android.service.watchdog.ExplicitHealthCheckService";
    public static final String BIND_PERMISSION = "android.permission.BIND_EXPLICIT_HEALTH_CHECK_SERVICE";
    private final ExplicitHealthCheckServiceWrapper mWrapper = new ExplicitHealthCheckServiceWrapper();
    private final Handler mHandler = new Handler(Looper.getMainLooper(), null, true);
    private RemoteCallback mCallback;

    public abstract void onRequestHealthCheck(String var1);

    public abstract void onCancelHealthCheck(String var1);

    public abstract List<PackageConfig> onGetSupportedPackages();

    public abstract List<String> onGetRequestedPackages();

    @Override
    public final IBinder onBind(Intent intent) {
        return this.mWrapper;
    }

    public final void notifyHealthCheckPassed(String packageName) {
        this.mHandler.post(() -> {
            if (this.mCallback != null) {
                Objects.requireNonNull(packageName, "Package passing explicit health check must be non-null");
                Bundle bundle = new Bundle();
                bundle.putString(EXTRA_HEALTH_CHECK_PASSED_PACKAGE, packageName);
                this.mCallback.sendResult(bundle);
            } else {
                Log.wtf(TAG, "System missed explicit health check result for " + packageName);
            }
        });
    }

    private class ExplicitHealthCheckServiceWrapper
    extends IExplicitHealthCheckService.Stub {
        private ExplicitHealthCheckServiceWrapper() {
        }

        @Override
        public void setCallback(RemoteCallback callback) throws RemoteException {
            ExplicitHealthCheckService.this.mHandler.post(() -> ExplicitHealthCheckService.this.mCallback = callback);
        }

        @Override
        public void request(String packageName) throws RemoteException {
            ExplicitHealthCheckService.this.mHandler.post(() -> ExplicitHealthCheckService.this.onRequestHealthCheck(packageName));
        }

        @Override
        public void cancel(String packageName) throws RemoteException {
            ExplicitHealthCheckService.this.mHandler.post(() -> ExplicitHealthCheckService.this.onCancelHealthCheck(packageName));
        }

        @Override
        public void getSupportedPackages(RemoteCallback callback) throws RemoteException {
            ExplicitHealthCheckService.this.mHandler.post(() -> {
                List<PackageConfig> packages = ExplicitHealthCheckService.this.onGetSupportedPackages();
                Objects.requireNonNull(packages, "Supported package list must be non-null");
                Bundle bundle = new Bundle();
                bundle.putParcelableArrayList(ExplicitHealthCheckService.EXTRA_SUPPORTED_PACKAGES, new ArrayList<PackageConfig>(packages));
                callback.sendResult(bundle);
            });
        }

        @Override
        public void getRequestedPackages(RemoteCallback callback) throws RemoteException {
            ExplicitHealthCheckService.this.mHandler.post(() -> {
                List<String> packages = ExplicitHealthCheckService.this.onGetRequestedPackages();
                Objects.requireNonNull(packages, "Requested  package list must be non-null");
                Bundle bundle = new Bundle();
                bundle.putStringArrayList(ExplicitHealthCheckService.EXTRA_REQUESTED_PACKAGES, new ArrayList<String>(packages));
                callback.sendResult(bundle);
            });
        }
    }

    @SystemApi
    public static final class PackageConfig
    implements Parcelable {
        private static final long DEFAULT_HEALTH_CHECK_TIMEOUT_MILLIS = TimeUnit.HOURS.toMillis(1L);
        private final String mPackageName;
        private final long mHealthCheckTimeoutMillis;
        public static final Parcelable.Creator<PackageConfig> CREATOR = new Parcelable.Creator<PackageConfig>(){

            @Override
            public PackageConfig createFromParcel(Parcel source) {
                return new PackageConfig(source);
            }

            public PackageConfig[] newArray(int size) {
                return new PackageConfig[size];
            }
        };

        public PackageConfig(String packageName, long healthCheckTimeoutMillis) {
            this.mPackageName = Preconditions.checkNotNull(packageName);
            this.mHealthCheckTimeoutMillis = healthCheckTimeoutMillis == 0L ? DEFAULT_HEALTH_CHECK_TIMEOUT_MILLIS : Preconditions.checkArgumentNonnegative(healthCheckTimeoutMillis);
        }

        private PackageConfig(Parcel parcel) {
            this.mPackageName = parcel.readString();
            this.mHealthCheckTimeoutMillis = parcel.readLong();
        }

        public String getPackageName() {
            return this.mPackageName;
        }

        public long getHealthCheckTimeoutMillis() {
            return this.mHealthCheckTimeoutMillis;
        }

        public String toString() {
            return "PackageConfig{" + this.mPackageName + ", " + this.mHealthCheckTimeoutMillis + "}";
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof PackageConfig)) {
                return false;
            }
            PackageConfig otherInfo = (PackageConfig)other;
            return Objects.equals(otherInfo.getHealthCheckTimeoutMillis(), this.mHealthCheckTimeoutMillis) && Objects.equals(otherInfo.getPackageName(), this.mPackageName);
        }

        public int hashCode() {
            return Objects.hash(this.mPackageName, this.mHealthCheckTimeoutMillis);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeString(this.mPackageName);
            parcel.writeLong(this.mHealthCheckTimeoutMillis);
        }
    }
}

