/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.media.AudioFormat;
import android.media.AudioTrack;
import android.speech.tts.TextToSpeechService;
import android.util.Log;

class BlockingAudioTrack {
    private static final String TAG = "TTS.BlockingAudioTrack";
    private static final boolean DBG = false;
    private static final long MIN_SLEEP_TIME_MS = 20L;
    private static final long MAX_SLEEP_TIME_MS = 2500L;
    private static final long MAX_PROGRESS_WAIT_MS = 2500L;
    private static final int MIN_AUDIO_BUFFER_SIZE = 8192;
    private final TextToSpeechService.AudioOutputParams mAudioParams;
    private final int mSampleRateInHz;
    private final int mAudioFormat;
    private final int mChannelCount;
    private final int mBytesPerFrame;
    private boolean mIsShortUtterance;
    private int mAudioBufferSize;
    private int mBytesWritten = 0;
    private Object mAudioTrackLock = new Object();
    private AudioTrack mAudioTrack;
    private volatile boolean mStopped;
    private int mSessionId;

    BlockingAudioTrack(TextToSpeechService.AudioOutputParams audioParams, int sampleRate, int audioFormat, int channelCount) {
        this.mAudioParams = audioParams;
        this.mSampleRateInHz = sampleRate;
        this.mAudioFormat = audioFormat;
        this.mChannelCount = channelCount;
        this.mBytesPerFrame = AudioFormat.getBytesPerSample(this.mAudioFormat) * this.mChannelCount;
        this.mIsShortUtterance = false;
        this.mAudioBufferSize = 0;
        this.mBytesWritten = 0;
        this.mAudioTrack = null;
        this.mStopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        AudioTrack track = this.createStreamingAudioTrack();
        Object object = this.mAudioTrackLock;
        synchronized (object) {
            this.mAudioTrack = track;
        }
        return track != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mAudioTrackLock;
        synchronized (object) {
            if (this.mAudioTrack != null) {
                this.mAudioTrack.stop();
            }
            this.mStopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(byte[] data) {
        AudioTrack track = null;
        Object object = this.mAudioTrackLock;
        synchronized (object) {
            track = this.mAudioTrack;
        }
        if (track == null || this.mStopped) {
            return -1;
        }
        int bytesWritten = BlockingAudioTrack.writeToAudioTrack(track, data);
        this.mBytesWritten += bytesWritten;
        return bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitAndRelease() {
        AudioTrack track = null;
        Object object = this.mAudioTrackLock;
        synchronized (object) {
            track = this.mAudioTrack;
        }
        if (track == null) {
            return;
        }
        if (this.mBytesWritten < this.mAudioBufferSize && !this.mStopped) {
            this.mIsShortUtterance = true;
            track.stop();
        }
        if (!this.mStopped) {
            this.blockUntilDone(this.mAudioTrack);
        }
        object = this.mAudioTrackLock;
        synchronized (object) {
            this.mAudioTrack = null;
        }
        track.release();
    }

    static int getChannelConfig(int channelCount) {
        if (channelCount == 1) {
            return 4;
        }
        if (channelCount == 2) {
            return 12;
        }
        return 0;
    }

    long getAudioLengthMs(int numBytes) {
        int unconsumedFrames = numBytes / this.mBytesPerFrame;
        long estimatedTimeMs = unconsumedFrames * 1000 / this.mSampleRateInHz;
        return estimatedTimeMs;
    }

    private static int writeToAudioTrack(AudioTrack audioTrack, byte[] bytes) {
        int count;
        int written;
        if (audioTrack.getPlayState() != 3) {
            audioTrack.play();
        }
        for (count = 0; count < bytes.length && (written = audioTrack.write(bytes, count, bytes.length)) > 0; count += written) {
        }
        return count;
    }

    private AudioTrack createStreamingAudioTrack() {
        int channelConfig = BlockingAudioTrack.getChannelConfig(this.mChannelCount);
        int minBufferSizeInBytes = AudioTrack.getMinBufferSize(this.mSampleRateInHz, channelConfig, this.mAudioFormat);
        int bufferSizeInBytes = Math.max(8192, minBufferSizeInBytes);
        AudioFormat audioFormat = new AudioFormat.Builder().setChannelMask(channelConfig).setEncoding(this.mAudioFormat).setSampleRate(this.mSampleRateInHz).build();
        AudioTrack audioTrack = new AudioTrack(this.mAudioParams.mAudioAttributes, audioFormat, bufferSizeInBytes, 1, this.mAudioParams.mSessionId);
        if (audioTrack.getState() != 1) {
            Log.w(TAG, "Unable to create audio track.");
            audioTrack.release();
            return null;
        }
        this.mAudioBufferSize = bufferSizeInBytes;
        BlockingAudioTrack.setupVolume(audioTrack, this.mAudioParams.mVolume, this.mAudioParams.mPan);
        return audioTrack;
    }

    private void blockUntilDone(AudioTrack audioTrack) {
        if (this.mBytesWritten <= 0) {
            return;
        }
        if (this.mIsShortUtterance) {
            this.blockUntilEstimatedCompletion();
        } else {
            this.blockUntilCompletion(audioTrack);
        }
    }

    private void blockUntilEstimatedCompletion() {
        int lengthInFrames = this.mBytesWritten / this.mBytesPerFrame;
        long estimatedTimeMs = lengthInFrames * 1000 / this.mSampleRateInHz;
        try {
            Thread.sleep(estimatedTimeMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void blockUntilCompletion(AudioTrack audioTrack) {
        int lengthInFrames = this.mBytesWritten / this.mBytesPerFrame;
        int previousPosition = -1;
        int currentPosition = 0;
        long blockedTimeMs = 0L;
        while ((currentPosition = audioTrack.getPlaybackHeadPosition()) < lengthInFrames && audioTrack.getPlayState() == 3 && !this.mStopped) {
            long estimatedTimeMs = (lengthInFrames - currentPosition) * 1000 / audioTrack.getSampleRate();
            long sleepTimeMs = BlockingAudioTrack.clip(estimatedTimeMs, 20L, 2500L);
            if (currentPosition == previousPosition) {
                if ((blockedTimeMs += sleepTimeMs) > 2500L) {
                    Log.w(TAG, "Waited unsuccessfully for 2500ms for AudioTrack to make progress, Aborting");
                    break;
                }
            } else {
                blockedTimeMs = 0L;
            }
            previousPosition = currentPosition;
            try {
                Thread.sleep(sleepTimeMs);
            }
            catch (InterruptedException ie) {
                break;
            }
        }
    }

    private static void setupVolume(AudioTrack audioTrack, float volume, float pan) {
        float vol = BlockingAudioTrack.clip(volume, 0.0f, 1.0f);
        float panning = BlockingAudioTrack.clip(pan, -1.0f, 1.0f);
        float volLeft = vol;
        float volRight = vol;
        if (panning > 0.0f) {
            volLeft *= 1.0f - panning;
        } else if (panning < 0.0f) {
            volRight *= 1.0f + panning;
        }
        if (audioTrack.setStereoVolume(volLeft, volRight) != 0) {
            Log.e(TAG, "Failed to set volume");
        }
    }

    private static final long clip(long value, long min, long max) {
        return value < min ? min : (value < max ? value : max);
    }

    private static final float clip(float value, float min, float max) {
        return value < min ? min : (value < max ? value : max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlaybackPositionUpdateListener(AudioTrack.OnPlaybackPositionUpdateListener listener) {
        Object object = this.mAudioTrackLock;
        synchronized (object) {
            if (this.mAudioTrack != null) {
                this.mAudioTrack.setPlaybackPositionUpdateListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotificationMarkerPosition(int frames) {
        Object object = this.mAudioTrackLock;
        synchronized (object) {
            if (this.mAudioTrack != null) {
                this.mAudioTrack.setNotificationMarkerPosition(frames);
            }
        }
    }
}

