/*
 * Decompiled with CFR 0.152.
 */
package android.sysprop;

import android.os.SystemProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;

public final class CarProperties {
    private CarProperties() {
    }

    private static Boolean tryParseBoolean(String str) {
        switch (str.toLowerCase(Locale.US)) {
            case "1": 
            case "true": {
                return Boolean.TRUE;
            }
            case "0": 
            case "false": {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static Integer tryParseInteger(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long tryParseLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Double tryParseDouble(String str) {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String tryParseString(String str) {
        return "".equals(str) ? null : str;
    }

    private static <T extends Enum<T>> T tryParseEnum(Class<T> enumType, String str) {
        try {
            return Enum.valueOf(enumType, str.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static <T> List<T> tryParseList(Function<String, T> elementParser, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (String element : str.split(",")) {
            ret.add(elementParser.apply(element));
        }
        return ret;
    }

    private static <T extends Enum<T>> List<T> tryParseEnumList(Class<T> enumType, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (String element : str.split(",")) {
            ret.add(CarProperties.tryParseEnum(enumType, element));
        }
        return ret;
    }

    private static <T> String formatList(List<T> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (T element : list) {
            joiner.add(element == null ? "" : element.toString());
        }
        return joiner.toString();
    }

    private static <T extends Enum<T>> String formatEnumList(List<T> list, Function<T, String> elementFormatter) {
        StringJoiner joiner = new StringJoiner(",");
        for (Enum element : list) {
            joiner.add(element == null ? "" : (CharSequence)elementFormatter.apply(element));
        }
        return joiner.toString();
    }

    public static Optional<Boolean> headless_system_user() {
        String value = SystemProperties.get("android.car.systemuser.headless");
        return Optional.ofNullable(CarProperties.tryParseBoolean(value));
    }

    public static void headless_system_user(Boolean value) {
        SystemProperties.set("android.car.systemuser.headless", value == null ? "" : value.toString());
    }

    public static Optional<Integer> boot_user_override_id() {
        String value = SystemProperties.get("android.car.systemuser.bootuseroverrideid");
        return Optional.ofNullable(CarProperties.tryParseInteger(value));
    }

    public static void boot_user_override_id(Integer value) {
        SystemProperties.set("android.car.systemuser.bootuseroverrideid", value == null ? "" : value.toString());
    }

    public static Optional<String> trusted_device_device_name_prefix() {
        String value = SystemProperties.get("ro.android.car.trusteddevice.device_name_prefix");
        return Optional.ofNullable(CarProperties.tryParseString(value));
    }
}

