/*
 * Decompiled with CFR 0.152.
 */
package android.sysprop;

import android.os.SystemProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;

public final class TraceProperties {
    private TraceProperties() {
    }

    private static Boolean tryParseBoolean(String str) {
        switch (str.toLowerCase(Locale.US)) {
            case "1": 
            case "true": {
                return Boolean.TRUE;
            }
            case "0": 
            case "false": {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static Integer tryParseInteger(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Long tryParseLong(String str) {
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Double tryParseDouble(String str) {
        try {
            return Double.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static String tryParseString(String str) {
        return "".equals(str) ? null : str;
    }

    private static <T extends Enum<T>> T tryParseEnum(Class<T> enumType, String str) {
        try {
            return Enum.valueOf(enumType, str.toUpperCase(Locale.US));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static <T> List<T> tryParseList(Function<String, T> elementParser, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (String element : str.split(",")) {
            ret.add(elementParser.apply(element));
        }
        return ret;
    }

    private static <T extends Enum<T>> List<T> tryParseEnumList(Class<T> enumType, String str) {
        if ("".equals(str)) {
            return new ArrayList();
        }
        ArrayList<T> ret = new ArrayList<T>();
        for (String element : str.split(",")) {
            ret.add(TraceProperties.tryParseEnum(enumType, element));
        }
        return ret;
    }

    private static <T> String formatList(List<T> list) {
        StringJoiner joiner = new StringJoiner(",");
        for (T element : list) {
            joiner.add(element == null ? "" : element.toString());
        }
        return joiner.toString();
    }

    private static <T extends Enum<T>> String formatEnumList(List<T> list, Function<T, String> elementFormatter) {
        StringJoiner joiner = new StringJoiner(",");
        for (Enum element : list) {
            joiner.add(element == null ? "" : (CharSequence)elementFormatter.apply(element));
        }
        return joiner.toString();
    }

    public static Optional<Boolean> user_initiated() {
        String value = SystemProperties.get("debug.atrace.user_initiated");
        return Optional.ofNullable(TraceProperties.tryParseBoolean(value));
    }

    public static void user_initiated(Boolean value) {
        SystemProperties.set("debug.atrace.user_initiated", value == null ? "" : (value != false ? "1" : "0"));
    }

    public static Optional<Boolean> enable() {
        String value = SystemProperties.get("persist.traced.enable");
        return Optional.ofNullable(TraceProperties.tryParseBoolean(value));
    }

    public static void enable(Boolean value) {
        SystemProperties.set("persist.traced.enable", value == null ? "" : (value != false ? "1" : "0"));
    }
}

