/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.telecom.Connection;
import android.telecom.Log;
import android.telecom.ParcelableCall;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import com.android.internal.annotations.VisibleForTesting;

public class ConferenceParticipant
implements Parcelable {
    private static final String ANONYMOUS_INVALID_HOST = "anonymous.invalid";
    private final Uri mHandle;
    private final String mDisplayName;
    private final Uri mEndpoint;
    private final int mState;
    private long mConnectTime;
    private long mConnectElapsedTime;
    private int mCallDirection;
    public static final Parcelable.Creator<ConferenceParticipant> CREATOR = new Parcelable.Creator<ConferenceParticipant>(){

        @Override
        public ConferenceParticipant createFromParcel(Parcel source) {
            ClassLoader classLoader = ParcelableCall.class.getClassLoader();
            Uri handle = (Uri)source.readParcelable(classLoader);
            String displayName = source.readString();
            Uri endpoint = (Uri)source.readParcelable(classLoader);
            int state = source.readInt();
            long connectTime = source.readLong();
            long elapsedRealTime = source.readLong();
            int callDirection = source.readInt();
            ConferenceParticipant participant = new ConferenceParticipant(handle, displayName, endpoint, state, callDirection);
            participant.setConnectTime(connectTime);
            participant.setConnectElapsedTime(elapsedRealTime);
            participant.setCallDirection(callDirection);
            return participant;
        }

        public ConferenceParticipant[] newArray(int size) {
            return new ConferenceParticipant[size];
        }
    };

    public ConferenceParticipant(Uri handle, String displayName, Uri endpoint, int state, int callDirection) {
        this.mHandle = handle;
        this.mDisplayName = displayName;
        this.mEndpoint = endpoint;
        this.mState = state;
        this.mCallDirection = callDirection;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @VisibleForTesting
    public int getParticipantPresentation() {
        Uri address = this.getHandle();
        if (address == null) {
            return 2;
        }
        String number = address.getSchemeSpecificPart();
        if (TextUtils.isEmpty(number)) {
            return 2;
        }
        String[] hostParts = number.split("[;]");
        String addressPart = hostParts[0];
        String[] numberParts = addressPart.split("[@]");
        if (numberParts.length != 2) {
            return 1;
        }
        String hostName = numberParts[1];
        if (hostName.equals(ANONYMOUS_INVALID_HOST)) {
            return 2;
        }
        return 1;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mHandle, 0);
        dest.writeString(this.mDisplayName);
        dest.writeParcelable(this.mEndpoint, 0);
        dest.writeInt(this.mState);
        dest.writeLong(this.mConnectTime);
        dest.writeLong(this.mConnectElapsedTime);
        dest.writeInt(this.mCallDirection);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ConferenceParticipant Handle: ");
        sb.append(Log.pii(this.mHandle));
        sb.append(" DisplayName: ");
        sb.append(Log.pii(this.mDisplayName));
        sb.append(" Endpoint: ");
        sb.append(Log.pii(this.mEndpoint));
        sb.append(" State: ");
        sb.append(Connection.stateToString(this.mState));
        sb.append(" ConnectTime: ");
        sb.append(this.getConnectTime());
        sb.append(" ConnectElapsedTime: ");
        sb.append(this.getConnectElapsedTime());
        sb.append(" Direction: ");
        sb.append(this.getCallDirection() == 0 ? "Incoming" : "Outgoing");
        sb.append("]");
        return sb.toString();
    }

    public Uri getHandle() {
        return this.mHandle;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public Uri getEndpoint() {
        return this.mEndpoint;
    }

    public int getState() {
        return this.mState;
    }

    public long getConnectTime() {
        return this.mConnectTime;
    }

    public void setConnectTime(long connectTime) {
        this.mConnectTime = connectTime;
    }

    public long getConnectElapsedTime() {
        return this.mConnectElapsedTime;
    }

    public void setConnectElapsedTime(long connectElapsedTime) {
        this.mConnectElapsedTime = connectElapsedTime;
    }

    public int getCallDirection() {
        return this.mCallDirection;
    }

    public void setCallDirection(int callDirection) {
        this.mCallDirection = callDirection;
    }

    @VisibleForTesting
    public static Uri getParticipantAddress(Uri address, String countryIso) {
        if (address == null) {
            return address;
        }
        String number = address.getSchemeSpecificPart();
        if (TextUtils.isEmpty(number)) {
            return address;
        }
        String[] numberParts = number.split("[@;:]");
        if (numberParts.length == 0) {
            return address;
        }
        number = numberParts[0];
        String formattedNumber = null;
        if (!TextUtils.isEmpty(countryIso)) {
            formattedNumber = PhoneNumberUtils.formatNumberToE164(number, countryIso);
        }
        return Uri.fromParts("tel", formattedNumber != null ? formattedNumber : number, null);
    }
}

