/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.app.Service;
import android.content.ComponentName;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.telecom.CallAudioState;
import android.telecom.Conference;
import android.telecom.Conferenceable;
import android.telecom.Connection;
import android.telecom.ConnectionRequest;
import android.telecom.ConnectionServiceAdapter;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.Logging.Runnable;
import android.telecom.Logging.Session;
import android.telecom.ParcelableConference;
import android.telecom.ParcelableConnection;
import android.telecom.PhoneAccountHandle;
import android.telecom.RemoteConference;
import android.telecom.RemoteConnection;
import android.telecom.RemoteConnectionManager;
import android.telecom.StatusHints;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IConnectionService;
import com.android.internal.telecom.IConnectionServiceAdapter;
import com.android.internal.telecom.RemoteServiceCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ConnectionService
extends Service {
    public static final String SERVICE_INTERFACE = "android.telecom.ConnectionService";
    public static final String EXTRA_IS_HANDOVER = "android.telecom.extra.IS_HANDOVER";
    private static final boolean PII_DEBUG = Log.isLoggable(3);
    private static final String SESSION_HANDLER = "H.";
    private static final String SESSION_ADD_CS_ADAPTER = "CS.aCSA";
    private static final String SESSION_REMOVE_CS_ADAPTER = "CS.rCSA";
    private static final String SESSION_CREATE_CONN = "CS.crCo";
    private static final String SESSION_CREATE_CONN_COMPLETE = "CS.crCoC";
    private static final String SESSION_CREATE_CONN_FAILED = "CS.crCoF";
    private static final String SESSION_ABORT = "CS.ab";
    private static final String SESSION_ANSWER = "CS.an";
    private static final String SESSION_ANSWER_VIDEO = "CS.anV";
    private static final String SESSION_DEFLECT = "CS.def";
    private static final String SESSION_REJECT = "CS.r";
    private static final String SESSION_REJECT_MESSAGE = "CS.rWM";
    private static final String SESSION_SILENCE = "CS.s";
    private static final String SESSION_DISCONNECT = "CS.d";
    private static final String SESSION_HOLD = "CS.h";
    private static final String SESSION_UNHOLD = "CS.u";
    private static final String SESSION_CALL_AUDIO_SC = "CS.cASC";
    private static final String SESSION_PLAY_DTMF = "CS.pDT";
    private static final String SESSION_STOP_DTMF = "CS.sDT";
    private static final String SESSION_CONFERENCE = "CS.c";
    private static final String SESSION_SPLIT_CONFERENCE = "CS.sFC";
    private static final String SESSION_MERGE_CONFERENCE = "CS.mC";
    private static final String SESSION_SWAP_CONFERENCE = "CS.sC";
    private static final String SESSION_POST_DIAL_CONT = "CS.oPDC";
    private static final String SESSION_PULL_EXTERNAL_CALL = "CS.pEC";
    private static final String SESSION_SEND_CALL_EVENT = "CS.sCE";
    private static final String SESSION_HANDOVER_COMPLETE = "CS.hC";
    private static final String SESSION_EXTRAS_CHANGED = "CS.oEC";
    private static final String SESSION_START_RTT = "CS.+RTT";
    private static final String SESSION_UPDATE_RTT_PIPES = "CS.uRTT";
    private static final String SESSION_STOP_RTT = "CS.-RTT";
    private static final String SESSION_RTT_UPGRADE_RESPONSE = "CS.rTRUR";
    private static final String SESSION_CONNECTION_SERVICE_FOCUS_LOST = "CS.cSFL";
    private static final String SESSION_CONNECTION_SERVICE_FOCUS_GAINED = "CS.cSFG";
    private static final String SESSION_HANDOVER_FAILED = "CS.haF";
    private static final int MSG_ADD_CONNECTION_SERVICE_ADAPTER = 1;
    private static final int MSG_CREATE_CONNECTION = 2;
    private static final int MSG_ABORT = 3;
    private static final int MSG_ANSWER = 4;
    private static final int MSG_REJECT = 5;
    private static final int MSG_DISCONNECT = 6;
    private static final int MSG_HOLD = 7;
    private static final int MSG_UNHOLD = 8;
    private static final int MSG_ON_CALL_AUDIO_STATE_CHANGED = 9;
    private static final int MSG_PLAY_DTMF_TONE = 10;
    private static final int MSG_STOP_DTMF_TONE = 11;
    private static final int MSG_CONFERENCE = 12;
    private static final int MSG_SPLIT_FROM_CONFERENCE = 13;
    private static final int MSG_ON_POST_DIAL_CONTINUE = 14;
    private static final int MSG_REMOVE_CONNECTION_SERVICE_ADAPTER = 16;
    private static final int MSG_ANSWER_VIDEO = 17;
    private static final int MSG_MERGE_CONFERENCE = 18;
    private static final int MSG_SWAP_CONFERENCE = 19;
    private static final int MSG_REJECT_WITH_MESSAGE = 20;
    private static final int MSG_SILENCE = 21;
    private static final int MSG_PULL_EXTERNAL_CALL = 22;
    private static final int MSG_SEND_CALL_EVENT = 23;
    private static final int MSG_ON_EXTRAS_CHANGED = 24;
    private static final int MSG_CREATE_CONNECTION_FAILED = 25;
    private static final int MSG_ON_START_RTT = 26;
    private static final int MSG_ON_STOP_RTT = 27;
    private static final int MSG_RTT_UPGRADE_RESPONSE = 28;
    private static final int MSG_CREATE_CONNECTION_COMPLETE = 29;
    private static final int MSG_CONNECTION_SERVICE_FOCUS_LOST = 30;
    private static final int MSG_CONNECTION_SERVICE_FOCUS_GAINED = 31;
    private static final int MSG_HANDOVER_FAILED = 32;
    private static final int MSG_HANDOVER_COMPLETE = 33;
    private static final int MSG_DEFLECT = 34;
    private static Connection sNullConnection;
    private final Map<String, Connection> mConnectionById = new ConcurrentHashMap<String, Connection>();
    private final Map<Connection, String> mIdByConnection = new ConcurrentHashMap<Connection, String>();
    private final Map<String, Conference> mConferenceById = new ConcurrentHashMap<String, Conference>();
    private final Map<Conference, String> mIdByConference = new ConcurrentHashMap<Conference, String>();
    private final RemoteConnectionManager mRemoteConnectionManager = new RemoteConnectionManager(this);
    private final List<java.lang.Runnable> mPreInitializationConnectionRequests = new ArrayList<java.lang.Runnable>();
    private final ConnectionServiceAdapter mAdapter = new ConnectionServiceAdapter();
    private boolean mAreAccountsInitialized = false;
    private Conference sNullConference;
    private Object mIdSyncRoot = new Object();
    private int mId = 0;
    private final IBinder mBinder = new IConnectionService.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addConnectionServiceAdapter(IConnectionServiceAdapter adapter, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_ADD_CS_ADAPTER);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = adapter;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(1, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeConnectionServiceAdapter(IConnectionServiceAdapter adapter, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_REMOVE_CS_ADAPTER);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = adapter;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(16, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void createConnection(PhoneAccountHandle connectionManagerPhoneAccount, String id2, ConnectionRequest request, boolean isIncoming, boolean isUnknown, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_CREATE_CONN);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = connectionManagerPhoneAccount;
                args.arg2 = id2;
                args.arg3 = request;
                args.arg4 = Log.createSubsession();
                args.argi1 = isIncoming ? 1 : 0;
                args.argi2 = isUnknown ? 1 : 0;
                ConnectionService.this.mHandler.obtainMessage(2, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void createConnectionComplete(String id2, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_CREATE_CONN_COMPLETE);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = id2;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(29, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void createConnectionFailed(PhoneAccountHandle connectionManagerPhoneAccount, String callId, ConnectionRequest request, boolean isIncoming, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_CREATE_CONN_FAILED);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = request;
                args.arg3 = Log.createSubsession();
                args.arg4 = connectionManagerPhoneAccount;
                args.argi1 = isIncoming ? 1 : 0;
                ConnectionService.this.mHandler.obtainMessage(25, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handoverFailed(String callId, ConnectionRequest request, int reason, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_HANDOVER_FAILED);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = request;
                args.arg3 = Log.createSubsession();
                args.arg4 = reason;
                ConnectionService.this.mHandler.obtainMessage(32, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handoverComplete(String callId, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_HANDOVER_COMPLETE);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(33, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abort(String callId, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_ABORT);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(3, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void answerVideo(String callId, int videoState, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_ANSWER_VIDEO);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                args.argi1 = videoState;
                ConnectionService.this.mHandler.obtainMessage(17, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void answer(String callId, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_ANSWER);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(4, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deflect(String callId, Uri address, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_DEFLECT);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = address;
                args.arg3 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(34, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reject(String callId, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_REJECT);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(5, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rejectWithMessage(String callId, String message, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_REJECT_MESSAGE);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = message;
                args.arg3 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(20, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void silence(String callId, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_SILENCE);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(21, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disconnect(String callId, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_DISCONNECT);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(6, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hold(String callId, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_HOLD);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(7, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unhold(String callId, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_UNHOLD);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(8, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCallAudioStateChanged(String callId, CallAudioState callAudioState, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_CALL_AUDIO_SC);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = callAudioState;
                args.arg3 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(9, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void playDtmfTone(String callId, char digit, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_PLAY_DTMF);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = Character.valueOf(digit);
                args.arg2 = callId;
                args.arg3 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(10, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopDtmfTone(String callId, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_STOP_DTMF);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(11, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void conference(String callId1, String callId2, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_CONFERENCE);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId1;
                args.arg2 = callId2;
                args.arg3 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(12, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void splitFromConference(String callId, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_SPLIT_CONFERENCE);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(13, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mergeConference(String callId, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_MERGE_CONFERENCE);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(18, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void swapConference(String callId, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_SWAP_CONFERENCE);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(19, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPostDialContinue(String callId, boolean proceed, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_POST_DIAL_CONT);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                args.argi1 = proceed ? 1 : 0;
                ConnectionService.this.mHandler.obtainMessage(14, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pullExternalCall(String callId, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_PULL_EXTERNAL_CALL);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(22, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendCallEvent(String callId, String event, Bundle extras, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_SEND_CALL_EVENT);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = event;
                args.arg3 = extras;
                args.arg4 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(23, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onExtrasChanged(String callId, Bundle extras, Session.Info sessionInfo) {
            Log.startSession(sessionInfo, ConnectionService.SESSION_EXTRAS_CHANGED);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = extras;
                args.arg3 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(24, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startRtt(String callId, ParcelFileDescriptor fromInCall, ParcelFileDescriptor toInCall, Session.Info sessionInfo) throws RemoteException {
            Log.startSession(sessionInfo, ConnectionService.SESSION_START_RTT);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = new Connection.RttTextStream(toInCall, fromInCall);
                args.arg3 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(26, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopRtt(String callId, Session.Info sessionInfo) throws RemoteException {
            Log.startSession(sessionInfo, ConnectionService.SESSION_STOP_RTT);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(27, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void respondToRttUpgradeRequest(String callId, ParcelFileDescriptor fromInCall, ParcelFileDescriptor toInCall, Session.Info sessionInfo) throws RemoteException {
            Log.startSession(sessionInfo, ConnectionService.SESSION_RTT_UPGRADE_RESPONSE);
            try {
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = callId;
                args.arg2 = toInCall == null || fromInCall == null ? null : new Connection.RttTextStream(toInCall, fromInCall);
                args.arg3 = Log.createSubsession();
                ConnectionService.this.mHandler.obtainMessage(28, args).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        @Override
        public void connectionServiceFocusLost(Session.Info sessionInfo) throws RemoteException {
            Log.startSession(sessionInfo, ConnectionService.SESSION_CONNECTION_SERVICE_FOCUS_LOST);
            try {
                ConnectionService.this.mHandler.obtainMessage(30).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }

        @Override
        public void connectionServiceFocusGained(Session.Info sessionInfo) throws RemoteException {
            Log.startSession(sessionInfo, ConnectionService.SESSION_CONNECTION_SERVICE_FOCUS_GAINED);
            try {
                ConnectionService.this.mHandler.obtainMessage(31).sendToTarget();
            }
            finally {
                Log.endSession();
            }
        }
    };
    private final Handler mHandler = new Handler(Looper.getMainLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        IConnectionServiceAdapter adapter = (IConnectionServiceAdapter)args.arg1;
                        Log.continueSession((Session)args.arg2, "H.CS.aCSA");
                        ConnectionService.this.mAdapter.addAdapter(adapter);
                        ConnectionService.this.onAdapterAttached();
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 16: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg2, "H.CS.rCSA");
                        ConnectionService.this.mAdapter.removeAdapter((IConnectionServiceAdapter)args.arg1);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg4, "H.CS.crCo");
                    try {
                        boolean isUnknown;
                        final PhoneAccountHandle connectionManagerPhoneAccount = (PhoneAccountHandle)args.arg1;
                        final String id2 = (String)args.arg2;
                        final ConnectionRequest request = (ConnectionRequest)args.arg3;
                        final boolean isIncoming = args.argi1 == 1;
                        boolean bl = isUnknown = args.argi2 == 1;
                        if (!ConnectionService.this.mAreAccountsInitialized) {
                            Log.d(this, "Enqueueing pre-init request %s", id2);
                            ConnectionService.this.mPreInitializationConnectionRequests.add(new Runnable("H.CS.crCo.pICR", null){

                                @Override
                                public void loggedRun() {
                                    ConnectionService.this.createConnection(connectionManagerPhoneAccount, id2, request, isIncoming, isUnknown);
                                }
                            }.prepare());
                            break;
                        }
                        ConnectionService.this.createConnection(connectionManagerPhoneAccount, id2, request, isIncoming, isUnknown);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 29: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg2, "H.CS.crCoC");
                    try {
                        final String id3 = (String)args.arg1;
                        if (!ConnectionService.this.mAreAccountsInitialized) {
                            Log.d(this, "Enqueueing pre-init request %s", id3);
                            ConnectionService.this.mPreInitializationConnectionRequests.add(new Runnable("H.CS.crCoC.pICR", null){

                                @Override
                                public void loggedRun() {
                                    ConnectionService.this.notifyCreateConnectionComplete(id3);
                                }
                            }.prepare());
                            break;
                        }
                        ConnectionService.this.notifyCreateConnectionComplete(id3);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 25: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg3, "H.CS.crCoF");
                    try {
                        final String id4 = (String)args.arg1;
                        final ConnectionRequest request = (ConnectionRequest)args.arg2;
                        final boolean isIncoming = args.argi1 == 1;
                        final PhoneAccountHandle connectionMgrPhoneAccount = (PhoneAccountHandle)args.arg4;
                        if (!ConnectionService.this.mAreAccountsInitialized) {
                            Log.d(this, "Enqueueing pre-init request %s", id4);
                            ConnectionService.this.mPreInitializationConnectionRequests.add(new Runnable("H.CS.crCoF.pICR", null){

                                @Override
                                public void loggedRun() {
                                    ConnectionService.this.createConnectionFailed(connectionMgrPhoneAccount, id4, request, isIncoming);
                                }
                            }.prepare());
                            break;
                        }
                        Log.i(this, "createConnectionFailed %s", id4);
                        ConnectionService.this.createConnectionFailed(connectionMgrPhoneAccount, id4, request, isIncoming);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 32: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg3, "H.CS.haF");
                    try {
                        final String id5 = (String)args.arg1;
                        final ConnectionRequest request = (ConnectionRequest)args.arg2;
                        final int reason = (Integer)args.arg4;
                        if (!ConnectionService.this.mAreAccountsInitialized) {
                            Log.d(this, "Enqueueing pre-init request %s", id5);
                            ConnectionService.this.mPreInitializationConnectionRequests.add(new Runnable("H.CS.haF.pICR", null){

                                @Override
                                public void loggedRun() {
                                    ConnectionService.this.handoverFailed(id5, request, reason);
                                }
                            }.prepare());
                            break;
                        }
                        Log.i(this, "createConnectionFailed %s", id5);
                        ConnectionService.this.handoverFailed(id5, request, reason);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 3: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg2, "H.CS.ab");
                    try {
                        ConnectionService.this.abort((String)args.arg1);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg2, "H.CS.an");
                    try {
                        ConnectionService.this.answer((String)args.arg1);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 17: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg2, "H.CS.anV");
                    try {
                        String callId = (String)args.arg1;
                        int videoState = args.argi1;
                        ConnectionService.this.answerVideo(callId, videoState);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 34: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg3, "H.CS.def");
                    try {
                        ConnectionService.this.deflect((String)args.arg1, (Uri)args.arg2);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 5: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg2, "H.CS.r");
                    try {
                        ConnectionService.this.reject((String)args.arg1);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 20: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg3, "H.CS.rWM");
                    try {
                        ConnectionService.this.reject((String)args.arg1, (String)args.arg2);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 6: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg2, "H.CS.d");
                    try {
                        ConnectionService.this.disconnect((String)args.arg1);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 21: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg2, "H.CS.s");
                    try {
                        ConnectionService.this.silence((String)args.arg1);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 7: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg2, "H.CS.r");
                    try {
                        ConnectionService.this.hold((String)args.arg1);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 8: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg2, "H.CS.u");
                    try {
                        ConnectionService.this.unhold((String)args.arg1);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 9: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    Log.continueSession((Session)args.arg3, "H.CS.cASC");
                    try {
                        String callId = (String)args.arg1;
                        CallAudioState audioState = (CallAudioState)args.arg2;
                        ConnectionService.this.onCallAudioStateChanged(callId, new CallAudioState(audioState));
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 10: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg3, "H.CS.pDT");
                        ConnectionService.this.playDtmfTone((String)args.arg2, ((Character)args.arg1).charValue());
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 11: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg2, "H.CS.sDT");
                        ConnectionService.this.stopDtmfTone((String)args.arg1);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 12: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg3, "H.CS.c");
                        String callId1 = (String)args.arg1;
                        String callId2 = (String)args.arg2;
                        ConnectionService.this.conference(callId1, callId2);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 13: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg2, "H.CS.sFC");
                        ConnectionService.this.splitFromConference((String)args.arg1);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 18: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg2, "H.CS.mC");
                        ConnectionService.this.mergeConference((String)args.arg1);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 19: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg2, "H.CS.sC");
                        ConnectionService.this.swapConference((String)args.arg1);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 14: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg2, "H.CS.oPDC");
                        String callId = (String)args.arg1;
                        boolean proceed = args.argi1 == 1;
                        ConnectionService.this.onPostDialContinue(callId, proceed);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 22: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg2, "H.CS.pEC");
                        ConnectionService.this.pullExternalCall((String)args.arg1);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 23: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg4, "H.CS.sCE");
                        String callId = (String)args.arg1;
                        String event = (String)args.arg2;
                        Bundle extras = (Bundle)args.arg3;
                        ConnectionService.this.sendCallEvent(callId, event, extras);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 33: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg2, "H.CS.hC");
                        String callId = (String)args.arg1;
                        ConnectionService.this.notifyHandoverComplete(callId);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 24: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg3, "H.CS.oEC");
                        String callId = (String)args.arg1;
                        Bundle extras = (Bundle)args.arg2;
                        ConnectionService.this.handleExtrasChanged(callId, extras);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 26: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg3, "H.CS.+RTT");
                        String callId = (String)args.arg1;
                        Connection.RttTextStream rttTextStream = (Connection.RttTextStream)args.arg2;
                        ConnectionService.this.startRtt(callId, rttTextStream);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 27: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg2, "H.CS.-RTT");
                        String callId = (String)args.arg1;
                        ConnectionService.this.stopRtt(callId);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 28: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        Log.continueSession((Session)args.arg3, "H.CS.rTRUR");
                        String callId = (String)args.arg1;
                        Connection.RttTextStream rttTextStream = (Connection.RttTextStream)args.arg2;
                        ConnectionService.this.handleRttUpgradeResponse(callId, rttTextStream);
                        break;
                    }
                    finally {
                        args.recycle();
                        Log.endSession();
                    }
                }
                case 31: {
                    ConnectionService.this.onConnectionServiceFocusGained();
                    break;
                }
                case 30: {
                    ConnectionService.this.onConnectionServiceFocusLost();
                    break;
                }
            }
        }
    };
    private final Conference.Listener mConferenceListener = new Conference.Listener(){

        @Override
        public void onStateChanged(Conference conference, int oldState, int newState) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(conference);
            switch (newState) {
                case 4: {
                    ConnectionService.this.mAdapter.setActive(id2);
                    break;
                }
                case 5: {
                    ConnectionService.this.mAdapter.setOnHold(id2);
                    break;
                }
            }
        }

        @Override
        public void onDisconnected(Conference conference, DisconnectCause disconnectCause) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(conference);
            ConnectionService.this.mAdapter.setDisconnected(id2, disconnectCause);
        }

        @Override
        public void onConnectionAdded(Conference conference, Connection connection) {
        }

        @Override
        public void onConnectionRemoved(Conference conference, Connection connection) {
        }

        @Override
        public void onConferenceableConnectionsChanged(Conference conference, List<Connection> conferenceableConnections) {
            ConnectionService.this.mAdapter.setConferenceableConnections((String)ConnectionService.this.mIdByConference.get(conference), ConnectionService.this.createConnectionIdList(conferenceableConnections));
        }

        @Override
        public void onDestroyed(Conference conference) {
            ConnectionService.this.removeConference(conference);
        }

        @Override
        public void onConnectionCapabilitiesChanged(Conference conference, int connectionCapabilities) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(conference);
            Log.d(this, "call capabilities: conference: %s", Connection.capabilitiesToString(connectionCapabilities));
            ConnectionService.this.mAdapter.setConnectionCapabilities(id2, connectionCapabilities);
        }

        @Override
        public void onConnectionPropertiesChanged(Conference conference, int connectionProperties) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(conference);
            Log.d(this, "call capabilities: conference: %s", Connection.propertiesToString(connectionProperties));
            ConnectionService.this.mAdapter.setConnectionProperties(id2, connectionProperties);
        }

        @Override
        public void onVideoStateChanged(Conference c, int videoState) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(c);
            Log.d(this, "onVideoStateChanged set video state %d", videoState);
            ConnectionService.this.mAdapter.setVideoState(id2, videoState);
        }

        @Override
        public void onVideoProviderChanged(Conference c, Connection.VideoProvider videoProvider) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(c);
            Log.d(this, "onVideoProviderChanged: Connection: %s, VideoProvider: %s", c, videoProvider);
            ConnectionService.this.mAdapter.setVideoProvider(id2, videoProvider);
        }

        @Override
        public void onStatusHintsChanged(Conference conference, StatusHints statusHints) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(conference);
            if (id2 != null) {
                ConnectionService.this.mAdapter.setStatusHints(id2, statusHints);
            }
        }

        @Override
        public void onExtrasChanged(Conference c, Bundle extras) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.putExtras(id2, extras);
            }
        }

        @Override
        public void onExtrasRemoved(Conference c, List<String> keys) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.removeExtras(id2, keys);
            }
        }

        @Override
        public void onConferenceStateChanged(Conference c, boolean isConference) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.setConferenceState(id2, isConference);
            }
        }

        @Override
        public void onAddressChanged(Conference c, Uri newAddress, int presentation) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.setAddress(id2, newAddress, presentation);
            }
        }

        @Override
        public void onCallerDisplayNameChanged(Conference c, String callerDisplayName, int presentation) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.setCallerDisplayName(id2, callerDisplayName, presentation);
            }
        }

        @Override
        public void onConnectionEvent(Conference c, String event, Bundle extras) {
            String id2 = (String)ConnectionService.this.mIdByConference.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.onConnectionEvent(id2, event, extras);
            }
        }
    };
    private final Connection.Listener mConnectionListener = new Connection.Listener(){

        @Override
        public void onStateChanged(Connection c, int state) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "Adapter set state %s %s", id2, Connection.stateToString(state));
            switch (state) {
                case 4: {
                    ConnectionService.this.mAdapter.setActive(id2);
                    break;
                }
                case 3: {
                    ConnectionService.this.mAdapter.setDialing(id2);
                    break;
                }
                case 7: {
                    ConnectionService.this.mAdapter.setPulling(id2);
                    break;
                }
                case 6: {
                    break;
                }
                case 5: {
                    ConnectionService.this.mAdapter.setOnHold(id2);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    ConnectionService.this.mAdapter.setRinging(id2);
                }
            }
        }

        @Override
        public void onDisconnected(Connection c, DisconnectCause disconnectCause) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "Adapter set disconnected %s", disconnectCause);
            ConnectionService.this.mAdapter.setDisconnected(id2, disconnectCause);
        }

        @Override
        public void onVideoStateChanged(Connection c, int videoState) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "Adapter set video state %d", videoState);
            ConnectionService.this.mAdapter.setVideoState(id2, videoState);
        }

        @Override
        public void onAddressChanged(Connection c, Uri address, int presentation) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            ConnectionService.this.mAdapter.setAddress(id2, address, presentation);
        }

        @Override
        public void onCallerDisplayNameChanged(Connection c, String callerDisplayName, int presentation) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            ConnectionService.this.mAdapter.setCallerDisplayName(id2, callerDisplayName, presentation);
        }

        @Override
        public void onDestroyed(Connection c) {
            ConnectionService.this.removeConnection(c);
        }

        @Override
        public void onPostDialWait(Connection c, String remaining) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "Adapter onPostDialWait %s, %s", c, remaining);
            ConnectionService.this.mAdapter.onPostDialWait(id2, remaining);
        }

        @Override
        public void onPostDialChar(Connection c, char nextChar) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "Adapter onPostDialChar %s, %s", c, Character.valueOf(nextChar));
            ConnectionService.this.mAdapter.onPostDialChar(id2, nextChar);
        }

        @Override
        public void onRingbackRequested(Connection c, boolean ringback) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "Adapter onRingback %b", ringback);
            ConnectionService.this.mAdapter.setRingbackRequested(id2, ringback);
        }

        @Override
        public void onConnectionCapabilitiesChanged(Connection c, int capabilities) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "capabilities: parcelableconnection: %s", Connection.capabilitiesToString(capabilities));
            ConnectionService.this.mAdapter.setConnectionCapabilities(id2, capabilities);
        }

        @Override
        public void onConnectionPropertiesChanged(Connection c, int properties) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "properties: parcelableconnection: %s", Connection.propertiesToString(properties));
            ConnectionService.this.mAdapter.setConnectionProperties(id2, properties);
        }

        @Override
        public void onVideoProviderChanged(Connection c, Connection.VideoProvider videoProvider) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            Log.d(this, "onVideoProviderChanged: Connection: %s, VideoProvider: %s", c, videoProvider);
            ConnectionService.this.mAdapter.setVideoProvider(id2, videoProvider);
        }

        @Override
        public void onAudioModeIsVoipChanged(Connection c, boolean isVoip) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            ConnectionService.this.mAdapter.setIsVoipAudioMode(id2, isVoip);
        }

        @Override
        public void onStatusHintsChanged(Connection c, StatusHints statusHints) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            ConnectionService.this.mAdapter.setStatusHints(id2, statusHints);
        }

        @Override
        public void onConferenceablesChanged(Connection connection, List<Conferenceable> conferenceables) {
            ConnectionService.this.mAdapter.setConferenceableConnections((String)ConnectionService.this.mIdByConnection.get(connection), ConnectionService.this.createIdList(conferenceables));
        }

        @Override
        public void onConferenceChanged(Connection connection, Conference conference) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(connection);
            if (id2 != null) {
                String conferenceId = null;
                if (conference != null) {
                    conferenceId = (String)ConnectionService.this.mIdByConference.get(conference);
                }
                ConnectionService.this.mAdapter.setIsConferenced(id2, conferenceId);
            }
        }

        @Override
        public void onConferenceMergeFailed(Connection connection) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(connection);
            if (id2 != null) {
                ConnectionService.this.mAdapter.onConferenceMergeFailed(id2);
            }
        }

        @Override
        public void onExtrasChanged(Connection c, Bundle extras) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.putExtras(id2, extras);
            }
        }

        @Override
        public void onExtrasRemoved(Connection c, List<String> keys) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.removeExtras(id2, keys);
            }
        }

        @Override
        public void onConnectionEvent(Connection connection, String event, Bundle extras) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(connection);
            if (id2 != null) {
                ConnectionService.this.mAdapter.onConnectionEvent(id2, event, extras);
            }
        }

        @Override
        public void onAudioRouteChanged(Connection c, int audioRoute, String bluetoothAddress) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.setAudioRoute(id2, audioRoute, bluetoothAddress);
            }
        }

        @Override
        public void onRttInitiationSuccess(Connection c) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.onRttInitiationSuccess(id2);
            }
        }

        @Override
        public void onRttInitiationFailure(Connection c, int reason) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.onRttInitiationFailure(id2, reason);
            }
        }

        @Override
        public void onRttSessionRemotelyTerminated(Connection c) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.onRttSessionRemotelyTerminated(id2);
            }
        }

        @Override
        public void onRemoteRttRequest(Connection c) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.onRemoteRttRequest(id2);
            }
        }

        @Override
        public void onPhoneAccountChanged(Connection c, PhoneAccountHandle pHandle) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.onPhoneAccountChanged(id2, pHandle);
            }
        }

        @Override
        public void onConnectionTimeReset(Connection c) {
            String id2 = (String)ConnectionService.this.mIdByConnection.get(c);
            if (id2 != null) {
                ConnectionService.this.mAdapter.resetConnectionTime(id2);
            }
        }
    };

    @Override
    public final IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    @Override
    public boolean onUnbind(Intent intent) {
        this.endAllConnections();
        return super.onUnbind(intent);
    }

    private void createConnection(PhoneAccountHandle callManagerAccount, String callId, ConnectionRequest request, boolean isIncoming, boolean isUnknown) {
        Uri address;
        boolean isSelfManaged;
        boolean isLegacyHandover = request.getExtras() != null && request.getExtras().getBoolean(EXTRA_IS_HANDOVER, false);
        boolean isHandover = request.getExtras() != null && request.getExtras().getBoolean("android.telecom.extra.IS_HANDOVER_CONNECTION", false);
        Log.d(this, "createConnection, callManagerAccount: %s, callId: %s, request: %s, isIncoming: %b, isUnknown: %b, isLegacyHandover: %b, isHandover: %b", callManagerAccount, callId, request, isIncoming, isUnknown, isLegacyHandover, isHandover);
        Connection connection = null;
        if (isHandover) {
            PhoneAccountHandle fromPhoneAccountHandle;
            PhoneAccountHandle phoneAccountHandle = fromPhoneAccountHandle = request.getExtras() != null ? (PhoneAccountHandle)request.getExtras().getParcelable("android.telecom.extra.HANDOVER_FROM_PHONE_ACCOUNT") : null;
            connection = !isIncoming ? this.onCreateOutgoingHandoverConnection(fromPhoneAccountHandle, request) : this.onCreateIncomingHandoverConnection(fromPhoneAccountHandle, request);
        } else {
            connection = isUnknown ? this.onCreateUnknownConnection(callManagerAccount, request) : (isIncoming ? this.onCreateIncomingConnection(callManagerAccount, request) : this.onCreateOutgoingConnection(callManagerAccount, request));
        }
        Log.d(this, "createConnection, connection: %s", connection);
        if (connection == null) {
            Log.i(this, "createConnection, implementation returned null connection.", new Object[0]);
            connection = Connection.createFailedConnection(new DisconnectCause(1, "IMPL_RETURNED_NULL_CONNECTION"));
        }
        boolean bl = isSelfManaged = (connection.getConnectionProperties() & 0x80) == 128;
        if (isSelfManaged) {
            connection.setAudioModeIsVoip(true);
        }
        connection.setTelecomCallId(callId);
        if (connection.getState() != 6) {
            this.addConnection(request.getAccountHandle(), callId, connection);
        }
        String number = (address = connection.getAddress()) == null ? "null" : address.getSchemeSpecificPart();
        Log.v(this, "createConnection, number: %s, state: %s, capabilities: %s, properties: %s", Connection.toLogSafePhoneNumber(number), Connection.stateToString(connection.getState()), Connection.capabilitiesToString(connection.getConnectionCapabilities()), Connection.propertiesToString(connection.getConnectionProperties()));
        Log.d(this, "createConnection, calling handleCreateConnectionSuccessful %s", callId);
        this.mAdapter.handleCreateConnectionComplete(callId, request, new ParcelableConnection(request.getAccountHandle(), connection.getState(), connection.getConnectionCapabilities(), connection.getConnectionProperties(), connection.getSupportedAudioRoutes(), connection.getAddress(), connection.getAddressPresentation(), connection.getCallerDisplayName(), connection.getCallerDisplayNamePresentation(), connection.getVideoProvider() == null ? null : connection.getVideoProvider().getInterface(), connection.getVideoState(), connection.isRingbackRequested(), connection.getAudioModeIsVoip(), connection.getConnectTimeMillis(), connection.getConnectElapsedTimeMillis(), connection.getStatusHints(), connection.getDisconnectCause(), this.createIdList(connection.getConferenceables()), connection.getExtras()));
        if (isIncoming && request.shouldShowIncomingCallUi() && isSelfManaged) {
            connection.onShowIncomingCallUi();
        }
        if (isUnknown) {
            this.triggerConferenceRecalculate();
        }
    }

    private void createConnectionFailed(PhoneAccountHandle callManagerAccount, String callId, ConnectionRequest request, boolean isIncoming) {
        Log.i(this, "createConnectionFailed %s", callId);
        if (isIncoming) {
            this.onCreateIncomingConnectionFailed(callManagerAccount, request);
        } else {
            this.onCreateOutgoingConnectionFailed(callManagerAccount, request);
        }
    }

    private void handoverFailed(String callId, ConnectionRequest request, int reason) {
        Log.i(this, "handoverFailed %s", callId);
        this.onHandoverFailed(request, reason);
    }

    private void notifyCreateConnectionComplete(String callId) {
        Log.i(this, "notifyCreateConnectionComplete %s", callId);
        if (callId == null) {
            Log.w(this, "notifyCreateConnectionComplete: callId is null.", new Object[0]);
            return;
        }
        this.onCreateConnectionComplete(this.findConnectionForAction(callId, "notifyCreateConnectionComplete"));
    }

    private void abort(String callId) {
        Log.d(this, "abort %s", callId);
        this.findConnectionForAction(callId, "abort").onAbort();
    }

    private void answerVideo(String callId, int videoState) {
        Log.d(this, "answerVideo %s", callId);
        this.findConnectionForAction(callId, "answer").onAnswer(videoState);
    }

    private void answer(String callId) {
        Log.d(this, "answer %s", callId);
        this.findConnectionForAction(callId, "answer").onAnswer();
    }

    private void deflect(String callId, Uri address) {
        Log.d(this, "deflect %s", callId);
        this.findConnectionForAction(callId, "deflect").onDeflect(address);
    }

    private void reject(String callId) {
        Log.d(this, "reject %s", callId);
        this.findConnectionForAction(callId, "reject").onReject();
    }

    private void reject(String callId, String rejectWithMessage) {
        Log.d(this, "reject %s with message", callId);
        this.findConnectionForAction(callId, "reject").onReject(rejectWithMessage);
    }

    private void silence(String callId) {
        Log.d(this, "silence %s", callId);
        this.findConnectionForAction(callId, "silence").onSilence();
    }

    private void disconnect(String callId) {
        Log.d(this, "disconnect %s", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "disconnect").onDisconnect();
        } else {
            this.findConferenceForAction(callId, "disconnect").onDisconnect();
        }
    }

    private void hold(String callId) {
        Log.d(this, "hold %s", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "hold").onHold();
        } else {
            this.findConferenceForAction(callId, "hold").onHold();
        }
    }

    private void unhold(String callId) {
        Log.d(this, "unhold %s", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "unhold").onUnhold();
        } else {
            this.findConferenceForAction(callId, "unhold").onUnhold();
        }
    }

    private void onCallAudioStateChanged(String callId, CallAudioState callAudioState) {
        Log.d(this, "onAudioStateChanged %s %s", callId, callAudioState);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "onCallAudioStateChanged").setCallAudioState(callAudioState);
        } else {
            this.findConferenceForAction(callId, "onCallAudioStateChanged").setCallAudioState(callAudioState);
        }
    }

    private void playDtmfTone(String callId, char digit) {
        Log.d(this, "playDtmfTone %s %c", callId, Character.valueOf(digit));
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "playDtmfTone").onPlayDtmfTone(digit);
        } else {
            this.findConferenceForAction(callId, "playDtmfTone").onPlayDtmfTone(digit);
        }
    }

    private void stopDtmfTone(String callId) {
        Log.d(this, "stopDtmfTone %s", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "stopDtmfTone").onStopDtmfTone();
        } else {
            this.findConferenceForAction(callId, "stopDtmfTone").onStopDtmfTone();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void conference(String callId1, String callId2) {
        Log.d(this, "conference %s, %s", callId1, callId2);
        Connection connection2 = this.findConnectionForAction(callId2, "conference");
        Conference conference2 = this.getNullConference();
        if (connection2 == ConnectionService.getNullConnection() && (conference2 = this.findConferenceForAction(callId2, "conference")) == this.getNullConference()) {
            Log.w(this, "Connection2 or Conference2 missing in conference request %s.", callId2);
            return;
        }
        Connection connection1 = this.findConnectionForAction(callId1, "conference");
        if (connection1 == ConnectionService.getNullConnection()) {
            Conference conference1 = this.findConferenceForAction(callId1, "addConnection");
            if (conference1 == this.getNullConference()) {
                Log.w(this, "Connection1 or Conference1 missing in conference request %s.", callId1);
                return;
            }
            if (connection2 != ConnectionService.getNullConnection()) {
                conference1.onMerge(connection2);
                return;
            }
            Log.wtf((Object)this, "There can only be one conference and an attempt was made to merge two conferences.", new Object[0]);
            return;
        }
        if (conference2 != this.getNullConference()) {
            conference2.onMerge(connection1);
            return;
        }
        this.onConference(connection1, connection2);
    }

    private void splitFromConference(String callId) {
        Log.d(this, "splitFromConference(%s)", callId);
        Connection connection = this.findConnectionForAction(callId, "splitFromConference");
        if (connection == ConnectionService.getNullConnection()) {
            Log.w(this, "Connection missing in conference request %s.", callId);
            return;
        }
        Conference conference = connection.getConference();
        if (conference != null) {
            conference.onSeparate(connection);
        }
    }

    private void mergeConference(String callId) {
        Log.d(this, "mergeConference(%s)", callId);
        Conference conference = this.findConferenceForAction(callId, "mergeConference");
        if (conference != null) {
            conference.onMerge();
        }
    }

    private void swapConference(String callId) {
        Log.d(this, "swapConference(%s)", callId);
        Conference conference = this.findConferenceForAction(callId, "swapConference");
        if (conference != null) {
            conference.onSwap();
        }
    }

    private void pullExternalCall(String callId) {
        Log.d(this, "pullExternalCall(%s)", callId);
        Connection connection = this.findConnectionForAction(callId, "pullExternalCall");
        if (connection != null) {
            connection.onPullExternalCall();
        }
    }

    private void sendCallEvent(String callId, String event, Bundle extras) {
        Log.d(this, "sendCallEvent(%s, %s)", callId, event);
        Connection connection = this.findConnectionForAction(callId, "sendCallEvent");
        if (connection != null) {
            connection.onCallEvent(event, extras);
        }
    }

    private void notifyHandoverComplete(String callId) {
        Log.d(this, "notifyHandoverComplete(%s)", callId);
        Connection connection = this.findConnectionForAction(callId, "notifyHandoverComplete");
        if (connection != null) {
            connection.onHandoverComplete();
        }
    }

    private void handleExtrasChanged(String callId, Bundle extras) {
        Log.d(this, "handleExtrasChanged(%s, %s)", callId, extras);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "handleExtrasChanged").handleExtrasChanged(extras);
        } else if (this.mConferenceById.containsKey(callId)) {
            this.findConferenceForAction(callId, "handleExtrasChanged").handleExtrasChanged(extras);
        }
    }

    private void startRtt(String callId, Connection.RttTextStream rttTextStream) {
        Log.d(this, "startRtt(%s)", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "startRtt").onStartRtt(rttTextStream);
        } else if (this.mConferenceById.containsKey(callId)) {
            Log.w(this, "startRtt called on a conference.", new Object[0]);
        }
    }

    private void stopRtt(String callId) {
        Log.d(this, "stopRtt(%s)", callId);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "stopRtt").onStopRtt();
        } else if (this.mConferenceById.containsKey(callId)) {
            Log.w(this, "stopRtt called on a conference.", new Object[0]);
        }
    }

    private void handleRttUpgradeResponse(String callId, Connection.RttTextStream rttTextStream) {
        Log.d(this, "handleRttUpgradeResponse(%s, %s)", callId, rttTextStream == null);
        if (this.mConnectionById.containsKey(callId)) {
            this.findConnectionForAction(callId, "handleRttUpgradeResponse").handleRttUpgradeResponse(rttTextStream);
        } else if (this.mConferenceById.containsKey(callId)) {
            Log.w(this, "handleRttUpgradeResponse called on a conference.", new Object[0]);
        }
    }

    private void onPostDialContinue(String callId, boolean proceed) {
        Log.d(this, "onPostDialContinue(%s)", callId);
        this.findConnectionForAction(callId, "stopDtmfTone").onPostDialContinue(proceed);
    }

    private void onAdapterAttached() {
        if (this.mAreAccountsInitialized) {
            return;
        }
        String callingPackage = this.getOpPackageName();
        this.mAdapter.queryRemoteConnectionServices(new RemoteServiceCallback.Stub(){

            @Override
            public void onResult(final List<ComponentName> componentNames, final List<IBinder> services) {
                ConnectionService.this.mHandler.post(new Runnable("oAA.qRCS.oR", null){

                    @Override
                    public void loggedRun() {
                        for (int i = 0; i < componentNames.size() && i < services.size(); ++i) {
                            ConnectionService.this.mRemoteConnectionManager.addConnectionService((ComponentName)componentNames.get(i), IConnectionService.Stub.asInterface((IBinder)services.get(i)));
                        }
                        ConnectionService.this.onAccountsInitialized();
                        Log.d(this, "remote connection services found: " + services, new Object[0]);
                    }
                }.prepare());
            }

            @Override
            public void onError() {
                ConnectionService.this.mHandler.post(new Runnable("oAA.qRCS.oE", null){

                    @Override
                    public void loggedRun() {
                        ConnectionService.this.mAreAccountsInitialized = true;
                    }
                }.prepare());
            }
        }, callingPackage);
    }

    public final RemoteConnection createRemoteIncomingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return this.mRemoteConnectionManager.createRemoteConnection(connectionManagerPhoneAccount, request, true);
    }

    public final RemoteConnection createRemoteOutgoingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return this.mRemoteConnectionManager.createRemoteConnection(connectionManagerPhoneAccount, request, false);
    }

    public final void conferenceRemoteConnections(RemoteConnection remoteConnection1, RemoteConnection remoteConnection2) {
        this.mRemoteConnectionManager.conferenceRemoteConnections(remoteConnection1, remoteConnection2);
    }

    public final void addConference(Conference conference) {
        Log.d(this, "addConference: conference=%s", conference);
        String id2 = this.addConferenceInternal(conference);
        if (id2 != null) {
            ArrayList<String> connectionIds = new ArrayList<String>(2);
            for (Connection connection : conference.getConnections()) {
                if (!this.mIdByConnection.containsKey(connection)) continue;
                connectionIds.add(this.mIdByConnection.get(connection));
            }
            conference.setTelecomCallId(id2);
            ParcelableConference parcelableConference = new ParcelableConference(conference.getPhoneAccountHandle(), conference.getState(), conference.getConnectionCapabilities(), conference.getConnectionProperties(), connectionIds, conference.getVideoProvider() == null ? null : conference.getVideoProvider().getInterface(), conference.getVideoState(), conference.getConnectTimeMillis(), conference.getConnectionStartElapsedRealTime(), conference.getStatusHints(), conference.getExtras(), conference.getAddress(), conference.getAddressPresentation(), conference.getCallerDisplayName(), conference.getCallerDisplayNamePresentation());
            this.mAdapter.addConferenceCall(id2, parcelableConference);
            this.mAdapter.setVideoProvider(id2, conference.getVideoProvider());
            this.mAdapter.setVideoState(id2, conference.getVideoState());
            for (Connection connection : conference.getConnections()) {
                String connectionId = this.mIdByConnection.get(connection);
                if (connectionId == null) continue;
                this.mAdapter.setIsConferenced(connectionId, id2);
            }
            this.onConferenceAdded(conference);
        }
    }

    public final void addExistingConnection(PhoneAccountHandle phoneAccountHandle, Connection connection) {
        this.addExistingConnection(phoneAccountHandle, connection, null);
    }

    public final void connectionServiceFocusReleased() {
        this.mAdapter.onConnectionServiceFocusReleased();
    }

    public final void addExistingConnection(PhoneAccountHandle phoneAccountHandle, Connection connection, Conference conference) {
        String id2 = this.addExistingConnectionInternal(phoneAccountHandle, connection);
        if (id2 != null) {
            ArrayList<String> emptyList = new ArrayList<String>(0);
            String conferenceId = null;
            if (conference != null) {
                conferenceId = this.mIdByConference.get(conference);
            }
            ParcelableConnection parcelableConnection = new ParcelableConnection(phoneAccountHandle, connection.getState(), connection.getConnectionCapabilities(), connection.getConnectionProperties(), connection.getSupportedAudioRoutes(), connection.getAddress(), connection.getAddressPresentation(), connection.getCallerDisplayName(), connection.getCallerDisplayNamePresentation(), connection.getVideoProvider() == null ? null : connection.getVideoProvider().getInterface(), connection.getVideoState(), connection.isRingbackRequested(), connection.getAudioModeIsVoip(), connection.getConnectTimeMillis(), connection.getConnectElapsedTimeMillis(), connection.getStatusHints(), connection.getDisconnectCause(), emptyList, connection.getExtras(), conferenceId, connection.getCallDirection());
            this.mAdapter.addExistingConnection(id2, parcelableConnection);
        }
    }

    public final Collection<Connection> getAllConnections() {
        return this.mConnectionById.values();
    }

    public final Collection<Conference> getAllConferences() {
        return this.mConferenceById.values();
    }

    public Connection onCreateIncomingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return null;
    }

    public void onCreateConnectionComplete(Connection connection) {
    }

    public void onCreateIncomingConnectionFailed(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
    }

    public void onCreateOutgoingConnectionFailed(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
    }

    public void triggerConferenceRecalculate() {
    }

    public Connection onCreateOutgoingConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return null;
    }

    public Connection onCreateOutgoingHandoverConnection(PhoneAccountHandle fromPhoneAccountHandle, ConnectionRequest request) {
        return null;
    }

    public Connection onCreateIncomingHandoverConnection(PhoneAccountHandle fromPhoneAccountHandle, ConnectionRequest request) {
        return null;
    }

    public void onHandoverFailed(ConnectionRequest request, int error) {
    }

    public Connection onCreateUnknownConnection(PhoneAccountHandle connectionManagerPhoneAccount, ConnectionRequest request) {
        return null;
    }

    public void onConference(Connection connection1, Connection connection2) {
    }

    public void onConnectionAdded(Connection connection) {
    }

    public void onConnectionRemoved(Connection connection) {
    }

    public void onConferenceAdded(Conference conference) {
    }

    public void onConferenceRemoved(Conference conference) {
    }

    public void onRemoteConferenceAdded(RemoteConference conference) {
    }

    public void onRemoteExistingConnectionAdded(RemoteConnection connection) {
    }

    public void onConnectionServiceFocusLost() {
    }

    public void onConnectionServiceFocusGained() {
    }

    public boolean containsConference(Conference conference) {
        return this.mIdByConference.containsKey(conference);
    }

    void addRemoteConference(RemoteConference remoteConference) {
        this.onRemoteConferenceAdded(remoteConference);
    }

    void addRemoteExistingConnection(RemoteConnection remoteConnection) {
        this.onRemoteExistingConnectionAdded(remoteConnection);
    }

    private void onAccountsInitialized() {
        this.mAreAccountsInitialized = true;
        for (java.lang.Runnable r : this.mPreInitializationConnectionRequests) {
            r.run();
        }
        this.mPreInitializationConnectionRequests.clear();
    }

    private String addExistingConnectionInternal(PhoneAccountHandle handle, Connection connection) {
        String id2;
        if (connection.getExtras() != null && connection.getExtras().containsKey("android.telecom.extra.ORIGINAL_CONNECTION_ID")) {
            id2 = connection.getExtras().getString("android.telecom.extra.ORIGINAL_CONNECTION_ID");
            Log.d(this, "addExistingConnectionInternal - conn %s reusing original id %s", connection.getTelecomCallId(), id2);
        } else {
            id2 = handle == null ? UUID.randomUUID().toString() : handle.getComponentName().getClassName() + "@" + this.getNextCallId();
        }
        this.addConnection(handle, id2, connection);
        return id2;
    }

    private void addConnection(PhoneAccountHandle handle, String callId, Connection connection) {
        connection.setTelecomCallId(callId);
        this.mConnectionById.put(callId, connection);
        this.mIdByConnection.put(connection, callId);
        connection.addConnectionListener(this.mConnectionListener);
        connection.setConnectionService(this);
        connection.setPhoneAccountHandle(handle);
        this.onConnectionAdded(connection);
    }

    protected void removeConnection(Connection connection) {
        connection.unsetConnectionService(this);
        connection.removeConnectionListener(this.mConnectionListener);
        String id2 = this.mIdByConnection.get(connection);
        if (id2 != null) {
            this.mConnectionById.remove(id2);
            this.mIdByConnection.remove(connection);
            this.mAdapter.removeCall(id2);
            this.onConnectionRemoved(connection);
        }
    }

    private String addConferenceInternal(Conference conference) {
        String originalId = null;
        if (conference.getExtras() != null && conference.getExtras().containsKey("android.telecom.extra.ORIGINAL_CONNECTION_ID")) {
            originalId = conference.getExtras().getString("android.telecom.extra.ORIGINAL_CONNECTION_ID");
            Log.d(this, "addConferenceInternal: conf %s reusing original id %s", conference.getTelecomCallId(), originalId);
        }
        if (this.mIdByConference.containsKey(conference)) {
            Log.w(this, "Re-adding an existing conference: %s.", conference);
        } else if (conference != null) {
            String id2 = originalId == null ? UUID.randomUUID().toString() : originalId;
            this.mConferenceById.put(id2, conference);
            this.mIdByConference.put(conference, id2);
            conference.addListener(this.mConferenceListener);
            return id2;
        }
        return null;
    }

    private void removeConference(Conference conference) {
        if (this.mIdByConference.containsKey(conference)) {
            conference.removeListener(this.mConferenceListener);
            String id2 = this.mIdByConference.get(conference);
            this.mConferenceById.remove(id2);
            this.mIdByConference.remove(conference);
            this.mAdapter.removeCall(id2);
            this.onConferenceRemoved(conference);
        }
    }

    private Connection findConnectionForAction(String callId, String action) {
        if (callId != null && this.mConnectionById.containsKey(callId)) {
            return this.mConnectionById.get(callId);
        }
        Log.w(this, "%s - Cannot find Connection %s", action, callId);
        return ConnectionService.getNullConnection();
    }

    static synchronized Connection getNullConnection() {
        if (sNullConnection == null) {
            sNullConnection = new Connection(){};
        }
        return sNullConnection;
    }

    private Conference findConferenceForAction(String conferenceId, String action) {
        if (this.mConferenceById.containsKey(conferenceId)) {
            return this.mConferenceById.get(conferenceId);
        }
        Log.w(this, "%s - Cannot find conference %s", action, conferenceId);
        return this.getNullConference();
    }

    private List<String> createConnectionIdList(List<Connection> connections) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Connection c : connections) {
            if (!this.mIdByConnection.containsKey(c)) continue;
            ids.add(this.mIdByConnection.get(c));
        }
        Collections.sort(ids);
        return ids;
    }

    private List<String> createIdList(List<Conferenceable> conferenceables) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Conferenceable c : conferenceables) {
            Conference conference;
            if (c instanceof Connection) {
                Connection connection = (Connection)c;
                if (!this.mIdByConnection.containsKey(connection)) continue;
                ids.add(this.mIdByConnection.get(connection));
                continue;
            }
            if (!(c instanceof Conference) || !this.mIdByConference.containsKey(conference = (Conference)c)) continue;
            ids.add(this.mIdByConference.get(conference));
        }
        Collections.sort(ids);
        return ids;
    }

    private Conference getNullConference() {
        if (this.sNullConference == null) {
            this.sNullConference = new Conference(null){};
        }
        return this.sNullConference;
    }

    private void endAllConnections() {
        for (Connection connection : this.mIdByConnection.keySet()) {
            if (connection.getConference() != null) continue;
            connection.onDisconnect();
        }
        for (Conference conference : this.mIdByConference.keySet()) {
            conference.onDisconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextCallId() {
        Object object = this.mIdSyncRoot;
        synchronized (object) {
            return ++this.mId;
        }
    }
}

