/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.app.ActivityManager;
import android.app.role.RoleManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Process;
import android.os.UserHandle;
import android.telecom.TelecomManager;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;

public class DefaultDialerManager {
    private static final String TAG = "DefaultDialerManager";

    public static boolean setDefaultDialerApplication(Context context, String packageName) {
        return DefaultDialerManager.setDefaultDialerApplication(context, packageName, ActivityManager.getCurrentUser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setDefaultDialerApplication(Context context, String packageName, int user) {
        long identity = Binder.clearCallingIdentity();
        try {
            CompletableFuture future = new CompletableFuture();
            Consumer<Boolean> callback = successful -> {
                if (successful.booleanValue()) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(new RuntimeException());
                }
            };
            context.getSystemService(RoleManager.class).addRoleHolderAsUser("android.app.role.DIALER", packageName, 0, UserHandle.of(user), AsyncTask.THREAD_POOL_EXECUTOR, callback);
            future.get(5L, TimeUnit.SECONDS);
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Slog.e(TAG, "Failed to set default dialer to " + packageName + " for user " + user, e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public static String getDefaultDialerApplication(Context context) {
        return DefaultDialerManager.getDefaultDialerApplication(context, context.getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultDialerApplication(Context context, int user) {
        long identity = Binder.clearCallingIdentity();
        try {
            String string2 = CollectionUtils.firstOrNull(context.getSystemService(RoleManager.class).getRoleHoldersAsUser("android.app.role.DIALER", UserHandle.of(user)));
            return string2;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public static List<String> getInstalledDialerApplications(Context context, int userId) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.DIAL");
        List<ResolveInfo> resolveInfoList = packageManager.queryIntentActivitiesAsUser(intent, 0, userId);
        ArrayList<String> packageNames = new ArrayList<String>();
        for (ResolveInfo resolveInfo : resolveInfoList) {
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (activityInfo == null || packageNames.contains(activityInfo.packageName) || resolveInfo.targetUserId != -2) continue;
            packageNames.add(activityInfo.packageName);
        }
        Intent dialIntentWithTelScheme = new Intent("android.intent.action.DIAL");
        dialIntentWithTelScheme.setData(Uri.fromParts("tel", "", null));
        return DefaultDialerManager.filterByIntent(context, packageNames, dialIntentWithTelScheme, userId);
    }

    public static List<String> getInstalledDialerApplications(Context context) {
        return DefaultDialerManager.getInstalledDialerApplications(context, Process.myUserHandle().getIdentifier());
    }

    public static boolean isDefaultOrSystemDialer(Context context, String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            return false;
        }
        TelecomManager tm = DefaultDialerManager.getTelecomManager(context);
        return packageName.equals(tm.getDefaultDialerPackage()) || packageName.equals(tm.getSystemDialerPackage());
    }

    private static List<String> filterByIntent(Context context, List<String> packageNames, Intent intent, int userId) {
        if (packageNames == null || packageNames.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        List<ResolveInfo> resolveInfoList = context.getPackageManager().queryIntentActivitiesAsUser(intent, 0, userId);
        int length = resolveInfoList.size();
        for (int i = 0; i < length; ++i) {
            ActivityInfo info = resolveInfoList.get((int)i).activityInfo;
            if (info == null || !packageNames.contains(info.packageName) || result.contains(info.packageName)) continue;
            result.add(info.packageName);
        }
        return result;
    }

    private static TelecomManager getTelecomManager(Context context) {
        return (TelecomManager)context.getSystemService("telecom");
    }
}

