/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.annotation.UnsupportedAppUsage;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.telecom.InCallService;
import android.telecom.Log;
import android.telecom.VideoProfile;
import android.view.Surface;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.SomeArgs;
import com.android.internal.telecom.IVideoCallback;
import com.android.internal.telecom.IVideoProvider;

public class VideoCallImpl
extends InCallService.VideoCall {
    private final IVideoProvider mVideoProvider;
    private final VideoCallListenerBinder mBinder;
    private InCallService.VideoCall.Callback mCallback;
    private int mVideoQuality = 0;
    private int mVideoState = 0;
    private final String mCallingPackageName;
    private int mTargetSdkVersion;
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        @Override
        public void binderDied() {
            VideoCallImpl.this.mVideoProvider.asBinder().unlinkToDeath(this, 0);
        }
    };
    private Handler mHandler;

    VideoCallImpl(IVideoProvider videoProvider, String callingPackageName, int targetSdkVersion) throws RemoteException {
        this.mVideoProvider = videoProvider;
        this.mVideoProvider.asBinder().linkToDeath(this.mDeathRecipient, 0);
        this.mBinder = new VideoCallListenerBinder();
        this.mVideoProvider.addVideoCallback(this.mBinder);
        this.mCallingPackageName = callingPackageName;
        this.setTargetSdkVersion(targetSdkVersion);
    }

    @VisibleForTesting
    public void setTargetSdkVersion(int sdkVersion) {
        this.mTargetSdkVersion = sdkVersion;
    }

    @Override
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=127403196L)
    public void destroy() {
        this.unregisterCallback(this.mCallback);
    }

    @Override
    public void registerCallback(InCallService.VideoCall.Callback callback) {
        this.registerCallback(callback, null);
    }

    @Override
    public void registerCallback(InCallService.VideoCall.Callback callback, Handler handler) {
        this.mCallback = callback;
        this.mHandler = handler == null ? new MessageHandler(Looper.getMainLooper()) : new MessageHandler(handler.getLooper());
    }

    @Override
    public void unregisterCallback(InCallService.VideoCall.Callback callback) {
        if (callback != this.mCallback) {
            return;
        }
        this.mCallback = null;
        try {
            this.mVideoProvider.removeVideoCallback(this.mBinder);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setCamera(String cameraId) {
        try {
            Log.w(this, "setCamera: cameraId=%s, calling=%s", cameraId, this.mCallingPackageName);
            this.mVideoProvider.setCamera(cameraId, this.mCallingPackageName, this.mTargetSdkVersion);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setPreviewSurface(Surface surface) {
        try {
            this.mVideoProvider.setPreviewSurface(surface);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setDisplaySurface(Surface surface) {
        try {
            this.mVideoProvider.setDisplaySurface(surface);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setDeviceOrientation(int rotation) {
        try {
            this.mVideoProvider.setDeviceOrientation(rotation);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setZoom(float value) {
        try {
            this.mVideoProvider.setZoom(value);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void sendSessionModifyRequest(VideoProfile requestProfile) {
        try {
            VideoProfile originalProfile = new VideoProfile(this.mVideoState, this.mVideoQuality);
            this.mVideoProvider.sendSessionModifyRequest(originalProfile, requestProfile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void sendSessionModifyResponse(VideoProfile responseProfile) {
        try {
            this.mVideoProvider.sendSessionModifyResponse(responseProfile);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void requestCameraCapabilities() {
        try {
            this.mVideoProvider.requestCameraCapabilities();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void requestCallDataUsage() {
        try {
            this.mVideoProvider.requestCallDataUsage();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setPauseImage(Uri uri) {
        try {
            this.mVideoProvider.setPauseImage(uri);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void setVideoState(int videoState) {
        this.mVideoState = videoState;
    }

    private final class MessageHandler
    extends Handler {
        private static final int MSG_RECEIVE_SESSION_MODIFY_REQUEST = 1;
        private static final int MSG_RECEIVE_SESSION_MODIFY_RESPONSE = 2;
        private static final int MSG_HANDLE_CALL_SESSION_EVENT = 3;
        private static final int MSG_CHANGE_PEER_DIMENSIONS = 4;
        private static final int MSG_CHANGE_CALL_DATA_USAGE = 5;
        private static final int MSG_CHANGE_CAMERA_CAPABILITIES = 6;
        private static final int MSG_CHANGE_VIDEO_QUALITY = 7;

        public MessageHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            if (VideoCallImpl.this.mCallback == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    VideoCallImpl.this.mCallback.onSessionModifyRequestReceived((VideoProfile)msg.obj);
                    break;
                }
                case 2: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        int status = (Integer)args.arg1;
                        VideoProfile requestProfile = (VideoProfile)args.arg2;
                        VideoProfile responseProfile = (VideoProfile)args.arg3;
                        VideoCallImpl.this.mCallback.onSessionModifyResponseReceived(status, requestProfile, responseProfile);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 3: {
                    VideoCallImpl.this.mCallback.onCallSessionEvent((Integer)msg.obj);
                    break;
                }
                case 4: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    try {
                        int width = (Integer)args.arg1;
                        int height = (Integer)args.arg2;
                        VideoCallImpl.this.mCallback.onPeerDimensionsChanged(width, height);
                        break;
                    }
                    finally {
                        args.recycle();
                    }
                }
                case 5: {
                    VideoCallImpl.this.mCallback.onCallDataUsageChanged((Long)msg.obj);
                    break;
                }
                case 6: {
                    VideoCallImpl.this.mCallback.onCameraCapabilitiesChanged((VideoProfile.CameraCapabilities)msg.obj);
                    break;
                }
                case 7: {
                    VideoCallImpl.this.mVideoQuality = msg.arg1;
                    VideoCallImpl.this.mCallback.onVideoQualityChanged(msg.arg1);
                    break;
                }
            }
        }
    }

    private final class VideoCallListenerBinder
    extends IVideoCallback.Stub {
        private VideoCallListenerBinder() {
        }

        @Override
        public void receiveSessionModifyRequest(VideoProfile videoProfile) {
            if (VideoCallImpl.this.mHandler == null) {
                return;
            }
            VideoCallImpl.this.mHandler.obtainMessage(1, videoProfile).sendToTarget();
        }

        @Override
        public void receiveSessionModifyResponse(int status, VideoProfile requestProfile, VideoProfile responseProfile) {
            if (VideoCallImpl.this.mHandler == null) {
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = status;
            args.arg2 = requestProfile;
            args.arg3 = responseProfile;
            VideoCallImpl.this.mHandler.obtainMessage(2, args).sendToTarget();
        }

        @Override
        public void handleCallSessionEvent(int event) {
            if (VideoCallImpl.this.mHandler == null) {
                return;
            }
            VideoCallImpl.this.mHandler.obtainMessage(3, event).sendToTarget();
        }

        @Override
        public void changePeerDimensions(int width, int height) {
            if (VideoCallImpl.this.mHandler == null) {
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = width;
            args.arg2 = height;
            VideoCallImpl.this.mHandler.obtainMessage(4, args).sendToTarget();
        }

        @Override
        public void changeVideoQuality(int videoQuality) {
            if (VideoCallImpl.this.mHandler == null) {
                return;
            }
            VideoCallImpl.this.mHandler.obtainMessage(7, videoQuality, 0).sendToTarget();
        }

        @Override
        public void changeCallDataUsage(long dataUsage) {
            if (VideoCallImpl.this.mHandler == null) {
                return;
            }
            VideoCallImpl.this.mHandler.obtainMessage(5, dataUsage).sendToTarget();
        }

        @Override
        public void changeCameraCapabilities(VideoProfile.CameraCapabilities cameraCapabilities) {
            if (VideoCallImpl.this.mHandler == null) {
                return;
            }
            VideoCallImpl.this.mHandler.obtainMessage(6, cameraCapabilities).sendToTarget();
        }
    }
}

