/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.ParcelUuid;
import android.telephony.Rlog;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public final class AnomalyReporter {
    private static final String TAG = "AnomalyReporter";
    private static Context sContext = null;
    private static Map<UUID, Integer> sEvents = new ConcurrentHashMap<UUID, Integer>();
    private static String sDebugPackageName = null;

    private AnomalyReporter() {
    }

    public static void reportAnomaly(UUID eventId, String description) {
        if (sContext == null) {
            Rlog.w(TAG, "AnomalyReporter not yet initialized, dropping event=" + eventId);
            return;
        }
        Integer count = sEvents.containsKey(eventId) ? sEvents.get(eventId) + 1 : 1;
        sEvents.put(eventId, count);
        if (count > 1) {
            return;
        }
        if (sDebugPackageName == null) {
            return;
        }
        Intent dbgIntent = new Intent("android.telephony.action.ANOMALY_REPORTED");
        dbgIntent.putExtra("android.telephony.extra.ANOMALY_ID", new ParcelUuid(eventId));
        if (description != null) {
            dbgIntent.putExtra("android.telephony.extra.ANOMALY_DESCRIPTION", description);
        }
        dbgIntent.setPackage(sDebugPackageName);
        sContext.sendBroadcast(dbgIntent, "android.permission.READ_PRIVILEGED_PHONE_STATE");
    }

    public static void initialize(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("AnomalyReporter needs a non-null context.");
        }
        context.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", "This app does not have privileges to send debug events");
        sContext = context;
        PackageManager pm = sContext.getPackageManager();
        if (pm == null) {
            return;
        }
        List<ResolveInfo> packages = pm.queryBroadcastReceivers(new Intent("android.telephony.action.ANOMALY_REPORTED"), 0x1C0000);
        if (packages == null || packages.isEmpty()) {
            return;
        }
        if (packages.size() > 1) {
            Rlog.e(TAG, "Multiple Anomaly Receivers installed.");
        }
        for (ResolveInfo r : packages) {
            if (r.activityInfo == null || pm.checkPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", r.activityInfo.packageName) != 0) {
                Rlog.w(TAG, "Found package without proper permissions or no activity" + r.activityInfo.packageName);
                continue;
            }
            Rlog.d(TAG, "Found a valid package " + r.activityInfo.packageName);
            sDebugPackageName = r.activityInfo.packageName;
            break;
        }
    }

    public static void dump(FileDescriptor fd, PrintWriter printWriter, String[] args) {
        if (sContext == null) {
            return;
        }
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printWriter, "  ");
        sContext.enforceCallingOrSelfPermission("android.permission.DUMP", "Requires DUMP");
        pw.println("Initialized=" + (sContext != null ? "Yes" : "No"));
        pw.println("Debug Package=" + sDebugPackageName);
        pw.println("Anomaly Counts:");
        pw.increaseIndent();
        for (UUID event : sEvents.keySet()) {
            pw.println(event + ": " + sEvents.get(event));
        }
        pw.decreaseIndent();
        pw.flush();
    }
}

