/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CallQuality;
import android.telephony.PreciseCallState;
import java.util.Objects;

@SystemApi
public final class CallAttributes
implements Parcelable {
    private PreciseCallState mPreciseCallState;
    private int mNetworkType;
    private CallQuality mCallQuality;
    public static final Parcelable.Creator<CallAttributes> CREATOR = new Parcelable.Creator(){

        public CallAttributes createFromParcel(Parcel in) {
            return new CallAttributes(in);
        }

        public CallAttributes[] newArray(int size) {
            return new CallAttributes[size];
        }
    };

    public CallAttributes(PreciseCallState state, int networkType, CallQuality callQuality) {
        this.mPreciseCallState = state;
        this.mNetworkType = networkType;
        this.mCallQuality = callQuality;
    }

    public String toString() {
        return "mPreciseCallState=" + this.mPreciseCallState + " mNetworkType=" + this.mNetworkType + " mCallQuality=" + this.mCallQuality;
    }

    private CallAttributes(Parcel in) {
        this.mPreciseCallState = (PreciseCallState)in.readParcelable(PreciseCallState.class.getClassLoader());
        this.mNetworkType = in.readInt();
        this.mCallQuality = (CallQuality)in.readParcelable(CallQuality.class.getClassLoader());
    }

    public PreciseCallState getPreciseCallState() {
        return this.mPreciseCallState;
    }

    public int getNetworkType() {
        return this.mNetworkType;
    }

    public CallQuality getCallQuality() {
        return this.mCallQuality;
    }

    public int hashCode() {
        return Objects.hash(this.mPreciseCallState, this.mNetworkType, this.mCallQuality);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CallAttributes) || this.hashCode() != o.hashCode()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        CallAttributes s = (CallAttributes)o;
        return Objects.equals(this.mPreciseCallState, s.mPreciseCallState) && this.mNetworkType == s.mNetworkType && Objects.equals(this.mCallQuality, s.mCallQuality);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mPreciseCallState, flags);
        dest.writeInt(this.mNetworkType);
        dest.writeParcelable(this.mCallQuality, flags);
    }
}

