/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.UnsupportedAppUsage;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.SmsCbCmasInfo;
import android.telephony.SmsCbEtwsInfo;
import android.telephony.SmsCbLocation;
import android.telephony.SmsCbMessage;
import android.text.format.DateUtils;

public class CellBroadcastMessage
implements Parcelable {
    public static final String SMS_CB_MESSAGE_EXTRA = "com.android.cellbroadcastreceiver.SMS_CB_MESSAGE";
    private final SmsCbMessage mSmsCbMessage;
    private final long mDeliveryTime;
    private boolean mIsRead;
    private int mSubId = 0;
    public static final Parcelable.Creator<CellBroadcastMessage> CREATOR = new Parcelable.Creator<CellBroadcastMessage>(){

        @Override
        public CellBroadcastMessage createFromParcel(Parcel in) {
            return new CellBroadcastMessage(in);
        }

        public CellBroadcastMessage[] newArray(int size) {
            return new CellBroadcastMessage[size];
        }
    };

    public void setSubId(int subId) {
        this.mSubId = subId;
    }

    public int getSubId() {
        return this.mSubId;
    }

    @UnsupportedAppUsage
    public CellBroadcastMessage(SmsCbMessage message) {
        this.mSmsCbMessage = message;
        this.mDeliveryTime = System.currentTimeMillis();
        this.mIsRead = false;
    }

    private CellBroadcastMessage(SmsCbMessage message, long deliveryTime, boolean isRead) {
        this.mSmsCbMessage = message;
        this.mDeliveryTime = deliveryTime;
        this.mIsRead = isRead;
    }

    private CellBroadcastMessage(Parcel in) {
        this.mSmsCbMessage = new SmsCbMessage(in);
        this.mDeliveryTime = in.readLong();
        this.mIsRead = in.readInt() != 0;
        this.mSubId = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        this.mSmsCbMessage.writeToParcel(out, flags);
        out.writeLong(this.mDeliveryTime);
        out.writeInt(this.mIsRead ? 1 : 0);
        out.writeInt(this.mSubId);
    }

    @UnsupportedAppUsage
    public static CellBroadcastMessage createFromCursor(Cursor cursor) {
        SmsCbCmasInfo cmasInfo;
        SmsCbEtwsInfo etwsInfo;
        int geoScope = cursor.getInt(cursor.getColumnIndexOrThrow("geo_scope"));
        int serialNum = cursor.getInt(cursor.getColumnIndexOrThrow("serial_number"));
        int category = cursor.getInt(cursor.getColumnIndexOrThrow("service_category"));
        String language = cursor.getString(cursor.getColumnIndexOrThrow("language"));
        String body = cursor.getString(cursor.getColumnIndexOrThrow("body"));
        int format = cursor.getInt(cursor.getColumnIndexOrThrow("format"));
        int priority = cursor.getInt(cursor.getColumnIndexOrThrow("priority"));
        int plmnColumn = cursor.getColumnIndex("plmn");
        String plmn = plmnColumn != -1 && !cursor.isNull(plmnColumn) ? cursor.getString(plmnColumn) : null;
        int lacColumn = cursor.getColumnIndex("lac");
        int lac = lacColumn != -1 && !cursor.isNull(lacColumn) ? cursor.getInt(lacColumn) : -1;
        int cidColumn = cursor.getColumnIndex("cid");
        int cid = cidColumn != -1 && !cursor.isNull(cidColumn) ? cursor.getInt(cidColumn) : -1;
        SmsCbLocation location = new SmsCbLocation(plmn, lac, cid);
        int etwsWarningTypeColumn = cursor.getColumnIndex("etws_warning_type");
        if (etwsWarningTypeColumn != -1 && !cursor.isNull(etwsWarningTypeColumn)) {
            int warningType = cursor.getInt(etwsWarningTypeColumn);
            etwsInfo = new SmsCbEtwsInfo(warningType, false, false, false, null);
        } else {
            etwsInfo = null;
        }
        int cmasMessageClassColumn = cursor.getColumnIndex("cmas_message_class");
        if (cmasMessageClassColumn != -1 && !cursor.isNull(cmasMessageClassColumn)) {
            int messageClass = cursor.getInt(cmasMessageClassColumn);
            int cmasCategoryColumn = cursor.getColumnIndex("cmas_category");
            int cmasCategory = cmasCategoryColumn != -1 && !cursor.isNull(cmasCategoryColumn) ? cursor.getInt(cmasCategoryColumn) : -1;
            int cmasResponseTypeColumn = cursor.getColumnIndex("cmas_response_type");
            int responseType = cmasResponseTypeColumn != -1 && !cursor.isNull(cmasResponseTypeColumn) ? cursor.getInt(cmasResponseTypeColumn) : -1;
            int cmasSeverityColumn = cursor.getColumnIndex("cmas_severity");
            int severity = cmasSeverityColumn != -1 && !cursor.isNull(cmasSeverityColumn) ? cursor.getInt(cmasSeverityColumn) : -1;
            int cmasUrgencyColumn = cursor.getColumnIndex("cmas_urgency");
            int urgency = cmasUrgencyColumn != -1 && !cursor.isNull(cmasUrgencyColumn) ? cursor.getInt(cmasUrgencyColumn) : -1;
            int cmasCertaintyColumn = cursor.getColumnIndex("cmas_certainty");
            int certainty = cmasCertaintyColumn != -1 && !cursor.isNull(cmasCertaintyColumn) ? cursor.getInt(cmasCertaintyColumn) : -1;
            cmasInfo = new SmsCbCmasInfo(messageClass, cmasCategory, responseType, severity, urgency, certainty);
        } else {
            cmasInfo = null;
        }
        SmsCbMessage msg = new SmsCbMessage(format, geoScope, serialNum, location, category, language, body, priority, etwsInfo, cmasInfo);
        long deliveryTime = cursor.getLong(cursor.getColumnIndexOrThrow("date"));
        boolean isRead = cursor.getInt(cursor.getColumnIndexOrThrow("read")) != 0;
        return new CellBroadcastMessage(msg, deliveryTime, isRead);
    }

    @UnsupportedAppUsage
    public ContentValues getContentValues() {
        SmsCbCmasInfo cmasInfo;
        ContentValues cv = new ContentValues(16);
        SmsCbMessage msg = this.mSmsCbMessage;
        cv.put("geo_scope", msg.getGeographicalScope());
        SmsCbLocation location = msg.getLocation();
        if (location.getPlmn() != null) {
            cv.put("plmn", location.getPlmn());
        }
        if (location.getLac() != -1) {
            cv.put("lac", location.getLac());
        }
        if (location.getCid() != -1) {
            cv.put("cid", location.getCid());
        }
        cv.put("serial_number", msg.getSerialNumber());
        cv.put("service_category", msg.getServiceCategory());
        cv.put("language", msg.getLanguageCode());
        cv.put("body", msg.getMessageBody());
        cv.put("date", this.mDeliveryTime);
        cv.put("read", this.mIsRead);
        cv.put("format", msg.getMessageFormat());
        cv.put("priority", msg.getMessagePriority());
        SmsCbEtwsInfo etwsInfo = this.mSmsCbMessage.getEtwsWarningInfo();
        if (etwsInfo != null) {
            cv.put("etws_warning_type", etwsInfo.getWarningType());
        }
        if ((cmasInfo = this.mSmsCbMessage.getCmasWarningInfo()) != null) {
            cv.put("cmas_message_class", cmasInfo.getMessageClass());
            cv.put("cmas_category", cmasInfo.getCategory());
            cv.put("cmas_response_type", cmasInfo.getResponseType());
            cv.put("cmas_severity", cmasInfo.getSeverity());
            cv.put("cmas_urgency", cmasInfo.getUrgency());
            cv.put("cmas_certainty", cmasInfo.getCertainty());
        }
        return cv;
    }

    public void setIsRead(boolean isRead) {
        this.mIsRead = isRead;
    }

    @UnsupportedAppUsage
    public String getLanguageCode() {
        return this.mSmsCbMessage.getLanguageCode();
    }

    @UnsupportedAppUsage
    public int getServiceCategory() {
        return this.mSmsCbMessage.getServiceCategory();
    }

    @UnsupportedAppUsage
    public long getDeliveryTime() {
        return this.mDeliveryTime;
    }

    @UnsupportedAppUsage
    public String getMessageBody() {
        return this.mSmsCbMessage.getMessageBody();
    }

    @UnsupportedAppUsage
    public boolean isRead() {
        return this.mIsRead;
    }

    @UnsupportedAppUsage
    public int getSerialNumber() {
        return this.mSmsCbMessage.getSerialNumber();
    }

    public SmsCbCmasInfo getCmasWarningInfo() {
        return this.mSmsCbMessage.getCmasWarningInfo();
    }

    @UnsupportedAppUsage
    public SmsCbEtwsInfo getEtwsWarningInfo() {
        return this.mSmsCbMessage.getEtwsWarningInfo();
    }

    public boolean isPublicAlertMessage() {
        return this.mSmsCbMessage.isEmergencyMessage();
    }

    @UnsupportedAppUsage
    public boolean isEmergencyAlertMessage() {
        return this.mSmsCbMessage.isEmergencyMessage();
    }

    @UnsupportedAppUsage
    public boolean isEtwsMessage() {
        return this.mSmsCbMessage.isEtwsMessage();
    }

    @UnsupportedAppUsage
    public boolean isCmasMessage() {
        return this.mSmsCbMessage.isCmasMessage();
    }

    public int getCmasMessageClass() {
        if (this.mSmsCbMessage.isCmasMessage()) {
            return this.mSmsCbMessage.getCmasWarningInfo().getMessageClass();
        }
        return -1;
    }

    public boolean isEtwsPopupAlert() {
        SmsCbEtwsInfo etwsInfo = this.mSmsCbMessage.getEtwsWarningInfo();
        return etwsInfo != null && etwsInfo.isPopupAlert();
    }

    public boolean isEtwsEmergencyUserAlert() {
        SmsCbEtwsInfo etwsInfo = this.mSmsCbMessage.getEtwsWarningInfo();
        return etwsInfo != null && etwsInfo.isEmergencyUserAlert();
    }

    public boolean isEtwsTestMessage() {
        SmsCbEtwsInfo etwsInfo = this.mSmsCbMessage.getEtwsWarningInfo();
        return etwsInfo != null && etwsInfo.getWarningType() == 3;
    }

    public String getDateString(Context context) {
        int flags = 527121;
        return DateUtils.formatDateTime(context, this.mDeliveryTime, flags);
    }

    @UnsupportedAppUsage
    public String getSpokenDateString(Context context) {
        int flags = 17;
        return DateUtils.formatDateTime(context, this.mDeliveryTime, flags);
    }
}

