/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellIdentity;
import android.telephony.CellLocation;
import android.telephony.gsm.GsmCellLocation;
import java.util.Objects;

public final class CellIdentityNr
extends CellIdentity {
    private static final String TAG = "CellIdentityNr";
    private static final int MAX_PCI = 1007;
    private static final int MAX_TAC = 65535;
    private static final int MAX_NRARFCN = 3279165;
    private static final long MAX_NCI = 0xFFFFFFFFFL;
    private final int mNrArfcn;
    private final int mPci;
    private final int mTac;
    private final long mNci;
    public static final Parcelable.Creator<CellIdentityNr> CREATOR = new Parcelable.Creator<CellIdentityNr>(){

        @Override
        public CellIdentityNr createFromParcel(Parcel in) {
            in.readInt();
            return CellIdentityNr.createFromParcelBody(in);
        }

        public CellIdentityNr[] newArray(int size) {
            return new CellIdentityNr[size];
        }
    };

    public CellIdentityNr(int pci, int tac, int nrArfcn, String mccStr, String mncStr, long nci, String alphal, String alphas) {
        super(TAG, 6, mccStr, mncStr, alphal, alphas);
        this.mPci = CellIdentityNr.inRangeOrUnavailable(pci, 0, 1007);
        this.mTac = CellIdentityNr.inRangeOrUnavailable(tac, 0, 65535);
        this.mNrArfcn = CellIdentityNr.inRangeOrUnavailable(nrArfcn, 0, 3279165);
        this.mNci = CellIdentityNr.inRangeOrUnavailable(nci, 0L, 0xFFFFFFFFFL);
    }

    public CellIdentityNr sanitizeLocationInfo() {
        return new CellIdentityNr(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, this.mMccStr, this.mMncStr, Integer.MAX_VALUE, this.mAlphaLong, this.mAlphaShort);
    }

    @Override
    public CellLocation asCellLocation() {
        return new GsmCellLocation();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mPci, this.mTac, this.mNrArfcn, this.mNci);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof CellIdentityNr)) {
            return false;
        }
        CellIdentityNr o = (CellIdentityNr)other;
        return super.equals(o) && this.mPci == o.mPci && this.mTac == o.mTac && this.mNrArfcn == o.mNrArfcn && this.mNci == o.mNci;
    }

    public long getNci() {
        return this.mNci;
    }

    public int getNrarfcn() {
        return this.mNrArfcn;
    }

    public int getPci() {
        return this.mPci;
    }

    public int getTac() {
        return this.mTac;
    }

    @Override
    public String getMccString() {
        return this.mMccStr;
    }

    @Override
    public String getMncString() {
        return this.mMncStr;
    }

    public String toString() {
        return "CellIdentityNr:{" + " mPci = " + this.mPci + " mTac = " + this.mTac + " mNrArfcn = " + this.mNrArfcn + " mMcc = " + this.mMccStr + " mMnc = " + this.mMncStr + " mNci = " + this.mNci + " mAlphaLong = " + this.mAlphaLong + " mAlphaShort = " + this.mAlphaShort + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int type) {
        super.writeToParcel(dest, 6);
        dest.writeInt(this.mPci);
        dest.writeInt(this.mTac);
        dest.writeInt(this.mNrArfcn);
        dest.writeLong(this.mNci);
    }

    private CellIdentityNr(Parcel in) {
        super(TAG, 6, in);
        this.mPci = in.readInt();
        this.mTac = in.readInt();
        this.mNrArfcn = in.readInt();
        this.mNci = in.readLong();
    }

    protected static CellIdentityNr createFromParcelBody(Parcel in) {
        return new CellIdentityNr(in);
    }
}

