/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.UnsupportedAppUsage;
import android.hardware.radio.V1_0.GsmSignalStrength;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.telephony.CellSignalStrength;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import java.util.Objects;

public final class CellSignalStrengthGsm
extends CellSignalStrength
implements Parcelable {
    private static final String LOG_TAG = "CellSignalStrengthGsm";
    private static final boolean DBG = false;
    private static final int GSM_RSSI_MAX = -51;
    private static final int GSM_RSSI_GREAT = -89;
    private static final int GSM_RSSI_GOOD = -97;
    private static final int GSM_RSSI_MODERATE = -103;
    private static final int GSM_RSSI_POOR = -107;
    private static final int GSM_RSSI_MIN = -113;
    private static final int[] sRssiThresholds = new int[]{-107, -103, -97, -89};
    private int mRssi;
    @UnsupportedAppUsage
    private int mBitErrorRate;
    @UnsupportedAppUsage(maxTargetSdk=28)
    private int mTimingAdvance;
    private int mLevel;
    private static final CellSignalStrengthGsm sInvalid = new CellSignalStrengthGsm();
    public static final Parcelable.Creator<CellSignalStrengthGsm> CREATOR = new Parcelable.Creator<CellSignalStrengthGsm>(){

        @Override
        public CellSignalStrengthGsm createFromParcel(Parcel in) {
            return new CellSignalStrengthGsm(in);
        }

        public CellSignalStrengthGsm[] newArray(int size) {
            return new CellSignalStrengthGsm[size];
        }
    };

    @UnsupportedAppUsage
    public CellSignalStrengthGsm() {
        this.setDefaultValues();
    }

    public CellSignalStrengthGsm(int rssi, int ber, int ta) {
        this.mRssi = CellSignalStrengthGsm.inRangeOrUnavailable(rssi, -113, -51);
        this.mBitErrorRate = CellSignalStrengthGsm.inRangeOrUnavailable(ber, 0, 7, 99);
        this.mTimingAdvance = CellSignalStrengthGsm.inRangeOrUnavailable(ta, 0, 219);
        this.updateLevel(null, null);
    }

    public CellSignalStrengthGsm(GsmSignalStrength gsm) {
        this(CellSignalStrengthGsm.getRssiDbmFromAsu(gsm.signalStrength), gsm.bitErrorRate, gsm.timingAdvance);
        if (this.mRssi == Integer.MAX_VALUE) {
            this.setDefaultValues();
        }
    }

    public CellSignalStrengthGsm(CellSignalStrengthGsm s) {
        this.copyFrom(s);
    }

    protected void copyFrom(CellSignalStrengthGsm s) {
        this.mRssi = s.mRssi;
        this.mBitErrorRate = s.mBitErrorRate;
        this.mTimingAdvance = s.mTimingAdvance;
        this.mLevel = s.mLevel;
    }

    @Override
    public CellSignalStrengthGsm copy() {
        return new CellSignalStrengthGsm(this);
    }

    @Override
    public void setDefaultValues() {
        this.mRssi = Integer.MAX_VALUE;
        this.mBitErrorRate = Integer.MAX_VALUE;
        this.mTimingAdvance = Integer.MAX_VALUE;
        this.mLevel = 0;
    }

    @Override
    public int getLevel() {
        return this.mLevel;
    }

    @Override
    public void updateLevel(PersistableBundle cc, ServiceState ss) {
        int level;
        int[] rssiThresholds;
        if (cc == null) {
            rssiThresholds = sRssiThresholds;
        } else {
            rssiThresholds = cc.getIntArray("gsm_rssi_thresholds_int_array");
            if (rssiThresholds == null || rssiThresholds.length != 4) {
                rssiThresholds = sRssiThresholds;
            }
        }
        if (this.mRssi < -113 || this.mRssi > -51) {
            this.mLevel = 0;
            return;
        }
        for (level = 4; level > 0 && this.mRssi < rssiThresholds[level - 1]; --level) {
        }
        this.mLevel = level;
    }

    public int getTimingAdvance() {
        return this.mTimingAdvance;
    }

    @Override
    public int getDbm() {
        return this.mRssi;
    }

    @Override
    public int getAsuLevel() {
        return CellSignalStrengthGsm.getAsuFromRssiDbm(this.mRssi);
    }

    public int getRssi() {
        return this.mRssi;
    }

    public int getBitErrorRate() {
        return this.mBitErrorRate;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mRssi, this.mBitErrorRate, this.mTimingAdvance);
    }

    @Override
    public boolean isValid() {
        return !this.equals(sInvalid);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CellSignalStrengthGsm)) {
            return false;
        }
        CellSignalStrengthGsm s = (CellSignalStrengthGsm)o;
        return this.mRssi == s.mRssi && this.mBitErrorRate == s.mBitErrorRate && this.mTimingAdvance == s.mTimingAdvance && this.mLevel == s.mLevel;
    }

    public String toString() {
        return "CellSignalStrengthGsm: rssi=" + this.mRssi + " ber=" + this.mBitErrorRate + " mTa=" + this.mTimingAdvance + " mLevel=" + this.mLevel;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mBitErrorRate);
        dest.writeInt(this.mTimingAdvance);
        dest.writeInt(this.mLevel);
    }

    private CellSignalStrengthGsm(Parcel in) {
        this.mRssi = in.readInt();
        this.mBitErrorRate = in.readInt();
        this.mTimingAdvance = in.readInt();
        this.mLevel = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static void log(String s) {
        Rlog.w(LOG_TAG, s);
    }
}

