/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.UnsupportedAppUsage;
import android.hardware.radio.V1_0.WcdmaSignalStrength;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.telephony.CellSignalStrength;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public final class CellSignalStrengthWcdma
extends CellSignalStrength
implements Parcelable {
    private static final String LOG_TAG = "CellSignalStrengthWcdma";
    private static final boolean DBG = false;
    private static final int WCDMA_RSSI_MAX = -51;
    private static final int WCDMA_RSSI_GREAT = -77;
    private static final int WCDMA_RSSI_GOOD = -87;
    private static final int WCDMA_RSSI_MODERATE = -97;
    private static final int WCDMA_RSSI_POOR = -107;
    private static final int WCDMA_RSSI_MIN = -113;
    private static final int[] sRssiThresholds = new int[]{-107, -97, -87, -77};
    private static final int WCDMA_RSCP_MAX = -24;
    private static final int WCDMA_RSCP_GREAT = -85;
    private static final int WCDMA_RSCP_GOOD = -95;
    private static final int WCDMA_RSCP_MODERATE = -105;
    private static final int WCDMA_RSCP_POOR = -115;
    private static final int WCDMA_RSCP_MIN = -120;
    private static final int[] sRscpThresholds = new int[]{-115, -105, -95, -85};
    public static final String LEVEL_CALCULATION_METHOD_RSSI = "rssi";
    public static final String LEVEL_CALCULATION_METHOD_RSCP = "rscp";
    private static final String DEFAULT_LEVEL_CALCULATION_METHOD = "rssi";
    private int mRssi;
    @UnsupportedAppUsage
    private int mBitErrorRate;
    private int mRscp;
    private int mEcNo;
    private int mLevel;
    private static final CellSignalStrengthWcdma sInvalid = new CellSignalStrengthWcdma();
    public static final Parcelable.Creator<CellSignalStrengthWcdma> CREATOR = new Parcelable.Creator<CellSignalStrengthWcdma>(){

        @Override
        public CellSignalStrengthWcdma createFromParcel(Parcel in) {
            return new CellSignalStrengthWcdma(in);
        }

        public CellSignalStrengthWcdma[] newArray(int size) {
            return new CellSignalStrengthWcdma[size];
        }
    };

    public CellSignalStrengthWcdma() {
        this.setDefaultValues();
    }

    public CellSignalStrengthWcdma(int rssi, int ber, int rscp, int ecno) {
        this.mRssi = CellSignalStrengthWcdma.inRangeOrUnavailable(rssi, -113, -51);
        this.mBitErrorRate = CellSignalStrengthWcdma.inRangeOrUnavailable(ber, 0, 7, 99);
        this.mRscp = CellSignalStrengthWcdma.inRangeOrUnavailable(rscp, -120, -24);
        this.mEcNo = CellSignalStrengthWcdma.inRangeOrUnavailable(ecno, -24, 1);
        this.updateLevel(null, null);
    }

    public CellSignalStrengthWcdma(WcdmaSignalStrength wcdma) {
        this(CellSignalStrengthWcdma.getRssiDbmFromAsu(wcdma.signalStrength), wcdma.bitErrorRate, Integer.MAX_VALUE, Integer.MAX_VALUE);
        if (this.mRssi == Integer.MAX_VALUE && this.mRscp == Integer.MAX_VALUE) {
            this.setDefaultValues();
        }
    }

    public CellSignalStrengthWcdma(android.hardware.radio.V1_2.WcdmaSignalStrength wcdma) {
        this(CellSignalStrengthWcdma.getRssiDbmFromAsu(wcdma.base.signalStrength), wcdma.base.bitErrorRate, CellSignalStrengthWcdma.getRscpDbmFromAsu(wcdma.rscp), CellSignalStrengthWcdma.getEcNoDbFromAsu(wcdma.ecno));
        if (this.mRssi == Integer.MAX_VALUE && this.mRscp == Integer.MAX_VALUE) {
            this.setDefaultValues();
        }
    }

    public CellSignalStrengthWcdma(CellSignalStrengthWcdma s) {
        this.copyFrom(s);
    }

    protected void copyFrom(CellSignalStrengthWcdma s) {
        this.mRssi = s.mRssi;
        this.mBitErrorRate = s.mBitErrorRate;
        this.mRscp = s.mRscp;
        this.mEcNo = s.mEcNo;
        this.mLevel = s.mLevel;
    }

    @Override
    public CellSignalStrengthWcdma copy() {
        return new CellSignalStrengthWcdma(this);
    }

    @Override
    public void setDefaultValues() {
        this.mRssi = Integer.MAX_VALUE;
        this.mBitErrorRate = Integer.MAX_VALUE;
        this.mRscp = Integer.MAX_VALUE;
        this.mEcNo = Integer.MAX_VALUE;
        this.mLevel = 0;
    }

    @Override
    public int getLevel() {
        return this.mLevel;
    }

    @Override
    public void updateLevel(PersistableBundle cc, ServiceState ss) {
        int[] rscpThresholds;
        String calcMethod;
        if (cc == null) {
            calcMethod = "rssi";
            rscpThresholds = sRscpThresholds;
        } else {
            calcMethod = cc.getString("wcdma_default_signal_strength_measurement_string", "rssi");
            if (TextUtils.isEmpty(calcMethod)) {
                calcMethod = "rssi";
            }
            if ((rscpThresholds = cc.getIntArray("wcdma_rscp_thresholds_int_array")) == null || rscpThresholds.length != 4) {
                rscpThresholds = sRscpThresholds;
            }
        }
        int level = 4;
        switch (calcMethod) {
            case "rscp": {
                if (this.mRscp < -120 || this.mRscp > -24) {
                    this.mLevel = 0;
                    return;
                }
                while (level > 0 && this.mRscp < rscpThresholds[level - 1]) {
                    --level;
                }
                this.mLevel = level;
                return;
            }
            default: {
                CellSignalStrengthWcdma.loge("Invalid Level Calculation Method for CellSignalStrengthWcdma = " + calcMethod);
            }
            case "rssi": 
        }
        if (this.mRssi < -113 || this.mRssi > -51) {
            this.mLevel = 0;
            return;
        }
        while (level > 0 && this.mRssi < sRssiThresholds[level - 1]) {
            --level;
        }
        this.mLevel = level;
    }

    @Override
    public int getDbm() {
        if (this.mRscp != Integer.MAX_VALUE) {
            return this.mRscp;
        }
        return this.mRssi;
    }

    @Override
    public int getAsuLevel() {
        if (this.mRscp != Integer.MAX_VALUE) {
            return CellSignalStrengthWcdma.getAsuFromRscpDbm(this.mRscp);
        }
        if (this.mRssi != Integer.MAX_VALUE) {
            return CellSignalStrengthWcdma.getAsuFromRssiDbm(this.mRssi);
        }
        return CellSignalStrengthWcdma.getAsuFromRscpDbm(Integer.MAX_VALUE);
    }

    public int getRssi() {
        return this.mRssi;
    }

    public int getRscp() {
        return this.mRscp;
    }

    public int getEcNo() {
        return this.mEcNo;
    }

    public int getBitErrorRate() {
        return this.mBitErrorRate;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mRssi, this.mBitErrorRate, this.mRscp, this.mEcNo, this.mLevel);
    }

    @Override
    public boolean isValid() {
        return !this.equals(sInvalid);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof CellSignalStrengthWcdma)) {
            return false;
        }
        CellSignalStrengthWcdma s = (CellSignalStrengthWcdma)o;
        return this.mRssi == s.mRssi && this.mBitErrorRate == s.mBitErrorRate && this.mRscp == s.mRscp && this.mEcNo == s.mEcNo && this.mLevel == s.mLevel;
    }

    public String toString() {
        return "CellSignalStrengthWcdma: ss=" + this.mRssi + " ber=" + this.mBitErrorRate + " rscp=" + this.mRscp + " ecno=" + this.mEcNo + " level=" + this.mLevel;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRssi);
        dest.writeInt(this.mBitErrorRate);
        dest.writeInt(this.mRscp);
        dest.writeInt(this.mEcNo);
        dest.writeInt(this.mLevel);
    }

    private CellSignalStrengthWcdma(Parcel in) {
        this.mRssi = in.readInt();
        this.mBitErrorRate = in.readInt();
        this.mRscp = in.readInt();
        this.mEcNo = in.readInt();
        this.mLevel = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private static void log(String s) {
        Rlog.w(LOG_TAG, s);
    }

    private static void loge(String s) {
        Rlog.e(LOG_TAG, s);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LevelCalculationMethod {
    }
}

