/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.location.LocationManager;
import android.os.Binder;
import android.os.Build;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Log;
import android.widget.Toast;
import java.util.List;

public final class LocationAccessPolicy {
    private static final String TAG = "LocationAccessPolicy";
    private static final boolean DBG = false;
    public static final int MAX_SDK_FOR_ANY_ENFORCEMENT = 10000;

    private static void logError(Context context, LocationPermissionQuery query, String errorMsg) {
        if (query.logAsInfo) {
            Log.i(TAG, errorMsg);
            return;
        }
        Log.e(TAG, errorMsg);
        try {
            if (Build.IS_DEBUGGABLE) {
                Toast.makeText(context, errorMsg, 0).show();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static LocationPermissionResult appOpsModeToPermissionResult(int appOpsMode) {
        switch (appOpsMode) {
            case 0: {
                return LocationPermissionResult.ALLOWED;
            }
            case 2: {
                return LocationPermissionResult.DENIED_HARD;
            }
        }
        return LocationPermissionResult.DENIED_SOFT;
    }

    private static LocationPermissionResult checkAppLocationPermissionHelper(Context context, LocationPermissionQuery query, String permissionToCheck) {
        int minSdkVersion;
        String locationTypeForLog = "android.permission.ACCESS_FINE_LOCATION".equals(permissionToCheck) ? "fine" : "coarse";
        boolean hasManifestPermission = LocationAccessPolicy.checkManifestPermission(context, query.callingPid, query.callingUid, permissionToCheck);
        if (hasManifestPermission) {
            int appOpMode = context.getSystemService(AppOpsManager.class).noteOpNoThrow(AppOpsManager.permissionToOpCode(permissionToCheck), query.callingUid, query.callingPackage);
            if (appOpMode == 0) {
                return LocationPermissionResult.ALLOWED;
            }
            Log.i(TAG, query.callingPackage + " is aware of " + locationTypeForLog + " but the app-ops permission is specifically denied.");
            return LocationAccessPolicy.appOpsModeToPermissionResult(appOpMode);
        }
        int n = minSdkVersion = "android.permission.ACCESS_FINE_LOCATION".equals(permissionToCheck) ? query.minSdkVersionForFine : query.minSdkVersionForCoarse;
        if (minSdkVersion > 10000) {
            String errorMsg = "Allowing " + query.callingPackage + " " + locationTypeForLog + " because we're not enforcing API " + minSdkVersion + " yet. Please fix this app because it will break in the future. Called from " + query.method;
            LocationAccessPolicy.logError(context, query, errorMsg);
            return null;
        }
        if (!LocationAccessPolicy.isAppAtLeastSdkVersion(context, query.callingPackage, minSdkVersion)) {
            String errorMsg = "Allowing " + query.callingPackage + " " + locationTypeForLog + " because it doesn't target API " + minSdkVersion + " yet. Please fix this app. Called from " + query.method;
            LocationAccessPolicy.logError(context, query, errorMsg);
            return null;
        }
        return LocationPermissionResult.DENIED_HARD;
    }

    public static LocationPermissionResult checkLocationPermission(Context context, LocationPermissionQuery query) {
        LocationPermissionResult resultForCoarse;
        LocationPermissionResult resultForFine;
        if (query.callingUid == 1001 || query.callingUid == 1000 || query.callingUid == 0) {
            return LocationPermissionResult.ALLOWED;
        }
        if (!LocationAccessPolicy.checkSystemLocationAccess(context, query.callingUid, query.callingPid)) {
            return LocationPermissionResult.DENIED_SOFT;
        }
        if (query.minSdkVersionForFine < Integer.MAX_VALUE && (resultForFine = LocationAccessPolicy.checkAppLocationPermissionHelper(context, query, "android.permission.ACCESS_FINE_LOCATION")) != null) {
            return resultForFine;
        }
        if (query.minSdkVersionForCoarse < Integer.MAX_VALUE && (resultForCoarse = LocationAccessPolicy.checkAppLocationPermissionHelper(context, query, "android.permission.ACCESS_COARSE_LOCATION")) != null) {
            return resultForCoarse;
        }
        return LocationPermissionResult.ALLOWED;
    }

    private static boolean checkManifestPermission(Context context, int pid, int uid, String permissionToCheck) {
        return context.checkPermission(permissionToCheck, pid, uid) == 0;
    }

    private static boolean checkSystemLocationAccess(Context context, int uid, int pid) {
        if (!LocationAccessPolicy.isLocationModeEnabled(context, UserHandle.getUserId(uid))) {
            return false;
        }
        return LocationAccessPolicy.isCurrentProfile(context, uid) || LocationAccessPolicy.checkInteractAcrossUsersFull(context, uid, pid);
    }

    private static boolean isLocationModeEnabled(Context context, int userId) {
        LocationManager locationManager = context.getSystemService(LocationManager.class);
        if (locationManager == null) {
            Log.w(TAG, "Couldn't get location manager, denying location access");
            return false;
        }
        return locationManager.isLocationEnabledForUser(UserHandle.of(userId));
    }

    private static boolean checkInteractAcrossUsersFull(Context context, int pid, int uid) {
        return LocationAccessPolicy.checkManifestPermission(context, pid, uid, "android.permission.INTERACT_ACROSS_USERS_FULL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isCurrentProfile(Context context, int uid) {
        long token = Binder.clearCallingIdentity();
        try {
            int currentUser = ActivityManager.getCurrentUser();
            int callingUserId = UserHandle.getUserId(uid);
            if (callingUserId == currentUser) {
                boolean bl = true;
                return bl;
            }
            List<UserInfo> userProfiles = context.getSystemService(UserManager.class).getProfiles(currentUser);
            for (UserInfo user : userProfiles) {
                if (user.id != callingUserId) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static boolean isAppAtLeastSdkVersion(Context context, String pkgName, int sdkVersion) {
        try {
            if (context.getPackageManager().getApplicationInfo((String)pkgName, (int)0).targetSdkVersion >= sdkVersion) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static class LocationPermissionQuery {
        public final String callingPackage;
        public final int callingUid;
        public final int callingPid;
        public final int minSdkVersionForCoarse;
        public final int minSdkVersionForFine;
        public final boolean logAsInfo;
        public final String method;

        private LocationPermissionQuery(String callingPackage, int callingUid, int callingPid, int minSdkVersionForCoarse, int minSdkVersionForFine, boolean logAsInfo, String method) {
            this.callingPackage = callingPackage;
            this.callingUid = callingUid;
            this.callingPid = callingPid;
            this.minSdkVersionForCoarse = minSdkVersionForCoarse;
            this.minSdkVersionForFine = minSdkVersionForFine;
            this.logAsInfo = logAsInfo;
            this.method = method;
        }

        public static class Builder {
            private String mCallingPackage;
            private int mCallingUid;
            private int mCallingPid;
            private int mMinSdkVersionForCoarse = Integer.MAX_VALUE;
            private int mMinSdkVersionForFine = Integer.MAX_VALUE;
            private boolean mLogAsInfo = false;
            private String mMethod;

            public Builder setCallingPackage(String callingPackage) {
                this.mCallingPackage = callingPackage;
                return this;
            }

            public Builder setCallingUid(int callingUid) {
                this.mCallingUid = callingUid;
                return this;
            }

            public Builder setCallingPid(int callingPid) {
                this.mCallingPid = callingPid;
                return this;
            }

            public Builder setMinSdkVersionForCoarse(int minSdkVersionForCoarse) {
                this.mMinSdkVersionForCoarse = minSdkVersionForCoarse;
                return this;
            }

            public Builder setMinSdkVersionForFine(int minSdkVersionForFine) {
                this.mMinSdkVersionForFine = minSdkVersionForFine;
                return this;
            }

            public Builder setMethod(String method) {
                this.mMethod = method;
                return this;
            }

            public Builder setLogAsInfo(boolean logAsInfo) {
                this.mLogAsInfo = logAsInfo;
                return this;
            }

            public LocationPermissionQuery build() {
                return new LocationPermissionQuery(this.mCallingPackage, this.mCallingUid, this.mCallingPid, this.mMinSdkVersionForCoarse, this.mMinSdkVersionForFine, this.mLogAsInfo, this.mMethod);
            }
        }
    }

    public static enum LocationPermissionResult {
        ALLOWED,
        DENIED_SOFT,
        DENIED_HARD;

    }
}

