/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.os.IBinder;
import android.os.RemoteException;
import android.telephony.SubscriptionManager;
import android.telephony.mbms.DownloadProgressListener;
import android.telephony.mbms.DownloadRequest;
import android.telephony.mbms.DownloadStatusListener;
import android.telephony.mbms.FileInfo;
import android.telephony.mbms.InternalDownloadProgressListener;
import android.telephony.mbms.InternalDownloadSessionCallback;
import android.telephony.mbms.InternalDownloadStatusListener;
import android.telephony.mbms.MbmsDownloadSessionCallback;
import android.telephony.mbms.MbmsTempFileProvider;
import android.telephony.mbms.MbmsUtils;
import android.telephony.mbms.vendor.IMbmsDownloadService;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class MbmsDownloadSession
implements AutoCloseable {
    private static final String LOG_TAG = MbmsDownloadSession.class.getSimpleName();
    @SystemApi
    public static final String MBMS_DOWNLOAD_SERVICE_ACTION = "android.telephony.action.EmbmsDownload";
    public static final String MBMS_DOWNLOAD_SERVICE_OVERRIDE_METADATA = "mbms-download-service-override";
    public static final String EXTRA_MBMS_DOWNLOAD_RESULT = "android.telephony.extra.MBMS_DOWNLOAD_RESULT";
    public static final String EXTRA_MBMS_FILE_INFO = "android.telephony.extra.MBMS_FILE_INFO";
    public static final String EXTRA_MBMS_COMPLETED_FILE_URI = "android.telephony.extra.MBMS_COMPLETED_FILE_URI";
    public static final String EXTRA_MBMS_DOWNLOAD_REQUEST = "android.telephony.extra.MBMS_DOWNLOAD_REQUEST";
    public static final String DEFAULT_TOP_LEVEL_TEMP_DIRECTORY = "androidMbmsTempFileRoot";
    public static final int RESULT_SUCCESSFUL = 1;
    public static final int RESULT_CANCELLED = 2;
    public static final int RESULT_EXPIRED = 3;
    public static final int RESULT_IO_ERROR = 4;
    public static final int RESULT_SERVICE_ID_NOT_DEFINED = 5;
    public static final int RESULT_DOWNLOAD_FAILURE = 6;
    public static final int RESULT_OUT_OF_STORAGE = 7;
    public static final int RESULT_FILE_ROOT_UNREACHABLE = 8;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_ACTIVELY_DOWNLOADING = 1;
    public static final int STATUS_PENDING_DOWNLOAD = 2;
    public static final int STATUS_PENDING_REPAIR = 3;
    public static final int STATUS_PENDING_DOWNLOAD_WINDOW = 4;
    private static final String DESTINATION_SANITY_CHECK_FILE_NAME = "destinationSanityCheckFile";
    private static AtomicBoolean sIsInitialized = new AtomicBoolean(false);
    private final Context mContext;
    private int mSubscriptionId = -1;
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        @Override
        public void binderDied() {
            MbmsDownloadSession.this.sendErrorToApp(3, "Received death notification");
        }
    };
    private AtomicReference<IMbmsDownloadService> mService = new AtomicReference<Object>(null);
    private final InternalDownloadSessionCallback mInternalCallback;
    private final Map<DownloadStatusListener, InternalDownloadStatusListener> mInternalDownloadStatusListeners = new HashMap<DownloadStatusListener, InternalDownloadStatusListener>();
    private final Map<DownloadProgressListener, InternalDownloadProgressListener> mInternalDownloadProgressListeners = new HashMap<DownloadProgressListener, InternalDownloadProgressListener>();

    private MbmsDownloadSession(Context context, Executor executor, int subscriptionId, MbmsDownloadSessionCallback callback) {
        this.mContext = context;
        this.mSubscriptionId = subscriptionId;
        this.mInternalCallback = new InternalDownloadSessionCallback(callback, executor);
    }

    public static MbmsDownloadSession create(Context context, Executor executor, MbmsDownloadSessionCallback callback) {
        return MbmsDownloadSession.create(context, executor, SubscriptionManager.getDefaultSubscriptionId(), callback);
    }

    public static MbmsDownloadSession create(Context context, Executor executor, int subscriptionId, final MbmsDownloadSessionCallback callback) {
        if (!sIsInitialized.compareAndSet(false, true)) {
            throw new IllegalStateException("Cannot have two active instances");
        }
        MbmsDownloadSession session = new MbmsDownloadSession(context, executor, subscriptionId, callback);
        final int result = session.bindAndInitialize();
        if (result != 0) {
            sIsInitialized.set(false);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onError(result, null);
                }
            });
            return null;
        }
        return session;
    }

    private int bindAndInitialize() {
        return MbmsUtils.startBinding(this.mContext, MBMS_DOWNLOAD_SERVICE_ACTION, new ServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName name, IBinder service) {
                int result;
                IMbmsDownloadService downloadService = IMbmsDownloadService.Stub.asInterface(service);
                try {
                    result = downloadService.initialize(MbmsDownloadSession.this.mSubscriptionId, MbmsDownloadSession.this.mInternalCallback);
                }
                catch (RemoteException e) {
                    Log.e(LOG_TAG, "Service died before initialization");
                    sIsInitialized.set(false);
                    return;
                }
                catch (RuntimeException e) {
                    Log.e(LOG_TAG, "Runtime exception during initialization");
                    MbmsDownloadSession.this.sendErrorToApp(103, e.toString());
                    sIsInitialized.set(false);
                    return;
                }
                if (result == -1) {
                    MbmsDownloadSession.this.close();
                    throw new IllegalStateException("Middleware must not return an unknown error code");
                }
                if (result != 0) {
                    MbmsDownloadSession.this.sendErrorToApp(result, "Error returned during initialization");
                    sIsInitialized.set(false);
                    return;
                }
                try {
                    downloadService.asBinder().linkToDeath(MbmsDownloadSession.this.mDeathRecipient, 0);
                }
                catch (RemoteException e) {
                    MbmsDownloadSession.this.sendErrorToApp(3, "Middleware lost during initialization");
                    sIsInitialized.set(false);
                    return;
                }
                MbmsDownloadSession.this.mService.set(downloadService);
            }

            @Override
            public void onServiceDisconnected(ComponentName name) {
                Log.w(LOG_TAG, "bindAndInitialize: Remote service disconnected");
                sIsInitialized.set(false);
                MbmsDownloadSession.this.mService.set(null);
            }
        });
    }

    public void requestUpdateFileServices(List<String> classList) {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            int returnCode = downloadService.requestUpdateFileServices(this.mSubscriptionId, classList);
            if (returnCode == -1) {
                this.close();
                throw new IllegalStateException("Middleware must not return an unknown error code");
            }
            if (returnCode != 0) {
                this.sendErrorToApp(returnCode, null);
            }
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Remote process died");
            this.mService.set(null);
            sIsInitialized.set(false);
            this.sendErrorToApp(3, null);
        }
    }

    public void setTempFileRootDirectory(File tempFileRootDirectory) {
        String filePath;
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            this.validateTempFileRootSanity(tempFileRootDirectory);
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException checking directory sanity");
        }
        try {
            filePath = tempFileRootDirectory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to canonicalize the provided path: " + e);
        }
        try {
            int result = downloadService.setTempFileRootDirectory(this.mSubscriptionId, filePath);
            if (result == -1) {
                this.close();
                throw new IllegalStateException("Middleware must not return an unknown error code");
            }
            if (result != 0) {
                this.sendErrorToApp(result, null);
                return;
            }
        }
        catch (RemoteException e) {
            this.mService.set(null);
            sIsInitialized.set(false);
            this.sendErrorToApp(3, null);
            return;
        }
        SharedPreferences prefs = this.mContext.getSharedPreferences("MbmsTempFileRootPrefs", 0);
        prefs.edit().putString("mbms_temp_file_root", filePath).apply();
    }

    private void validateTempFileRootSanity(File tempFileRootDirectory) throws IOException {
        if (!tempFileRootDirectory.exists()) {
            throw new IllegalArgumentException("Provided directory does not exist");
        }
        if (!tempFileRootDirectory.isDirectory()) {
            throw new IllegalArgumentException("Provided File is not a directory");
        }
        String canonicalTempFilePath = tempFileRootDirectory.getCanonicalPath();
        if (this.mContext.getDataDir().getCanonicalPath().equals(canonicalTempFilePath)) {
            throw new IllegalArgumentException("Temp file root cannot be your data dir");
        }
        if (this.mContext.getCacheDir().getCanonicalPath().equals(canonicalTempFilePath)) {
            throw new IllegalArgumentException("Temp file root cannot be your cache dir");
        }
        if (this.mContext.getFilesDir().getCanonicalPath().equals(canonicalTempFilePath)) {
            throw new IllegalArgumentException("Temp file root cannot be your files dir");
        }
    }

    public File getTempFileRootDirectory() {
        SharedPreferences prefs = this.mContext.getSharedPreferences("MbmsTempFileRootPrefs", 0);
        String path = prefs.getString("mbms_temp_file_root", null);
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    public void download(DownloadRequest request) {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        SharedPreferences prefs = this.mContext.getSharedPreferences("MbmsTempFileRootPrefs", 0);
        if (prefs.getString("mbms_temp_file_root", null) == null) {
            File tempRootDirectory = new File(this.mContext.getFilesDir(), DEFAULT_TOP_LEVEL_TEMP_DIRECTORY);
            tempRootDirectory.mkdirs();
            this.setTempFileRootDirectory(tempRootDirectory);
        }
        this.checkDownloadRequestDestination(request);
        try {
            int result = downloadService.download(request);
            if (result == 0) {
                this.writeDownloadRequestToken(request);
            } else {
                if (result == -1) {
                    this.close();
                    throw new IllegalStateException("Middleware must not return an unknown error code");
                }
                this.sendErrorToApp(result, null);
            }
        }
        catch (RemoteException e) {
            this.mService.set(null);
            sIsInitialized.set(false);
            this.sendErrorToApp(3, null);
        }
    }

    public List<DownloadRequest> listPendingDownloads() {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            return downloadService.listPendingDownloads(this.mSubscriptionId);
        }
        catch (RemoteException e) {
            this.mService.set(null);
            sIsInitialized.set(false);
            this.sendErrorToApp(3, null);
            return Collections.emptyList();
        }
    }

    public void addStatusListener(DownloadRequest request, Executor executor, DownloadStatusListener listener) {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        InternalDownloadStatusListener internalListener = new InternalDownloadStatusListener(listener, executor);
        try {
            int result = downloadService.addStatusListener(request, internalListener);
            if (result == -1) {
                this.close();
                throw new IllegalStateException("Middleware must not return an unknown error code");
            }
            if (result != 0) {
                if (result == 402) {
                    throw new IllegalArgumentException("Unknown download request.");
                }
                this.sendErrorToApp(result, null);
                return;
            }
        }
        catch (RemoteException e) {
            this.mService.set(null);
            sIsInitialized.set(false);
            this.sendErrorToApp(3, null);
            return;
        }
        this.mInternalDownloadStatusListeners.put(listener, internalListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(DownloadRequest request, DownloadStatusListener listener) {
        try {
            IMbmsDownloadService downloadService = this.mService.get();
            if (downloadService == null) {
                throw new IllegalStateException("Middleware not yet bound");
            }
            InternalDownloadStatusListener internalListener = this.mInternalDownloadStatusListeners.get(listener);
            if (internalListener == null) {
                throw new IllegalArgumentException("Provided listener was never registered");
            }
            try {
                int result = downloadService.removeStatusListener(request, internalListener);
                if (result == -1) {
                    this.close();
                    throw new IllegalStateException("Middleware must not return an unknown error code");
                }
                if (result != 0) {
                    if (result == 402) {
                        throw new IllegalArgumentException("Unknown download request.");
                    }
                    this.sendErrorToApp(result, null);
                    return;
                }
            }
            catch (RemoteException e) {
                this.mService.set(null);
                sIsInitialized.set(false);
                this.sendErrorToApp(3, null);
                return;
            }
        }
        finally {
            InternalDownloadStatusListener internalCallback = this.mInternalDownloadStatusListeners.remove(listener);
            if (internalCallback != null) {
                internalCallback.stop();
            }
        }
    }

    public void addProgressListener(DownloadRequest request, Executor executor, DownloadProgressListener listener) {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        InternalDownloadProgressListener internalListener = new InternalDownloadProgressListener(listener, executor);
        try {
            int result = downloadService.addProgressListener(request, internalListener);
            if (result == -1) {
                this.close();
                throw new IllegalStateException("Middleware must not return an unknown error code");
            }
            if (result != 0) {
                if (result == 402) {
                    throw new IllegalArgumentException("Unknown download request.");
                }
                this.sendErrorToApp(result, null);
                return;
            }
        }
        catch (RemoteException e) {
            this.mService.set(null);
            sIsInitialized.set(false);
            this.sendErrorToApp(3, null);
            return;
        }
        this.mInternalDownloadProgressListeners.put(listener, internalListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(DownloadRequest request, DownloadProgressListener listener) {
        try {
            IMbmsDownloadService downloadService = this.mService.get();
            if (downloadService == null) {
                throw new IllegalStateException("Middleware not yet bound");
            }
            InternalDownloadProgressListener internalListener = this.mInternalDownloadProgressListeners.get(listener);
            if (internalListener == null) {
                throw new IllegalArgumentException("Provided listener was never registered");
            }
            try {
                int result = downloadService.removeProgressListener(request, internalListener);
                if (result == -1) {
                    this.close();
                    throw new IllegalStateException("Middleware must not return an unknown error code");
                }
                if (result != 0) {
                    if (result == 402) {
                        throw new IllegalArgumentException("Unknown download request.");
                    }
                    this.sendErrorToApp(result, null);
                    return;
                }
            }
            catch (RemoteException e) {
                this.mService.set(null);
                sIsInitialized.set(false);
                this.sendErrorToApp(3, null);
                return;
            }
        }
        finally {
            InternalDownloadProgressListener internalCallback = this.mInternalDownloadProgressListeners.remove(listener);
            if (internalCallback != null) {
                internalCallback.stop();
            }
        }
    }

    public void cancelDownload(DownloadRequest downloadRequest) {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            int result = downloadService.cancelDownload(downloadRequest);
            if (result == -1) {
                this.close();
                throw new IllegalStateException("Middleware must not return an unknown error code");
            }
            if (result != 0) {
                this.sendErrorToApp(result, null);
            } else {
                this.deleteDownloadRequestToken(downloadRequest);
            }
        }
        catch (RemoteException e) {
            this.mService.set(null);
            sIsInitialized.set(false);
            this.sendErrorToApp(3, null);
        }
    }

    public void requestDownloadState(DownloadRequest downloadRequest, FileInfo fileInfo) {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            int result = downloadService.requestDownloadState(downloadRequest, fileInfo);
            if (result == -1) {
                this.close();
                throw new IllegalStateException("Middleware must not return an unknown error code");
            }
            if (result != 0) {
                if (result == 402) {
                    throw new IllegalArgumentException("Unknown download request.");
                }
                if (result == 403) {
                    throw new IllegalArgumentException("Unknown file.");
                }
                this.sendErrorToApp(result, null);
            }
        }
        catch (RemoteException e) {
            this.mService.set(null);
            sIsInitialized.set(false);
            this.sendErrorToApp(3, null);
        }
    }

    public void resetDownloadKnowledge(DownloadRequest downloadRequest) {
        IMbmsDownloadService downloadService = this.mService.get();
        if (downloadService == null) {
            throw new IllegalStateException("Middleware not yet bound");
        }
        try {
            int result = downloadService.resetDownloadKnowledge(downloadRequest);
            if (result == -1) {
                this.close();
                throw new IllegalStateException("Middleware must not return an unknown error code");
            }
            if (result != 0) {
                if (result == 402) {
                    throw new IllegalArgumentException("Unknown download request.");
                }
                this.sendErrorToApp(result, null);
            }
        }
        catch (RemoteException e) {
            this.mService.set(null);
            sIsInitialized.set(false);
            this.sendErrorToApp(3, null);
        }
    }

    @Override
    public void close() {
        try {
            IMbmsDownloadService downloadService = this.mService.get();
            if (downloadService == null) {
                Log.i(LOG_TAG, "Service already dead");
                return;
            }
            downloadService.dispose(this.mSubscriptionId);
        }
        catch (RemoteException e) {
            Log.i(LOG_TAG, "Remote exception while disposing of service");
        }
        finally {
            this.mService.set(null);
            sIsInitialized.set(false);
            this.mInternalCallback.stop();
        }
    }

    private void writeDownloadRequestToken(DownloadRequest request) {
        File token = this.getDownloadRequestTokenPath(request);
        if (!token.getParentFile().exists()) {
            token.getParentFile().mkdirs();
        }
        if (token.exists()) {
            Log.w(LOG_TAG, "Download token " + token.getName() + " already exists");
            return;
        }
        try {
            if (!token.createNewFile()) {
                throw new RuntimeException("Failed to create download token for request " + request + ". Token location is " + token.getPath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create download token for request " + request + " due to IOException " + e + ". Attempted to write to " + token.getPath());
        }
    }

    private void deleteDownloadRequestToken(DownloadRequest request) {
        File token = this.getDownloadRequestTokenPath(request);
        if (!token.isFile()) {
            Log.w(LOG_TAG, "Attempting to delete non-existent download token at " + token);
            return;
        }
        if (!token.delete()) {
            Log.w(LOG_TAG, "Couldn't delete download token at " + token);
        }
    }

    private void checkDownloadRequestDestination(DownloadRequest request) {
        File downloadRequestDestination = new File(request.getDestinationUri().getPath());
        if (!downloadRequestDestination.isDirectory()) {
            throw new IllegalArgumentException("The destination path must be a directory");
        }
        File testFile = new File(MbmsTempFileProvider.getEmbmsTempFileDir(this.mContext), DESTINATION_SANITY_CHECK_FILE_NAME);
        File testFileDestination = new File(downloadRequestDestination, DESTINATION_SANITY_CHECK_FILE_NAME);
        try {
            if (!testFile.exists()) {
                testFile.createNewFile();
            }
            if (!testFile.renameTo(testFileDestination)) {
                throw new IllegalArgumentException("Destination provided in the download request is invalid -- files in the temp file directory cannot be directly moved there.");
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Got IOException while testing out the destination: " + e);
        }
        finally {
            testFile.delete();
            testFileDestination.delete();
        }
    }

    private File getDownloadRequestTokenPath(DownloadRequest request) {
        File tempFileLocation = MbmsUtils.getEmbmsTempFileDirForService(this.mContext, request.getFileServiceId());
        String downloadTokenFileName = request.getHash() + ".download_token";
        return new File(tempFileLocation, downloadTokenFileName);
    }

    private void sendErrorToApp(int errorCode, String message) {
        this.mInternalCallback.onError(errorCode, message);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DownloadStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DownloadResultCode {
    }
}

